/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js.util;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.compiler.js.AttributeGenerator;
import com.redhat.ceylon.compiler.js.GenerateJsVisitor;
import com.redhat.ceylon.compiler.js.loader.MetamodelGenerator;
import com.redhat.ceylon.compiler.js.util.JsUtils;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.util.NativeUtil;
import com.redhat.ceylon.model.typechecker.model.Annotation;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Generic;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.NothingType;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Setter;
import com.redhat.ceylon.model.typechecker.model.SiteVariance;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeAlias;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.Unit;
import com.redhat.ceylon.model.typechecker.model.UnknownType;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TypeUtils {
    public static void printTypeArguments(Node node, Map<TypeParameter, Type> targs, GenerateJsVisitor gen, boolean skipSelfDecl, Map<TypeParameter, SiteVariance> overrides) {
        if (targs == null) {
            return;
        }
        gen.out("{", new String[0]);
        boolean first = true;
        for (Map.Entry<TypeParameter, Type> e : targs.entrySet()) {
            Type pt;
            if (first) {
                first = false;
            } else {
                gen.out(",", new String[0]);
            }
            gen.out(gen.getNames().typeParameterName(e.getKey()), ":");
            Type type = pt = e.getValue() == null ? null : e.getValue().resolveAliases();
            if (pt == null) {
                gen.out("'", e.getKey().getName(), "'");
                continue;
            }
            if (TypeUtils.outputTypeList(node, pt, gen, skipSelfDecl)) continue;
            boolean hasParams = pt.getTypeArgumentList() != null && !pt.getTypeArgumentList().isEmpty();
            boolean closeBracket = false;
            TypeDeclaration d = pt.getDeclaration();
            if (pt.isTypeParameter()) {
                TypeUtils.resolveTypeParameter(node, (TypeParameter)d, gen, skipSelfDecl);
                if (((TypeParameter)d).isInvariant() && (e.getKey().isCovariant() || e.getKey().isContravariant())) {
                    gen.out("/*ORALE!", d.getQualifiedNameString(), " inv pero ", e.getKey().getQualifiedNameString(), e.getKey().isCovariant() ? " out" : " in", "*/");
                }
            } else {
                boolean bl = closeBracket = !pt.isTypeAlias();
                if (closeBracket) {
                    gen.out("{t:", new String[0]);
                }
                TypeUtils.outputQualifiedTypename(node, node != null && gen.isImported(node.getUnit().getPackage(), pt.getDeclaration()), pt, gen, skipSelfDecl);
            }
            if (hasParams) {
                gen.out(",a:", new String[0]);
                TypeUtils.printTypeArguments(node, pt.getTypeArguments(), gen, skipSelfDecl, pt.getVarianceOverrides());
            }
            SiteVariance siteVariance = overrides == null ? null : overrides.get(e.getKey());
            TypeUtils.printSiteVariance(siteVariance, gen);
            if (!closeBracket) continue;
            gen.out("}", new String[0]);
        }
        gen.out("}", new String[0]);
    }

    public static void outputQualifiedTypename(Node node, boolean imported, Type pt, GenerateJsVisitor gen, boolean skipSelfDecl) {
        TypeDeclaration t = pt.getDeclaration();
        if (t instanceof NothingType) {
            gen.out(gen.getClAlias(), "Nothing");
        } else if (t.isNull()) {
            gen.out(gen.getClAlias(), "Null");
        } else if (t.isAnything()) {
            gen.out(gen.getClAlias(), "Anything");
        } else if (ModelUtil.isTypeUnknown(pt)) {
            if (!gen.isInDynamicBlock()) {
                gen.out("/*WARNING unknown type", new String[0]);
                gen.location(node);
                gen.out("*/", new String[0]);
            }
            gen.out(gen.getClAlias(), "Anything");
        } else {
            ClassOrInterface dynintc;
            boolean _init;
            if (t.isValueConstructor()) {
                t = (TypeDeclaration)t.getContainer();
            }
            gen.out(TypeUtils.qualifiedTypeContainer(node, imported, t, gen), new String[0]);
            boolean isAnonCallable = t.isAnonymous() && t.getExtendedType() != null && t.getExtendedType().isCallable();
            boolean bl = _init = !imported && pt.getDeclaration().isDynamic() || t.isAnonymous();
            if (!(!_init || pt.getDeclaration().isToplevel() || (dynintc = ModelUtil.getContainingClassOrInterface(node.getScope())) != null && dynintc instanceof Scope && ModelUtil.contains(dynintc, pt.getDeclaration()))) {
                _init = false;
            }
            if (_init && !isAnonCallable) {
                gen.out("$init$", new String[0]);
            }
            if (!TypeUtils.outputTypeList(null, pt, gen, skipSelfDecl)) {
                if (isAnonCallable) {
                    gen.out("{t:", new String[0]);
                    TypeUtils.outputQualifiedTypename(node, true, pt.getExtendedType(), gen, skipSelfDecl);
                    gen.out("}", new String[0]);
                    return;
                }
                if (t.isAnonymous()) {
                    gen.out(gen.getNames().objectName(t), new String[0]);
                } else {
                    gen.out(gen.getNames().name(t), new String[0]);
                }
            }
            if (!(!_init || t.isAnonymous() && t.isToplevel())) {
                gen.out("()", new String[0]);
            }
        }
    }

    static String qualifiedTypeContainer(Node node, boolean imported, TypeDeclaration t, GenerateJsVisitor gen) {
        String modAlias = imported ? gen.getNames().moduleAlias(t.getUnit().getPackage().getModule()) : null;
        StringBuilder sb = new StringBuilder();
        if (modAlias != null && !modAlias.isEmpty()) {
            sb.append(modAlias).append('.');
        }
        if (t.getContainer() instanceof ClassOrInterface) {
            ClassOrInterface parent;
            ClassOrInterface scope = node == null ? null : ModelUtil.getContainingClassOrInterface(node.getScope());
            ArrayList<ClassOrInterface> parents = new ArrayList<ClassOrInterface>(3);
            parents.add(0, parent);
            for (parent = (ClassOrInterface)t.getContainer(); parent != scope && parent.isClassOrInterfaceMember(); parent = (ClassOrInterface)parent.getContainer()) {
                parents.add(0, parent);
            }
            boolean first = true;
            for (ClassOrInterface p : parents) {
                if (p == scope) {
                    if (gen.opts.isOptimize()) {
                        sb.append(gen.getNames().self(p)).append('.');
                    }
                } else {
                    if (!first) {
                        if (p.isStatic()) {
                            sb.append("$st$.");
                        } else if (p.getContainer() != scope && p.isClassOrInterfaceMember() && gen.opts.isOptimize()) {
                            sb.append("$$.prototype.");
                        }
                    }
                    sb.append(gen.getNames().name(p)).append('.');
                }
                first = false;
            }
            if (t.isStatic()) {
                sb.append("$st$.");
            } else if (t.getContainer() != scope && t.isClassOrInterfaceMember() && gen.opts.isOptimize()) {
                sb.append("$$.prototype.");
            }
        }
        return sb.toString();
    }

    public static void typeNameOrList(Node node, Type pt, GenerateJsVisitor gen, boolean skipSelfDecl) {
        TypeDeclaration type = pt.getDeclaration();
        if (!TypeUtils.outputTypeList(node, pt, gen, skipSelfDecl)) {
            if (pt.isTypeParameter()) {
                TypeUtils.resolveTypeParameter(node, (TypeParameter)type, gen, skipSelfDecl);
            } else if (pt.isTypeAlias()) {
                TypeUtils.outputQualifiedTypename(node, node != null && gen.isImported(node.getUnit().getPackage(), type), pt, gen, skipSelfDecl);
            } else {
                gen.out("{t:", new String[0]);
                TypeUtils.outputQualifiedTypename(node, node != null && gen.isImported(node.getUnit().getPackage(), type), pt, gen, skipSelfDecl);
                if (!pt.getTypeArgumentList().isEmpty()) {
                    Map<TypeParameter, Type> targs;
                    if (pt.getDeclaration().isToplevel()) {
                        targs = pt.getTypeArguments();
                    } else {
                        HashSet<TypeParameter> parenttp = new HashSet<TypeParameter>();
                        for (Scope scope = node.getScope(); scope != null; scope = scope.getScope()) {
                            if (!(scope instanceof Generic)) continue;
                            Generic g = (Generic)((Object)scope);
                            for (TypeParameter tp : g.getTypeParameters()) {
                                parenttp.add(tp);
                            }
                        }
                        targs = new HashMap<TypeParameter, Type>();
                        targs.putAll(pt.getTypeArguments());
                        Declaration cd = ModelUtil.getContainingDeclaration(pt.getDeclaration());
                        while (cd != null) {
                            for (TypeParameter tp : cd.getTypeParameters()) {
                                if (!parenttp.contains(tp)) continue;
                                targs.put(tp, tp.getType());
                            }
                            cd = ModelUtil.getContainingDeclaration(cd);
                        }
                    }
                    gen.out(",a:", new String[0]);
                    TypeUtils.printTypeArguments(node, targs, gen, skipSelfDecl, pt.getVarianceOverrides());
                }
                gen.out("}", new String[0]);
            }
        }
    }

    public static boolean outputTypeList(Node node, Type pt, GenerateJsVisitor gen, boolean skipSelfDecl) {
        List<Type> subs;
        int seq = 0;
        if (pt.isIntersection()) {
            gen.out(gen.getClAlias(), "mit$([");
            subs = pt.getSatisfiedTypes();
        } else if (pt.isUnion()) {
            gen.out(gen.getClAlias(), "mut$([");
            subs = pt.getCaseTypes();
        } else if (pt.isTuple()) {
            TypeDeclaration d = pt.getDeclaration();
            subs = d.getUnit().getTupleElementTypes(pt);
            Type lastType = subs.get(subs.size() - 1);
            if (pt.involvesTypeParameters() && !d.getUnit().isHomogeneousTuple(pt)) {
                gen.out("{t:", gen.getClAlias(), "Tuple,a:");
                TypeUtils.printTypeArguments(node, pt.getTypeArguments(), gen, skipSelfDecl, pt.getVarianceOverrides());
                gen.out("}", new String[0]);
                return true;
            }
            int tupleMinLength = pt.getDeclaration().getUnit().getTupleMinimumLength(pt);
            if (!lastType.isEmpty()) {
                if (lastType.isSequential()) {
                    seq = 1;
                }
                if (lastType.isSequence()) {
                    seq = 2;
                }
            }
            if (seq > 0) {
                Type utail = ModelUtil.unionType(lastType.getTypeArgumentList().get(0), lastType, d.getUnit());
                subs.remove(subs.size() - 1);
                subs.add(utail);
            }
            gen.out(gen.getClAlias(), "mtt$([");
            if (tupleMinLength < subs.size() - (seq > 0 ? 1 : 0)) {
                int limit = subs.size();
                if (seq > 0) {
                    --limit;
                }
                for (int i = tupleMinLength; i < limit; ++i) {
                    subs.set(i, ModelUtil.unionType(d.getUnit().getEmptyType(), subs.get(i), node.getUnit()));
                }
            }
        } else {
            return false;
        }
        Type lastSub = subs.isEmpty() ? null : subs.get(subs.size() - 1);
        int index = 0;
        for (Type t : subs) {
            if (index > 0) {
                gen.out(",", new String[0]);
            }
            if (t == lastSub && seq > 0 && t.getCaseTypes() != null) {
                gen.out("{t:'u',l:[", new String[0]);
                TypeUtils.typeNameOrList(node, t.getCaseTypes().get(0), gen, skipSelfDecl);
                gen.out(",", new String[0]);
                TypeUtils.typeNameOrList(node, t.getCaseTypes().get(1), gen, skipSelfDecl);
                gen.out("],seq:", Integer.toString(seq), "}");
            } else {
                TypeUtils.typeNameOrList(node, t, gen, skipSelfDecl);
            }
            ++index;
        }
        gen.out("])", new String[0]);
        return true;
    }

    static void resolveTypeParameter(Node node, TypeParameter tp, GenerateJsVisitor gen, boolean skipSelfDecl) {
        Scope parent;
        int outers = 0;
        for (parent = ModelUtil.getRealScope(node.getScope()); parent != null && parent != tp.getContainer(); parent = parent.getScope()) {
            if (!(parent instanceof TypeDeclaration) || parent instanceof Constructor || ((TypeDeclaration)parent).isAnonymous()) continue;
            ++outers;
        }
        if (tp.getContainer() instanceof ClassOrInterface) {
            if (parent == tp.getContainer()) {
                if (!skipSelfDecl) {
                    ClassOrInterface ontoy = ModelUtil.getContainingClassOrInterface(node.getScope());
                    while (ontoy.isAnonymous()) {
                        ontoy = ModelUtil.getContainingClassOrInterface(ontoy.getScope());
                    }
                    gen.out(gen.getNames().self(ontoy), new String[0]);
                    if (ontoy == parent) {
                        --outers;
                    }
                    for (int i = 0; i < outers; ++i) {
                        gen.out(".outer$", new String[0]);
                    }
                    gen.out(".", new String[0]);
                }
                gen.out("$$targs$$.", gen.getNames().typeParameterName(tp));
            } else {
                gen.out("{/*NO PARENT*/t:", gen.getClAlias(), "Anything}");
            }
        } else if (tp.getContainer() instanceof TypeAlias) {
            if (parent == tp.getContainer()) {
                gen.out("'", gen.getNames().typeParameterName(tp), "'");
            } else {
                gen.out("{/*NO PARENT ALIAS*/t:", gen.getClAlias(), "Anything}");
            }
        } else {
            Type type = null;
            Iterator<ParameterList> iter0 = ((Function)tp.getContainer()).getParameterLists().iterator();
            while (type == null && iter0.hasNext()) {
                Iterator<Parameter> iter1 = iter0.next().getParameters().iterator();
                while (iter1.hasNext()) {
                    type = TypeUtils.typeContainsTypeParameter(iter1.next().getType(), tp);
                }
            }
            if (tp.getContainer() == parent) {
                gen.out(gen.getNames().typeArgsParamName((Function)tp.getContainer()), ".", gen.getNames().typeParameterName(tp));
            } else {
                if (parent == null && node instanceof Tree.StaticMemberOrTypeExpression && tp.getContainer() == ((Tree.StaticMemberOrTypeExpression)node).getDeclaration()) {
                    type = ((Tree.StaticMemberOrTypeExpression)node).getTarget().getTypeArguments().get(tp);
                    TypeUtils.typeNameOrList(node, type, gen, skipSelfDecl);
                    return;
                }
                gen.out("'", gen.getNames().typeParameterName(tp), "'");
            }
        }
    }

    static Type typeContainsTypeParameter(Type td, TypeParameter tp) {
        block5: {
            block4: {
                if (!td.isUnion() && !td.isIntersection()) break block4;
                List<Type> comps = td.getCaseTypes();
                if (comps == null) {
                    comps = td.getSatisfiedTypes();
                }
                for (Type sub : comps) {
                    td = TypeUtils.typeContainsTypeParameter(sub, tp);
                    if (td == null) continue;
                    return td;
                }
                break block5;
            }
            TypeDeclaration d = td.getDeclaration();
            if (d == tp) {
                return td;
            }
            if (!(d instanceof ClassOrInterface)) break block5;
            for (Type sub : td.getTypeArgumentList()) {
                if (TypeUtils.typeContainsTypeParameter(sub, tp) == null) continue;
                return td;
            }
        }
        return null;
    }

    public static Type findSupertype(TypeDeclaration d, Type pt) {
        if (pt.getDeclaration().equals(d)) {
            return pt;
        }
        List<Type> list = pt.getSupertypes() == null ? pt.getCaseTypes() : pt.getSupertypes();
        for (Type t : list) {
            if (!t.getDeclaration().equals(d)) continue;
            return t;
        }
        return null;
    }

    public static List<Type> getDefaultTypeArguments(List<TypeParameter> tparms) {
        ArrayList<Type> targs = new ArrayList<Type>(tparms.size());
        for (TypeParameter tp : tparms) {
            Type t = tp.getDefaultTypeArgument();
            if (t == null) {
                t = tp.getUnit().getAnythingType();
            }
            targs.add(t);
        }
        return targs;
    }

    public static Map<TypeParameter, Type> matchTypeParametersWithArguments(List<TypeParameter> params, List<Type> targs) {
        if (params != null) {
            if (targs == null) {
                targs = TypeUtils.getDefaultTypeArguments(params);
            }
            if (params.size() == targs.size()) {
                HashMap<TypeParameter, Type> r = new HashMap<TypeParameter, Type>();
                for (int i = 0; i < targs.size(); ++i) {
                    r.put(params.get(i), targs.get(i));
                }
                return r;
            }
        }
        return null;
    }

    public static Map<TypeParameter, Type> wrapAsIterableArguments(Type pt) {
        HashMap<TypeParameter, Type> r = new HashMap<TypeParameter, Type>();
        Interface iterable = pt.getDeclaration().getUnit().getIterableDeclaration();
        List<TypeParameter> typeParameters = ((Declaration)iterable).getTypeParameters();
        r.put(typeParameters.get(0), pt);
        r.put(typeParameters.get(1), pt.getDeclaration().getUnit().getNullType());
        return r;
    }

    public static boolean isUnknown(Declaration d) {
        return d == null || d instanceof UnknownType;
    }

    public static void spreadArrayCheck(Tree.Term term, GenerateJsVisitor gen) {
        String tmp = gen.getNames().createTempVariable();
        gen.out("(", tmp, "=");
        term.visit(gen);
        gen.out(",Array.isArray(", tmp, ")?", tmp);
        gen.out(":function(){throw new TypeError('Expected JS Array (", term.getUnit().getFilename(), " ", term.getLocation(), ")')}())");
    }

    public static Type extractDynamic(Type t) {
        if (t != null) {
            if (t.isUnion()) {
                for (Type ct : t.getCaseTypes()) {
                    if ((ct = TypeUtils.extractDynamic(ct)) == null) continue;
                    return ct;
                }
            } else if (t.isIntersection()) {
                for (Type st : t.getSatisfiedTypes()) {
                    if ((st = TypeUtils.extractDynamic(st)) == null) continue;
                    return st;
                }
            } else if (t.getDeclaration() != null && t.getDeclaration().isDynamic()) {
                return t;
            }
        }
        return null;
    }

    public static void generateDynamicCheck(Tree.Term term, Type t, GenerateJsVisitor gen, boolean skipSelfDecl, Map<TypeParameter, Type> typeArguments) {
        Type dyntype = TypeUtils.extractDynamic(t);
        if (dyntype != null) {
            gen.out(gen.getClAlias(), "dre$$(");
            term.visit(gen);
            gen.out(",", new String[0]);
            TypeUtils.typeNameOrList(term, dyntype, gen, skipSelfDecl);
            gen.out(",'", term.getUnit().getFilename(), " ", term.getLocation(), "')");
        } else if (t.isFloat() || t.isInteger()) {
            gen.out(gen.getClAlias(), "ndnc$(");
            term.visit(gen);
            gen.out(",'", t.isFloat() ? "f" : "i", "','", term.getUnit().getFilename(), " ", term.getLocation(), "')");
        } else if (t.getDeclaration() != null && t.getDeclaration().isArray()) {
            gen.out(gen.getClAlias(), "natc$(");
            term.visit(gen);
            gen.out(",", new String[0]);
            t = t.getTypeArgumentList().get(0);
            if (t.isTypeParameter() && typeArguments != null && typeArguments.containsKey(t.getDeclaration())) {
                t = typeArguments.get(t.getDeclaration());
            }
            TypeUtils.typeNameOrList(term, t, gen, skipSelfDecl);
            gen.out(",'", term.getUnit().getFilename(), " ", term.getLocation(), "')");
        } else {
            gen.out(gen.getClAlias(), "ndtc$(");
            term.visit(gen);
            gen.out(",", new String[0]);
            if (t.isTypeParameter() && typeArguments != null && typeArguments.containsKey(t.getDeclaration())) {
                t = typeArguments.get(t.getDeclaration());
            }
            TypeUtils.typeNameOrList(term, t, gen, skipSelfDecl);
            gen.out(",'", term.getUnit().getFilename(), " ", term.getLocation(), "')");
        }
    }

    public static void encodeParameterListForRuntime(boolean resolveTargs, Node n, ParameterList plist, GenerateJsVisitor gen) {
        boolean first = true;
        gen.out("[", new String[0]);
        HashMap<String, Tree.Parameter> treeParams = new HashMap<String, Tree.Parameter>();
        if (n instanceof Tree.AnyMethod) {
            for (Tree.ParameterList tplist : ((Tree.AnyMethod)n).getParameterLists()) {
                for (Tree.Parameter tparm : tplist.getParameters()) {
                    if (tparm.getParameterModel() == null || tparm.getParameterModel().getName() == null) continue;
                    treeParams.put(tparm.getParameterModel().getName(), tparm);
                }
            }
        }
        for (Parameter p : plist.getParameters()) {
            Tree.TypedDeclaration tdec;
            Tree.Parameter tparm;
            if (first) {
                first = false;
            } else {
                gen.out(",", new String[0]);
            }
            gen.out("{", "nm", ":'", p.getName(), "',");
            gen.out("mt", ":'", "prm", "',");
            Type ptype = p.getType();
            if (p.getModel() instanceof Function) {
                gen.out("$pt:'f',", new String[0]);
                ptype = ((Function)p.getModel()).getTypedReference().getFullType();
            }
            if (p.isSequenced()) {
                if (p.isAtLeastOne()) {
                    gen.out("seq:2,", new String[0]);
                } else {
                    gen.out("seq:1,", new String[0]);
                }
            }
            if (p.isDefaulted()) {
                gen.out("def", ":1,");
            }
            gen.out("$t", ":");
            TypeUtils.metamodelTypeNameOrList(resolveTargs, n, gen.getCurrentPackage(), ptype, null, gen);
            if (p.getModel() instanceof Function) {
                gen.out(",", "$rt", ":");
                TypeUtils.metamodelTypeNameOrList(resolveTargs, n, gen.getCurrentPackage(), p.getType(), null, gen);
                gen.out(",", "ps", ":");
                TypeUtils.encodeParameterListForRuntime(resolveTargs, n, ((Function)p.getModel()).getFirstParameterList(), gen);
            }
            Tree.Parameter parameter = tparm = p.getName() == null ? null : (Tree.Parameter)treeParams.get(p.getName());
            if (tparm == null) {
                if (p.getModel().getAnnotations() != null && !p.getModel().getAnnotations().isEmpty()) {
                    new ModelAnnotationGenerator(gen, p.getModel(), n).generateAnnotations();
                }
            } else if (tparm instanceof Tree.ParameterDeclaration && (tdec = ((Tree.ParameterDeclaration)tparm).getTypedDeclaration()).getAnnotationList() != null && !tdec.getAnnotationList().getAnnotations().isEmpty()) {
                TypeUtils.outputAnnotationsFunction(tdec.getAnnotationList(), p.getDeclaration(), gen);
            }
            gen.out("}", new String[0]);
        }
        gen.out("]", new String[0]);
    }

    private static Unit getUnit(Type pt) {
        block4: {
            block3: {
                if (pt.isClassOrInterface()) {
                    return pt.getDeclaration().getUnit();
                }
                if (!pt.isUnion()) break block3;
                for (Type ct : pt.getCaseTypes()) {
                    Unit u = TypeUtils.getUnit(ct);
                    if (u == null) continue;
                    return u;
                }
                break block4;
            }
            if (!pt.isIntersection()) break block4;
            for (Type st : pt.getSatisfiedTypes()) {
                Unit u = TypeUtils.getUnit(st);
                if (u == null) continue;
                return u;
            }
        }
        return null;
    }

    public static List<Parameter> convertTupleToParameters(Type _tuple) {
        ArrayList<Parameter> rval = new ArrayList<Parameter>();
        int pos = 0;
        Unit unit = TypeUtils.getUnit(_tuple);
        Type empty = unit.getEmptyType();
        while (_tuple != null && !_tuple.isSubtypeOf(empty) && !_tuple.isTypeParameter()) {
            Parameter _p = null;
            if (TypeUtils.isTuple(_tuple)) {
                _p = new Parameter();
                _p.setModel(new Value());
                if (_tuple.isUnion()) {
                    for (Type mt : _tuple.getCaseTypes()) {
                        if (!mt.isTuple()) continue;
                        _p.getModel().setType(mt.getTypeArgumentList().get(1));
                        _tuple = mt.getTypeArgumentList().get(2);
                        break;
                    }
                    _p.setDefaulted(true);
                } else {
                    _p.getModel().setType(_tuple.getTypeArgumentList().get(1));
                    _tuple = _tuple.getTypeArgumentList().get(2);
                }
            } else if (unit.isSequentialType(_tuple)) {
                _p = new Parameter();
                _p.setModel(new Value());
                _p.getModel().setType(_tuple.getTypeArgumentList().get(0));
                _p.setSequenced(true);
                _tuple = null;
            } else if (pos > 100) {
                return rval;
            }
            if (_p != null) {
                _p.setName("arg" + pos);
                rval.add(_p);
            }
            ++pos;
        }
        return rval;
    }

    private static boolean isTuple(Type pt) {
        if (pt.isClass() && pt.getDeclaration().equals(pt.getDeclaration().getUnit().getTupleDeclaration())) {
            return true;
        }
        if (pt.isUnion() && pt.getCaseTypes().size() == 2) {
            Class tuple = pt.getCaseTypes().get(0).isClassOrInterface() ? pt.getCaseTypes().get(0).getDeclaration().getUnit().getTupleDeclaration() : (pt.getCaseTypes().get(1).isClassOrInterface() ? pt.getCaseTypes().get(1).getDeclaration().getUnit().getTupleDeclaration() : null);
            return tuple != null && (tuple.equals(pt.getCaseTypes().get(0).getDeclaration()) || tuple.equals(pt.getCaseTypes().get(1).getDeclaration()));
        }
        return false;
    }

    private static void encodeTupleAsParameterListForRuntime(boolean resolveTargs, Node node, Type _tuple, boolean nameAndMetatype, GenerateJsVisitor gen) {
        gen.out("[", new String[0]);
        int pos = 1;
        Type empty = node.getUnit().getEmptyType();
        while (_tuple != null && !_tuple.isExactly(empty) && !_tuple.isTypeParameter()) {
            if (pos > 1) {
                gen.out(",", new String[0]);
            }
            ++pos;
            if (nameAndMetatype) {
                gen.out("{", "nm", ":'p", Integer.toString(pos), "',");
                gen.out("mt", ":'", "prm", "',");
                gen.out("$t", ":");
            }
            if (TypeUtils.isTuple(_tuple)) {
                if (_tuple.isUnion() && _tuple.getCaseTypes().contains(node.getUnit().getEmptyType())) {
                    TypeUtils.metamodelTypeNameOrList(resolveTargs, node, gen.getCurrentPackage(), _tuple, null, gen);
                    if (nameAndMetatype) {
                        gen.out(",", "def", ":1");
                    }
                    _tuple = null;
                } else {
                    TypeUtils.metamodelTypeNameOrList(resolveTargs, node, gen.getCurrentPackage(), _tuple.getTypeArgumentList().get(1), null, gen);
                    _tuple = _tuple.getTypeArgumentList().get(2);
                }
            } else if (node.getUnit().isSequentialType(_tuple)) {
                int seq;
                Type _t2 = _tuple.getSupertype(node.getUnit().getSequenceDeclaration());
                if (_t2 == null) {
                    _t2 = _tuple.getSupertype(node.getUnit().getSequentialDeclaration());
                    seq = 1;
                } else {
                    seq = 2;
                }
                if (nameAndMetatype) {
                    TypeUtils.metamodelTypeNameOrList(resolveTargs, node, gen.getCurrentPackage(), _t2.getTypeArgumentList().get(0), null, gen);
                    gen.out(",seq:", Integer.toString(seq));
                } else {
                    gen.out(gen.getClAlias(), "mkseq$(");
                    TypeUtils.metamodelTypeNameOrList(resolveTargs, node, gen.getCurrentPackage(), _t2.getTypeArgumentList().get(0), null, gen);
                    gen.out(",", Integer.toString(seq), ")");
                }
                _tuple = null;
            } else if (_tuple.isUnion()) {
                TypeUtils.metamodelTypeNameOrList(resolveTargs, node, gen.getCurrentPackage(), _tuple, null, gen);
                _tuple = null;
            } else {
                gen.out("\n/*WARNING3! Tuple is actually ", _tuple.asString(), "*/");
                if (pos > 100) break;
            }
            if (!nameAndMetatype) continue;
            gen.out("}", new String[0]);
        }
        gen.out("]", new String[0]);
    }

    public static void encodeCallableArgumentsAsParameterListForRuntime(Node node, Type _callable, GenerateJsVisitor gen) {
        if (_callable.getCaseTypes() != null) {
            for (Type pt : _callable.getCaseTypes()) {
                if (!pt.isCallable()) continue;
                _callable = pt;
                break;
            }
        } else if (_callable.getSatisfiedTypes() != null) {
            for (Type pt : _callable.getSatisfiedTypes()) {
                if (!pt.isCallable()) continue;
                _callable = pt;
                break;
            }
        }
        if (!_callable.isCallable()) {
            gen.out("[/*WARNING1: got ", _callable.asString(), " instead of Callable*/]");
            return;
        }
        List<Type> targs = _callable.getTypeArgumentList();
        if (targs == null || targs.size() != 2) {
            gen.out("[/*WARNING2: missing argument types for Callable*/]", new String[0]);
            return;
        }
        TypeUtils.encodeTupleAsParameterListForRuntime(true, node, targs.get(1), true, gen);
    }

    public static void encodeForRuntime(Node that, Declaration d, GenerateJsVisitor gen) {
        if (d.getAnnotations() == null || d.getAnnotations().isEmpty() || d instanceof Class && d.isAnonymous()) {
            TypeUtils.encodeForRuntime(that, d, gen, null);
        } else {
            TypeUtils.encodeForRuntime(that, d, gen, new ModelAnnotationGenerator(gen, d, that));
        }
    }

    public static void encodeMethodForRuntime(final Tree.AnyMethod that, final GenerateJsVisitor gen) {
        TypeUtils.encodeForRuntime((Node)that, (Declaration)that.getDeclarationModel(), gen, new RuntimeMetamodelAnnotationGenerator(){

            @Override
            public void generateAnnotations() {
                TypeUtils.outputAnnotationsFunction(that.getAnnotationList(), that.getDeclarationModel(), gen);
            }
        });
    }

    public static void encodeForRuntime(Node node, final Declaration d, final Tree.AnnotationList annotations, final GenerateJsVisitor gen) {
        TypeUtils.encodeForRuntime(node, d, gen, new RuntimeMetamodelAnnotationGenerator(){

            @Override
            public void generateAnnotations() {
                TypeUtils.outputAnnotationsFunction(annotations, d, gen);
            }
        });
    }

    public static List<String> generateModelPath(Declaration d) {
        ArrayList<String> sb = new ArrayList<String>();
        Package pkg = d.getUnit().getPackage();
        sb.add(pkg.isLanguagePackage() ? "$" : pkg.getNameAsString());
        if (d.isToplevel()) {
            sb.add(d.getName());
            if (d instanceof Setter) {
                sb.add("$set");
            }
        } else {
            Declaration p = d;
            int i = sb.size();
            while (p instanceof Declaration) {
                String mname;
                if (p instanceof Setter) {
                    sb.add(i, "$set");
                }
                if (!(mname = TypeUtils.modelName(p)).startsWith("anon$") && !mname.startsWith("anonymous#")) {
                    sb.add(i, mname);
                    if (!p.isToplevel()) {
                        if (p instanceof Class) {
                            sb.add(i, p.isAnonymous() ? "$o" : "$c");
                        } else if (p instanceof Interface) {
                            sb.add(i, "$i");
                        } else if (p instanceof Function) {
                            if (!p.isAnonymous()) {
                                sb.add(i, "$m");
                            }
                        } else if (p instanceof TypeAlias || p instanceof Setter) {
                            sb.add(i, "$at");
                        } else if (p instanceof Constructor || ModelUtil.isConstructor(p)) {
                            sb.add(i, "$cn");
                        } else {
                            TypeDeclaration td = ((TypedDeclaration)p).getTypeDeclaration();
                            sb.add(i, td != null && td.isAnonymous() ? "$o" : "$at");
                        }
                    }
                }
                p = ModelUtil.getContainingDeclaration(p);
                while (!(p == null || p instanceof ClassOrInterface || p.isToplevel() || p.isAnonymous() || p.isClassOrInterfaceMember() || p.isJsCaptured())) {
                    p = ModelUtil.getContainingDeclaration(p);
                }
            }
        }
        return sb;
    }

    static void outputModelPath(Declaration d, GenerateJsVisitor gen) {
        List<String> parts = TypeUtils.generateModelPath(d);
        gen.out("[", new String[0]);
        boolean first = true;
        for (String p : parts) {
            if (p.startsWith("anon$") || p.startsWith("anonymous#")) continue;
            if (first) {
                first = false;
            } else {
                gen.out(",", new String[0]);
            }
            gen.out("'", p, "'");
        }
        gen.out("]", new String[0]);
    }

    public static void encodeForRuntime(Node that, Declaration d, GenerateJsVisitor gen, RuntimeMetamodelAnnotationGenerator annGen) {
        gen.out("function(){return{mod:$CCMM$", new String[0]);
        List<TypeParameter> tparms = d instanceof Generic ? d.getTypeParameters() : null;
        List<Type> satisfies = null;
        List<Type> caseTypes = null;
        if (d instanceof Class) {
            Class _cd = (Class)d;
            if (_cd.getExtendedType() != null) {
                gen.out(",'super':", new String[0]);
                TypeUtils.metamodelTypeNameOrList(false, that, d.getUnit().getPackage(), _cd.getExtendedType(), null, gen);
            }
            if (_cd.getParameterList() != null) {
                gen.out(",", "ps", ":");
                TypeUtils.encodeParameterListForRuntime(false, that, _cd.getParameterList(), gen);
            }
            satisfies = _cd.getSatisfiedTypes();
            caseTypes = _cd.getCaseTypes();
        } else if (d instanceof Interface) {
            Interface _id = (Interface)d;
            satisfies = _id.getSatisfiedTypes();
            caseTypes = _id.getCaseTypes();
            if (_id.isAlias()) {
                ArrayList<Type> s2 = new ArrayList<Type>(satisfies.size() + 1);
                s2.add(_id.getExtendedType());
                s2.addAll(satisfies);
                satisfies = s2;
            }
        } else if (d instanceof FunctionOrValue) {
            gen.out(",", "$t", ":");
            if (d instanceof Function && ((Function)d).getParameterLists().size() > 1) {
                Type callableType = ((Function)d).getTypedReference().getFullType();
                TypeUtils.metamodelTypeNameOrList(false, that, d.getUnit().getPackage(), that.getUnit().getCallableReturnType(callableType), null, gen);
            } else {
                TypeUtils.metamodelTypeNameOrList(false, that, d.getUnit().getPackage(), ((FunctionOrValue)d).getType(), null, gen);
            }
            if (d instanceof Function) {
                gen.out(",", "ps", ":");
                TypeUtils.encodeParameterListForRuntime(false, that, ((Function)d).getFirstParameterList(), gen);
                tparms = d.getTypeParameters();
            }
        } else if (d instanceof Constructor) {
            gen.out(",", "ps", ":");
            TypeUtils.encodeParameterListForRuntime(false, that, ((Constructor)d).getFirstParameterList(), gen);
        }
        if (!d.isToplevel()) {
            Declaration __d;
            Declaration _cont = ModelUtil.getContainingDeclaration(d);
            while (!(!_cont.isAnonymous() && (_cont.isToplevel() || _cont.isClassOrInterfaceMember() || !(_cont instanceof Value)) || _cont instanceof Value && ((Value)_cont).isJsCaptured() || _cont instanceof Class || (__d = ModelUtil.getContainingDeclaration(_cont)) == null)) {
                _cont = __d;
            }
            gen.out(",$cont:", new String[0]);
            boolean generateName = true;
            if (_cont.getName() != null && _cont.isAnonymous() && _cont instanceof Function || _cont instanceof Value && !((Value)_cont).isTransient()) {
                Declaration _supercont = ModelUtil.getContainingDeclaration(_cont);
                while (_supercont != null && _supercont.getName() != null && _supercont.isAnonymous()) {
                    _supercont = ModelUtil.getContainingDeclaration(_supercont);
                }
                if (_supercont == null) {
                    generateName = false;
                    gen.out("0", new String[0]);
                } else {
                    _cont = _supercont;
                }
            }
            if (generateName) {
                if (_cont instanceof Value) {
                    if (AttributeGenerator.defineAsProperty(_cont)) {
                        gen.qualify(that, _cont);
                    }
                    gen.out(gen.getNames().getter(_cont, true), new String[0]);
                } else if (_cont instanceof Setter) {
                    gen.out("{setter:", new String[0]);
                    if (AttributeGenerator.defineAsProperty(_cont)) {
                        gen.qualify(that, _cont);
                        gen.out(gen.getNames().getter(((Setter)_cont).getGetter(), true), ".set");
                    } else {
                        gen.out(gen.getNames().setter(((Setter)_cont).getGetter()), new String[0]);
                    }
                    gen.out("}", new String[0]);
                } else {
                    boolean inProto = gen.opts.isOptimize() && _cont.getContainer() instanceof TypeDeclaration;
                    String path = gen.qualifiedPath(that, _cont, inProto);
                    if (path != null && !path.isEmpty()) {
                        gen.out(path, ".");
                    }
                    String contName = gen.getNames().name(_cont);
                    gen.out(contName, new String[0]);
                }
            }
        }
        if (tparms != null && !tparms.isEmpty()) {
            gen.out(",", "tp", ":{");
            TypeUtils.encodeTypeParametersForRuntime(that, d, tparms, true, gen);
            gen.out("}", new String[0]);
        }
        if (satisfies != null && !satisfies.isEmpty()) {
            gen.out(",", "sts", ":[");
            boolean first = true;
            for (Type st : satisfies) {
                if (!first) {
                    gen.out(",", new String[0]);
                }
                first = false;
                TypeUtils.metamodelTypeNameOrList(false, that, d.getUnit().getPackage(), st, null, gen);
            }
            gen.out("]", new String[0]);
        }
        if (caseTypes != null && !caseTypes.isEmpty()) {
            gen.out(",of:[", new String[0]);
            boolean first = true;
            for (Type st : caseTypes) {
                TypeDeclaration std = st.getDeclaration();
                if (!first) {
                    gen.out(",", new String[0]);
                }
                first = false;
                if (ModelUtil.isConstructor(std)) {
                    if (std.isAnonymous()) {
                        gen.out(gen.getNames().name(d), ".", gen.getNames().valueConstructorName(std));
                        continue;
                    }
                    gen.out("/*TODO callable constructor*/", new String[0]);
                    continue;
                }
                if (std.isAnonymous()) {
                    if (std.isStatic()) {
                        gen.out(gen.getNames().name(ModelUtil.getContainingDeclaration(std)), ".$st$.", gen.getNames().objectName(std));
                        continue;
                    }
                    gen.out(gen.getNames().getter(std, true), new String[0]);
                    continue;
                }
                TypeUtils.metamodelTypeNameOrList(false, that, d.getUnit().getPackage(), st, null, gen);
            }
            gen.out("]", new String[0]);
        }
        if (annGen != null) {
            annGen.generateAnnotations();
        }
        gen.out(",d:", new String[0]);
        TypeUtils.outputModelPath(d, gen);
        gen.out("};}", new String[0]);
    }

    static boolean encodeTypeParametersForRuntime(Node node, Declaration d, List<TypeParameter> tparms, boolean first, GenerateJsVisitor gen) {
        for (TypeParameter tp : tparms) {
            boolean comma = false;
            if (!first) {
                gen.out(",", new String[0]);
            }
            first = false;
            gen.out(gen.getNames().typeParameterName(tp), ":{");
            if (tp.isCovariant()) {
                gen.out("dv", ":'out'");
                comma = true;
            } else if (tp.isContravariant()) {
                gen.out("dv", ":'in'");
                comma = true;
            }
            List<Type> typelist = tp.getSatisfiedTypes();
            if (typelist != null && !typelist.isEmpty()) {
                if (comma) {
                    gen.out(",", new String[0]);
                }
                gen.out("sts", ":[");
                boolean first2 = true;
                for (Type st : typelist) {
                    if (!first2) {
                        gen.out(",", new String[0]);
                    }
                    first2 = false;
                    TypeUtils.metamodelTypeNameOrList(false, node, d.getUnit().getPackage(), st, null, gen);
                }
                gen.out("]", new String[0]);
                comma = true;
            }
            if ((typelist = tp.getCaseTypes()) != null && !typelist.isEmpty()) {
                if (comma) {
                    gen.out(",", new String[0]);
                }
                gen.out("of:[", new String[0]);
                boolean first3 = true;
                for (Type st : typelist) {
                    if (!first3) {
                        gen.out(",", new String[0]);
                    }
                    first3 = false;
                    TypeUtils.metamodelTypeNameOrList(false, node, d.getUnit().getPackage(), st, null, gen);
                }
                gen.out("]", new String[0]);
                comma = true;
            }
            if (tp.getDefaultTypeArgument() != null) {
                if (comma) {
                    gen.out(",", new String[0]);
                }
                gen.out("def:", new String[0]);
                TypeUtils.metamodelTypeNameOrList(false, node, d.getUnit().getPackage(), tp.getDefaultTypeArgument(), null, gen);
            }
            gen.out("}", new String[0]);
        }
        return first;
    }

    static void metamodelTypeNameOrList(boolean resolveTargsFromScope, Node node, Package pkg, Type pt, SiteVariance useSiteVariance, GenerateJsVisitor gen) {
        if (pt == null) {
            gen.out("'$U'", new String[0]);
            return;
        }
        if (!TypeUtils.outputMetamodelTypeList(resolveTargsFromScope, node, pkg, pt, gen)) {
            TypeDeclaration type = pt.getDeclaration();
            if (pt.isTypeParameter()) {
                boolean rtafs;
                TypeParameter tparm = (TypeParameter)type;
                Declaration tpowner = tparm.getDeclaration();
                boolean nodeIsDecl = node instanceof Tree.Declaration;
                boolean bl = rtafs = !(tpowner instanceof TypeDeclaration) && (!nodeIsDecl || ((Tree.Declaration)node).getDeclarationModel() != tpowner);
                if (rtafs && ModelUtil.contains((Scope)((Object)tpowner), node.getScope())) {
                    if (tpowner instanceof TypeDeclaration) {
                        gen.out(gen.getNames().self((TypeDeclaration)tpowner), ".$$targs$$.", gen.getNames().typeParameterName(tparm));
                    } else if (tpowner instanceof Function) {
                        gen.out(gen.getNames().typeArgsParamName((Function)tpowner), ".", gen.getNames().typeParameterName(tparm));
                    }
                } else if (resolveTargsFromScope && tpowner instanceof TypeDeclaration && (!nodeIsDecl || ((Tree.Declaration)node).getDeclarationModel() == tpowner) && ModelUtil.contains((Scope)((Object)tpowner), node.getScope())) {
                    TypeUtils.typeNameOrList(node, tparm.getType(), gen, false);
                } else {
                    gen.out("'", gen.getNames().typeParameterName(tparm), "'");
                }
            } else if (pt.isTypeAlias()) {
                TypeUtils.outputQualifiedTypename(node, gen.isImported(pkg, type), pt, gen, false);
            } else {
                gen.out("{t:", new String[0]);
                Type qt = type instanceof Constructor ? pt.getQualifyingType() : pt;
                TypeUtils.outputQualifiedTypename(node, gen.isImported(pkg, type), qt, gen, false);
                if (!pt.getTypeArguments().isEmpty()) {
                    gen.out(",a:{", new String[0]);
                    boolean first = true;
                    for (Map.Entry<TypeParameter, Type> e : pt.getTypeArguments().entrySet()) {
                        if (first) {
                            first = false;
                        } else {
                            gen.out(",", new String[0]);
                        }
                        gen.out(gen.getNames().typeParameterName(e.getKey()), ":");
                        TypeUtils.metamodelTypeNameOrList(resolveTargsFromScope, node, pkg, e.getValue(), pt.getVarianceOverrides().get(e.getKey()), gen);
                    }
                    gen.out("}", new String[0]);
                }
                TypeUtils.printSiteVariance(useSiteVariance, gen);
                gen.out("}", new String[0]);
            }
        }
    }

    private static void printSiteVariance(SiteVariance sv, GenerateJsVisitor gen) {
        if (sv != null) {
            gen.out(",", "uv", ":");
            if (sv == SiteVariance.IN) {
                gen.out("'in'", new String[0]);
            } else {
                gen.out("'out'", new String[0]);
            }
        }
    }

    static boolean outputMetamodelTypeList(boolean resolveTargs, Node node, Package pkg, Type pt, GenerateJsVisitor gen) {
        List<Type> subs;
        if (pt.isIntersection()) {
            gen.out("{t:'i", new String[0]);
            subs = pt.getSatisfiedTypes();
        } else if (pt.isUnion()) {
            gen.out("{t:'u", new String[0]);
            subs = pt.getCaseTypes();
        } else {
            if (pt.isTuple()) {
                if (pt.involvesTypeParameters() && resolveTargs) {
                    gen.out("{t:", gen.getClAlias(), "Tuple,a:");
                    TypeUtils.printTypeArguments(node, pt.getTypeArguments(), gen, false, pt.getVarianceOverrides());
                } else {
                    gen.out("{t:'T',l:", new String[0]);
                    TypeUtils.encodeTupleAsParameterListForRuntime(resolveTargs, node, pt, false, gen);
                }
                gen.out("}", new String[0]);
                return true;
            }
            return false;
        }
        gen.out("',l:[", new String[0]);
        boolean first = true;
        for (Type t : subs) {
            if (!first) {
                gen.out(",", new String[0]);
            }
            TypeUtils.metamodelTypeNameOrList(resolveTargs, node, pkg, t, null, gen);
            first = false;
        }
        gen.out("]}", new String[0]);
        return true;
    }

    static String pathToModelDoc(Declaration d) {
        if (d == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String p : TypeUtils.generateModelPath(d)) {
            sb.append(sb.length() == 0 ? (char)'\'' : ':').append(p);
        }
        sb.append('\'');
        return sb.toString();
    }

    public static void outputAnnotationsFunction(Tree.AnnotationList annotations, AnnotationFunctionHelper helper, GenerateJsVisitor gen) {
        List<Tree.Annotation> anns = annotations == null ? null : annotations.getAnnotations();
        int mask = 0;
        if (helper.getPackedAnnotationsKey() != null) {
            mask = MetamodelGenerator.encodeAnnotations(helper.getAnnotations(), helper.getAnnotationSource(), null);
            if (mask > 0) {
                gen.out(",", helper.getPackedAnnotationsKey(), ":", Integer.toString(mask));
            }
            if (annotations == null || anns.isEmpty() && annotations.getAnonymousAnnotation() == null) {
                return;
            }
            anns = new ArrayList<Tree.Annotation>(annotations.getAnnotations().size());
            anns.addAll(annotations.getAnnotations());
            Iterator<Tree.Annotation> iter = anns.iterator();
            while (iter.hasNext()) {
                String qn = ((Tree.StaticMemberOrTypeExpression)iter.next().getPrimary()).getDeclaration().getQualifiedNameString();
                if (qn.equals("ceylon.language::native") || !qn.startsWith("ceylon.language::") || !MetamodelGenerator.annotationBits.contains(qn.substring(17))) continue;
                iter.remove();
            }
            if (anns.isEmpty() && annotations.getAnonymousAnnotation() == null) {
                return;
            }
        }
        if (helper.getAnnotationsKey() != null) {
            gen.out(",", helper.getAnnotationsKey(), ":");
        }
        if (annotations == null || anns.isEmpty() && annotations.getAnonymousAnnotation() == null) {
            gen.out("[]", new String[0]);
        } else {
            gen.out("function(){return[", new String[0]);
            boolean first = true;
            if (annotations.getAnonymousAnnotation() != null) {
                first = false;
                Tree.StringLiteral lit = annotations.getAnonymousAnnotation().getStringLiteral();
                String ptmd = helper.getPathToModelDoc();
                if (ptmd != null && ptmd.length() < lit.getText().length()) {
                    gen.out(gen.getClAlias(), "doc$($CCMM$,", ptmd);
                    if (helper.getAnPath() != null) {
                        gen.out(",", helper.getAnPath());
                    }
                } else {
                    gen.out(gen.getClAlias(), "doc(");
                    lit.visit(gen);
                }
                gen.out(")", new String[0]);
            }
            for (Tree.Annotation a : anns) {
                if (first) {
                    first = false;
                } else {
                    gen.out(",", new String[0]);
                }
                gen.getInvoker().generateInvocation(a);
            }
            gen.out("];}", new String[0]);
        }
    }

    public static void outputAnnotationsFunction(Tree.AnnotationList annotations, final Declaration d, GenerateJsVisitor gen) {
        TypeUtils.outputAnnotationsFunction(annotations, new AnnotationFunctionHelper(){

            @Override
            public String getPathToModelDoc() {
                return TypeUtils.pathToModelDoc(d);
            }

            @Override
            public String getPackedAnnotationsKey() {
                return "pa";
            }

            @Override
            public String getAnnotationsKey() {
                return "an";
            }

            @Override
            public List<Annotation> getAnnotations() {
                return d.getAnnotations();
            }

            @Override
            public Object getAnnotationSource() {
                return d;
            }

            @Override
            public String getAnPath() {
                return null;
            }
        }, gen);
    }

    public static Map<TypeParameter, Type> mapTypeArgument(Tree.BinaryOperatorExpression expr, String methodName, String rightTpName, String leftTpName) {
        Function md = (Function)expr.getLeftTerm().getTypeModel().getDeclaration().getMember(methodName, null, false);
        if (md == null) {
            expr.addUnexpectedError("Left term of intersection operator should have method named " + methodName, Backend.JavaScript);
            return null;
        }
        Map<TypeParameter, Type> targs = expr.getRightTerm().getTypeModel().getTypeArguments();
        Type otherType = null;
        for (TypeParameter tp : targs.keySet()) {
            if (!tp.getName().equals(rightTpName)) continue;
            otherType = targs.get(tp);
            break;
        }
        if (otherType == null) {
            expr.addUnexpectedError("Right term of intersection operator should have type parameter named " + rightTpName, Backend.JavaScript);
            return null;
        }
        targs = new HashMap<TypeParameter, Type>();
        TypeParameter mtp = null;
        for (TypeParameter tp : md.getTypeParameters()) {
            if (!tp.getName().equals(leftTpName)) continue;
            mtp = tp;
            break;
        }
        if (mtp == null) {
            expr.addUnexpectedError("Left term of intersection should have type parameter named " + leftTpName, Backend.JavaScript);
        }
        targs.put(mtp, otherType);
        return targs;
    }

    public static String qualifiedNameSkippingMethods(Declaration d) {
        StringBuilder p = new StringBuilder(d.getName());
        for (Scope s = d.getContainer(); s != null; s = s.getContainer()) {
            if (s instanceof Package) {
                String pkname = ((Package)s).getNameAsString();
                if (pkname.isEmpty()) continue;
                p.insert(0, "::");
                p.insert(0, pkname);
                continue;
            }
            if (!(s instanceof TypeDeclaration)) continue;
            p.insert(0, '.');
            p.insert(0, ((TypeDeclaration)s).getName());
        }
        return p.toString();
    }

    public static String modelName(Declaration d) {
        String dname = d.getName();
        if (dname == null && d instanceof Constructor) {
            dname = "$def";
        }
        if (dname.startsWith("anonymous#")) {
            dname = "anon$" + dname.substring(10);
        }
        if (d.isToplevel() || d.isShared()) {
            return dname;
        }
        if (d instanceof Setter) {
            d = ((Setter)d).getGetter();
        }
        return dname + "$" + Long.toString(Math.abs((long)d.hashCode()), 36);
    }

    public static boolean acceptNative(Tree.Declaration node) {
        return node.getDeclarationModel() == null || TypeUtils.acceptNative(node.getDeclarationModel());
    }

    public static boolean acceptNative(Declaration decl) {
        return !decl.isNative() || NativeUtil.isForBackend(decl, Backend.JavaScript) || TypeUtils.isNativeExternal(decl) || NativeUtil.isHeaderWithoutBackend(decl, Backend.JavaScript) && ModelUtil.isImplemented(decl);
    }

    public static boolean isCallable(Type t) {
        return t != null && !t.isUnknown() && t.isCallable();
    }

    public static boolean isNativeExternal(Declaration decl) {
        return decl.isNativeHeader() && (decl.getOverloads() == null || decl.getOverloads().isEmpty());
    }

    public static List<Type> getTypes(List<Tree.StaticType> treeTypes) {
        if (treeTypes == null) {
            return null;
        }
        if (treeTypes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Type> r = new ArrayList<Type>(treeTypes.size());
        for (Tree.StaticType st : treeTypes) {
            r.add(st.getTypeModel().resolveAliases());
        }
        return r;
    }

    public static Constructor getConstructor(Declaration d) {
        if (d instanceof Constructor) {
            return (Constructor)d;
        }
        if (d instanceof FunctionOrValue && ((FunctionOrValue)d).getTypeDeclaration() instanceof Constructor) {
            return (Constructor)((FunctionOrValue)d).getTypeDeclaration();
        }
        if (d instanceof Class) {
            return ((Class)d).getDefaultConstructor();
        }
        return null;
    }

    public static boolean makeAbstractNative(Declaration d) {
        return d.isNativeHeader() && ModelUtil.getNativeDeclaration(d, Backend.JavaScript) != null;
    }

    public static Declaration getToplevel(Declaration d) {
        while (d != null && !d.isToplevel()) {
            Scope s;
            for (s = d.getContainer(); s != null && !(s instanceof Declaration); s = s.getContainer()) {
            }
            d = (Declaration)((Object)s);
        }
        return d;
    }

    public static boolean isNativeJs(Tree.Term t) {
        if (t instanceof Tree.MemberOrTypeExpression) {
            return TypeUtils.isNativeJs(((Tree.MemberOrTypeExpression)t).getDeclaration());
        }
        return false;
    }

    public static boolean isNativeJs(Declaration d) {
        return TypeUtils.hasAnnotationByName(TypeUtils.getToplevel(d), "nativejs") || TypeUtils.isUnknown(d);
    }

    private static boolean hasAnnotationByName(Declaration d, String name) {
        if (d != null) {
            for (Annotation annotation : d.getAnnotations()) {
                if (!annotation.getName().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isStaticWithGenericContainer(Declaration d) {
        if (d != null && d.isStatic() && d.getContainer() instanceof Generic) {
            Generic c = (Generic)((Object)d.getContainer());
            return c.isParameterized();
        }
        return false;
    }

    public static boolean intsOrFloats(Type t1, Type t2) {
        return !(t1 == null || t2 == null || !t1.isInteger() && !t1.isFloat() || !t2.isInteger() && !t2.isFloat());
    }

    public static boolean bothInts(Type t1, Type t2) {
        return t1 != null && t2 != null && t1.isInteger() && t2.isInteger();
    }

    public static boolean bothFloats(Type t1, Type t2) {
        return t1 != null && t2 != null && t1.isFloat() && t2.isFloat();
    }

    static class ModelAnnotationGenerator
    implements RuntimeMetamodelAnnotationGenerator {
        private final GenerateJsVisitor gen;
        private final Declaration d;
        private final Node node;

        ModelAnnotationGenerator(GenerateJsVisitor generator, Declaration decl, Node n) {
            this.gen = generator;
            this.d = decl;
            this.node = n;
        }

        @Override
        public void generateAnnotations() {
            List<Annotation> anns = this.d.getAnnotations();
            int bits = MetamodelGenerator.encodeAnnotations(anns, this.d, null);
            if (bits > 0) {
                this.gen.out(",", "pa", ":", Integer.toString(bits));
                anns = new ArrayList<Annotation>(this.d.getAnnotations().size());
                anns.addAll(this.d.getAnnotations());
                Iterator<Annotation> iter = anns.iterator();
                while (iter.hasNext()) {
                    Annotation a = iter.next();
                    Declaration ad = this.d.getUnit().getPackage().getMemberOrParameter(this.d.getUnit(), a.getName(), null, false);
                    String qn = ad.getQualifiedNameString();
                    if (!qn.startsWith("ceylon.language::") || !MetamodelGenerator.annotationBits.contains(qn.substring(17))) continue;
                    iter.remove();
                }
                if (anns.isEmpty()) {
                    return;
                }
            }
            this.gen.out(",", "an", ":function(){return[");
            boolean first = true;
            for (Annotation a : anns) {
                Declaration ad = this.d.getUnit().getPackage().getMemberOrParameter(this.d.getUnit(), a.getName(), null, false);
                if (ad instanceof Function) {
                    if (first) {
                        first = false;
                    } else {
                        this.gen.out(",", new String[0]);
                    }
                    boolean isDoc = "ceylon.language::doc".equals(ad.getQualifiedNameString());
                    if (!isDoc) {
                        this.gen.qualify(this.node, ad);
                        this.gen.out(this.gen.getNames().name(ad), "(");
                    }
                    if (a.getPositionalArguments() == null) {
                        for (Parameter p : ((Function)ad).getFirstParameterList().getParameters()) {
                            String v = a.getNamedArguments().get(p.getName());
                            this.gen.out(v == null ? "undefined" : v, new String[0]);
                        }
                    } else if (isDoc) {
                        String ref = TypeUtils.pathToModelDoc(this.d);
                        String doc = a.getPositionalArguments().get(0);
                        if (ref != null && ref.length() < doc.length()) {
                            this.gen.out(this.gen.getClAlias(), "doc$($CCMM$,", ref);
                        } else {
                            this.gen.out(this.gen.getClAlias(), "doc(\"", JsUtils.escapeStringLiteral(doc), "\"");
                        }
                    } else {
                        boolean farg = true;
                        for (String s : a.getPositionalArguments()) {
                            if (farg) {
                                farg = false;
                            } else {
                                this.gen.out(",", new String[0]);
                            }
                            this.gen.out("\"", JsUtils.escapeStringLiteral(s), "\"");
                        }
                    }
                    this.gen.out(")", new String[0]);
                    continue;
                }
                this.gen.out("/*MISSING DECLARATION FOR ANNOTATION ", a.getName(), "*/");
            }
            this.gen.out("];}", new String[0]);
        }
    }

    public static interface RuntimeMetamodelAnnotationGenerator {
        public void generateAnnotations();
    }

    public static interface AnnotationFunctionHelper {
        public String getPackedAnnotationsKey();

        public String getAnnotationsKey();

        public Object getAnnotationSource();

        public List<Annotation> getAnnotations();

        public String getPathToModelDoc();

        public String getAnPath();
    }
}

