/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.analyzer;

import com.redhat.ceylon.compiler.typechecker.analyzer.AnalyzerUtil;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.TreeUtil;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import java.util.List;

public class ControlFlowVisitor
extends Visitor {
    private boolean definitelyReturns = false;
    private boolean definitelyBreaksOrContinues = false;
    private boolean canReturn = false;
    private boolean canExecute = true;
    private boolean unreachabilityReported = false;
    private LoopState loopState = null;

    boolean beginDefiniteReturnScope() {
        boolean dr = this.definitelyReturns;
        this.definitelyReturns = false;
        return dr;
    }

    boolean beginIndefiniteReturnScope() {
        return this.definitelyReturns;
    }

    void endDefiniteReturnScope(boolean dr) {
        this.definitelyReturns = dr;
        this.unreachabilityReported = false;
    }

    void exit() {
        this.definitelyReturns = true;
    }

    boolean beginReturnScope(boolean cr) {
        boolean ocr = this.canReturn;
        this.canReturn = cr;
        return ocr;
    }

    void endReturnScope(boolean cr) {
        this.canReturn = cr;
    }

    boolean beginStatementScope(boolean ce) {
        boolean oce = this.canExecute;
        this.canExecute = ce;
        return oce;
    }

    void endStatementScope(boolean ce) {
        this.canExecute = ce;
    }

    LoopState beginLoop() {
        LoopState efl = this.loopState;
        this.loopState = new LoopState();
        return efl;
    }

    void endLoop(LoopState efl) {
        this.loopState = efl;
    }

    void exitLoop() {
        if (this.loopState != null) {
            this.loopState.breaks = true;
        }
    }

    void continueLoop() {
        if (this.loopState != null) {
            this.loopState.continues = true;
        }
    }

    boolean inLoop() {
        return this.loopState != null;
    }

    boolean beginLoopScope() {
        boolean obc = this.definitelyBreaksOrContinues;
        this.definitelyBreaksOrContinues = false;
        return obc;
    }

    void endLoopScope(boolean bc) {
        this.definitelyBreaksOrContinues = bc;
    }

    void exitLoopScope() {
        this.definitelyBreaksOrContinues = true;
    }

    LoopState pauseLoop() {
        LoopState efl = this.loopState;
        this.loopState = null;
        return efl;
    }

    void unpauseLoop(LoopState efl) {
        this.loopState = efl;
    }

    boolean pauseLoopScope() {
        Boolean bc = this.definitelyBreaksOrContinues;
        this.definitelyBreaksOrContinues = false;
        return bc;
    }

    void unpauseLoopScope(boolean bc) {
        this.definitelyBreaksOrContinues = bc;
    }

    @Override
    public void visit(Tree.AttributeGetterDefinition that) {
        boolean c = this.beginReturnScope(true);
        boolean d = this.beginDefiniteReturnScope();
        super.visit(that);
        this.checkDefiniteReturn(that, TreeUtil.name(that.getIdentifier()));
        this.endDefiniteReturnScope(d);
        this.endReturnScope(c);
    }

    @Override
    public void visit(Tree.AttributeArgument that) {
        if (that.getSpecifierExpression() == null) {
            boolean c = this.beginReturnScope(true);
            boolean d = this.beginDefiniteReturnScope();
            super.visit(that);
            this.checkDefiniteReturn(that, TreeUtil.name(that.getIdentifier()));
            this.endDefiniteReturnScope(d);
            this.endReturnScope(c);
        } else {
            super.visit(that);
        }
    }

    private void checkDefiniteReturn(Node that, String name) {
        if (!this.definitelyReturns) {
            name = name == null ? "anonymous function" : "'" + name + "'";
            that.addError("does not definitely return: " + name + " has branches which do not end in a 'return' statement", 12100);
        }
    }

    @Override
    public void visit(Tree.MethodDefinition that) {
        boolean c = this.beginReturnScope(true);
        boolean d = this.beginDefiniteReturnScope();
        super.visit(that);
        if (!that.getDeclarationModel().isDeclaredVoid()) {
            this.checkDefiniteReturn(that, TreeUtil.name(that.getIdentifier()));
        }
        this.endDefiniteReturnScope(d);
        this.endReturnScope(c);
    }

    @Override
    public void visit(Tree.MethodArgument that) {
        if (that.getSpecifierExpression() == null) {
            boolean c = this.beginReturnScope(true);
            boolean d = this.beginDefiniteReturnScope();
            super.visit(that);
            if (!that.getDeclarationModel().isDeclaredVoid()) {
                this.checkDefiniteReturn(that, TreeUtil.name(that.getIdentifier()));
            }
            this.endDefiniteReturnScope(d);
            this.endReturnScope(c);
        } else {
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.FunctionArgument that) {
        if (that.getExpression() == null) {
            LoopState efl = this.pauseLoop();
            boolean bc = this.pauseLoopScope();
            boolean c = this.beginReturnScope(true);
            boolean d = this.beginDefiniteReturnScope();
            super.visit(that);
            if (!that.getDeclarationModel().isDeclaredVoid()) {
                this.checkDefiniteReturn(that, null);
            }
            this.endDefiniteReturnScope(d);
            this.endReturnScope(c);
            this.unpauseLoop(efl);
            this.unpauseLoopScope(bc);
        } else {
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.AttributeDeclaration that) {
        if (!that.getDeclarationModel().isParameter() && that.getSpecifierOrInitializerExpression() != null && !(that.getSpecifierOrInitializerExpression() instanceof Tree.LazySpecifierExpression)) {
            this.checkExecutableStatementAllowed(that.getSpecifierOrInitializerExpression());
            super.visit(that);
        } else {
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.AttributeSetterDefinition that) {
        boolean c = this.beginReturnScope(true);
        boolean d = this.beginDefiniteReturnScope();
        super.visit(that);
        this.endReturnScope(c);
        this.endDefiniteReturnScope(d);
    }

    @Override
    public void visit(Tree.Constructor that) {
        this.checkReachable(that);
        boolean c = this.beginReturnScope(true);
        boolean d = this.beginDefiniteReturnScope();
        super.visit(that);
        this.endReturnScope(c);
        this.endDefiniteReturnScope(d);
    }

    @Override
    public void visit(Tree.Enumerated that) {
        this.checkReachable(that);
        boolean c = this.beginReturnScope(true);
        boolean d = this.beginDefiniteReturnScope();
        super.visit(that);
        this.endReturnScope(c);
        this.endDefiniteReturnScope(d);
    }

    @Override
    public void visit(Tree.ClassDefinition that) {
        boolean c = this.beginReturnScope(true);
        boolean d = this.beginDefiniteReturnScope();
        super.visit(that);
        this.endReturnScope(c);
        this.endDefiniteReturnScope(d);
    }

    @Override
    public void visit(Tree.InterfaceDefinition that) {
        boolean c = this.beginReturnScope(false);
        boolean d = this.beginDefiniteReturnScope();
        super.visit(that);
        this.endReturnScope(c);
        this.endDefiniteReturnScope(d);
    }

    @Override
    public void visit(Tree.ObjectDefinition that) {
        boolean c = this.beginReturnScope(true);
        boolean d = this.beginDefiniteReturnScope();
        super.visit(that);
        this.endReturnScope(c);
        this.endDefiniteReturnScope(d);
    }

    @Override
    public void visit(Tree.ObjectArgument that) {
        boolean c = this.beginReturnScope(true);
        boolean d = this.beginDefiniteReturnScope();
        super.visit(that);
        this.endReturnScope(c);
        this.endDefiniteReturnScope(d);
    }

    @Override
    public void visit(Tree.ObjectExpression that) {
        boolean c = this.beginReturnScope(true);
        boolean d = this.beginDefiniteReturnScope();
        super.visit(that);
        this.endReturnScope(c);
        this.endDefiniteReturnScope(d);
    }

    @Override
    public void visit(Tree.Body that) {
        boolean e = this.beginStatementScope(!(that instanceof Tree.InterfaceBody));
        super.visit(that);
        this.endStatementScope(e);
    }

    @Override
    public void visit(Tree.LazySpecifierExpression that) {
        boolean e = this.beginStatementScope(true);
        super.visit(that);
        this.endStatementScope(e);
    }

    @Override
    public void visit(Tree.Block that) {
        super.visit(that);
        that.setDefinitelyReturns(this.definitelyReturns);
        that.setDefinitelyBreaksOrContinues(this.definitelyBreaksOrContinues);
    }

    @Override
    public void visit(Tree.Declaration that) {
        LoopState efl = this.pauseLoop();
        boolean bc = this.pauseLoopScope();
        super.visit(that);
        this.unpauseLoop(efl);
        this.unpauseLoopScope(bc);
    }

    @Override
    public void visit(Tree.TypedArgument that) {
        LoopState efl = this.pauseLoop();
        boolean bc = this.pauseLoopScope();
        super.visit(that);
        this.unpauseLoop(efl);
        this.unpauseLoopScope(bc);
    }

    @Override
    public void visit(Tree.ExecutableStatement that) {
        boolean executable = true;
        if (that instanceof Tree.SpecifierStatement) {
            Tree.SpecifierStatement s = (Tree.SpecifierStatement)that;
            boolean bl = executable = !(s.getSpecifierExpression() instanceof Tree.LazySpecifierExpression) || !s.getRefinement();
        }
        if (executable) {
            this.checkExecutableStatementAllowed(that);
        }
        super.visit(that);
    }

    private void checkExecutableStatementAllowed(Node that) {
        if (!this.canExecute) {
            that.addError("statement or initializer may not occur directly in interface body");
        }
    }

    @Override
    public void visit(Tree.Return that) {
        if (!this.canReturn) {
            that.addError("nothing to return from");
        }
        super.visit(that);
        this.exit();
        this.exitLoopScope();
    }

    @Override
    public void visit(Tree.Throw that) {
        super.visit(that);
        this.exit();
        this.exitLoopScope();
    }

    @Override
    public void visit(Tree.Break that) {
        if (!this.inLoop()) {
            that.addError("no surrounding loop to break");
        }
        super.visit(that);
        this.exitLoop();
        this.exitLoopScope();
    }

    @Override
    public void visit(Tree.Continue that) {
        if (!this.inLoop()) {
            that.addError("no surrounding loop to continue");
        }
        super.visit(that);
        this.continueLoop();
        this.exitLoopScope();
    }

    @Override
    public void visit(Tree.Statement that) {
        if (!(that instanceof Tree.Variable)) {
            this.checkReachable(that);
        }
        super.visit(that);
    }

    private void checkReachable(Tree.Statement that) {
        if ((this.definitelyReturns || this.definitelyBreaksOrContinues) && !this.unreachabilityReported) {
            that.addError("unreachable code");
            this.unreachabilityReported = true;
        }
    }

    @Override
    public void visit(Tree.WhileStatement that) {
        this.checkExecutableStatementAllowed(that);
        this.checkReachable(that);
        boolean d = this.beginIndefiniteReturnScope();
        LoopState b = this.beginLoop();
        boolean bc = this.beginLoopScope();
        that.getWhileClause().visit(this);
        boolean definitelyDoesNotBreakWhile = !this.loopState.breaks;
        this.endDefiniteReturnScope(d);
        this.endLoop(b);
        this.endLoopScope(bc);
        if (AnalyzerUtil.isAlwaysSatisfied(that.getWhileClause().getConditionList()) && definitelyDoesNotBreakWhile) {
            this.definitelyReturns = true;
        }
    }

    @Override
    public void visit(Tree.ForStatement that) {
        boolean definitelyReturnsFromElse;
        this.checkExecutableStatementAllowed(that);
        this.checkReachable(that);
        boolean d = this.beginIndefiniteReturnScope();
        LoopState b = this.beginLoop();
        boolean bc = this.beginLoopScope();
        boolean atLeastOneIteration = false;
        Tree.ForClause forClause = that.getForClause();
        if (forClause != null) {
            forClause.visit(this);
            atLeastOneIteration = AnalyzerUtil.isAtLeastOne(forClause);
        }
        boolean definitelyDoesNotBreakFor = !this.loopState.breaks;
        boolean definitelyDoesNotContinueFor = !this.loopState.continues;
        boolean definitelyReturnsFromFor = this.definitelyReturns && atLeastOneIteration && definitelyDoesNotBreakFor && definitelyDoesNotContinueFor;
        that.setExits(this.loopState.breaks);
        this.endLoop(b);
        this.endLoopScope(bc);
        this.definitelyReturns = d || definitelyReturnsFromFor;
        Tree.ElseClause elseClause = that.getElseClause();
        if (elseClause != null) {
            elseClause.visit(this);
            definitelyReturnsFromElse = this.definitelyReturns && definitelyDoesNotBreakFor;
        } else {
            definitelyReturnsFromElse = false;
        }
        this.endLoopScope(bc);
        this.definitelyReturns = d || definitelyReturnsFromFor || definitelyReturnsFromElse;
    }

    @Override
    public void visit(Tree.IfStatement that) {
        Tree.ConditionList cl;
        boolean breaksOrContinuesFromElse;
        boolean definitelyReturnsFromElse;
        this.checkExecutableStatementAllowed(that);
        this.checkReachable(that);
        boolean d = this.beginIndefiniteReturnScope();
        LoopState ls = this.loopState;
        boolean bc = this.definitelyBreaksOrContinues;
        this.loopState = ls == null ? null : new LoopState(ls);
        Tree.IfClause ifClause = that.getIfClause();
        if (ifClause != null) {
            ifClause.visit(this);
        }
        boolean definitelyReturnsFromIf = this.definitelyReturns;
        boolean possiblyBreaksFromIf = this.inLoop() && this.loopState.breaks;
        boolean possiblyContinuesFromIf = this.inLoop() && this.loopState.continues;
        boolean breaksOrContinuesFromIf = this.definitelyBreaksOrContinues;
        this.loopState = ls;
        this.endDefiniteReturnScope(d);
        this.endLoopScope(bc);
        this.loopState = ls == null ? null : new LoopState(ls);
        Tree.ElseClause elseClause = that.getElseClause();
        if (elseClause != null) {
            elseClause.visit(this);
            definitelyReturnsFromElse = this.definitelyReturns;
            breaksOrContinuesFromElse = this.definitelyBreaksOrContinues;
        } else {
            definitelyReturnsFromElse = false;
            breaksOrContinuesFromElse = false;
        }
        Boolean possiblyBreaksFromElse = this.inLoop() && this.loopState.breaks;
        boolean possiblyContinuesFromElse = this.inLoop() && this.loopState.continues;
        this.loopState = ls;
        this.endLoopScope(bc);
        Tree.ConditionList conditionList = cl = ifClause == null ? null : ifClause.getConditionList();
        if (AnalyzerUtil.isAlwaysSatisfied(cl)) {
            this.definitelyReturns = d || definitelyReturnsFromIf;
            boolean bl = this.definitelyBreaksOrContinues = bc || breaksOrContinuesFromIf;
            if (this.inLoop()) {
                this.loopState.breaks = this.loopState.breaks || possiblyBreaksFromIf;
                this.loopState.continues = this.loopState.continues || possiblyContinuesFromIf;
            }
        } else if (AnalyzerUtil.isNeverSatisfied(cl)) {
            this.definitelyReturns = d || definitelyReturnsFromElse;
            boolean bl = this.definitelyBreaksOrContinues = bc || breaksOrContinuesFromElse;
            if (this.inLoop()) {
                this.loopState.breaks = this.loopState.breaks || possiblyBreaksFromElse != false;
                this.loopState.continues = this.loopState.continues || possiblyContinuesFromElse;
            }
        } else {
            this.definitelyReturns = d || definitelyReturnsFromIf && definitelyReturnsFromElse;
            boolean bl = this.definitelyBreaksOrContinues = bc || breaksOrContinuesFromIf && breaksOrContinuesFromElse;
            if (this.inLoop()) {
                this.loopState.breaks = this.loopState.breaks || possiblyBreaksFromIf || possiblyBreaksFromElse != false;
                this.loopState.continues = this.loopState.continues || possiblyContinuesFromIf || possiblyContinuesFromElse;
            }
        }
    }

    @Override
    public void visit(Tree.SwitchStatement that) {
        this.checkExecutableStatementAllowed(that);
        this.checkReachable(that);
        boolean d = this.beginIndefiniteReturnScope();
        boolean bc = this.definitelyBreaksOrContinues;
        that.getSwitchClause().visit(this);
        boolean definitelyReturnsFromEveryCase = true;
        boolean definitelyBreaksOrContinuesFromEveryCase = true;
        List<Tree.CaseClause> caseClauses = that.getSwitchCaseList().getCaseClauses();
        for (Tree.CaseClause cc : caseClauses) {
            cc.visit(this);
            definitelyReturnsFromEveryCase = definitelyReturnsFromEveryCase && this.definitelyReturns;
            definitelyBreaksOrContinuesFromEveryCase = definitelyBreaksOrContinuesFromEveryCase && this.definitelyBreaksOrContinues;
            this.endDefiniteReturnScope(d);
            this.endLoopScope(bc);
        }
        Tree.ElseClause elseClause = that.getSwitchCaseList().getElseClause();
        if (elseClause != null) {
            elseClause.visit(this);
            definitelyReturnsFromEveryCase = definitelyReturnsFromEveryCase && this.definitelyReturns;
            definitelyBreaksOrContinuesFromEveryCase = definitelyBreaksOrContinuesFromEveryCase && this.definitelyBreaksOrContinues;
            this.endDefiniteReturnScope(d);
            this.endLoopScope(bc);
        }
        this.definitelyReturns = d || definitelyReturnsFromEveryCase;
        this.definitelyBreaksOrContinues = bc || definitelyBreaksOrContinuesFromEveryCase;
    }

    @Override
    public void visit(Tree.TryCatchStatement that) {
        boolean definitelyBreaksOrContinuesFromFinally;
        boolean definitelyReturnsFromFinally;
        this.checkExecutableStatementAllowed(that);
        this.checkReachable(that);
        boolean d = this.beginIndefiniteReturnScope();
        boolean bc = this.definitelyBreaksOrContinues;
        Tree.TryClause tryClause = that.getTryClause();
        if (tryClause != null) {
            tryClause.visit(this);
        }
        boolean definitelyReturnsFromTry = this.definitelyReturns;
        boolean definitelyBreaksOrContinuesFromTry = this.definitelyBreaksOrContinues;
        this.endDefiniteReturnScope(d);
        this.endLoopScope(bc);
        boolean definitelyReturnsFromEveryCatch = true;
        boolean definitelyBreaksOrContinuesFromEveryCatch = true;
        for (Tree.CatchClause cc : that.getCatchClauses()) {
            cc.visit(this);
            definitelyReturnsFromEveryCatch = definitelyReturnsFromEveryCatch && this.definitelyReturns;
            definitelyBreaksOrContinuesFromEveryCatch = definitelyBreaksOrContinuesFromEveryCatch && this.definitelyBreaksOrContinues;
            this.endDefiniteReturnScope(d);
            this.endLoopScope(bc);
        }
        Tree.FinallyClause finallyClause = that.getFinallyClause();
        if (finallyClause != null) {
            finallyClause.visit(this);
            definitelyReturnsFromFinally = this.definitelyReturns;
            definitelyBreaksOrContinuesFromFinally = this.definitelyBreaksOrContinues;
        } else {
            definitelyReturnsFromFinally = false;
            definitelyBreaksOrContinuesFromFinally = false;
        }
        this.definitelyReturns = d || definitelyReturnsFromTry && definitelyReturnsFromEveryCatch || definitelyReturnsFromFinally;
        this.definitelyBreaksOrContinues = bc || definitelyBreaksOrContinuesFromTry && definitelyBreaksOrContinuesFromEveryCatch || definitelyBreaksOrContinuesFromFinally;
    }

    @Override
    public void visit(Tree.ExpressionStatement that) {
        super.visit(that);
        Tree.Expression expr = that.getExpression();
        if (expr != null) {
            Tree.Term t = expr.getTerm();
            if (t == null) {
                expr.addError("malformed expression statement");
            } else if (!(t instanceof Tree.InvocationExpression || t instanceof Tree.PostfixOperatorExpression || t instanceof Tree.PrefixOperatorExpression || t instanceof Tree.AssignmentOp)) {
                expr.addError("not a legal statement (not an invocation, assignment, or increment/decrement)", 3000);
            }
        }
    }

    @Override
    public void visit(Tree.Assertion that) {
        super.visit(that);
        if (AnalyzerUtil.isNeverSatisfied(that.getConditionList())) {
            this.definitelyReturns = true;
        }
    }

    private static class LoopState {
        private boolean breaks = false;
        private boolean continues = false;

        private LoopState() {
        }

        private LoopState(LoopState loopState) {
            this.breaks = loopState.breaks;
            this.continues = loopState.continues;
        }
    }
}

