/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.analyzer;

import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.compiler.typechecker.analyzer.AnalyzerUtil;
import com.redhat.ceylon.compiler.typechecker.analyzer.Warning;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.TreeUtil;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.loader.JvmBackendUtil;
import com.redhat.ceylon.model.loader.NamingBase;
import com.redhat.ceylon.model.typechecker.model.Cancellable;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Import;
import com.redhat.ceylon.model.typechecker.model.ImportList;
import com.redhat.ceylon.model.typechecker.model.ImportScope;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.Unit;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ImportVisitor
extends Visitor {
    private Unit unit;
    private Cancellable cancellable;

    public ImportVisitor(Cancellable cancellable) {
        this.cancellable = cancellable;
    }

    public ImportVisitor(Unit unit, Cancellable cancellable) {
        this.unit = unit;
        this.cancellable = cancellable;
    }

    @Override
    public void visit(Tree.CompilationUnit that) {
        this.unit = that.getUnit();
        super.visit(that);
        HashSet<String> set = new HashSet<String>();
        for (Tree.Import im : that.getImportList().getImports()) {
            String mp;
            Tree.ImportPath ip = im.getImportPath();
            if (ip == null || set.add(mp = TreeUtil.formatPath(ip.getIdentifiers()))) continue;
            ip.addError("duplicate import: package '" + mp + "' is already imported");
        }
    }

    @Override
    public void visit(Tree.Import that) {
        Backends scopedBackends = that.getScope().getScopedBackends();
        if (!scopedBackends.none() && !scopedBackends.supports(this.unit.getSupportedBackends())) {
            return;
        }
        Tree.ImportPath path = that.getImportPath();
        Package importedPackage = AnalyzerUtil.importedPackage(path, this.unit);
        if (importedPackage != null) {
            path.setModel(importedPackage);
            Tree.ImportMemberOrTypeList imtl = that.getImportMemberOrTypeList();
            if (imtl != null) {
                ImportList il = imtl.getImportList();
                il.setImportedScope(importedPackage);
                HashSet<String> names = new HashSet<String>();
                List<Tree.ImportMemberOrType> list = imtl.getImportMemberOrTypes();
                for (Tree.ImportMemberOrType member : list) {
                    names.add(this.importMember(member, importedPackage, il));
                }
                if (imtl.getImportWildcard() != null) {
                    this.importAllMembers(importedPackage, names, il);
                } else if (list.isEmpty()) {
                    imtl.addError("empty import list", 1020);
                }
            }
        }
    }

    private ImportScope getImportScope(ImportList importList) {
        Scope scope = importList;
        while (scope instanceof ImportList) {
            scope = scope.getContainer();
        }
        return scope instanceof ImportScope ? (ImportScope)((Object)scope) : this.unit;
    }

    private void importAllMembers(Package importedPackage, Set<String> ignoredMembers, ImportList il) {
        for (Declaration dec : importedPackage.getMembers()) {
            if (!dec.isShared() || !ModelUtil.isResolvable(dec) || ignoredMembers.contains(dec.getName()) || this.isNonimportable(importedPackage, dec.getName())) continue;
            this.addWildcardImport(il, dec);
        }
    }

    private void importAllMembers(TypeDeclaration importedType, Set<String> ignoredMembers, ImportList til) {
        for (Declaration dec : importedType.getMembers()) {
            if (!dec.isShared() || !this.isStaticNonGeneric(dec, importedType) && !ModelUtil.isConstructor(dec) || !ModelUtil.isResolvable(dec) || ignoredMembers.contains(dec.getName())) continue;
            this.addWildcardImport(til, dec, importedType);
        }
    }

    private void addWildcardImport(ImportList il, Declaration dec) {
        if (!this.hidesToplevel(dec, il)) {
            Import i = new Import();
            i.setAlias(dec.getName());
            i.setDeclaration(dec);
            i.setWildcardImport(true);
            this.addWildcardImport(il, dec, i);
        }
    }

    private void addWildcardImport(ImportList il, Declaration dec, TypeDeclaration td) {
        if (!this.hidesToplevel(dec, il)) {
            Import i = new Import();
            i.setAlias(dec.getName());
            i.setDeclaration(dec);
            i.setWildcardImport(true);
            i.setTypeDeclaration(td);
            this.addWildcardImport(il, dec, i);
        }
    }

    private void addWildcardImport(ImportList il, Declaration dec, Import i) {
        String alias;
        if (ModelUtil.notOverloaded(dec) && (alias = i.getAlias()) != null) {
            ImportScope scope = this.getImportScope(il);
            Import o = scope.getImport(dec.getName());
            if (o != null && o.isWildcardImport()) {
                if (o.getDeclaration().equals(dec) || dec.isNativeHeader()) {
                    scope.removeImport(o);
                    il.getImports().remove(o);
                } else if (!dec.isNative()) {
                    i.setAmbiguous(true);
                    o.setAmbiguous(true);
                }
            }
            scope.addImport(i);
            il.getImports().add(i);
        }
    }

    private boolean hidesToplevel(Declaration dec, ImportList il) {
        ImportScope scope = this.getImportScope(il);
        for (Declaration d : scope.getMembers()) {
            String n = d.getName();
            if (!d.isToplevel() || n == null || !dec.getName().equals(n)) continue;
            return true;
        }
        return false;
    }

    private boolean checkForHiddenToplevel(Tree.Identifier id, Import i, Tree.Alias alias, ImportList il) {
        ImportScope scope = this.getImportScope(il);
        for (Declaration d : scope.getMembers()) {
            String message;
            String n = d.getName();
            Declaration idec = i.getDeclaration();
            if (n == null || !i.getAlias().equals(n) || idec.equals(d) || ImportVisitor.isLegalAliasFreeImport(d, idec)) continue;
            String qn = d.getQualifiedNameString();
            String string = message = scope instanceof Unit ? "toplevel declaration with this name declared in this unit" : "declaration with this name declared in this scope";
            if (alias == null) {
                String iqn = idec.getQualifiedNameString();
                id.addError(message + ": imported '" + iqn + "' would hide '" + qn + "' (add an alias to the import)");
            } else {
                alias.addError(message + ": imported '" + n + "' would hide '" + qn + "' (choose a different alias for the import)");
            }
            return true;
        }
        return false;
    }

    private static boolean isLegalAliasFreeImport(Declaration dec, Declaration importedDec) {
        if (importedDec instanceof Value) {
            Value value = (Value)importedDec;
            TypeDeclaration td = value.getTypeDeclaration();
            return td.isObjectClass() && td.equals(dec);
        }
        return false;
    }

    private void importMembers(Tree.ImportMemberOrType member, Declaration d) {
        Tree.ImportMemberOrTypeList imtl = member.getImportMemberOrTypeList();
        if (imtl != null) {
            Value v;
            TypeDeclaration td;
            if (d instanceof Value && (td = (v = (Value)d).getTypeDeclaration()).isObjectClass()) {
                d = td;
            }
            if (d instanceof TypeDeclaration) {
                HashSet<String> names = new HashSet<String>();
                ImportList til = imtl.getImportList();
                TypeDeclaration td2 = (TypeDeclaration)d;
                til.setImportedScope(td2);
                List<Tree.ImportMemberOrType> imts = imtl.getImportMemberOrTypes();
                for (Tree.ImportMemberOrType imt : imts) {
                    names.add(this.importMember(imt, td2, til));
                }
                if (imtl.getImportWildcard() != null) {
                    this.importAllMembers(td2, names, til);
                } else if (imts.isEmpty()) {
                    imtl.addError("empty import list", 1020);
                }
            } else {
                imtl.addError("member alias list must follow a type");
            }
        }
    }

    private void checkAliasCase(Tree.Alias alias, Declaration d) {
        if (alias != null) {
            Tree.Identifier id = alias.getIdentifier();
            int tt = id.getToken().getType();
            if (d instanceof TypeDeclaration && tt != 125) {
                id.addError("imported type should have uppercase alias: '" + d.getName() + "' is a type declaration");
            } else if (d instanceof TypedDeclaration && tt != 69) {
                id.addError("imported member should have lowercase alias: '" + d.getName() + "' is not a type declaration");
            }
        }
    }

    private String importMember(Tree.ImportMemberOrType member, Package importedPackage, ImportList il) {
        String newName;
        Tree.Identifier id = member.getIdentifier();
        if (id == null) {
            return null;
        }
        Import i = new Import();
        member.setImportModel(i);
        Tree.Alias alias = member.getAlias();
        String name = TreeUtil.name(id);
        if (alias == null) {
            i.setAlias(name);
        } else {
            String al = TreeUtil.name(alias.getIdentifier());
            if (name.equals(al)) {
                alias.addUsageWarning(Warning.redundantImportAlias, "redundant import alias");
            }
            i.setAlias(al);
        }
        if (this.isNonimportable(importedPackage, name)) {
            id.addError("root type may not be imported: '" + name + "' in '" + importedPackage.getNameAsString() + "' is represented by '" + name + "' in 'ceylon.language'");
            return name;
        }
        Declaration d = importedPackage.getMember(name, null, false);
        if (d == null && (d = importedPackage.getMember(newName = JvmBackendUtil.isInitialLowerCase(name) ? NamingBase.capitalize(name) : NamingBase.getJavaBeanName(name), null, false)) != null && !d.isJava()) {
            d = null;
        }
        if (d == null) {
            id.addError("imported declaration not found: '" + name + "'" + AnalyzerUtil.importCorrectionMessage(name, importedPackage, this.unit, this.cancellable), 100);
            this.unit.setUnresolvedReferences();
        } else {
            if (!AnalyzerUtil.declaredInPackage(d, this.unit)) {
                if (!d.isShared()) {
                    id.addError("imported declaration is not visible: '" + name + "' is not shared", 400);
                } else if (!d.withinRestrictions(this.unit)) {
                    id.addError("imported declaration is not visible: '" + name + "' is restricted");
                } else if (d.isPackageVisibility()) {
                    id.addError("imported declaration is not visible: '" + name + "' is package private");
                } else if (d.isProtectedVisibility()) {
                    id.addError("imported declaration is not visible: '" + name + "' is protected");
                }
            }
            i.setDeclaration(d);
            member.setDeclarationModel(d);
            if (il.hasImport(d)) {
                id.addError("already imported: '" + name + "'");
            } else if (!this.checkForHiddenToplevel(id, i, alias, il)) {
                this.addImport(member, il, i);
            }
            this.checkAliasCase(alias, d);
        }
        if (d != null) {
            this.importMembers(member, d);
        }
        return name;
    }

    private String importMember(Tree.ImportMemberOrType member, TypeDeclaration td, ImportList il) {
        Tree.Identifier id = member.getIdentifier();
        if (id == null) {
            return null;
        }
        Import i = new Import();
        member.setImportModel(i);
        Tree.Alias alias = member.getAlias();
        String name = TreeUtil.name(id);
        if (alias == null) {
            i.setAlias(name);
        } else {
            i.setAlias(TreeUtil.name(alias.getIdentifier()));
        }
        Declaration m = td.getMember(name, null, false);
        if (m == null && td.isJava()) {
            String newName = JvmBackendUtil.isInitialLowerCase(name) ? NamingBase.capitalize(name) : NamingBase.getJavaBeanName(name);
            m = td.getMember(newName, null, false);
        }
        if (m == null) {
            id.addError("imported declaration not found: '" + name + "' of '" + td.getName() + "'" + AnalyzerUtil.memberCorrectionMessage(name, td, null, this.unit, this.cancellable), 100);
            this.unit.setUnresolvedReferences();
        } else {
            List<Declaration> members = m.getContainer().getMembers();
            for (Declaration d : members) {
                String dn = d.getName();
                if (dn == null || !dn.equals(name) || d.sameKind(m) || d.isAnonymous()) continue;
                id.addError("ambiguous member declaration: '" + name + "' of '" + td.getName() + "' is ambiguous");
                return null;
            }
            if (!m.isShared()) {
                id.addError("imported declaration is not visible: '" + name + "' of '" + td.getName() + "' is not shared", 400);
            } else if (!m.withinRestrictions(this.unit)) {
                id.addError("imported declaration is not visible: '" + name + "' of '" + td.getName() + "' is restricted", 400);
            } else if (!AnalyzerUtil.declaredInPackage(m, this.unit)) {
                if (m.isPackageVisibility()) {
                    id.addError("imported declaration is not visible: '" + name + "' of '" + td.getName() + "' is package private");
                } else if (m.isProtectedVisibility()) {
                    id.addError("imported declaration is not visible: '" + name + "' of '" + td.getName() + "' is protected");
                }
            }
            i.setTypeDeclaration(td);
            if (!(this.isStaticNonGeneric(m, td) || ModelUtil.isToplevelClassConstructor(td, m) || ModelUtil.isToplevelAnonymousClass(m.getContainer()) || alias != null)) {
                if (m.isStatic()) {
                    member.addError("illegal static import: static member '" + name + "' belongs to the generic type '" + td.getName() + "'");
                } else if (ModelUtil.isConstructor(m)) {
                    member.addError("illegal static import: '" + td.getName() + "' is not a toplevel class");
                } else if (ModelUtil.isAnonymousClass(m.getContainer())) {
                    member.addError("illegal static import: '" + td.getName() + "' is not a toplevel anonymous class");
                } else {
                    member.addError("illegal static import: '" + name + "' is not static");
                }
            }
            i.setDeclaration(m);
            member.setDeclarationModel(m);
            if (il.hasImport(m)) {
                id.addError("duplicate import: '" + name + "' of '" + td.getName() + "' is already imported");
            } else if (this.isStaticNonGeneric(m, td) || ModelUtil.isToplevelClassConstructor(td, m) || ModelUtil.isToplevelAnonymousClass(m.getContainer())) {
                if (!this.checkForHiddenToplevel(id, i, alias, il)) {
                    this.addImport(member, il, i);
                }
            } else {
                this.addMemberImport(member, il, i);
            }
            this.checkAliasCase(alias, m);
        }
        if (m != null) {
            this.importMembers(member, m);
        }
        return name;
    }

    private boolean isStaticNonGeneric(Declaration dec, TypeDeclaration outer) {
        return dec.isStatic() && (outer.isJava() || !outer.isParameterized());
    }

    private void addImport(Tree.ImportMemberOrType member, ImportList il, Import i) {
        String alias = i.getAlias();
        if (alias != null) {
            Map<String, String> mods = this.unit.getModifiers();
            if (mods.containsKey(alias) && mods.get(alias).equals(alias)) {
                member.addUsageWarning(Warning.hidesLanguageModifier, "import hides a language modifier: '" + alias + "' is a language modifier");
            } else {
                ImportScope scope = this.getImportScope(il);
                Import o = scope.getImport(alias);
                if (o == null) {
                    scope.addImport(i);
                    il.getImports().add(i);
                } else if (o.isWildcardImport()) {
                    scope.removeImport(o);
                    il.getImports().remove(o);
                    scope.addImport(i);
                    il.getImports().add(i);
                } else {
                    member.addError("duplicate import alias: '" + alias + "' is already used");
                }
            }
        }
    }

    private void addMemberImport(Tree.ImportMemberOrType member, ImportList il, Import i) {
        String alias = i.getAlias();
        if (alias != null) {
            if (il.getImport(alias) == null) {
                this.getImportScope(il).addImport(i);
                il.getImports().add(i);
            } else {
                member.addError("duplicate member import alias: '" + alias + "' is already used");
            }
        }
    }

    private boolean isNonimportable(Package pkg, String name) {
        String pname = pkg.getQualifiedNameString();
        return pname.equals("java.lang") && ("Object".equals(name) || "Throwable".equals(name) || "Exception".equals(name)) || pname.equals("java.lang.annotation") && "Annotation".equals(name);
    }
}

