/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.analyzer;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.CmrRepository;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.api.VersionComparator;
import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.compiler.typechecker.analyzer.ModuleHelper;
import com.redhat.ceylon.compiler.typechecker.analyzer.ModuleSourceMapper;
import com.redhat.ceylon.compiler.typechecker.analyzer.Warning;
import com.redhat.ceylon.compiler.typechecker.context.Context;
import com.redhat.ceylon.compiler.typechecker.context.PhasedUnit;
import com.redhat.ceylon.compiler.typechecker.context.PhasedUnits;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.TreeUtil;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.typechecker.context.TypeCache;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.ModuleImport;
import com.redhat.ceylon.model.typechecker.util.ModuleManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ModuleValidator {
    private final Context context;
    private List<PhasedUnits> phasedUnitsOfDependencies;
    private final ModuleManager moduleManager;
    private final ModuleSourceMapper moduleManagerUtil;
    private Map<Module, ArtifactResult> searchedArtifacts = new HashMap<Module, ArtifactResult>();
    private Map<Module, List<Module>> moduleToImportPath = new HashMap<Module, List<Module>>();
    private ProgressListener listener = new ProgressListener(){

        @Override
        public void resolvingModuleArtifact(Module module, ArtifactResult artifactResult) {
        }

        @Override
        public void retrievingModuleArtifact(Module module, ArtifactContext artifactContext) {
        }

        @Override
        public void retrievingModuleArtifactFailed(Module module, ArtifactContext artifactContext) {
        }

        @Override
        public void retrievingModuleArtifactSuccess(Module module, ArtifactResult artifact) {
        }
    };

    public ModuleValidator(Context context, PhasedUnits phasedUnits) {
        this.context = context;
        this.moduleManager = phasedUnits.getModuleManager();
        this.moduleManagerUtil = phasedUnits.getModuleSourceMapper();
    }

    public void setListener(ProgressListener listener) {
        this.listener = listener;
    }

    public List<PhasedUnits> getPhasedUnitsOfDependencies() {
        return this.phasedUnitsOfDependencies;
    }

    public void verifyModuleDependencyTree() {
        TypeCache.doWithoutCaching(new Runnable(){

            @Override
            public void run() {
                ModuleValidator.this.phasedUnitsOfDependencies = new ArrayList();
                LinkedList<Module> dependencyTree = new LinkedList<Module>();
                Set<Module> compiledModules = ModuleValidator.this.moduleManagerUtil.getCompiledModules();
                ModuleValidator.this.moduleManagerUtil.preResolveDependenciesIfRequired(ModuleValidator.this.context.getRepositoryManager());
                Module jdkProviderModule = ModuleValidator.this.moduleManagerUtil.getJdkProviderModule();
                ArrayList<Module> modules = new ArrayList<Module>(compiledModules.size() + 2);
                if (jdkProviderModule != null) {
                    ModuleImport synthimp = new ModuleImport(null, jdkProviderModule, false, false);
                    ModuleValidator.this.resolveModuleIfRequired(jdkProviderModule, true, synthimp, ImportDepth.First, dependencyTree, ModuleValidator.this.searchedArtifacts);
                }
                modules.add(ModuleValidator.this.context.getModules().getLanguageModule());
                modules.add(ModuleValidator.this.context.getModules().getDefaultModule());
                modules.addAll(compiledModules);
                for (Module module : modules) {
                    dependencyTree.addLast(module);
                    ModuleValidator.this.verifyModuleDependencyTree(module.getImports(), dependencyTree, new ArrayList(), ImportDepth.First, ModuleValidator.this.searchedArtifacts);
                    dependencyTree.pollLast();
                }
                for (Module module : compiledModules) {
                    ModuleValidator.this.verifyNative(module);
                }
                ModuleValidator.this.moduleManager.addImplicitImports();
            }
        });
        this.executeExternalModulePhases();
    }

    public final long numberOfModulesNotAlreadySearched() {
        long result = 0L;
        for (Module m : this.context.getModules().getListOfModules()) {
            if (m.isAvailable() || this.searchedArtifacts.containsKey(m)) continue;
            ++result;
        }
        return result;
    }

    public final long numberOfModulesAlreadySearched() {
        return this.searchedArtifacts.size();
    }

    private void verifyModuleDependencyTree(Collection<ModuleImport> moduleImports, LinkedList<Module> dependencyTree, List<Module> propagatedDependencies, ImportDepth importDepth, Map<Module, ArtifactResult> alreadySearchedArtifacts) {
        ArrayList<Module> visibleDependencies = new ArrayList<Module>();
        visibleDependencies.add(dependencyTree.getLast());
        for (ModuleImport moduleImport : moduleImports) {
            Module module;
            if (moduleImport.isNative() && !ModelUtil.isForBackend(moduleImport.getNativeBackends(), this.moduleManager.getSupportedBackends()) || this.moduleManager.findModule(module = moduleImport.getModule(), dependencyTree, true) != null) continue;
            ImportDepth newImportDepth = importDepth.forModuleImport(moduleImport);
            boolean forCompiledModule = newImportDepth.isVisibleToCompiledModules();
            this.resolveModuleIfRequired(module, forCompiledModule, moduleImport, importDepth, dependencyTree, alreadySearchedArtifacts);
            this.moduleManager.visitedModule(module, forCompiledModule);
            dependencyTree.addLast(module);
            ArrayList<Module> subModulePropagatedDependencies = new ArrayList<Module>();
            this.verifyModuleDependencyTree(module.getImports(), dependencyTree, subModulePropagatedDependencies, newImportDepth, alreadySearchedArtifacts);
            this.checkAndAddDependency(visibleDependencies, module, dependencyTree);
            for (Module submodule : subModulePropagatedDependencies) {
                this.checkAndAddDependency(visibleDependencies, submodule, dependencyTree);
            }
            if (moduleImport.isExport()) {
                this.checkAndAddDependency(propagatedDependencies, module, dependencyTree);
                for (Module submodule : subModulePropagatedDependencies) {
                    this.checkAndAddDependency(propagatedDependencies, submodule, dependencyTree);
                }
            }
            dependencyTree.pollLast();
        }
    }

    private void resolveModuleIfRequired(Module module, boolean forCompiledModule, ModuleImport moduleImport, ImportDepth importDepth, LinkedList<Module> dependencyTree, Map<Module, ArtifactResult> alreadySearchedArtifacts) {
        if (!module.isAvailable()) {
            boolean firstTime;
            ArtifactResult artifact = null;
            if (alreadySearchedArtifacts.containsKey(module)) {
                artifact = alreadySearchedArtifacts.get(module);
                firstTime = false;
            } else {
                RepositoryManager repositoryManager = this.context.getRepositoryManager();
                if (repositoryManager.isValidNamespace(moduleImport.getNamespace())) {
                    Exception exceptionOnGetArtifact = null;
                    Iterable<String> searchedArtifactExtensions = this.moduleManager.getSearchedArtifactExtensions();
                    ArtifactContext artifactContext = new ArtifactContext(moduleImport.getNamespace(), module.getNameAsString(), module.getVersion(), this.getArtifactSuffixes(searchedArtifactExtensions));
                    this.listener.retrievingModuleArtifact(module, artifactContext);
                    try {
                        artifact = repositoryManager.getArtifactResult(artifactContext);
                    }
                    catch (Exception e) {
                        exceptionOnGetArtifact = this.catchIfPossible(e);
                    }
                    if (artifact == null) {
                        boolean error = true;
                        if (ModuleUtil.isMavenModule(module.getNameAsString()) && !dependencyTree.isEmpty() && ModuleUtil.isMavenModule(dependencyTree.peekLast().getNameAsString())) {
                            error = false;
                        }
                        ModuleHelper.buildErrorOnMissingArtifact(artifactContext, module, moduleImport, dependencyTree, exceptionOnGetArtifact, this.moduleManagerUtil, error);
                        this.listener.retrievingModuleArtifactFailed(module, artifactContext);
                    } else {
                        this.listener.retrievingModuleArtifactSuccess(module, artifact);
                    }
                } else {
                    StringBuilder msg = new StringBuilder().append("unknown import namespace: '").append(moduleImport.getNamespace()).append("' should be one of ");
                    TreeSet<String> namespaces = new TreeSet<String>();
                    for (CmrRepository repo : repositoryManager.getRepositories()) {
                        namespaces.add(repo.getNamespace());
                    }
                    boolean first = true;
                    for (String namespace : namespaces) {
                        if (first) {
                            first = false;
                        } else {
                            msg.append(", ");
                        }
                        msg.append("'").append(namespace).append("'");
                    }
                    this.moduleManagerUtil.attachErrorToDependencyDeclaration(moduleImport, dependencyTree, msg.toString(), true);
                }
                alreadySearchedArtifacts.put(module, artifact);
                firstTime = true;
            }
            if (artifact != null && (firstTime || forCompiledModule)) {
                this.listener.resolvingModuleArtifact(module, artifact);
                Module moduleOverride = this.moduleManager.overridesModule(artifact, module, moduleImport);
                if (moduleOverride != null) {
                    if (importDepth.equals((Object)ImportDepth.First)) {
                        this.moduleManagerUtil.attachErrorToDependencyDeclaration(moduleImport, dependencyTree, "project source module import is overridden in module overrides file: '" + moduleOverride.getNameAsString() + "/" + moduleOverride.getVersion() + "' overrides '" + module.getNameAsString() + "/" + module.getVersion() + "'", false);
                    }
                    module = moduleOverride;
                }
                this.moduleManagerUtil.resolveModule(artifact, module, moduleImport, dependencyTree, this.phasedUnitsOfDependencies, forCompiledModule);
            }
        }
    }

    protected Exception catchIfPossible(Exception e) {
        return e;
    }

    private String[] getArtifactSuffixes(Iterable<String> extensions) {
        ArrayList<String> suffixes = new ArrayList<String>();
        for (String ext : extensions) {
            suffixes.add("." + ext);
        }
        return suffixes.toArray(new String[suffixes.size()]);
    }

    private void checkAndAddDependency(List<Module> dependencies, Module module, LinkedList<Module> dependencyTree) {
        boolean isDupe;
        Module dupe = this.moduleManager.findModule(module, dependencies, false);
        boolean bl = isDupe = dupe != null;
        if (dupe == null) {
            dupe = this.moduleManager.findSimilarModule(module, dependencies);
        }
        if (dupe != null && !this.isSameVersion(module, dupe)) {
            if (isDupe) {
                String importPathB;
                String versionB;
                String importPathA;
                String versionA;
                StringBuilder error = new StringBuilder("module (transitively) imports conflicting versions of dependency '");
                error.append(module.getNameAsString()).append("': ");
                if (VersionComparator.compareVersions(module.getVersion(), dupe.getVersion()) < 0) {
                    versionA = module.getVersion();
                    importPathA = this.importPathToString(dependencyTree);
                    versionB = dupe.getVersion();
                    importPathB = this.importPathToString(this.moduleToImportPath.get(dupe));
                } else {
                    versionA = dupe.getVersion();
                    importPathA = this.importPathToString(this.moduleToImportPath.get(dupe));
                    versionB = module.getVersion();
                    importPathB = this.importPathToString(dependencyTree);
                }
                error.append("version '").append(versionA).append("' (via import path '").append(importPathA).append("') and version '").append(versionB).append("' (via import path '").append(importPathB).append("')");
                this.moduleManagerUtil.addConflictingModuleErrorToModule(module.getNameAsString(), dependencyTree.getFirst(), error.toString());
            } else {
                String importPathB;
                String moduleB;
                String importPathA;
                String moduleA;
                String moduleName = module.getNameAsString();
                String duplicateModuleName = dupe.getNameAsString();
                if (duplicateModuleName.compareTo(moduleName) < 0) {
                    moduleA = ModuleUtil.makeModuleName(duplicateModuleName, dupe.getVersion());
                    importPathA = this.importPathToString(this.moduleToImportPath.get(dupe));
                    moduleB = ModuleUtil.makeModuleName(moduleName, module.getVersion());
                    importPathB = this.importPathToString(dependencyTree);
                } else {
                    moduleA = ModuleUtil.makeModuleName(moduleName, module.getVersion());
                    importPathA = this.importPathToString(dependencyTree);
                    moduleB = ModuleUtil.makeModuleName(duplicateModuleName, dupe.getVersion());
                    importPathB = this.importPathToString(this.moduleToImportPath.get(dupe));
                }
                String error = "module (transitively) imports conflicting versions of similar dependencies '" + moduleA + "' (via import path '" + importPathA + "') and '" + moduleB + "' (via import path '" + importPathB + "')";
                this.moduleManagerUtil.addConflictingModuleWarningToModule(moduleA, dependencyTree.getFirst(), Warning.similarModule, error);
            }
        } else {
            dependencies.add(module);
            ArrayList<Module> importPath = new ArrayList<Module>(dependencyTree.size());
            importPath.addAll(dependencyTree);
            this.moduleToImportPath.put(module, importPath);
        }
    }

    private String importPathToString(List<Module> dependencyTree) {
        StringBuffer b = new StringBuffer();
        for (Module mod : dependencyTree) {
            if (b.length() != 0) {
                b.append(" -> ");
            }
            b.append(mod.getNameAsString());
        }
        return b.toString();
    }

    private boolean isSameVersion(Module module, Module dupe) {
        if (module == null || dupe == null) {
            return false;
        }
        if (dupe.getVersion() == null) {
            System.err.println("TypeChecker assertion failure: version should not be null in ModuleValidator.isSameVersion. Please report the issue with a test case");
            return false;
        }
        return dupe.getVersion().equals(module.getVersion());
    }

    private void verifyNative(Module module) {
        for (Tree.ImportModule imp : this.moduleManagerUtil.retrieveModuleImportNodes(module)) {
            Module importedModule;
            Node node;
            if (imp.getImportPath() != null) {
                node = imp.getImportPath();
                importedModule = (Module)imp.getImportPath().getModel();
            } else {
                node = imp.getQuotedLiteral();
                importedModule = this.moduleManagerUtil.getModuleForNode(node);
                if (importedModule == null) continue;
            }
            Backends bs = TreeUtil.getNativeBackend(imp.getAnnotationList(), imp.getUnit());
            if (bs.none()) {
                if (!importedModule.isNative() || module.isNative()) continue;
                node.addError(new ModuleSourceMapper.ModuleDependencyAnalysisError(node, "native import for cross-platform module (mark either the module or the import as native)", 20000));
                continue;
            }
            if (!importedModule.isNative() || bs.supports(importedModule.getNativeBackends())) continue;
            node.addError(new ModuleSourceMapper.ModuleDependencyAnalysisError(node, "native backend name conflicts with imported module: '\"" + bs + "\"' is not '\"" + importedModule.getNativeBackends().names() + "\"'"));
        }
    }

    protected void executeExternalModulePhases() {
        for (PhasedUnits units : this.phasedUnitsOfDependencies) {
            for (PhasedUnit pu : units.getPhasedUnits()) {
                pu.scanDeclarations();
            }
        }
        for (PhasedUnits units : this.phasedUnitsOfDependencies) {
            for (PhasedUnit pu : units.getPhasedUnits()) {
                pu.scanTypeDeclarations();
            }
        }
        for (PhasedUnits units : this.phasedUnitsOfDependencies) {
            for (PhasedUnit pu : units.getPhasedUnits()) {
                pu.validateRefinement();
            }
        }
    }

    private static enum ImportDepth {
        First{

            @Override
            public ImportDepth forModuleImport(ModuleImport moduleImport) {
                return Required;
            }

            @Override
            public boolean isVisibleToCompiledModules() {
                return true;
            }
        }
        ,
        Required{

            @Override
            public ImportDepth forModuleImport(ModuleImport moduleImport) {
                return moduleImport.isExport() ? Required : Transitive;
            }

            @Override
            public boolean isVisibleToCompiledModules() {
                return true;
            }
        }
        ,
        Transitive{

            @Override
            public ImportDepth forModuleImport(ModuleImport moduleImport) {
                return Transitive;
            }

            @Override
            public boolean isVisibleToCompiledModules() {
                return false;
            }
        };


        public abstract ImportDepth forModuleImport(ModuleImport var1);

        public abstract boolean isVisibleToCompiledModules();
    }

    public static interface ProgressListener {
        public void retrievingModuleArtifact(Module var1, ArtifactContext var2);

        public void retrievingModuleArtifactFailed(Module var1, ArtifactContext var2);

        public void retrievingModuleArtifactSuccess(Module var1, ArtifactResult var2);

        public void resolvingModuleArtifact(Module var1, ArtifactResult var2);
    }
}

