/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.analyzer;

import com.redhat.ceylon.compiler.typechecker.analyzer.AnalyzerUtil;
import com.redhat.ceylon.compiler.typechecker.analyzer.ExpressionVisitor;
import com.redhat.ceylon.compiler.typechecker.analyzer.Warning;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.TreeUtil;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.Annotation;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.IntersectionType;
import com.redhat.ceylon.model.typechecker.model.LazyType;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import com.redhat.ceylon.model.typechecker.model.Reference;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Setter;
import com.redhat.ceylon.model.typechecker.model.SiteVariance;
import com.redhat.ceylon.model.typechecker.model.Specification;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.Unit;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RefinementVisitor
extends Visitor {
    private static final Comparator<Declaration> declarationCmp = new Comparator<Declaration>(){

        @Override
        public int compare(Declaration o1, Declaration o2) {
            if (o1.getName() == null && o2.getName() == null) {
                return 0;
            }
            if (o1.getName() == null) {
                return -1;
            }
            if (o2.getName() == null) {
                return 1;
            }
            return o1.getName().compareTo(o2.getName());
        }
    };

    @Override
    public void visit(Tree.AnyMethod that) {
        super.visit(that);
        this.inheritDefaultedArguments(that.getDeclarationModel());
    }

    @Override
    public void visit(Tree.AnyClass that) {
        super.visit(that);
        this.inheritDefaultedArguments(that.getDeclarationModel());
    }

    private void inheritDefaultedArguments(Declaration d) {
        Declaration rd = d.getRefinedDeclaration();
        if (rd != d && rd instanceof Functional && d instanceof Functional) {
            Functional fd = (Functional)((Object)d);
            Functional frd = (Functional)((Object)rd);
            List<ParameterList> tdpls = fd.getParameterLists();
            List<ParameterList> rdpls = frd.getParameterLists();
            if (!tdpls.isEmpty() && !rdpls.isEmpty()) {
                List<Parameter> tdps = tdpls.get(0).getParameters();
                List<Parameter> rdps = rdpls.get(0).getParameters();
                for (int i = 0; i < tdps.size() && i < rdps.size(); ++i) {
                    Parameter tdp = tdps.get(i);
                    Parameter rdp = rdps.get(i);
                    if (tdp == null || rdp == null) continue;
                    tdp.setDefaulted(rdp.isDefaulted());
                }
            }
        }
    }

    @Override
    public void visit(Tree.Declaration that) {
        super.visit(that);
        Declaration dec = that.getDeclarationModel();
        if (dec != null) {
            boolean member;
            boolean mayBeRefined;
            boolean mayBeShared;
            boolean bl = mayBeShared = dec.isToplevel() || dec.isClassOrInterfaceMember();
            if (dec.isShared() && !mayBeShared) {
                that.addError("shared declaration is not a member of a class, interface, or package: " + AnalyzerUtil.message(dec) + " may not be annotated 'shared'", 1200);
            }
            boolean bl2 = mayBeRefined = dec instanceof Value || dec instanceof Function || dec instanceof Class;
            if (!mayBeRefined) {
                this.checkNonrefinableDeclaration(that, dec);
            }
            boolean bl3 = member = dec.isClassOrInterfaceMember() && dec.isShared() && !ModelUtil.isConstructor(dec) && !(dec instanceof TypeParameter);
            if (member) {
                this.checkMember(that, dec);
            } else {
                this.checkNonMember(that, dec);
            }
            if (dec.isNativeImplementation() || RefinementVisitor.isNativeMember(dec)) {
                this.checkNative(that, dec);
            }
        }
    }

    private static boolean isNativeMember(Declaration dec) {
        if (dec.isMember()) {
            Declaration container = (Declaration)((Object)dec.getContainer());
            return container.isNativeImplementation();
        }
        return false;
    }

    private void checkNative(Tree.Declaration that, Declaration dec) {
        if (dec instanceof Setter) {
            return;
        }
        Declaration header = ModelUtil.getNativeHeader(dec);
        if (header == null || dec != header && (!dec.isClassOrInterfaceMember() || dec.getContainer() != header.getContainer())) {
            this.checkNativeDeclaration(that, dec, header);
        }
    }

    private void checkNativeDeclaration(Tree.Declaration that, Declaration dec, Declaration header) {
        if (header == null && dec.isMember()) {
            Declaration container = (Declaration)((Object)dec.getContainer());
            if (container.isNative() && dec.isNative() && dec.isShared() && !dec.isFormal() && !dec.isActual() && !dec.isDefault()) {
                that.addError("native member does not implement any header member: " + AnalyzerUtil.message(dec));
            }
            if (!dec.isNative() && dec.isShared()) {
                that.addError("non-native shared members not allowed in native implementations: " + AnalyzerUtil.message(dec));
            }
            return;
        }
        if (header != null && dec.isMember() && !dec.isParameter() && !dec.isNative()) {
            that.addError("member implementing a native header member must be marked native: " + AnalyzerUtil.message(dec));
            return;
        }
        if (dec instanceof Function && (header == null || header instanceof Function)) {
            this.checkNativeMethod(that, (Function)dec, (Function)header);
        } else if (dec instanceof Value && (header == null || header instanceof Value)) {
            this.checkNativeValue(that, (Value)dec, (Value)header);
        } else if (dec instanceof Class && (header == null || header instanceof Class)) {
            this.checkNativeClass(that, (Class)dec, (Class)header);
        } else if (dec instanceof Interface && (header == null || header instanceof Interface)) {
            this.checkNativeInterface(that, (Interface)dec, (Interface)header);
        } else if (header != null) {
            that.addError("native declarations not of same type: " + AnalyzerUtil.message(dec));
        }
    }

    private void checkNativeClass(Tree.Declaration that, Class dec, Class header) {
        if (header == null) {
            return;
        }
        if (dec.isAlias() || header.isAlias()) {
            return;
        }
        if (dec.isShared() && !header.isShared()) {
            that.addError("native header is not shared: " + AnalyzerUtil.message(dec));
        }
        if (!dec.isShared() && header.isShared()) {
            that.addError("native header is shared: " + AnalyzerUtil.message(dec));
        }
        if (dec.isAbstract() && !header.isAbstract()) {
            that.addError("native header is not abstract: " + AnalyzerUtil.message(dec));
        }
        if (!dec.isAbstract() && header.isAbstract()) {
            that.addError("native header is abstract: " + AnalyzerUtil.message(dec));
        }
        if (dec.isFinal() && !header.isFinal()) {
            that.addError("native header is not final: " + AnalyzerUtil.message(dec));
        }
        if (!dec.isFinal() && header.isFinal()) {
            that.addError("native header is final: " + AnalyzerUtil.message(dec));
        }
        if (dec.isSealed() && !header.isSealed()) {
            that.addError("native header is not sealed: " + AnalyzerUtil.message(dec));
        }
        if (!dec.isSealed() && header.isSealed()) {
            that.addError("native header is sealed: " + AnalyzerUtil.message(dec));
        }
        if (dec.isAnnotation() && !header.isAnnotation()) {
            that.addError("native header is not an annotation type: " + AnalyzerUtil.message(dec));
        }
        if (!dec.isAnnotation() && header.isAnnotation()) {
            that.addError("native header is an annotation type: " + AnalyzerUtil.message(dec));
        }
        Type dext = dec.getExtendedType();
        Type aext = header.getExtendedType();
        if (dext != null && aext == null || dext == null && aext != null || !dext.isExactly(aext)) {
            that.addError("native classes do not extend the same type: " + AnalyzerUtil.message(dec));
        }
        List<Type> dst = dec.getSatisfiedTypes();
        List<Type> ast = header.getSatisfiedTypes();
        if (dst.size() != ast.size() || !dst.containsAll(ast)) {
            that.addError("native classes do not satisfy the same interfaces: " + AnalyzerUtil.message(dec));
        }
        this.checkNativeClassParameters(that, dec, header, dec.getReference(), header.getReference());
        this.checkNativeTypeParameters(that, dec, header, dec.getTypeParameters(), header.getTypeParameters());
        this.checkMissingMemberImpl(that, dec, header);
    }

    private void checkMissingMemberImpl(Tree.Declaration that, Class dec, Class header) {
        List<Declaration> hdrMembers = this.getNativeClassMembers(header);
        List<Declaration> implMembers = this.getNativeClassMembers(dec);
        Iterator<Declaration> hdrIter = hdrMembers.iterator();
        Iterator<Declaration> implIter = implMembers.iterator();
        boolean hdrNext = true;
        boolean implNext = true;
        Declaration hdr = null;
        Declaration impl2 = null;
        while (!(!hdrIter.hasNext() && hdrNext || !implIter.hasNext() && implNext)) {
            int cmp;
            if (hdrNext) {
                hdr = hdrIter.next();
            }
            if (implNext) {
                impl2 = implIter.next();
            }
            if ((cmp = declarationCmp.compare(hdr, impl2)) < 0) {
                if (!ModelUtil.isImplemented(hdr)) {
                    that.addError("native header '" + hdr.getName() + "' of '" + RefinementVisitor.containerName(hdr) + "' has no native implementation");
                }
                hdrNext = true;
                implNext = false;
                continue;
            }
            if (cmp > 0) {
                hdrNext = false;
                implNext = true;
                continue;
            }
            hdrNext = true;
            implNext = true;
        }
        while (hdrIter.hasNext()) {
            hdr = hdrIter.next();
            if (ModelUtil.isImplemented(hdr)) continue;
            that.addError("native header '" + hdr.getName() + "' of '" + RefinementVisitor.containerName(hdr) + "' has no native implementation");
        }
    }

    private List<Declaration> getNativeClassMembers(Class dec) {
        List<Declaration> members = dec.getMembers();
        ArrayList<Declaration> nats = new ArrayList<Declaration>(members.size());
        for (Declaration m : members) {
            if (!m.isNative() || m.isFormal() || m.isActual() || m.isDefault()) continue;
            nats.add(m);
        }
        Collections.sort(nats, declarationCmp);
        return nats;
    }

    private void checkNativeInterface(Tree.Declaration that, Interface dec, Interface header) {
        if (header == null) {
            return;
        }
        if (dec.isAlias() || header.isAlias()) {
            return;
        }
        if (dec.isShared() && !header.isShared()) {
            that.addError("native header is not shared: " + AnalyzerUtil.message(dec));
        }
        if (!dec.isShared() && header.isShared()) {
            that.addError("native header is shared: " + AnalyzerUtil.message(dec));
        }
        if (dec.isFinal() && !header.isFinal()) {
            that.addError("native header is not final: " + AnalyzerUtil.message(dec));
        }
        if (!dec.isFinal() && header.isFinal()) {
            that.addError("native header is final: " + AnalyzerUtil.message(dec));
        }
        if (dec.isSealed() && !header.isSealed()) {
            that.addError("native header is not sealed: " + AnalyzerUtil.message(dec));
        }
        if (!dec.isSealed() && header.isSealed()) {
            that.addError("native header is sealed: " + AnalyzerUtil.message(dec));
        }
        if (dec.isAnnotation() && !header.isAnnotation()) {
            that.addError("native header is not an annotation type: " + AnalyzerUtil.message(dec));
        }
        if (!dec.isAnnotation() && header.isAnnotation()) {
            that.addError("native header is an annotation type: " + AnalyzerUtil.message(dec));
        }
        Type dext = dec.getExtendedType();
        Type aext = header.getExtendedType();
        if (dext != null && aext == null || dext == null && aext != null || !dext.isExactly(aext)) {
            that.addError("native classes do not extend the same type: " + AnalyzerUtil.message(dec));
        }
        List<Type> dst = dec.getSatisfiedTypes();
        List<Type> ast = header.getSatisfiedTypes();
        if (dst.size() != ast.size() || !dst.containsAll(ast)) {
            that.addError("native classes do not satisfy the same interfaces: " + AnalyzerUtil.message(dec));
        }
        this.checkNativeTypeParameters(that, dec, header, dec.getTypeParameters(), header.getTypeParameters());
    }

    private void checkNativeMethod(Tree.Declaration that, Function dec, Function header) {
        if (header == null) {
            return;
        }
        Type at = header.getType();
        Type dt = dec.getType();
        if (dt != null && !dt.isExactly(at)) {
            that.addError("native implementation must have the same return type as native header: " + AnalyzerUtil.message(dec) + " must have the type '" + at.asString(that.getUnit()) + "'");
        }
        if (dec.isShared() && !header.isShared()) {
            that.addError("native header is not shared: " + AnalyzerUtil.message(dec));
        }
        if (!dec.isShared() && header.isShared()) {
            that.addError("native header is shared: " + AnalyzerUtil.message(dec));
        }
        if (dec.isAnnotation() && !header.isAnnotation()) {
            that.addError("native header is not an annotation constructor: " + AnalyzerUtil.message(dec));
        }
        if (!dec.isAnnotation() && header.isAnnotation()) {
            that.addError("native header is an annotation constructor: " + AnalyzerUtil.message(dec));
        }
        this.checkRefiningMemberParameters(that, dec, header, dec.getReference(), header.getReference(), true);
        this.checkNativeTypeParameters(that, dec, header, dec.getTypeParameters(), header.getTypeParameters());
    }

    private void checkNativeValue(Tree.Declaration that, Value dec, Value header) {
        if (header == null) {
            return;
        }
        Type at = header.getType();
        Type dt = dec.getType();
        if (dt != null && !dt.isExactly(at) && !this.sameObjects(dec, header)) {
            that.addError("native implementation must have the same type as native header: " + AnalyzerUtil.message(dec) + " must have the type '" + at.asString(that.getUnit()) + "'");
        }
        if (dec.isShared() && !header.isShared()) {
            that.addError("native header is not shared: " + AnalyzerUtil.message(dec));
        }
        if (!dec.isShared() && header.isShared()) {
            that.addError("native header is shared: " + AnalyzerUtil.message(dec));
        }
        if (dec.isVariable() && !header.isVariable()) {
            that.addError("native header is not variable: " + AnalyzerUtil.message(dec));
        }
        if (!dec.isVariable() && header.isVariable()) {
            that.addError("native header is variable: " + AnalyzerUtil.message(dec));
        }
    }

    private boolean sameObjects(Value dec, Value header) {
        return ModelUtil.isObject(dec) && ModelUtil.isObject(header) && dec.getQualifiedNameString().equals(header.getQualifiedNameString());
    }

    private void checkNativeClassParameters(Tree.Declaration that, Class dec, Class header, Reference decRef, Reference hdrRef) {
        boolean checkok;
        boolean bl = checkok = (header.hasConstructors() || header.hasEnumerated()) && !dec.hasConstructors() && !dec.hasEnumerated() && dec.getParameterLists().isEmpty();
        if (!checkok) {
            if (dec.hasConstructors() != header.hasConstructors() || dec.hasEnumerated() != header.hasEnumerated()) {
                that.addError("native classes must all have parameters or all have constructors: " + AnalyzerUtil.message(dec));
            } else if (!dec.hasConstructors() && !dec.hasEnumerated()) {
                List<ParameterList> refiningParamLists = dec.getParameterLists();
                List<ParameterList> refinedParamLists = header.getParameterLists();
                if (refinedParamLists.size() != refiningParamLists.size()) {
                    that.addError("native classes must have the same number of parameter lists: " + AnalyzerUtil.message(dec));
                }
                for (int i = 0; i < refinedParamLists.size() && i < refiningParamLists.size(); ++i) {
                    this.checkParameterTypes(that, RefinementVisitor.getParameterList(that, i), hdrRef, decRef, refiningParamLists.get(i), refinedParamLists.get(i), true);
                }
            }
        }
    }

    private void checkNativeTypeParameters(Tree.Declaration that, Declaration impl2, Declaration header, List<TypeParameter> implTypeParams, List<TypeParameter> headerTypeParams) {
        int implSize;
        int headerSize = headerTypeParams.size();
        if (headerSize != (implSize = implTypeParams.size())) {
            that.addError("native header does not have the same number of type parameters as native implementation: " + AnalyzerUtil.message(impl2));
        } else {
            for (int i = 0; i < headerSize; ++i) {
                Type implIntersect;
                Type headerIntersect;
                TypeParameter headerTP = headerTypeParams.get(i);
                TypeParameter implTP = implTypeParams.get(i);
                if (!headerTP.getName().equals(implTP.getName())) {
                    that.addError("type parameter does not have the same name as its header: '" + implTP.getName() + "' is not '" + headerTP.getName() + "' for " + AnalyzerUtil.message(impl2));
                }
                if ((headerIntersect = ModelUtil.intersectionOfSupertypes(headerTP)).isExactly(implIntersect = ModelUtil.intersectionOfSupertypes(implTP))) continue;
                that.addError("type parameter does not have the same bounds as its header: '" + implTP.getName() + "' for " + AnalyzerUtil.message(impl2));
            }
        }
    }

    private void checkMember(Tree.Declaration that, Declaration member) {
        Class c;
        String name = member.getName();
        if (name == null) {
            return;
        }
        if (member instanceof Setter) {
            Setter setter = (Setter)member;
            Value getter = setter.getGetter();
            Declaration rd = getter.getRefinedDeclaration();
            member.setRefinedDeclaration(rd);
            return;
        }
        ClassOrInterface type = (ClassOrInterface)member.getContainer();
        if (member.isFormal() && type instanceof Class && !(c = (Class)type).isAbstract() && !c.isFormal()) {
            if (c.isClassOrInterfaceMember()) {
                that.addError("formal member belongs to concrete nested class: '" + member.getName() + "' is a member of class '" + c.getName() + "' which is neither 'abstract' nor 'formal'", 1100);
            } else {
                that.addError("formal member belongs to concrete class: '" + member.getName() + "' is a member of class '" + c.getName() + "' which is not annotated 'abstract'", 1100);
            }
        }
        if (member.isStatic() && !type.isToplevel()) {
            that.addError("static member belongs to a nested class: '" + member.getName() + "' is a member of nested type '" + type.getName() + "'");
        }
        if (type.isDynamic()) {
            if (member instanceof Class) {
                that.addError("member class belongs to dynamic interface");
            } else if (!member.isFormal()) {
                that.addError("non-formal member belongs to dynamic interface");
            }
        }
        if (member instanceof Functional && !that.hasErrors() && ModelUtil.isOverloadedVersion(member)) {
            this.checkOverloadedAnnotation(that, member);
            this.checkOverloadedParameters(that, member);
        }
        this.checkRefinement(that, member, type);
    }

    private void checkRefinement(Tree.Declaration that, Declaration member, ClassOrInterface type) {
        boolean legallyOverloaded;
        Unit unit = that.getUnit();
        String name = member.getName();
        List<Type> signature = ModelUtil.getSignature(member);
        boolean variadic = ModelUtil.isVariadic(member);
        Declaration root = type.getRefinedMember(name, signature, variadic);
        boolean bl = legallyOverloaded = member.isNative() || !ModelUtil.isOverloadedVersion(member) || ModelUtil.isOverloadedVersion(root);
        if (root == null || root.equals(member) || root.isNative() && member.isNative()) {
            member.setRefinedDeclaration(member);
            if (member.isActual() && !ModelUtil.isNativeForWrongBackend(member)) {
                that.addError("actual member does not refine any inherited member: " + AnalyzerUtil.message(member) + " is annotated 'actual' but '" + type.getName() + "' does not inherit any member named '" + name + "'", 1300);
            } else if (!legallyOverloaded) {
                that.addError("duplicate or overloaded member name: " + AnalyzerUtil.message(member));
            } else {
                List<Declaration> inheritedDeclarations = ModelUtil.getInheritedDeclarations(name, type);
                if (!inheritedDeclarations.isEmpty()) {
                    that.addError("duplicate or overloaded member name in type hierarchy: " + AnalyzerUtil.message(member) + " collides with " + AnalyzerUtil.message(inheritedDeclarations.get(0)));
                }
            }
        } else {
            member.setRefinedDeclaration(root);
            if (!root.withinRestrictions(unit)) {
                that.addError("refined declaration is not visible: " + AnalyzerUtil.message(member) + " refines " + AnalyzerUtil.message(root) + " which is restricted");
            } else if (root.isPackageVisibility() && !AnalyzerUtil.declaredInPackage(root, unit)) {
                that.addError("refined declaration is not visible: " + AnalyzerUtil.message(member) + " refines " + AnalyzerUtil.message(root) + " which is package private");
            }
            if (root.isCoercionPoint()) {
                that.addError("refined declaration is not a real method: " + AnalyzerUtil.message(member) + " refines " + AnalyzerUtil.message(root));
            }
            boolean found = false;
            TypeDeclaration rootType = (TypeDeclaration)root.getContainer();
            List<Declaration> interveningRefinements = ModelUtil.getInterveningRefinements(member, root, type, rootType);
            for (Declaration refined : interveningRefinements) {
                TypeDeclaration interveningType = (TypeDeclaration)refined.getContainer();
                if (interveningType.isJava() && RefinementVisitor.atLeastOneJava(ModelUtil.getInterveningRefinements(member, root, type, interveningType))) continue;
                if (ModelUtil.isOverloadedVersion(refined)) {
                    legallyOverloaded = true;
                }
                found = true;
                boolean checkTypes = true;
                if (member instanceof Function) {
                    if (!(refined instanceof Function)) {
                        that.addError("refined declaration is not a method: " + AnalyzerUtil.message(member) + " refines " + AnalyzerUtil.message(refined));
                        checkTypes = false;
                    }
                } else if (member instanceof Class) {
                    if (!(refined instanceof Class)) {
                        that.addError("refined declaration is not a class: " + AnalyzerUtil.message(member) + " refines " + AnalyzerUtil.message(refined));
                        checkTypes = false;
                    }
                } else if (member instanceof TypedDeclaration) {
                    if (refined instanceof Class || refined instanceof Function) {
                        that.addError("refined declaration is not an attribute: " + AnalyzerUtil.message(member) + " refines " + AnalyzerUtil.message(refined));
                        checkTypes = false;
                    } else if (refined instanceof TypedDeclaration) {
                        TypedDeclaration rtd = (TypedDeclaration)refined;
                        TypedDeclaration mtd = (TypedDeclaration)member;
                        if (rtd.isVariable() && !mtd.isVariable()) {
                            if (member instanceof Value) {
                                that.addError("non-variable attribute refines a variable attribute: " + AnalyzerUtil.message(member) + " refines variable " + AnalyzerUtil.message(refined) + " and so must be 'variable' or have a setter", 804);
                            } else {
                                that.addError("non-variable attribute refines a variable attribute: " + AnalyzerUtil.message(member) + " refines variable " + AnalyzerUtil.message(refined));
                            }
                        }
                    }
                }
                if (!member.isActual()) {
                    that.addError("non-actual member collides with an inherited member: " + AnalyzerUtil.message(member) + " refines " + AnalyzerUtil.message(refined) + " but is not annotated 'actual'", 600);
                } else if (!refined.isDefault() && !refined.isFormal()) {
                    that.addError("member refines a non-default, non-formal member: " + AnalyzerUtil.message(member) + " refines " + AnalyzerUtil.message(refined) + " which is not annotated 'formal' or 'default'", 500);
                }
                if (!checkTypes || type.isInconsistentType()) continue;
                this.checkRefinedTypeAndParameterTypes(that, member, type, refined);
            }
            if (!found) {
                if (member instanceof Function && root instanceof Function) {
                    that.addError("overloaded member does not exactly refine an inherited overloaded member: " + AnalyzerUtil.message(member, signature, variadic, unit) + " does not match any overloaded version of " + AnalyzerUtil.message(root));
                }
            } else if (!legallyOverloaded) {
                that.addError("overloaded member does not exactly refine an inherited overloaded member: " + AnalyzerUtil.message(member, signature, variadic, unit) + " does not match any overloaded version of " + AnalyzerUtil.message(root));
            }
        }
    }

    private void checkOverloadedAnnotation(Tree.Declaration that, Declaration member) {
        boolean marked = false;
        Unit unit = that.getUnit();
        for (Tree.Annotation a : that.getAnnotationList().getAnnotations()) {
            Tree.Primary p = a.getPrimary();
            if (!(p instanceof Tree.BaseMemberExpression)) continue;
            Tree.BaseMemberExpression bme = (Tree.BaseMemberExpression)p;
            String aname = bme.getIdentifier().getText();
            Declaration ad = p.getScope().getMemberOrParameter(unit, aname, null, false);
            if (ad == null || !RefinementVisitor.isOverloadedAnnotation(ad)) continue;
            marked = true;
        }
        if (!marked) {
            if (member.isActual()) {
                that.addUsageWarning(Warning.unknownWarning, "overloaded function should be declared with the 'overloaded' annotation in 'java.lang'");
            } else if (member instanceof Constructor) {
                that.addError("duplicate default constructor (overloaded default constructor must be declared with the 'overloaded' annotation in 'java.lang')");
            } else if (member instanceof Function) {
                that.addError("duplicate declaration: the name '" + member.getName() + "' is not unique in this scope " + "(overloaded function must be declared with the 'overloaded' annotation in 'java.lang')");
            }
        }
    }

    private static boolean isOverloadedAnnotation(Declaration ad) {
        return "java.lang::overloaded".equals(ad.getQualifiedNameString());
    }

    private void checkOverloadedParameters(Tree.Declaration that, Declaration member) {
        String name = member.getName();
        Declaration abstraction = member.getScope().getDirectMember(name, null, false);
        if (abstraction != null) {
            Functional fun = (Functional)((Object)member);
            List<Parameter> parameters = fun.getFirstParameterList().getParameters();
            for (Parameter param : parameters) {
                if (!param.isDefaulted()) continue;
                that.addError("overloaded function parameter must be required: parameter '" + param.getName() + "' is defaulted");
            }
            Unit unit = that.getUnit();
            for (Declaration dec : abstraction.getOverloads()) {
                if (dec == member) break;
                Functional other = (Functional)((Object)dec);
                List<Parameter> otherParams = other.getFirstParameterList().getParameters();
                if (otherParams.size() != parameters.size()) continue;
                boolean allSame = true;
                for (int i = 0; i < parameters.size(); ++i) {
                    TypeDeclaration paramType = ModelUtil.erasedType(parameters.get(i), unit);
                    TypeDeclaration otherType = ModelUtil.erasedType(otherParams.get(i), unit);
                    if (paramType == null || otherType == null || paramType.equals(otherType)) continue;
                    allSame = false;
                    break;
                }
                if (!allSame) continue;
                that.addError("non-unique parameter list erasure for overloaded function: each overloaded declaration of '" + name + "' must have a distinct parameter list erasure");
            }
        }
    }

    private static boolean atLeastOneJava(List<Declaration> members) {
        for (Declaration d : members) {
            if (!d.isJava()) continue;
            return members.size() > 1;
        }
        return false;
    }

    private void checkRefinedTypeAndParameterTypes(Tree.Declaration that, Declaration refining, ClassOrInterface ci, Declaration refined) {
        List<TypeParameter> refinedTypeParams = refined.getTypeParameters();
        List<TypeParameter> refiningTypeParams = refining.getTypeParameters();
        this.checkRefiningMemberTypeParameters(that, refining, refined, refinedTypeParams, refiningTypeParams);
        List<Type> typeArgs = this.checkRefiningMemberUpperBounds(that, ci, refined, refinedTypeParams, refiningTypeParams);
        Type cit = ci.getType();
        Reference refinedMember = cit.getTypedReference(refined, typeArgs);
        Reference refiningMember = cit.getTypedReference(refining, typeArgs);
        Declaration refinedMemberDec = refinedMember.getDeclaration();
        Declaration refiningMemberDec = refiningMember.getDeclaration();
        Node typeNode = AnalyzerUtil.getTypeErrorNode(that);
        if (this.refinedMemberIsDynamicallyTyped(refinedMemberDec, refiningMemberDec)) {
            this.checkRefiningMemberDynamicallyTyped(refined, refiningMemberDec, typeNode);
        } else if (this.refiningMemberIsDynamicallyTyped(refinedMemberDec, refiningMemberDec)) {
            this.checkRefinedMemberDynamicallyTyped(refined, refinedMemberDec, typeNode);
        } else if (this.refinedMemberIsVariable(refinedMemberDec)) {
            this.checkRefinedMemberTypeExactly(refiningMember, refinedMember, typeNode, refined, refining);
        } else {
            this.checkRefinedMemberTypeAssignable(refiningMember, refinedMember, typeNode, refined, refining);
        }
        if (refining instanceof Functional && refined instanceof Functional) {
            this.checkRefiningMemberParameters(that, refining, refined, refinedMember, refiningMember, false);
        }
    }

    private void checkRefiningMemberParameters(Tree.Declaration that, Declaration refining, Declaration refined, Reference refinedMember, Reference refiningMember, boolean forNative) {
        Functional refiningFun = (Functional)((Object)refining);
        Functional refinedFun = (Functional)((Object)refined);
        List<ParameterList> refiningParamLists = refiningFun.getParameterLists();
        List<ParameterList> refinedParamLists = refinedFun.getParameterLists();
        if (refinedParamLists.size() != refiningParamLists.size()) {
            String subject = forNative ? "native header" : "refined member";
            String current = forNative ? "native implementation" : "refining member";
            StringBuilder message = new StringBuilder();
            message.append(current).append(" must have the same number of parameter lists as ").append(subject).append(": ").append(AnalyzerUtil.message(refining));
            if (!forNative) {
                message.append(" refines ").append(AnalyzerUtil.message(refined));
            }
            that.addError(message.toString());
        }
        for (int i = 0; i < refinedParamLists.size() && i < refiningParamLists.size(); ++i) {
            this.checkParameterTypes(that, RefinementVisitor.getParameterList(that, i), refiningMember, refinedMember, refiningParamLists.get(i), refinedParamLists.get(i), forNative);
        }
    }

    private boolean refinedMemberIsVariable(Declaration refinedMemberDec) {
        if (refinedMemberDec instanceof TypedDeclaration) {
            TypedDeclaration typedDec = (TypedDeclaration)refinedMemberDec;
            return typedDec.isVariable();
        }
        return false;
    }

    private void checkRefinedMemberDynamicallyTyped(Declaration refined, Declaration refinedMemberDec, Node typeNode) {
        TypedDeclaration td = (TypedDeclaration)refinedMemberDec;
        if (!td.isDynamicallyTyped()) {
            typeNode.addError("member which refines statically typed refined member must also be statically typed: " + AnalyzerUtil.message(refined));
        }
    }

    private void checkRefiningMemberDynamicallyTyped(Declaration refined, Declaration refiningMemberDec, Node typeNode) {
        TypedDeclaration td = (TypedDeclaration)refiningMemberDec;
        if (!td.isDynamicallyTyped()) {
            typeNode.addError("member which refines dynamically typed refined member must also be dynamically typed: " + AnalyzerUtil.message(refined));
        }
    }

    private boolean refiningMemberIsDynamicallyTyped(Declaration refinedMemberDec, Declaration refiningMemberDec) {
        return refinedMemberDec instanceof TypedDeclaration && refiningMemberDec instanceof TypedDeclaration && ((TypedDeclaration)refiningMemberDec).isDynamicallyTyped();
    }

    private boolean refinedMemberIsDynamicallyTyped(Declaration refinedMemberDec, Declaration refiningMemberDec) {
        return refinedMemberDec instanceof TypedDeclaration && refiningMemberDec instanceof TypedDeclaration && ((TypedDeclaration)refinedMemberDec).isDynamicallyTyped();
    }

    private void checkRefiningMemberTypeParameters(Tree.Declaration that, Declaration dec, Declaration refined, List<TypeParameter> refinedTypeParams, List<TypeParameter> refiningTypeParams) {
        int refinedSize;
        int refiningSize = refiningTypeParams.size();
        if (refiningSize != (refinedSize = refinedTypeParams.size())) {
            StringBuilder message = new StringBuilder();
            message.append("refining member does not have the same number of type parameters as refined member: ").append(AnalyzerUtil.message(dec)).append(" refines ").append(AnalyzerUtil.message(refined));
            that.addError(message.toString());
        }
    }

    private List<Type> checkRefiningMemberUpperBounds(Tree.Declaration that, ClassOrInterface ci, Declaration refined, List<TypeParameter> refinedTypeParams, List<TypeParameter> refiningTypeParams) {
        int refinedSize;
        int max;
        int refiningSize = refiningTypeParams.size();
        int n = max = refiningSize <= (refinedSize = refinedTypeParams.size()) ? refiningSize : refinedSize;
        if (max == 0) {
            return AnalyzerUtil.NO_TYPE_ARGS;
        }
        HashMap<TypeParameter, Type> substitution = new HashMap<TypeParameter, Type>();
        for (int i = 0; i < max; ++i) {
            TypeParameter refinedTypeParam = refinedTypeParams.get(i);
            TypeParameter refiningTypeParam = refiningTypeParams.get(i);
            substitution.put(refiningTypeParam, refinedTypeParam.getType());
        }
        Map<TypeParameter, SiteVariance> noVariances = Collections.emptyMap();
        TypeDeclaration rc = (TypeDeclaration)refined.getContainer();
        Type supertype = ci.getType().getSupertype(rc);
        Map<TypeParameter, Type> args = supertype.getTypeArguments();
        Map<TypeParameter, SiteVariance> variances = supertype.getVarianceOverrides();
        ArrayList<Type> typeArgs = new ArrayList<Type>(max);
        for (int i = 0; i < max; ++i) {
            boolean ok;
            TypeParameter refinedTypeParam = refinedTypeParams.get(i);
            TypeParameter refiningTypeParam = refiningTypeParams.get(i);
            refiningTypeParam.setReified(refinedTypeParam.isReified());
            Type refinedProducedType = refinedTypeParam.getType();
            List<Type> refinedBounds = refinedTypeParam.getSatisfiedTypes();
            List<Type> refiningBounds = refiningTypeParam.getSatisfiedTypes();
            Unit unit = that.getUnit();
            for (Type bound : refiningBounds) {
                Type refiningBound = bound.substitute(substitution, noVariances);
                ok = false;
                for (Type refinedBound : refinedBounds) {
                    if (!(refinedBound = refinedBound.substitute(args, variances)).isSubtypeOf(refiningBound)) continue;
                    ok = true;
                }
                if (ok) continue;
                that.addError("refining member type parameter '" + refiningTypeParam.getName() + "' has upper bound which refined member type parameter '" + refinedTypeParam.getName() + "' of " + AnalyzerUtil.message(refined) + " does not satisfy: '" + bound.asString(unit) + "' ('" + refiningTypeParam.getName() + "' should be upper bounded by '" + ModelUtil.intersectionOfSupertypes(refinedTypeParam).substitute(args, variances).asString(unit) + "')");
            }
            for (Type bound : refinedBounds) {
                Type refinedBound = bound.substitute(args, variances);
                ok = false;
                for (Type refiningBound : refiningBounds) {
                    if (!refinedBound.isSubtypeOf(refiningBound = refiningBound.substitute(substitution, noVariances))) continue;
                    ok = true;
                }
                if (ok) continue;
                that.addUnsupportedError("refined member type parameter '" + refinedTypeParam.getName() + "' of " + AnalyzerUtil.message(refined) + " has upper bound which refining member type parameter '" + refiningTypeParam.getName() + "' does not satisfy: '" + bound.asString(unit) + "' ('" + refiningTypeParam.getName() + "' should be upper bounded by '" + ModelUtil.intersectionOfSupertypes(refinedTypeParam).substitute(args, variances).asString(unit) + "')");
            }
            typeArgs.add(refinedProducedType);
        }
        return typeArgs;
    }

    private void checkRefinedMemberTypeAssignable(Reference refiningMember, Reference refinedMember, Node that, Declaration refined, Declaration refining) {
        Unit unit = that.getUnit();
        Type refiningType = refiningMember.getType();
        Type refinedType = refinedMember.getType();
        if (!ModelUtil.isTypeUnknown(refinedType)) {
            if (that instanceof Tree.LocalModifier) {
                TypedDeclaration td = (TypedDeclaration)refining;
                Tree.LocalModifier mod = (Tree.LocalModifier)that;
                Type t = ModelUtil.isTypeUnknown(refiningType) ? refinedType : ModelUtil.intersectionType(refinedType, refiningType, unit);
                td.setType(t);
                mod.setTypeModel(t);
                return;
            }
            if (AnalyzerUtil.hasUncheckedNullType(refinedMember)) {
                Type optionalRefinedType = unit.getOptionalType(refinedType);
                AnalyzerUtil.checkAssignableToOneOf(refiningType, refinedType, optionalRefinedType, that, "type of member must be assignable to type of refined member " + AnalyzerUtil.message(refined), 9000);
            } else {
                AnalyzerUtil.checkAssignable(refiningType, refinedType, that, "type of member must be assignable to type of refined member " + AnalyzerUtil.message(refined), 9000);
                this.checkSmallRefinement(that, refiningMember.getDeclaration(), refinedMember.getDeclaration());
            }
        }
    }

    private void checkRefinedMemberTypeExactly(Reference refiningMember, Reference refinedMember, Node that, Declaration refined, Declaration refining) {
        Unit unit = that.getUnit();
        Type refiningType = refiningMember.getType();
        Type refinedType = refinedMember.getType();
        if (!ModelUtil.isTypeUnknown(refinedType)) {
            if (that instanceof Tree.LocalModifier) {
                TypedDeclaration td = (TypedDeclaration)refining;
                Tree.LocalModifier mod = (Tree.LocalModifier)that;
                if (ModelUtil.isTypeUnknown(refiningType)) {
                    Type t = refinedType;
                    td.setType(t);
                    mod.setTypeModel(t);
                } else {
                    AnalyzerUtil.checkIsExactly(refiningType, refinedType, that, "inferred type of member must be exactly the same as type of variable refined member: " + AnalyzerUtil.message(refined), 9000);
                }
                return;
            }
            if (AnalyzerUtil.hasUncheckedNullType(refinedMember)) {
                Type optionalRefinedType = unit.getOptionalType(refinedType);
                AnalyzerUtil.checkIsExactlyOneOf(refiningType, refinedMember.getType(), optionalRefinedType, that, "type of member must be exactly the same as type of variable refined member: " + AnalyzerUtil.message(refined));
            } else {
                AnalyzerUtil.checkIsExactly(refiningType, refinedType, that, "type of member must be exactly the same as type of variable refined member: " + AnalyzerUtil.message(refined), 9000);
            }
        }
    }

    private void checkSmallRefinement(Node that, Declaration refiningDeclaration, Declaration refinedDeclaration) {
        if (refiningDeclaration instanceof FunctionOrValue && refinedDeclaration instanceof FunctionOrValue) {
            FunctionOrValue refiningFunctionOrValue = (FunctionOrValue)refiningDeclaration;
            FunctionOrValue refinedFunctionOrValue = (FunctionOrValue)refinedDeclaration;
            boolean refiningSmall = refiningFunctionOrValue.isSmall();
            boolean refinedSmall = refinedFunctionOrValue.isSmall();
            if (refiningSmall && !refinedSmall) {
                that.addUsageWarning(Warning.smallIgnored, "small annotation on actual member " + AnalyzerUtil.message(refiningDeclaration) + " will be ignored: " + AnalyzerUtil.message(refinedDeclaration) + " is not small");
            }
            refiningFunctionOrValue.setSmall(refinedSmall);
        }
    }

    private void checkNonrefinableDeclaration(Tree.Declaration that, Declaration dec) {
        if (dec.isActual()) {
            that.addError("actual declaration is not a method, getter, reference attribute, or class", 1301);
        }
        if (dec.isFormal()) {
            that.addError("formal declaration is not a method, getter, reference attribute, or class", 1302);
        }
        if (dec.isDefault()) {
            that.addError("default declaration is not a method, getter, reference attribute, or class", 1303);
        }
    }

    private void checkNonMember(Tree.Declaration that, Declaration dec) {
        Class clazz;
        Declaration member;
        Scope container;
        boolean mayBeShared = !(dec instanceof TypeParameter);
        boolean nonTypeMember = !dec.isClassOrInterfaceMember();
        String name = dec.getName();
        if (dec.isStatic()) {
            if (nonTypeMember) {
                that.addError("static declaration is not a member of a class or interface: '" + name + "' is not defined directly in the body of a class or interface");
            } else {
                ClassOrInterface type = (ClassOrInterface)dec.getContainer();
                if (!type.isToplevel()) {
                    that.addError("static declaration belongs to a nested a class or interface: '" + name + "' is a member of nested type '" + type.getName() + "'");
                }
            }
        }
        if (nonTypeMember && mayBeShared) {
            if (dec.isActual()) {
                that.addError("actual declaration is not a member of a class or interface: '" + name + "'", 1301);
            }
            if (dec.isFormal()) {
                that.addError("formal declaration is not a member of a class or interface: '" + name + "'", 1302);
            }
            if (dec.isDefault()) {
                that.addError("default declaration is not a member of a class or interface: '" + name + "'", 1303);
            }
        } else if (!dec.isShared() && mayBeShared) {
            if (dec.isActual()) {
                that.addError("actual declaration must be shared: '" + name + "'", 701);
            }
            if (dec.isFormal()) {
                that.addError("formal declaration must be shared: '" + name + "'", 702);
            }
            if (dec.isDefault()) {
                that.addError("default declaration must be shared: '" + name + "'", 703);
            }
        } else {
            if (dec.isActual()) {
                that.addError("declaration may not be actual: '" + name + "'", 1301);
            }
            if (dec.isFormal()) {
                that.addError("declaration may not be formal: '" + name + "'", 1302);
            }
            if (dec.isDefault()) {
                that.addError("declaration may not be default: '" + name + "'", 1303);
            }
        }
        if (ModelUtil.isOverloadedVersion(dec)) {
            if (ModelUtil.isConstructor(dec)) {
                this.checkOverloadedAnnotation(that, dec);
                this.checkOverloadedParameters(that, dec);
            } else {
                that.addError("duplicate declaration: the name '" + name + "' is not unique in this scope");
            }
        } else if (ModelUtil.isAbstraction(dec) && that instanceof Tree.ClassDefinition && !that.hasErrors()) {
            Tree.ClassDefinition def = (Tree.ClassDefinition)that;
            Class abs = (Class)dec;
            for (Tree.Statement st : def.getClassBody().getStatements()) {
                Tree.Constructor node;
                if (!(st instanceof Tree.Constructor) || (node = (Tree.Constructor)st).getIdentifier() != null) continue;
                Constructor con = node.getConstructor();
                Class cla = RefinementVisitor.classOverloadForConstructor(abs, con);
                this.checkOverloadedAnnotation(node, con);
                this.checkOverloadedParameters(node, cla);
            }
        }
        if (ModelUtil.isConstructor(dec) && dec.isShared() && (container = dec.getContainer()) instanceof Class && (member = ModelUtil.intersectionOfSupertypes(clazz = (Class)container).getDeclaration().getMember(name, null, false)) != null && member.isShared() && !ModelUtil.isConstructor(member)) {
            Declaration supertype = (Declaration)((Object)member.getContainer());
            that.addError("constructor has same name as an inherited member '" + clazz.getName() + "' inherits '" + member.getName() + "' from '" + supertype.getName(that.getUnit()) + "'");
        }
    }

    private static Class classOverloadForConstructor(Class abs, Constructor con) {
        for (Declaration d : abs.getOverloads()) {
            Class c;
            if (!(d instanceof Class) || (c = (Class)d).getParameterList() != con.getParameterList()) continue;
            return c;
        }
        return null;
    }

    private static String containerName(Reference member) {
        return RefinementVisitor.containerName(member.getDeclaration());
    }

    private static String containerName(Declaration member) {
        Scope container = member.getContainer();
        if (container instanceof Declaration) {
            Declaration dec = (Declaration)((Object)container);
            return dec.getName();
        }
        if (container instanceof Package) {
            Package pack = (Package)container;
            return pack.getQualifiedNameString();
        }
        return "Unknown";
    }

    private void checkParameterTypes(Tree.Declaration that, Tree.ParameterList pl, Reference member, Reference refinedMember, ParameterList params, ParameterList refinedParams, boolean forNative) {
        List<Parameter> paramsList = params.getParameters();
        List<Parameter> refinedParamsList = refinedParams.getParameters();
        if (paramsList.size() != refinedParamsList.size()) {
            this.handleWrongParameterListLength(that, member, refinedMember, forNative, pl);
        } else {
            for (int i = 0; i < paramsList.size(); ++i) {
                Tree.ParameterDeclaration pd;
                Tree.Type type;
                Parameter rparam = refinedParamsList.get(i);
                Parameter param = paramsList.get(i);
                Tree.Parameter parameter = pl.getParameters().get(i);
                if (forNative && !param.getName().equals(rparam.getName())) {
                    parameter.addError("parameter does not have the same name as its header: '" + param.getName() + "' is not '" + rparam.getName() + "' for " + AnalyzerUtil.message(refinedMember.getDeclaration()));
                }
                if (rparam.isSequenced() && !param.isSequenced()) {
                    parameter.addError("parameter must be variadic: parameter '" + rparam.getName() + "' of " + (forNative ? "native header " : "refined member ") + AnalyzerUtil.message(refinedMember.getDeclaration()) + " is variadic");
                }
                if (!rparam.isSequenced() && param.isSequenced()) {
                    parameter.addError("parameter may not be variadic: parameter '" + rparam.getName() + "' of " + (forNative ? "native header " : "refined member ") + AnalyzerUtil.message(refinedMember.getDeclaration()) + " is not variadic");
                }
                Type refinedParameterType = refinedMember.getTypedParameter(rparam).getFullType();
                Type parameterType = member.getTypedParameter(param).getFullType();
                Node typeNode = parameter;
                if (parameter instanceof Tree.ParameterDeclaration && (type = (pd = (Tree.ParameterDeclaration)parameter).getTypedDeclaration().getType()) != null) {
                    typeNode = type;
                }
                if (parameter == null) continue;
                if (rparam.getModel().isDynamicallyTyped()) {
                    this.checkRefiningParameterDynamicallyTyped(member, refinedMember, param, typeNode);
                    continue;
                }
                if (param.getModel() != null && param.getModel().isDynamicallyTyped()) {
                    this.checkRefinedParameterDynamicallyTyped(member, refinedMember, rparam, param, typeNode);
                    continue;
                }
                if (refinedParameterType == null || parameterType == null) {
                    this.handleUnknownParameterType(member, refinedMember, param, typeNode, forNative);
                    continue;
                }
                RefinementVisitor.checkRefiningParameterType(member, refinedMember, refinedParams, rparam, refinedParameterType, param, parameterType, typeNode, forNative);
                this.checkRefiningParameterSmall(typeNode, member.getDeclaration(), param, refinedMember.getDeclaration(), rparam);
            }
        }
    }

    private void checkRefiningParameterSmall(Node that, Declaration member, Parameter param, Declaration refinedMember, Parameter refinedParam) {
        if (param.getModel().isSmall() && !refinedParam.getModel().isSmall()) {
            that.addUsageWarning(Warning.smallIgnored, "small annotation on parameter '" + param.getName() + "' of '" + member.getName() + "' will be ignored: corresponding parameter '" + refinedParam.getName() + "' of '" + refinedMember.getName() + "' is not small");
        }
        param.getModel().setSmall(refinedParam.getModel().isSmall());
    }

    private void handleWrongParameterListLength(Tree.Declaration that, Reference member, Reference refinedMember, boolean forNative, Tree.ParameterList paramList) {
        StringBuilder message = new StringBuilder();
        String subject = forNative ? "native header" : "refined member";
        message.append("member does not have the same number of parameters as ").append(subject).append(": '").append(member.getDeclaration().getName()).append("'");
        if (!forNative) {
            message.append(" declared by '").append(RefinementVisitor.containerName(member)).append("' refining '").append(refinedMember.getDeclaration().getName()).append("' declared by '").append(RefinementVisitor.containerName(refinedMember)).append("'");
        }
        paramList.addError(message.toString(), 9100);
    }

    private static void checkRefiningParameterType(Reference member, Reference refinedMember, ParameterList refinedParams, Parameter rparam, Type refinedParameterType, Parameter param, Type parameterType, Node typeNode, boolean forNative) {
        StringBuilder message = new StringBuilder();
        String subject = forNative ? "native header" : "refined member";
        message.append("type of parameter '").append(param.getName()).append("' of '").append(member.getDeclaration().getName()).append("'");
        if (!forNative) {
            message.append(" declared by '").append(RefinementVisitor.containerName(member)).append("'");
        }
        message.append(" is different to type of corresponding parameter '").append(rparam.getName()).append("' of ").append(subject).append(" '").append(refinedMember.getDeclaration().getName()).append("'");
        if (!forNative) {
            message.append(" of '").append(RefinementVisitor.containerName(refinedMember)).append("'");
        }
        AnalyzerUtil.checkIsExactlyForInterop(typeNode.getUnit(), refinedParams.isNamedParametersSupported(), parameterType, refinedParameterType, typeNode, message.toString());
    }

    private void handleUnknownParameterType(Reference member, Reference refinedMember, Parameter param, Node typeNode, boolean forNative) {
        StringBuilder message = new StringBuilder();
        String subject = forNative ? "native header" : "refined member";
        message.append("could not determine if parameter type is the same as the corresponding parameter of ").append(subject).append(": '").append(param.getName()).append("' of '").append(member.getDeclaration().getName());
        if (!forNative) {
            message.append("' declared by '").append(RefinementVisitor.containerName(member)).append("' refining '").append(refinedMember.getDeclaration().getName()).append("' declared by '").append(RefinementVisitor.containerName(refinedMember)).append("'");
        }
        typeNode.addError(message.toString());
    }

    private void checkRefinedParameterDynamicallyTyped(Reference member, Reference refinedMember, Parameter rparam, Parameter param, Node typeNode) {
        if (!rparam.getModel().isDynamicallyTyped()) {
            typeNode.addError("parameter which refines statically typed parameter must also be statically typed: '" + param.getName() + "' of '" + member.getDeclaration().getName() + "' declared by '" + RefinementVisitor.containerName(member) + "' refining '" + refinedMember.getDeclaration().getName() + "' declared by '" + RefinementVisitor.containerName(refinedMember) + "'");
        }
    }

    private void checkRefiningParameterDynamicallyTyped(Reference member, Reference refinedMember, Parameter param, Node typeNode) {
        if (!param.getModel().isDynamicallyTyped()) {
            typeNode.addError("parameter which refines dynamically typed parameter must also be dynamically typed: '" + param.getName() + "' of '" + member.getDeclaration().getName() + "' declared by '" + RefinementVisitor.containerName(member) + "' refining '" + refinedMember.getDeclaration().getName() + "' declared by '" + RefinementVisitor.containerName(refinedMember) + "'");
        }
    }

    private static Tree.ParameterList getParameterList(Tree.Declaration that, int i) {
        if (that instanceof Tree.AnyMethod) {
            Tree.AnyMethod am = (Tree.AnyMethod)that;
            return am.getParameterLists().get(i);
        }
        if (that instanceof Tree.AnyClass) {
            Tree.AnyClass ac = (Tree.AnyClass)that;
            return ac.getParameterList();
        }
        if (that instanceof Tree.Constructor) {
            Tree.Constructor con = (Tree.Constructor)that;
            return con.getParameterList();
        }
        return null;
    }

    @Override
    public void visit(Tree.ParameterList that) {
        super.visit(that);
        boolean foundSequenced = false;
        boolean foundDefault = false;
        ParameterList pl = that.getModel();
        for (Tree.Parameter p : that.getParameters()) {
            Parameter pm;
            if (p == null || (pm = p.getParameterModel()) == null) continue;
            if (pm.isDefaulted()) {
                if (foundSequenced) {
                    p.addError("defaulted parameter must occur before variadic parameter");
                }
                foundDefault = true;
                if (pl.isFirst()) continue;
                p.addError("only the first parameter list may have defaulted parameters");
                continue;
            }
            if (pm.isSequenced()) {
                if (foundSequenced) {
                    p.addError("parameter list may have at most one variadic parameter");
                }
                foundSequenced = true;
                if (!pl.isFirst()) {
                    p.addError("only the first parameter list may have a variadic parameter");
                }
                if (!foundDefault || !pm.isAtLeastOne()) continue;
                p.addError("parameter list with defaulted parameters may not have a nonempty variadic parameter");
                continue;
            }
            if (foundDefault) {
                p.addError("required parameter must occur before defaulted parameters");
            }
            if (!foundSequenced) continue;
            p.addError("required parameter must occur before variadic parameter");
        }
    }

    @Override
    public void visit(Tree.SpecifierStatement that) {
        super.visit(that);
        ArrayList<Type> sig = new ArrayList<Type>();
        Tree.Term term = that.getBaseMemberExpression();
        while (term instanceof Tree.ParameterizedExpression) {
            sig.clear();
            Tree.ParameterizedExpression pe = (Tree.ParameterizedExpression)term;
            Tree.TypeParameterList typeParameterList = pe.getTypeParameterList();
            if (typeParameterList != null) {
                typeParameterList.addError("specification statements may not have type parameters");
            }
            Tree.ParameterList pl = pe.getParameterLists().get(0);
            for (Tree.Parameter p : pl.getParameters()) {
                if (p == null) {
                    sig.add(null);
                    continue;
                }
                Parameter model = p.getParameterModel();
                if (model != null) {
                    sig.add(model.getType());
                    continue;
                }
                sig.add(null);
            }
            term = pe.getPrimary();
        }
        if (term instanceof Tree.BaseMemberExpression) {
            Tree.BaseMemberExpression bme = (Tree.BaseMemberExpression)term;
            Unit unit = that.getUnit();
            TypedDeclaration td = AnalyzerUtil.getTypedDeclaration(bme.getScope(), TreeUtil.name(bme.getIdentifier()), sig, false, unit);
            if (td != null) {
                that.setDeclaration(td);
                Scope scope = that.getScope();
                Scope container = scope.getContainer();
                Scope realScope = ModelUtil.getRealScope(container);
                if (realScope instanceof ClassOrInterface) {
                    ClassOrInterface ci = (ClassOrInterface)realScope;
                    Scope tdcontainer = td.getContainer();
                    if (td.isClassOrInterfaceMember()) {
                        boolean lazy;
                        ClassOrInterface tdci = (ClassOrInterface)tdcontainer;
                        if (!(tdcontainer.equals(realScope) || !ci.inherits(tdci) || !(lazy = that.getSpecifierExpression() instanceof Tree.LazySpecifierExpression) && td.isVariable() && td.isJava())) {
                            if (tdcontainer == scope) {
                                that.addError("parameter declaration hides refining member: '" + td.getName(unit) + "' (rename parameter)");
                            } else if (td instanceof Value) {
                                this.refineAttribute((Value)td, bme, that, ci);
                            } else if (td instanceof Function) {
                                this.refineMethod((Function)td, bme, that, ci);
                            } else {
                                bme.addError("not a reference to a formal attribute: '" + td.getName(unit) + "'");
                            }
                        }
                    }
                }
            }
        }
    }

    private void refineAttribute(Value sv, Tree.BaseMemberExpression bme, Tree.SpecifierStatement that, final ClassOrInterface c) {
        String name;
        final ClassOrInterface ci = (ClassOrInterface)sv.getContainer();
        Declaration refined = ci.getRefinedMember(name = sv.getName(), null, false);
        final Value root = refined instanceof Value ? (Value)refined : sv;
        Reference rv = ExpressionVisitor.getRefinedMemberReference(sv, c);
        if (!(sv.isFormal() || sv.isDefault() || sv.isShortcutRefinement())) {
            that.addError("inherited attribute may not be assigned in initializer and is neither formal nor default so may not be refined: " + AnalyzerUtil.message(sv), 510);
        } else if (sv.isVariable()) {
            that.addError("inherited attribute may not be assigned in initializer and is variable so may not be refined by non-variable: " + AnalyzerUtil.message(sv));
        }
        boolean lazy = that.getSpecifierExpression() instanceof Tree.LazySpecifierExpression;
        Value v = new Value();
        v.setName(name);
        v.setShared(true);
        v.setActual(true);
        v.getAnnotations().add(new Annotation("shared"));
        v.getAnnotations().add(new Annotation("actual"));
        v.setRefinedDeclaration(root);
        Unit unit = that.getUnit();
        v.setUnit(unit);
        v.setContainer(c);
        v.setScope(c);
        v.setShortcutRefinement(true);
        v.setTransient(lazy);
        Declaration rvd = rv.getDeclaration();
        if (rvd instanceof TypedDeclaration) {
            TypedDeclaration rvtd = (TypedDeclaration)rvd;
            v.setUncheckedNullType(rvtd.hasUncheckedNullType());
        }
        ModelUtil.setVisibleScope(v);
        c.addMember(v);
        that.setRefinement(true);
        that.setDeclaration(v);
        that.setRefined(sv);
        unit.addDeclaration(v);
        v.setType(new LazyType(unit){

            Type intersection() {
                ArrayList<Type> list = new ArrayList<Type>();
                for (Declaration d : ModelUtil.getInterveningRefinements(name, null, false, root, c, ci)) {
                    ModelUtil.addToIntersection(list, c.getType().getTypedReference(d, AnalyzerUtil.NO_TYPE_ARGS).getType(), this.getUnit());
                }
                IntersectionType it = new IntersectionType(this.getUnit());
                it.setSatisfiedTypes(list);
                return it.canonicalize().getType();
            }

            @Override
            public Type initQualifyingType() {
                Type type = this.intersection();
                return type == null ? null : type.getQualifyingType();
            }

            @Override
            public Map<TypeParameter, Type> initTypeArguments() {
                Type type = this.intersection();
                return type == null ? null : type.getTypeArguments();
            }

            @Override
            public TypeDeclaration initDeclaration() {
                Type type = this.intersection();
                return type == null ? null : type.getDeclaration();
            }

            @Override
            public Map<TypeParameter, SiteVariance> getVarianceOverrides() {
                Type type = this.intersection();
                return type == null ? null : type.getVarianceOverrides();
            }
        });
    }

    private void refineMethod(Function sm, Tree.BaseMemberExpression bme, Tree.SpecifierStatement that, final ClassOrInterface c) {
        ArrayList<TypeParameter> typeParams;
        List<Object> paramLists;
        Function root;
        boolean variadic;
        List<Type> signature;
        String name;
        final ClassOrInterface ci = (ClassOrInterface)sm.getContainer();
        Declaration refined = ci.getRefinedMember(name = sm.getName(), signature = ModelUtil.getSignature(sm), variadic = ModelUtil.isVariadic(sm));
        Function function = root = refined instanceof Function ? (Function)refined : sm;
        if (!(sm.isFormal() || sm.isDefault() || sm.isShortcutRefinement())) {
            that.addError("inherited method is neither formal nor default so may not be refined: " + AnalyzerUtil.message(sm), 510);
        }
        final Reference rm = ExpressionVisitor.getRefinedMemberReference(sm, c);
        Function m = new Function();
        m.setName(name);
        Tree.Term me = that.getBaseMemberExpression();
        if (me instanceof Tree.ParameterizedExpression) {
            Tree.ParameterizedExpression pe = (Tree.ParameterizedExpression)me;
            paramLists = pe.getParameterLists();
            Tree.TypeParameterList typeParameterList = pe.getTypeParameterList();
            if (typeParameterList != null) {
                typeParams = new ArrayList<TypeParameter>();
                for (Tree.TypeParameterDeclaration tpd : typeParameterList.getTypeParameterDeclarations()) {
                    typeParams.add(tpd.getDeclarationModel());
                }
            } else {
                typeParams = null;
            }
        } else {
            paramLists = Collections.emptyList();
            typeParams = null;
        }
        int i = 0;
        Unit unit = that.getUnit();
        for (ParameterList pl : sm.getParameterLists()) {
            ParameterList l = new ParameterList();
            Tree.ParameterList tpl = paramLists.size() <= i ? null : (Tree.ParameterList)paramLists.get(i++);
            int j = 0;
            for (final Parameter p : pl.getParameters()) {
                if (tpl == null || tpl.getParameters().size() <= j) {
                    Parameter vp = new Parameter();
                    Value v = new Value();
                    vp.setModel(v);
                    v.setInitializerParameter(vp);
                    vp.setSequenced(p.isSequenced());
                    vp.setAtLeastOne(p.isAtLeastOne());
                    vp.setName(p.getName());
                    v.setName(p.getName());
                    vp.setDeclaration(m);
                    v.setContainer(m);
                    v.setScope(m);
                    l.getParameters().add(vp);
                    v.setType(new LazyType(unit){

                        private Type type() {
                            return rm.getTypedParameter(p).getFullType();
                        }

                        @Override
                        public Type initQualifyingType() {
                            Type type = this.type();
                            return type == null ? null : type.getQualifyingType();
                        }

                        @Override
                        public Map<TypeParameter, Type> initTypeArguments() {
                            Type type = this.type();
                            return type == null ? null : type.getTypeArguments();
                        }

                        @Override
                        public TypeDeclaration initDeclaration() {
                            Type type = this.type();
                            return type == null ? null : type.getDeclaration();
                        }

                        @Override
                        public Map<TypeParameter, SiteVariance> getVarianceOverrides() {
                            Type type = this.type();
                            return type == null ? null : type.getVarianceOverrides();
                        }
                    });
                } else {
                    Tree.Parameter tp = tpl.getParameters().get(j);
                    Parameter rp = tp.getParameterModel();
                    rp.setDefaulted(p.isDefaulted());
                    rp.setDeclaration(m);
                    l.getParameters().add(rp);
                }
                ++j;
            }
            m.getParameterLists().add(l);
        }
        if (typeParams != null) {
            m.setTypeParameters(typeParams);
        } else if (!sm.getTypeParameters().isEmpty()) {
            if (me instanceof Tree.ParameterizedExpression) {
                bme.addError("refined method is generic: '" + sm.getName(unit) + "' declares type parameters");
            } else {
                TypeParameter tp;
                int j;
                List<TypeParameter> typeParameters = sm.getTypeParameters();
                ArrayList<TypeParameter> tps = new ArrayList<TypeParameter>(typeParameters.size());
                HashMap<TypeParameter, Type> subs = new HashMap<TypeParameter, Type>();
                for (j = 0; j < typeParameters.size(); ++j) {
                    TypeParameter param = typeParameters.get(j);
                    tp = new TypeParameter();
                    tp.setName(param.getName());
                    tp.setUnit(unit);
                    tp.setScope(m);
                    tp.setContainer(m);
                    tp.setDeclaration(m);
                    tp.setCovariant(param.isCovariant());
                    tp.setContravariant(param.isContravariant());
                    tps.add(tp);
                    subs.put(param, tp.getType());
                }
                for (j = 0; j < typeParameters.size(); ++j) {
                    TypeParameter param = typeParameters.get(j);
                    tp = (TypeParameter)tps.get(j);
                    List<Type> sts = param.getSatisfiedTypes();
                    ArrayList<Type> ssts = new ArrayList<Type>(sts.size());
                    for (Type st : sts) {
                        ssts.add(st.substitute(subs, null));
                    }
                    tp.setSatisfiedTypes(ssts);
                    List<Type> cts = param.getCaseTypes();
                    if (cts == null) continue;
                    ArrayList<Type> scts = new ArrayList<Type>(cts.size());
                    for (Type ct : cts) {
                        scts.add(ct.substitute(subs, null));
                    }
                    tp.setCaseTypes(scts);
                }
                m.setTypeParameters(tps);
            }
        }
        m.setShared(true);
        m.setActual(true);
        m.getAnnotations().add(new Annotation("shared"));
        m.getAnnotations().add(new Annotation("actual"));
        m.setRefinedDeclaration(root);
        m.setUnit(unit);
        m.setContainer(c);
        m.setScope(c);
        m.setShortcutRefinement(true);
        m.setDeclaredVoid(sm.isDeclaredVoid());
        Declaration rmd = rm.getDeclaration();
        if (rmd instanceof TypedDeclaration) {
            TypedDeclaration rmtd = (TypedDeclaration)rmd;
            m.setUncheckedNullType(rmtd.hasUncheckedNullType());
        }
        ModelUtil.setVisibleScope(m);
        c.addMember(m);
        that.setRefinement(true);
        that.setDeclaration(m);
        that.setRefined(root);
        unit.addDeclaration(m);
        Scope scope = that.getScope();
        if (scope instanceof Specification) {
            Specification spec = (Specification)scope;
            spec.setDeclaration(m);
        }
        m.setType(new LazyType(unit){

            Type intersection() {
                ArrayList<Type> list = new ArrayList<Type>();
                for (Declaration d : ModelUtil.getInterveningRefinements(name, signature, variadic, root, c, ci)) {
                    ModelUtil.addToIntersection(list, c.getType().getTypedReference(d, AnalyzerUtil.NO_TYPE_ARGS).getType(), this.getUnit());
                }
                IntersectionType it = new IntersectionType(this.getUnit());
                it.setSatisfiedTypes(list);
                return it.canonicalize().getType();
            }

            @Override
            public Type initQualifyingType() {
                Type type = this.intersection();
                return type == null ? null : type.getQualifyingType();
            }

            @Override
            public Map<TypeParameter, Type> initTypeArguments() {
                Type type = this.intersection();
                return type == null ? null : type.getTypeArguments();
            }

            @Override
            public TypeDeclaration initDeclaration() {
                Type type = this.intersection();
                return type == null ? null : type.getDeclaration();
            }

            @Override
            public Map<TypeParameter, SiteVariance> getVarianceOverrides() {
                Type type = this.intersection();
                return type == null ? null : type.getVarianceOverrides();
            }
        });
        this.inheritDefaultedArguments(m);
    }
}

