/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.analyzer;

import com.redhat.ceylon.compiler.typechecker.analyzer.AnalyzerUtil;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.TreeUtil;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Setter;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.ArrayList;
import java.util.List;

public class SpecificationVisitor
extends Visitor {
    private final Declaration declaration;
    private boolean specificationDisabled = false;
    private boolean withinDeclaration = false;
    private int loopDepth = 0;
    private int brokenLoopDepth = 0;
    private boolean allOuterLoopsBreak = true;
    private boolean declared = false;
    private boolean hasParameter = false;
    private Tree.Statement lastExecutableStatement;
    private Tree.Declaration lastConstructor;
    private boolean declarationSection = false;
    private boolean endsInReturnThrow = false;
    private boolean endsInBreak = false;
    private boolean inExtends = false;
    private boolean inParameter = false;
    private boolean inDelegatedContructor = false;
    private boolean inLazyExpression = false;
    private Parameter parameter = null;
    private boolean usedInDeclarationSection = false;
    private boolean definedInDeclarationSection = false;
    private boolean hasNonStatic = false;
    private boolean definitely = false;
    private boolean possibly = false;
    private boolean possiblyExited = false;
    private boolean definitelyExited = false;
    private boolean definitelyByLoopBreaks = true;
    private boolean possiblyByLoopBreaks = false;
    private Tree.Continue lastContinue;
    private Tree.Statement lastContinueStatement;
    private TypeDeclaration delegatedConstructor;
    private List<Constructor> definitelyInitedBy = new ArrayList<Constructor>();
    private List<Constructor> possiblyInitedBy = new ArrayList<Constructor>();
    private boolean initedByEveryConstructor = true;

    @Override
    public void visit(Tree.ExtendedType that) {
        boolean oie = this.inExtends;
        this.inExtends = this.declared;
        super.visit(that);
        this.inExtends = oie;
    }

    public SpecificationVisitor(Declaration declaration) {
        this.declaration = declaration;
    }

    private void declare() {
        this.declared = true;
    }

    private void specify() {
        this.definitely = true;
        this.possibly = true;
    }

    private void exit() {
        this.possiblyExited = true;
        this.definitelyExited = true;
    }

    private void beginSpecificationScope() {
        this.possiblyExited = false;
        this.definitelyExited = false;
        this.definitelyByLoopBreaks = true;
        this.possiblyByLoopBreaks = false;
    }

    private boolean isVariable() {
        if (this.declaration instanceof TypedDeclaration) {
            TypedDeclaration td = (TypedDeclaration)this.declaration;
            return td.isVariable();
        }
        return false;
    }

    private boolean isLate() {
        if (this.declaration instanceof FunctionOrValue) {
            FunctionOrValue fov = (FunctionOrValue)this.declaration;
            return fov.isLate();
        }
        return false;
    }

    @Override
    public void visit(Tree.AnnotationList that) {
    }

    @Override
    public void visit(Tree.BaseMemberExpression that) {
        super.visit(that);
        this.visitReference(that);
    }

    @Override
    public void visit(Tree.MetaLiteral that) {
        super.visit(that);
        this.visitReference(that);
    }

    @Override
    public void visit(Tree.ExtendedTypeExpression that) {
        super.visit(that);
        this.visitReference(that);
    }

    @Override
    public void visit(Tree.CaseTypes that) {
    }

    @Override
    public void visit(Tree.TypeConstraint that) {
    }

    @Override
    public void visit(Tree.SatisfiedTypes that) {
        for (Tree.Type type : that.getTypes()) {
            if (!(type instanceof Tree.SimpleType)) continue;
            Tree.SimpleType st = (Tree.SimpleType)type;
            this.checkReference(type, st.getDeclarationModel(), false, false);
        }
    }

    @Override
    public void visit(Tree.BaseTypeExpression that) {
        super.visit(that);
        this.visitReference(that);
    }

    @Override
    public void visit(Tree.QualifiedMemberExpression that) {
        super.visit(that);
        if (TreeUtil.isSelfReference(that.getPrimary())) {
            this.visitReference(that);
        }
        if (that.getStaticMethodReference()) {
            this.visitReference(that);
        }
    }

    @Override
    public void visit(Tree.QualifiedTypeExpression that) {
        super.visit(that);
        if (TreeUtil.isSelfReference(that.getPrimary())) {
            this.visitReference(that);
        }
        if (that.getStaticMethodReference()) {
            this.visitReference(that);
        }
    }

    private String name() {
        String name = this.declaration.getName();
        return name == null ? "default constructor" : "'" + name + "'";
    }

    private void visitReference(Tree.Primary that) {
        boolean metamodel;
        boolean assigned;
        Declaration member;
        if (that instanceof Tree.MemberOrTypeExpression) {
            Tree.MemberOrTypeExpression mte = (Tree.MemberOrTypeExpression)that;
            if ((that instanceof Tree.BaseTypeExpression || that instanceof Tree.QualifiedTypeExpression) && mte.getStaticMethodReferencePrimary() && !SpecificationVisitor.hasConstructors(mte.getDeclaration())) {
                return;
            }
            member = mte.getDeclaration();
            assigned = mte.getAssigned();
            metamodel = false;
        } else if (that instanceof Tree.MetaLiteral) {
            Tree.MetaLiteral ml = (Tree.MetaLiteral)that;
            member = ml.getDeclaration();
            assigned = false;
            metamodel = true;
        } else {
            return;
        }
        this.checkReference(that, member, assigned, metamodel);
    }

    private void checkReference(Node that, Declaration member, boolean assigned, boolean metamodel) {
        Scope scope = that.getScope();
        if ((member == this.declaration || this.isDelegationToDefaultConstructor(member)) && this.declaration.isDefinedInScope(scope) && !this.isReferenceToNativeHeaderMember(scope)) {
            Declaration paramDec;
            if (!this.declared) {
                if (!(metamodel || this.isForwardReferenceable() || this.hasParameter)) {
                    Scope container = this.declaration.getContainer();
                    if (container instanceof Class) {
                        that.addError("forward reference to class member in initializer: " + this.name() + " is not yet declared (forward references must occur in declaration section)");
                    } else {
                        that.addError("forward reference to local declaration: " + this.name() + " is not yet declared");
                    }
                }
            } else if (!this.definitely || this.declaration.isFormal()) {
                if (this.declaration.isFormal()) {
                    if (!this.isForwardReferenceable()) {
                        that.addError("formal member may not be used in initializer: " + this.name() + " is declared 'formal'");
                    }
                } else if (!(metamodel || ModelUtil.isNativeHeader(this.declaration) || this.isLate())) {
                    String message = "not definitely " + (this.isVariable() ? "initialized" : "specified") + ": " + this.name() + " has not been assigned " + (this.declaration instanceof Value ? "a value" : "a definition") + " by every conditional branch";
                    that.addError(message);
                }
            } else if (this.parameter != null && ModelUtil.isConstructor(paramDec = this.parameter.getDeclaration()) && !this.declaration.isStatic() && paramDec.getContainer().equals(this.declaration.getContainer())) {
                that.addError("default argument to constructor parameter is a member of the constructed class");
            }
            if (!assigned && this.declaration.isDefault() && !this.isForwardReferenceable()) {
                that.addError("default member may not be used in initializer: " + this.name() + " is declared 'default'");
            }
            if (this.definitely && this.isVariable() && this.inLazyExpression) {
                if (this.inParameter && (paramDec = this.parameter.getDeclaration()).equals(this.declaration.getContainer())) {
                    that.addError("value may not be captured by lazy expression in default argument: " + this.name() + " is declared 'variable'");
                }
                if (this.inExtends && this.declaration.isClassOrInterfaceMember() && ModelUtil.getContainingClassOrInterface(scope).equals(this.declaration.getContainer())) {
                    that.addError("value may not be captured by lazy expression in extends clause: " + this.name() + " is declared 'variable'");
                }
            }
        }
    }

    private static boolean hasConstructors(Declaration td) {
        return td instanceof Class && ((Class)td).hasConstructors();
    }

    private boolean isDelegationToDefaultConstructor(Declaration member) {
        return this.inDelegatedContructor && member instanceof Class && this.declaration == ((Class)member).getDefaultConstructor();
    }

    private boolean isReferenceToNativeHeaderMember(Scope scope) {
        if (this.declaration.isClassOrInterfaceMember()) {
            ClassOrInterface container = (ClassOrInterface)this.declaration.getContainer();
            return container.isNativeHeader() && !scope.getScopedBackends().none();
        }
        return false;
    }

    private boolean isForwardReferenceable() {
        return this.declarationSection || this.declaration.isToplevel() || !this.inDelegatedContructor && ModelUtil.isConstructor(this.declaration);
    }

    @Override
    public void visit(Tree.LogicalOp that) {
        that.getLeftTerm().visit(this);
        boolean odefinitely = this.definitely;
        boolean opossibly = this.possibly;
        boolean opossiblyExited = this.possiblyExited;
        boolean odefinitelyExited = this.definitelyExited;
        boolean odefinitelyByLoopBreaks = this.definitelyByLoopBreaks;
        boolean opossiblyByLoopBreaks = this.possiblyByLoopBreaks;
        this.beginSpecificationScope();
        that.getRightTerm().visit(this);
        this.definitely = odefinitely;
        this.possibly = opossibly;
        this.possiblyExited = opossiblyExited;
        this.definitelyExited = odefinitelyExited;
        this.definitelyByLoopBreaks = odefinitelyByLoopBreaks;
        this.possiblyByLoopBreaks = opossiblyByLoopBreaks;
    }

    @Override
    public void visit(Tree.IfExpression that) {
        Tree.ElseClause elseClause;
        Tree.IfClause ifClause = that.getIfClause();
        if (ifClause != null) {
            boolean odefinitely = this.definitely;
            boolean opossibly = this.possibly;
            boolean opossiblyExited = this.possiblyExited;
            boolean odefinitelyExited = this.definitelyExited;
            boolean odefinitelyByLoopBreaks = this.definitelyByLoopBreaks;
            boolean opossiblyByLoopBreaks = this.possiblyByLoopBreaks;
            this.beginSpecificationScope();
            ifClause.visit(this);
            this.definitely = odefinitely;
            this.possibly = opossibly;
            this.possiblyExited = opossiblyExited;
            this.definitelyExited = odefinitelyExited;
            this.definitelyByLoopBreaks = odefinitelyByLoopBreaks;
            this.possiblyByLoopBreaks = opossiblyByLoopBreaks;
        }
        if ((elseClause = that.getElseClause()) != null) {
            boolean odefinitely = this.definitely;
            boolean opossibly = this.possibly;
            boolean opossiblyExited = this.possiblyExited;
            boolean odefinitelyExited = this.definitelyExited;
            boolean odefinitelyByLoopBreaks = this.definitelyByLoopBreaks;
            boolean opossiblyByLoopBreaks = this.possiblyByLoopBreaks;
            this.beginSpecificationScope();
            elseClause.visit(this);
            this.definitely = odefinitely;
            this.possibly = opossibly;
            this.possiblyExited = opossiblyExited;
            this.definitelyExited = odefinitelyExited;
            this.definitelyByLoopBreaks = odefinitelyByLoopBreaks;
            this.possiblyByLoopBreaks = opossiblyByLoopBreaks;
        }
    }

    @Override
    public void visit(Tree.SwitchExpression that) {
        Tree.SwitchCaseList switchCaseList;
        Tree.SwitchClause switchClause = that.getSwitchClause();
        if (switchClause != null) {
            switchClause.visit(this);
        }
        if ((switchCaseList = that.getSwitchCaseList()) != null) {
            for (Tree.CaseClause caseClause : switchCaseList.getCaseClauses()) {
                boolean odefinitely = this.definitely;
                boolean opossibly = this.possibly;
                boolean opossiblyExited = this.possiblyExited;
                boolean odefinitelyExited = this.definitelyExited;
                boolean odefinitelyByLoopBreaks = this.definitelyByLoopBreaks;
                boolean opossiblyByLoopBreaks = this.possiblyByLoopBreaks;
                this.beginSpecificationScope();
                caseClause.visit(this);
                this.definitely = odefinitely;
                this.possibly = opossibly;
                this.possiblyExited = opossiblyExited;
                this.definitelyExited = odefinitelyExited;
                this.definitelyByLoopBreaks = odefinitelyByLoopBreaks;
                this.possiblyByLoopBreaks = opossiblyByLoopBreaks;
            }
            Tree.ElseClause elseClause = switchCaseList.getElseClause();
            if (elseClause != null) {
                boolean odefinitely = this.definitely;
                boolean opossibly = this.possibly;
                boolean opossiblyExited = this.possiblyExited;
                boolean odefinitelyExited = this.definitelyExited;
                boolean odefinitelyByLoopBreaks = this.definitelyByLoopBreaks;
                boolean opossiblyByLoopBreaks = this.possiblyByLoopBreaks;
                this.beginSpecificationScope();
                elseClause.visit(this);
                this.definitely = odefinitely;
                this.possibly = opossibly;
                this.possiblyExited = opossiblyExited;
                this.definitelyExited = odefinitelyExited;
                this.definitelyByLoopBreaks = odefinitelyByLoopBreaks;
                this.possiblyByLoopBreaks = opossiblyByLoopBreaks;
            }
        }
    }

    @Override
    public void visit(Tree.SequenceEnumeration that) {
        boolean odefinitely = this.definitely;
        boolean oile = this.inLazyExpression;
        this.inLazyExpression = this.declared && (this.inExtends || this.inParameter);
        super.visit(that);
        this.definitely = odefinitely;
        this.inLazyExpression = oile;
    }

    @Override
    public void visit(Tree.NamedArgumentList that) {
        for (Tree.NamedArgument na : that.getNamedArguments()) {
            na.visit(this);
        }
        Tree.SequencedArgument sa = that.getSequencedArgument();
        if (sa != null) {
            boolean odefinitely = this.definitely;
            boolean oile = this.inLazyExpression;
            this.inLazyExpression = this.declared && (this.inExtends || this.inParameter);
            sa.visit(this);
            this.definitely = odefinitely;
            this.inLazyExpression = oile;
        }
    }

    @Override
    public void visit(Tree.Comprehension that) {
        boolean odefinitely = this.definitely;
        super.visit(that);
        this.definitely = odefinitely;
    }

    @Override
    public void visit(Tree.LazySpecifierExpression that) {
        boolean oile = this.inLazyExpression;
        this.inLazyExpression = this.declared && (this.inExtends || this.inParameter);
        super.visit(that);
        this.inLazyExpression = oile;
    }

    @Override
    public void visit(Tree.FunctionArgument that) {
        boolean c = this.specificationDisabled;
        this.specificationDisabled = true;
        boolean oile = this.inLazyExpression;
        this.inLazyExpression = this.declared && (this.inExtends || this.inParameter);
        boolean odefinitely = this.definitely;
        boolean opossibly = this.possibly;
        boolean opossiblyExited = this.possiblyExited;
        boolean odefinitelyExited = this.definitelyExited;
        boolean odefinitelyByLoopBreaks = this.definitelyByLoopBreaks;
        boolean opossiblyByLoopBreaks = this.possiblyByLoopBreaks;
        this.beginSpecificationScope();
        super.visit(that);
        this.definitely = odefinitely;
        this.possibly = opossibly;
        this.possiblyExited = opossiblyExited;
        this.definitelyExited = odefinitelyExited;
        this.definitelyByLoopBreaks = odefinitelyByLoopBreaks;
        this.possiblyByLoopBreaks = opossiblyByLoopBreaks;
        this.inLazyExpression = oile;
        this.specificationDisabled = c;
    }

    @Override
    public void visit(Tree.ObjectExpression that) {
        boolean c = this.specificationDisabled;
        this.specificationDisabled = true;
        boolean oile = this.inLazyExpression;
        this.inLazyExpression = this.declared && (this.inExtends || this.inParameter);
        boolean odefinitely = this.definitely;
        boolean opossibly = this.possibly;
        boolean opossiblyExited = this.possiblyExited;
        boolean odefinitelyExited = this.definitelyExited;
        boolean odefinitelyByLoopBreaks = this.definitelyByLoopBreaks;
        boolean opossiblyByLoopBreaks = this.possiblyByLoopBreaks;
        this.beginSpecificationScope();
        super.visit(that);
        this.definitely = odefinitely;
        this.possibly = opossibly;
        this.possiblyExited = opossiblyExited;
        this.definitelyExited = odefinitelyExited;
        this.definitelyByLoopBreaks = odefinitelyByLoopBreaks;
        this.possiblyByLoopBreaks = opossiblyByLoopBreaks;
        this.inLazyExpression = oile;
        this.specificationDisabled = c;
    }

    @Override
    public void visit(Tree.AssignOp that) {
        Tree.Term lt = that.getLeftTerm();
        if (lt instanceof Tree.IndexExpression) {
            Tree.IndexExpression ie = (Tree.IndexExpression)lt;
            Tree.Primary p = ie.getPrimary();
            if (p != null) {
                ((Tree.Term)p).visit(this);
            }
            ie.getElementOrRange().visit(this);
        } else if (TreeUtil.isEffectivelyBaseMemberExpression(lt)) {
            Tree.StaticMemberOrTypeExpression me = (Tree.StaticMemberOrTypeExpression)lt;
            Declaration member = me.getDeclaration();
            if (member == this.declaration) {
                if (that.getRightTerm() != null) {
                    that.getRightTerm().visit(this);
                }
                this.checkVariable(lt, that);
                this.specify();
                lt.visit(this);
            } else {
                super.visit(that);
            }
        }
    }

    @Override
    public void visit(Tree.AssignmentOp that) {
        super.visit(that);
        this.checkVariable(that.getLeftTerm(), that);
    }

    @Override
    public void visit(Tree.PostfixOperatorExpression that) {
        super.visit(that);
        this.checkVariable(that.getTerm(), that);
    }

    @Override
    public void visit(Tree.PrefixOperatorExpression that) {
        super.visit(that);
        this.checkVariable(that.getTerm(), that);
    }

    private void checkVariable(Tree.Term term, Node node) {
        Tree.StaticMemberOrTypeExpression mte;
        Declaration member;
        if (TreeUtil.isEffectivelyBaseMemberExpression(term) && (member = (mte = (Tree.StaticMemberOrTypeExpression)term).getDeclaration()) == this.declaration) {
            boolean isFormal = this.declaration.isFormal();
            boolean isDefault = this.declaration.isDefault();
            if ((isFormal || isDefault) && !this.isForwardReferenceable()) {
                term.addError("member may not be assigned here: " + this.name() + " is declared '" + (isFormal ? "formal" : "default") + "'");
            } else if (!(member instanceof Value)) {
                term.addError("not a variable value: " + this.name());
            } else if (node instanceof Tree.AssignOp) {
                if (!this.isVariable() && !this.isLate()) {
                    term.addError("value is already assigned: " + this.name() + " is neither 'variable' nor 'late'", 800);
                }
            } else if (!this.isVariable()) {
                term.addError("value may not be mutated: " + this.name() + " is not 'variable'", 800);
            }
        }
    }

    @Override
    public void visit(Tree.Block that) {
        Scope scope = that.getScope();
        if (scope instanceof Constructor) {
            if (this.definitelyInitedBy.contains(this.delegatedConstructor)) {
                this.definitely = true;
            }
            if (this.possiblyInitedBy.contains(this.delegatedConstructor)) {
                this.possibly = true;
            }
            this.delegatedConstructor = null;
        }
        boolean of = this.endsInBreak;
        boolean oe = this.endsInReturnThrow;
        Tree.Continue olc = this.lastContinue;
        Tree.Statement olcs = this.lastContinueStatement;
        boolean continueInSomeBranchOfCurrentConditional = this.lastContinue != null && this.lastContinueStatement == null;
        boolean blockEndsInReturnThrow = this.blockEndsInReturnThrow(that);
        boolean blockEndsInBreak = this.blockEndsInBreak(that);
        this.endsInBreak = this.endsInBreak || blockEndsInBreak;
        this.endsInReturnThrow = this.endsInReturnThrow || blockEndsInReturnThrow;
        Tree.Continue last = null;
        Tree.Statement lastStatement = null;
        for (Tree.Statement st : that.getStatements()) {
            ContinueVisitor cv = new ContinueVisitor(olc);
            st.visit(cv);
            if (cv.node != null) {
                last = cv.node;
                lastStatement = st;
            }
            if (!cv.found) continue;
            olc = null;
            olcs = null;
        }
        if (blockEndsInReturnThrow || blockEndsInBreak || continueInSomeBranchOfCurrentConditional) {
            this.lastContinue = last;
            this.lastContinueStatement = lastStatement;
        }
        super.visit(that);
        this.endsInBreak = of;
        this.endsInReturnThrow = oe;
        this.lastContinue = olc;
        this.lastContinueStatement = olcs;
        if (scope instanceof Constructor) {
            Constructor c = (Constructor)scope;
            if (this.definitely) {
                this.definitelyInitedBy.add(c);
            }
            if (this.possibly) {
                this.possiblyInitedBy.add(c);
            }
        }
        if (SpecificationVisitor.isNonPartialConstructor(scope) && this.declaration.getContainer() == scope.getContainer() && !this.definitely) {
            this.initedByEveryConstructor = false;
        }
    }

    @Override
    public void visit(Tree.DelegatedConstructor that) {
        boolean odc = this.inDelegatedContructor;
        this.inDelegatedContructor = true;
        super.visit(that);
        this.inDelegatedContructor = odc;
        Tree.SimpleType type = that.getType();
        if (type != null) {
            this.delegatedConstructor = type.getDeclarationModel();
            if (this.delegatedConstructor instanceof Class) {
                Class c = (Class)this.delegatedConstructor;
                this.delegatedConstructor = c.getDefaultConstructor();
            }
        }
    }

    private boolean blockEndsInBreak(Tree.Block that) {
        return this.blockEndsInReturnThrowBreak(that) && !this.blockEndsInReturnThrow(that);
    }

    private boolean blockEndsInReturnThrow(Tree.Block that) {
        if (that == null) {
            return false;
        }
        int size = that.getStatements().size();
        if (size > 0) {
            Tree.Statement s = that.getStatements().get(size - 1);
            if (s instanceof Tree.IfStatement) {
                Tree.IfStatement is = (Tree.IfStatement)s;
                Tree.IfClause ic = is.getIfClause();
                Tree.ElseClause ec = is.getElseClause();
                if (ic != null) {
                    Tree.ConditionList cl = ic.getConditionList();
                    if (cl != null) {
                        if (AnalyzerUtil.isAlwaysSatisfied(cl)) {
                            return this.blockEndsInReturnThrow(ic.getBlock());
                        }
                        if (ec != null && AnalyzerUtil.isNeverSatisfied(cl)) {
                            return this.blockEndsInReturnThrow(ec.getBlock());
                        }
                    }
                    if (ec != null) {
                        return this.blockEndsInReturnThrow(ic.getBlock()) && this.blockEndsInReturnThrow(ec.getBlock());
                    }
                }
            } else if (s instanceof Tree.SwitchStatement) {
                Tree.SwitchStatement ss = (Tree.SwitchStatement)s;
                Tree.SwitchCaseList scl = ss.getSwitchCaseList();
                for (Tree.CaseClause cc : scl.getCaseClauses()) {
                    if (this.blockEndsInReturnThrow(cc.getBlock())) continue;
                    return false;
                }
                Tree.ElseClause ec = scl.getElseClause();
                if (ec != null) {
                    return this.blockEndsInReturnThrow(ec.getBlock());
                }
            } else if (s instanceof Tree.ForStatement) {
                Tree.ForStatement fs = (Tree.ForStatement)s;
                Tree.ForClause fc = fs.getForClause();
                Tree.ElseClause ec = fs.getElseClause();
                if (fc != null) {
                    if (AnalyzerUtil.isAtLeastOne(fc)) {
                        return this.blockEndsInReturnThrow(fc.getBlock());
                    }
                    if (ec != null) {
                        return this.blockEndsInReturnThrow(fc.getBlock()) && this.blockEndsInReturnThrow(ec.getBlock());
                    }
                }
            }
            return s instanceof Tree.Return || s instanceof Tree.Throw;
        }
        return false;
    }

    private boolean blockEndsInReturnThrowBreak(Tree.Block that) {
        if (that == null) {
            return false;
        }
        int size = that.getStatements().size();
        if (size > 0) {
            Tree.Statement s = that.getStatements().get(size - 1);
            if (s instanceof Tree.IfStatement) {
                Tree.IfStatement is = (Tree.IfStatement)s;
                Tree.IfClause ic = is.getIfClause();
                Tree.ElseClause ec = is.getElseClause();
                if (ic != null) {
                    Tree.ConditionList cl = ic.getConditionList();
                    if (cl != null) {
                        if (AnalyzerUtil.isAlwaysSatisfied(cl)) {
                            return this.blockEndsInReturnThrowBreak(ic.getBlock());
                        }
                        if (ec != null && AnalyzerUtil.isNeverSatisfied(cl)) {
                            return this.blockEndsInReturnThrowBreak(ec.getBlock());
                        }
                    }
                    if (ec != null) {
                        return this.blockEndsInReturnThrowBreak(ic.getBlock()) && this.blockEndsInReturnThrowBreak(ec.getBlock());
                    }
                }
            } else if (s instanceof Tree.SwitchStatement) {
                Tree.SwitchStatement ss = (Tree.SwitchStatement)s;
                Tree.SwitchCaseList scl = ss.getSwitchCaseList();
                for (Tree.CaseClause cc : scl.getCaseClauses()) {
                    if (this.blockEndsInReturnThrowBreak(cc.getBlock())) continue;
                    return false;
                }
                Tree.ElseClause ec = scl.getElseClause();
                if (ec != null) {
                    return this.blockEndsInReturnThrowBreak(ec.getBlock());
                }
            } else if (s instanceof Tree.ForStatement) {
                Tree.ForStatement fs = (Tree.ForStatement)s;
                Tree.ForClause fc = fs.getForClause();
                Tree.ElseClause ec = fs.getElseClause();
                if (fc != null) {
                    if (AnalyzerUtil.isAtLeastOne(fc)) {
                        return this.blockEndsInReturnThrowBreak(fc.getBlock());
                    }
                    if (ec != null) {
                        return this.blockEndsInReturnThrowBreak(fc.getBlock()) && this.blockEndsInReturnThrowBreak(ec.getBlock());
                    }
                }
            }
            return s instanceof Tree.Return || s instanceof Tree.Throw || s instanceof Tree.Break;
        }
        return false;
    }

    @Override
    public void visit(Tree.ForClause that) {
        boolean of = this.endsInBreak;
        boolean oe = this.endsInReturnThrow;
        Tree.Continue olc = this.lastContinue;
        this.lastContinue = null;
        this.endsInBreak = false;
        this.endsInReturnThrow = false;
        super.visit(that);
        this.endsInBreak = of;
        this.endsInReturnThrow = oe;
        this.lastContinue = olc;
    }

    @Override
    public void visit(Tree.WhileClause that) {
        boolean of = this.endsInBreak;
        boolean oe = this.endsInReturnThrow;
        Tree.Continue olc = this.lastContinue;
        this.lastContinue = null;
        this.endsInBreak = false;
        this.endsInReturnThrow = false;
        super.visit(that);
        this.endsInBreak = of;
        this.endsInReturnThrow = oe;
        this.lastContinue = olc;
    }

    @Override
    public void visit(Tree.Body that) {
        if (this.hasParameter && that.getScope() == this.declaration.getContainer()) {
            this.hasParameter = false;
        }
        super.visit(that);
    }

    private static boolean isNonPartialConstructor(Scope scope) {
        if (scope instanceof Constructor) {
            Constructor constructor = (Constructor)scope;
            return !constructor.isAbstract();
        }
        return false;
    }

    private String longdesc() {
        if (this.declaration instanceof Value) {
            return "value is neither variable nor late and";
        }
        if (this.declaration instanceof Function) {
            return "function";
        }
        return "declaration";
    }

    private String shortdesc() {
        if (this.declaration instanceof Value) {
            return "value";
        }
        if (this.declaration instanceof Function) {
            return "function";
        }
        return "declaration";
    }

    @Override
    public void visit(Tree.SpecifierStatement that) {
        Tree.Term term = that.getBaseMemberExpression();
        boolean parameterized = false;
        while (term instanceof Tree.ParameterizedExpression) {
            Tree.ParameterizedExpression pe = (Tree.ParameterizedExpression)term;
            term = pe.getPrimary();
            parameterized = true;
        }
        if (term instanceof Tree.StaticMemberOrTypeExpression) {
            Tree.StaticMemberOrTypeExpression bme = (Tree.StaticMemberOrTypeExpression)term;
            Declaration member = bme.getDeclaration();
            if (member == this.declaration) {
                if (!this.isForwardReferenceable()) {
                    if (this.declaration.isFormal()) {
                        bme.addError("member is formal and may not be specified: " + this.name() + " is declared formal");
                    } else if (this.declaration.isDefault()) {
                        bme.addError("member is default and may not be specified except in its declaration: " + this.name() + " is declared default");
                    }
                }
                if (that.getRefinement()) {
                    this.declare();
                }
                Tree.SpecifierExpression se = that.getSpecifierExpression();
                boolean lazy = se instanceof Tree.LazySpecifierExpression;
                this.checkSpecifiedValue(se);
                if (!lazy || !parameterized) {
                    se.visit(this);
                }
                if (that.getRefinement()) {
                    this.specify();
                    term.visit(this);
                } else {
                    this.specification(that, bme);
                }
                if (lazy && parameterized) {
                    se.visit(this);
                }
                this.checkDeclarationSection(that);
            } else {
                super.visit(that);
            }
        } else {
            super.visit(that);
        }
    }

    private void checkSpecifiedValue(Tree.SpecifierExpression se) {
        if (this.declaration instanceof Value) {
            boolean lazy = se instanceof Tree.LazySpecifierExpression;
            Value value = (Value)this.declaration;
            if (!value.isVariable() && lazy != value.isTransient()) {
                se.addError("value must be specified using => lazy specifier: " + this.name());
            }
            if (lazy) {
                if (value.isVariable()) {
                    se.addError("variable value may not be specified using => lazy specifier: " + this.name());
                } else if (value.isLate()) {
                    se.addError("late reference may not be specified using => lazy specifier: " + this.name());
                }
            }
        }
    }

    private void specification(Tree.SpecifierStatement that, Tree.StaticMemberOrTypeExpression bme) {
        boolean constant = !this.isVariable() && !this.isLate();
        Scope scope = that.getScope();
        if (!constant || this.declaration.isDefinedInScope(scope) && (!(this.declaration instanceof FunctionOrValue) || !((FunctionOrValue)this.declaration).isShortcutRefinement())) {
            if (!this.declared && constant) {
                bme.addError(this.shortdesc() + " is not yet declared: " + this.name());
            } else if (!(this.loopDepth <= 0 || !constant || this.endsInReturnThrow && this.lastContinue == null || this.endsInBreak && this.allOuterLoopsBreak && this.lastContinue == null)) {
                if (this.definitely) {
                    bme.addError(this.longdesc() + " is aready definitely specified: " + this.name(), 803);
                } else {
                    bme.addError(this.longdesc() + " is not definitely unspecified in loop: " + this.name(), 803);
                    this.specify();
                }
            } else if (this.specificationDisabled && constant) {
                if (this.withinDeclaration) {
                    bme.addError("cannot specify " + this.shortdesc() + " from within its own body: " + this.name());
                } else {
                    bme.addError("cannot specify " + this.shortdesc() + " declared in outer scope: " + this.name(), 803);
                }
            } else if (this.possibly && constant) {
                if (this.definitely) {
                    bme.addError(this.longdesc() + " is aready definitely specified: " + this.name(), 803);
                } else {
                    bme.addError(this.longdesc() + " is not definitely unspecified: " + this.name(), 803);
                    this.specify();
                }
            } else {
                this.specify();
                bme.visit(this);
            }
        }
    }

    @Override
    public void visit(Tree.Declaration that) {
        boolean oe = this.endsInReturnThrow;
        boolean of = this.endsInBreak;
        Tree.Continue olc = this.lastContinue;
        this.lastContinue = null;
        this.endsInReturnThrow = false;
        this.endsInBreak = false;
        if (this.isSameDeclaration(that)) {
            this.loopDepth = 0;
            this.brokenLoopDepth = 0;
            this.specificationDisabled = true;
            this.withinDeclaration = true;
            this.declare();
            super.visit(that);
            this.withinDeclaration = false;
            this.specificationDisabled = false;
            this.loopDepth = 0;
            this.brokenLoopDepth = 0;
        } else {
            int l = this.loopDepth;
            int bl = this.brokenLoopDepth;
            this.loopDepth = 0;
            this.brokenLoopDepth = 0;
            Scope scope = that.getScope();
            boolean constructor = scope instanceof Constructor;
            boolean valueWithInitializer = scope instanceof Value && !((Value)scope).isTransient();
            boolean c = false;
            if (!constructor) {
                c = this.specificationDisabled;
                this.specificationDisabled = true;
            }
            boolean d = this.declared;
            if (valueWithInitializer) {
                super.visit(that);
            } else {
                boolean odefinitely = this.definitely;
                boolean opossibly = this.possibly;
                boolean opossiblyExited = this.possiblyExited;
                boolean odefinitelyExited = this.definitelyExited;
                boolean odefinitelyByLoopBreaks = this.definitelyByLoopBreaks;
                boolean opossiblyByLoopBreaks = this.possiblyByLoopBreaks;
                this.beginSpecificationScope();
                super.visit(that);
                this.definitely = odefinitely;
                this.possibly = opossibly;
                this.possiblyExited = opossiblyExited;
                this.definitelyExited = odefinitelyExited;
                this.definitelyByLoopBreaks = odefinitelyByLoopBreaks;
                this.possiblyByLoopBreaks = opossiblyByLoopBreaks;
            }
            this.declared = d;
            if (!constructor) {
                this.specificationDisabled = c;
            }
            this.loopDepth = l;
            this.brokenLoopDepth = bl;
        }
        this.endsInReturnThrow = oe;
        this.endsInBreak = of;
        this.lastContinue = olc;
    }

    private boolean isSameDeclaration(Tree.Declaration that) {
        Declaration dec = that.getDeclarationModel();
        if (dec instanceof Class && dec.isAbstraction()) {
            return dec == this.declaration || dec.getOverloads().contains(this.declaration);
        }
        return dec == this.declaration;
    }

    private boolean isSameDeclaration(Tree.TypedArgument that) {
        TypedDeclaration dec = that.getDeclarationModel();
        return dec == this.declaration;
    }

    @Override
    public void visit(Tree.Constructor that) {
        Function f = that.getDeclarationModel();
        Constructor c = that.getConstructor();
        if (f == this.declaration || c == this.declaration) {
            this.declare();
            this.specify();
        }
        super.visit(that);
        if (this.declaration.getContainer() == c.getContainer() && that == this.lastConstructor && this.initedByEveryConstructor) {
            this.definitely = true;
        }
    }

    @Override
    public void visit(Tree.Enumerated that) {
        Value v = that.getDeclarationModel();
        Constructor e = that.getEnumerated();
        if (v == this.declaration || e == this.declaration) {
            this.declare();
            this.specify();
        }
        super.visit(that);
        if (this.declaration.getContainer() == e.getContainer() && that == this.lastConstructor && this.initedByEveryConstructor) {
            this.definitely = true;
        }
    }

    @Override
    public void visit(Tree.TypedArgument that) {
        boolean oile = this.inLazyExpression;
        boolean bl = this.inLazyExpression = this.declared && (this.inExtends || this.inParameter);
        if (this.isSameDeclaration(that)) {
            this.loopDepth = 0;
            this.brokenLoopDepth = 0;
            this.specificationDisabled = true;
            this.withinDeclaration = true;
            super.visit(that);
            this.declare();
            this.withinDeclaration = false;
            this.specificationDisabled = false;
            this.loopDepth = 0;
            this.brokenLoopDepth = 0;
        } else {
            int l = this.loopDepth;
            int bl2 = this.brokenLoopDepth;
            this.loopDepth = 0;
            this.brokenLoopDepth = 0;
            boolean c = this.specificationDisabled;
            this.specificationDisabled = true;
            boolean d = this.declared;
            boolean odefinitely = this.definitely;
            boolean opossibly = this.possibly;
            boolean opossiblyExited = this.possiblyExited;
            boolean odefinitelyExited = this.definitelyExited;
            boolean odefinitelyByLoopBreaks = this.definitelyByLoopBreaks;
            boolean opossiblyByLoopBreaks = this.possiblyByLoopBreaks;
            this.beginSpecificationScope();
            super.visit(that);
            this.specificationDisabled = c;
            this.declared = d;
            this.definitely = odefinitely;
            this.possibly = opossibly;
            this.possiblyExited = opossiblyExited;
            this.definitelyExited = odefinitelyExited;
            this.definitelyByLoopBreaks = odefinitelyByLoopBreaks;
            this.possiblyByLoopBreaks = opossiblyByLoopBreaks;
            this.loopDepth = l;
            this.brokenLoopDepth = bl2;
        }
        this.inLazyExpression = oile;
    }

    @Override
    public void visit(Tree.MethodDeclaration that) {
        if (this.isSameDeclaration(that)) {
            if (that.getSpecifierExpression() != null) {
                this.specify();
                super.visit(that);
            } else {
                super.visit(that);
                if (this.declaration.isToplevel() && !ModelUtil.isNativeHeader(this.declaration) && !this.declaration.isJavaNative()) {
                    that.addError("toplevel function must be specified: " + this.name() + " may not be forward declared");
                } else if (this.declaration.isStatic() && !ModelUtil.isNativeHeader(this.declaration)) {
                    that.addError("static function must be specified: " + this.name() + " may not be forward declared");
                } else if (this.declaration.isClassMember() && !ModelUtil.isNativeHeader(this.declaration) && !this.declaration.isFormal() && !this.declaration.isJavaNative() && that.getDeclarationModel().getInitializerParameter() == null && this.declarationSection) {
                    that.addError("forward declaration may not occur in declaration section: " + this.name(), 1450);
                } else if (this.declaration.isInterfaceMember() && !ModelUtil.isNativeHeader(this.declaration) && !this.declaration.isFormal() && !this.declaration.isJavaNative()) {
                    that.addError("interface method must be formal or specified: " + this.name(), 1400);
                }
            }
        } else {
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.MethodDefinition that) {
        if (this.isSameDeclaration(that)) {
            this.declare();
            this.specify();
        }
        super.visit(that);
    }

    @Override
    public void visit(Tree.MethodArgument that) {
        if (this.isSameDeclaration(that)) {
            this.declare();
            this.specify();
        }
        super.visit(that);
    }

    @Override
    public void visit(Tree.Variable that) {
        super.visit(that);
        if (this.isSameDeclaration(that)) {
            this.specify();
        }
    }

    @Override
    public void visit(Tree.Parameter that) {
        Parameter p = that.getParameterModel();
        boolean oip = this.inParameter;
        this.inParameter = true;
        Parameter op = this.parameter;
        this.parameter = p;
        super.visit(that);
        this.parameter = op;
        this.inParameter = oip;
        if (p != null && p.getModel() == this.declaration) {
            this.specify();
        }
    }

    @Override
    public void visit(Tree.InitializerParameter that) {
        Declaration a;
        super.visit(that);
        Parameter p = that.getParameterModel();
        if (p != null && (a = that.getScope().getDirectMember(p.getName(), null, false)) != null && a == this.declaration) {
            this.specify();
            this.hasParameter = true;
        }
    }

    @Override
    public void visit(Tree.TypeParameterDeclaration that) {
        super.visit(that);
        if (this.isSameDeclaration(that)) {
            this.specify();
        }
    }

    @Override
    public void visit(Tree.AttributeDeclaration that) {
        if (this.isSameDeclaration(that)) {
            Tree.SpecifierOrInitializerExpression sie = that.getSpecifierOrInitializerExpression();
            if (sie != null) {
                super.visit(that);
                this.specify();
            } else {
                super.visit(that);
                if (this.declaration.isToplevel() && !ModelUtil.isNativeHeader(this.declaration) && !this.isLate() && !this.declaration.isJavaNative()) {
                    if (this.isVariable()) {
                        that.addError("toplevel variable value must be initialized: " + this.name());
                    } else {
                        that.addError("toplevel value must be specified: " + this.name());
                    }
                } else if (this.declaration.isStatic() && !ModelUtil.isNativeHeader(this.declaration) && !this.isLate()) {
                    if (this.isVariable()) {
                        that.addError("static variable value must be initialized: " + this.name());
                    } else {
                        that.addError("static value must be specified: " + this.name());
                    }
                } else if (this.declaration.isClassOrInterfaceMember() && !ModelUtil.isNativeHeader(this.declaration) && !this.declaration.isFormal() && !this.declaration.isJavaNative() && that.getDeclarationModel().getInitializerParameter() == null && !that.getDeclarationModel().isLate() && this.declarationSection) {
                    that.addError("forward declaration may not occur in declaration section: " + this.name(), 1450);
                }
            }
        } else {
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.AttributeGetterDefinition that) {
        if (this.isSameDeclaration(that)) {
            this.declare();
            super.visit(that);
            this.specify();
        } else {
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.AttributeSetterDefinition that) {
        Setter d = that.getDeclarationModel();
        if (d == this.declaration || d.getParameter().getModel() == this.declaration) {
            this.declare();
            this.specify();
        }
        super.visit(that);
    }

    @Override
    public void visit(Tree.AttributeArgument that) {
        if (this.isSameDeclaration(that)) {
            this.declare();
            this.specify();
        }
        super.visit(that);
    }

    @Override
    public void visit(Tree.ObjectDefinition that) {
        if (this.isSameDeclaration(that)) {
            this.declare();
            this.specify();
        }
        super.visit(that);
    }

    @Override
    public void visit(Tree.ObjectArgument that) {
        if (this.isSameDeclaration(that)) {
            this.declare();
            this.specify();
        }
        super.visit(that);
    }

    private Tree.Declaration getDeclaration(Tree.ClassBody that) {
        for (Tree.Statement s : that.getStatements()) {
            Tree.Declaration d;
            if (!(s instanceof Tree.Declaration) || (d = (Tree.Declaration)s).getDeclarationModel() != this.declaration) continue;
            return d;
        }
        return null;
    }

    @Override
    public void visit(Tree.InterfaceBody that) {
        if (that.getScope() == this.declaration.getContainer()) {
            Tree.Statement les = AnalyzerUtil.getLastStatic(that);
            this.declarationSection = les == null;
            this.lastExecutableStatement = les;
            super.visit(that);
            this.declarationSection = false;
            this.lastExecutableStatement = null;
        } else {
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.ClassBody that) {
        if (that.getScope() == this.declaration.getContainer()) {
            Tree.Statement les = AnalyzerUtil.getLastExecutableStatement(that);
            Tree.Declaration lc = AnalyzerUtil.getLastConstructor(that);
            this.declarationSection = les == null;
            this.lastExecutableStatement = les;
            this.lastConstructor = lc;
            new Visitor(){
                boolean declarationSection = false;

                @Override
                public void visit(Tree.ExecutableStatement that) {
                    super.visit(that);
                    if (that == SpecificationVisitor.this.lastExecutableStatement) {
                        this.declarationSection = true;
                    }
                }

                @Override
                public void visit(Tree.Declaration that) {
                    super.visit(that);
                    if (this.declarationSection && SpecificationVisitor.this.isSameDeclaration(that)) {
                        SpecificationVisitor.this.definedInDeclarationSection = true;
                    }
                    if (that == SpecificationVisitor.this.lastExecutableStatement) {
                        this.declarationSection = true;
                    }
                }

                @Override
                public void visit(Tree.StaticMemberOrTypeExpression that) {
                    super.visit(that);
                    if (this.declarationSection && SpecificationVisitor.this.declaration instanceof FunctionOrValue && that.getDeclaration() == SpecificationVisitor.this.declaration) {
                        SpecificationVisitor.this.usedInDeclarationSection = true;
                    }
                }
            }.visit(that);
            super.visit(that);
            this.declarationSection = false;
            this.lastExecutableStatement = null;
            this.lastConstructor = null;
            if (!this.declaration.isAnonymous() && this.isSharedDeclarationUninitialized()) {
                Node d = this.getDeclaration(that);
                if (d == null) {
                    d = that;
                }
                d.addError("must be definitely specified by class initializer: " + AnalyzerUtil.message(this.declaration) + (this.declaration.isShared() ? " is shared" : " is captured"), 1401);
            }
        } else {
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.Statement that) {
        if (!(that instanceof Tree.TypeParameterDeclaration) && !(that instanceof Tree.TypeConstraint)) {
            if (that instanceof Tree.Declaration) {
                Tree.Declaration dec = (Tree.Declaration)that;
                Declaration model = dec.getDeclarationModel();
                if (model.isStatic()) {
                    if (this.hasNonStatic && model == this.declaration) {
                        that.addError("static member must occur before all non-static members and initializer statements");
                    }
                } else {
                    this.hasNonStatic = true;
                }
            } else if (that instanceof Tree.ExecutableStatement) {
                this.hasNonStatic = true;
            }
        }
        boolean ohs = this.hasNonStatic;
        this.hasNonStatic = false;
        super.visit(that);
        this.hasNonStatic = ohs;
        this.checkDeclarationSection(that);
    }

    private void checkDeclarationSection(Tree.Statement that) {
        this.declarationSection = this.declarationSection || that == this.lastExecutableStatement;
    }

    @Override
    public void visit(Tree.ClassOrInterface that) {
        if (this.isSameDeclaration(that)) {
            this.declare();
            this.specify();
        }
        super.visit(that);
    }

    @Override
    public void visit(Tree.TypeAliasDeclaration that) {
        if (this.isSameDeclaration(that)) {
            this.declare();
            this.specify();
        }
        super.visit(that);
    }

    @Override
    public void visit(Tree.Return that) {
        super.visit(that);
        if (!this.specificationDisabled && this.isSharedDeclarationUninitialized()) {
            that.addError("must be definitely specified by class initializer: " + AnalyzerUtil.message(this.declaration) + (this.declaration.isShared() ? " is shared" : " is captured"));
        } else if (that.getDeclaration() == this.declaration.getContainer() && this.isCapturedDeclarationUninitialized()) {
            that.addError("must be definitely specified by class initializer: " + AnalyzerUtil.message(this.declaration) + (this.declaration.isShared() ? " is shared" : " is captured"));
        }
        this.exit();
    }

    private boolean isSharedDeclarationUninitialized() {
        return (this.declaration.isShared() || this.declaration.getOtherInstanceAccess()) && !this.declaration.isFormal() && !this.declaration.isJavaNative() && !ModelUtil.isNativeHeader(this.declaration) && !this.isLate() && !this.definitely;
    }

    private boolean isCapturedDeclarationUninitialized() {
        return (this.declaration.isShared() || this.declaration.getOtherInstanceAccess() || this.usedInDeclarationSection) && !this.definedInDeclarationSection && !this.declaration.isFormal() && !ModelUtil.isNativeHeader(this.declaration) && !this.isLate() && !this.definitely;
    }

    @Override
    public void visit(Tree.Throw that) {
        super.visit(that);
        this.exit();
    }

    @Override
    public void visit(Tree.Assertion that) {
        super.visit(that);
        if (AnalyzerUtil.isNeverSatisfied(that.getConditionList())) {
            this.exit();
        }
    }

    @Override
    public void visit(Tree.Break that) {
        super.visit(that);
        this.exit();
        if (!this.definitely) {
            this.definitelyByLoopBreaks = false;
        }
        if (this.possibly) {
            this.possiblyByLoopBreaks = true;
        }
    }

    @Override
    public void visit(Tree.Continue that) {
        super.visit(that);
        this.exit();
        if (this.lastContinue == that) {
            this.lastContinue = null;
        }
    }

    @Override
    public void visit(Tree.IfStatement that) {
        boolean possiblySpecifiedByExitsFromElseClause;
        boolean definitelySpecifiedByExitsFromElseClause;
        boolean possiblyExitedFromElseClause;
        boolean definitelyExitedFromElseClause;
        boolean possiblyAssignedByElseClause;
        boolean definitelyAssignedByElseClause;
        Tree.Block block;
        if (that == this.lastContinueStatement) {
            this.lastContinueStatement = null;
        }
        Tree.IfClause ifClause = that.getIfClause();
        Tree.ConditionList conditionList = ifClause.getConditionList();
        if (ifClause != null && conditionList != null) {
            conditionList.visit(this);
        }
        boolean d = this.declared;
        boolean odefinitely = this.definitely;
        boolean opossibly = this.possibly;
        boolean opossiblyExited = this.possiblyExited;
        boolean odefinitelyExited = this.definitelyExited;
        boolean odefinitelyByLoopBreaks = this.definitelyByLoopBreaks;
        boolean opossiblyByLoopBreaks = this.possiblyByLoopBreaks;
        this.beginSpecificationScope();
        if (ifClause != null && (block = ifClause.getBlock()) != null) {
            block.visit(this);
        }
        boolean definitelyAssignedByIfClause = this.definitely || this.definitelyExited;
        boolean possiblyAssignedByIfClause = this.possibly;
        boolean possiblyExitedFromIfClause = this.possiblyExited;
        boolean definitelyExitedFromIfClause = this.definitelyExited;
        boolean definitelySpecifiedByExitsFromIfClause = this.definitelyByLoopBreaks;
        boolean possiblySpecifiedByExitsFromIfClause = this.possiblyByLoopBreaks;
        this.declared = d;
        this.definitely = odefinitely;
        this.possibly = opossibly;
        this.possiblyExited = opossiblyExited;
        this.definitelyExited = odefinitelyExited;
        this.definitelyByLoopBreaks = odefinitelyByLoopBreaks;
        this.possiblyByLoopBreaks = opossiblyByLoopBreaks;
        Tree.ElseClause elseClause = that.getElseClause();
        if (elseClause != null) {
            d = this.declared;
            boolean pdefinitely = this.definitely;
            boolean ppossibly = this.possibly;
            boolean ppossiblyExited = this.possiblyExited;
            boolean pdefinitelyExited = this.definitelyExited;
            boolean pdefinitelyByLoopBreaks = this.definitelyByLoopBreaks;
            boolean ppossiblyByLoopBreaks = this.possiblyByLoopBreaks;
            this.beginSpecificationScope();
            elseClause.visit(this);
            definitelyAssignedByElseClause = this.definitely || this.definitelyExited;
            possiblyAssignedByElseClause = this.possibly;
            definitelyExitedFromElseClause = this.definitelyExited;
            possiblyExitedFromElseClause = this.possiblyExited;
            definitelySpecifiedByExitsFromElseClause = this.definitelyByLoopBreaks;
            possiblySpecifiedByExitsFromElseClause = this.possiblyByLoopBreaks;
            this.declared = d;
            this.definitely = pdefinitely;
            this.possibly = ppossibly;
            this.possiblyExited = ppossiblyExited;
            this.definitelyExited = pdefinitelyExited;
            this.definitelyByLoopBreaks = pdefinitelyByLoopBreaks;
            this.possiblyByLoopBreaks = ppossiblyByLoopBreaks;
        } else {
            definitelyAssignedByElseClause = false;
            possiblyAssignedByElseClause = false;
            definitelyExitedFromElseClause = false;
            possiblyExitedFromElseClause = false;
            definitelySpecifiedByExitsFromElseClause = true;
            possiblySpecifiedByExitsFromElseClause = false;
        }
        if (AnalyzerUtil.isAlwaysSatisfied(conditionList)) {
            this.definitely = this.definitely || definitelyAssignedByIfClause;
            this.possibly = this.possibly || possiblyAssignedByIfClause && !definitelyExitedFromIfClause;
            this.definitelyExited = this.definitelyExited || definitelyExitedFromIfClause;
            this.possiblyExited = this.possiblyExited || possiblyExitedFromIfClause;
            this.definitelyByLoopBreaks = this.definitelyByLoopBreaks && definitelySpecifiedByExitsFromIfClause;
            this.possiblyByLoopBreaks = this.possiblyByLoopBreaks || possiblySpecifiedByExitsFromIfClause;
        } else if (AnalyzerUtil.isNeverSatisfied(conditionList)) {
            this.definitely = this.definitely || definitelyAssignedByElseClause;
            this.possibly = this.possibly || possiblyAssignedByElseClause && !definitelyExitedFromElseClause;
            this.definitelyExited = this.definitelyExited || definitelyExitedFromElseClause;
            this.possiblyExited = this.possiblyExited || possiblyExitedFromElseClause;
            this.definitelyByLoopBreaks = this.definitelyByLoopBreaks && definitelySpecifiedByExitsFromElseClause;
            this.possiblyByLoopBreaks = this.possiblyByLoopBreaks || possiblySpecifiedByExitsFromElseClause;
        } else {
            this.definitely = this.definitely || definitelyAssignedByIfClause && definitelyAssignedByElseClause;
            this.possibly = this.possibly || possiblyAssignedByIfClause && !definitelyExitedFromIfClause || possiblyAssignedByElseClause && !definitelyExitedFromElseClause;
            this.definitelyExited = this.definitelyExited || definitelyExitedFromIfClause && definitelyExitedFromElseClause;
            this.possiblyExited = this.possiblyExited || possiblyExitedFromIfClause || possiblyExitedFromElseClause;
            this.definitelyByLoopBreaks = this.definitelyByLoopBreaks && definitelySpecifiedByExitsFromIfClause && definitelySpecifiedByExitsFromElseClause;
            this.possiblyByLoopBreaks = this.possiblyByLoopBreaks || possiblySpecifiedByExitsFromIfClause || possiblySpecifiedByExitsFromIfClause;
        }
        this.checkDeclarationSection(that);
    }

    @Override
    public void visit(Tree.TryCatchStatement that) {
        boolean possiblySpecifiedByExitsFromFinallyClause;
        boolean definitelySpecifiedByExitsFromFinallyClause;
        boolean possiblyExitedFromFinallyClause;
        boolean definitelyExitedFromFinallyClause;
        boolean possiblyAssignedByFinallyClause;
        boolean definitelyAssignedByFinallyClause;
        if (that == this.lastContinueStatement) {
            this.lastContinueStatement = null;
        }
        boolean d = this.declared;
        boolean odefinitely = this.definitely;
        boolean opossibly = this.possibly;
        boolean opossiblyExited = this.possiblyExited;
        boolean odefinitelyExited = this.definitelyExited;
        boolean odefinitelyByLoopBreaks = this.definitelyByLoopBreaks;
        boolean opossiblyByLoopBreaks = this.possiblyByLoopBreaks;
        this.beginSpecificationScope();
        Tree.TryClause tryClause = that.getTryClause();
        if (tryClause != null) {
            tryClause.visit(this);
        }
        boolean definitelyAssignedByTryClause = this.definitely || this.definitelyExited;
        boolean possiblyAssignedByTryClause = this.possibly;
        boolean possiblyExitedFromTryClause = this.possiblyExited;
        boolean definitelySpecifiedByExitsFromTryClause = this.definitelyByLoopBreaks;
        boolean possiblySpecifiedByExitsFromTryClause = this.possiblyByLoopBreaks;
        this.declared = d;
        this.definitely = odefinitely;
        this.possibly = opossibly;
        this.possiblyExited = opossiblyExited;
        this.definitelyExited = odefinitelyExited;
        this.definitelyByLoopBreaks = odefinitelyByLoopBreaks;
        this.possiblyByLoopBreaks = opossiblyByLoopBreaks;
        this.possibly = this.possibly || possiblyAssignedByTryClause;
        this.possiblyExited = this.possiblyExited || possiblyExitedFromTryClause;
        boolean definitelyAssignedByEveryCatchClause = true;
        boolean possiblyAssignedBySomeCatchClause = false;
        boolean definitelyExitedFromEveryCatchClause = true;
        boolean possiblyExitedFromSomeCatchClause = false;
        boolean specifiedByExitsFromEveryCatchClause = true;
        boolean specifiedByExitsFromSomeCatchClause = false;
        for (Tree.CatchClause cc : that.getCatchClauses()) {
            d = this.declared;
            boolean pdefinitely = this.definitely;
            boolean ppossibly = this.possibly;
            boolean ppossiblyExited = this.possiblyExited;
            boolean pdefinitelyExited = this.definitelyExited;
            boolean pdefinitelyByLoopBreaks = this.definitelyByLoopBreaks;
            boolean ppossiblyByLoopBreaks = this.possiblyByLoopBreaks;
            this.beginSpecificationScope();
            cc.visit(this);
            definitelyAssignedByEveryCatchClause = definitelyAssignedByEveryCatchClause && (this.definitely || this.definitelyExited);
            possiblyAssignedBySomeCatchClause = possiblyAssignedBySomeCatchClause || this.possibly;
            definitelyExitedFromEveryCatchClause = definitelyExitedFromEveryCatchClause && this.definitelyExited;
            possiblyExitedFromSomeCatchClause = possiblyExitedFromSomeCatchClause || this.possiblyExited;
            specifiedByExitsFromEveryCatchClause = specifiedByExitsFromEveryCatchClause && this.definitelyByLoopBreaks;
            specifiedByExitsFromSomeCatchClause = specifiedByExitsFromSomeCatchClause || this.possiblyByLoopBreaks;
            this.declared = d;
            this.definitely = pdefinitely;
            this.possibly = ppossibly;
            this.possiblyExited = ppossiblyExited;
            this.definitelyExited = pdefinitelyExited;
            this.definitelyByLoopBreaks = pdefinitelyByLoopBreaks;
            this.possiblyByLoopBreaks = ppossiblyByLoopBreaks;
        }
        this.possibly = this.possibly || possiblyAssignedBySomeCatchClause;
        this.possiblyExited = this.possiblyExited || possiblyExitedFromSomeCatchClause;
        Tree.FinallyClause finallyClause = that.getFinallyClause();
        if (finallyClause != null) {
            d = this.declared;
            boolean pdefinitely = this.definitely;
            boolean ppossibly = this.possibly;
            boolean ppossiblyExited = this.possiblyExited;
            boolean pdefinitelyExited = this.definitelyExited;
            boolean pdefinitelyByLoopBreaks = this.definitelyByLoopBreaks;
            boolean ppossiblyByLoopBreaks = this.possiblyByLoopBreaks;
            this.beginSpecificationScope();
            finallyClause.visit(this);
            definitelyAssignedByFinallyClause = this.definitely || this.definitelyExited;
            possiblyAssignedByFinallyClause = this.possibly;
            definitelyExitedFromFinallyClause = this.definitelyExited;
            possiblyExitedFromFinallyClause = this.possiblyExited;
            definitelySpecifiedByExitsFromFinallyClause = this.definitelyByLoopBreaks;
            possiblySpecifiedByExitsFromFinallyClause = this.possiblyByLoopBreaks;
            this.declared = d;
            this.definitely = pdefinitely;
            this.possibly = ppossibly;
            this.possiblyExited = ppossiblyExited;
            this.definitelyExited = pdefinitelyExited;
            this.definitelyByLoopBreaks = pdefinitelyByLoopBreaks;
            this.possiblyByLoopBreaks = ppossiblyByLoopBreaks;
        } else {
            definitelyAssignedByFinallyClause = false;
            possiblyAssignedByFinallyClause = false;
            definitelyExitedFromFinallyClause = false;
            possiblyExitedFromFinallyClause = false;
            definitelySpecifiedByExitsFromFinallyClause = true;
            possiblySpecifiedByExitsFromFinallyClause = false;
        }
        this.possibly = this.possibly || possiblyAssignedByFinallyClause;
        this.definitely = this.definitely || definitelyAssignedByFinallyClause || definitelyAssignedByTryClause && definitelyAssignedByEveryCatchClause;
        this.definitelyExited = this.definitelyExited && definitelyExitedFromFinallyClause;
        this.possiblyExited = this.possiblyExited || possiblyExitedFromFinallyClause;
        this.definitelyByLoopBreaks = this.definitelyByLoopBreaks || definitelySpecifiedByExitsFromFinallyClause || specifiedByExitsFromEveryCatchClause && definitelySpecifiedByExitsFromTryClause;
        this.possiblyByLoopBreaks = this.possiblyByLoopBreaks || possiblySpecifiedByExitsFromFinallyClause || specifiedByExitsFromSomeCatchClause || possiblySpecifiedByExitsFromTryClause;
        this.checkDeclarationSection(that);
    }

    @Override
    public void visit(Tree.SwitchStatement that) {
        Tree.SwitchClause switchClause;
        if (that == this.lastContinueStatement) {
            this.lastContinueStatement = null;
        }
        if ((switchClause = that.getSwitchClause()) != null) {
            switchClause.visit(this);
        }
        boolean definitelyAssignedByEveryCaseClause = true;
        boolean possiblyAssignedBySomeCaseClause = false;
        boolean definitelyExitedFromEveryCaseClause = false;
        boolean possiblyExitedFromSomeCaseClause = false;
        boolean specifiedByExitsFromEveryCaseClause = true;
        boolean specifiedByExitsFromSomeCaseClause = false;
        boolean possiblyAssignedAndNotDefinitelyExitedFromSomeCaseClause = false;
        Tree.SwitchCaseList switchCaseList = that.getSwitchCaseList();
        for (Tree.CaseClause cc : switchCaseList.getCaseClauses()) {
            boolean d = this.declared;
            boolean odefinitely = this.definitely;
            boolean opossibly = this.possibly;
            boolean opossiblyExited = this.possiblyExited;
            boolean odefinitelyExited = this.definitelyExited;
            boolean odefinitelyByLoopBreaks = this.definitelyByLoopBreaks;
            boolean opossiblyByLoopBreaks = this.possiblyByLoopBreaks;
            this.beginSpecificationScope();
            cc.visit(this);
            definitelyAssignedByEveryCaseClause = definitelyAssignedByEveryCaseClause && (this.definitely || this.definitelyExited);
            possiblyAssignedBySomeCaseClause = possiblyAssignedBySomeCaseClause || this.possibly;
            definitelyExitedFromEveryCaseClause = definitelyExitedFromEveryCaseClause && this.definitelyExited;
            possiblyExitedFromSomeCaseClause = possiblyExitedFromSomeCaseClause || this.possiblyExited;
            specifiedByExitsFromEveryCaseClause = specifiedByExitsFromEveryCaseClause && this.definitelyByLoopBreaks;
            specifiedByExitsFromSomeCaseClause = specifiedByExitsFromSomeCaseClause || this.possiblyByLoopBreaks;
            possiblyAssignedAndNotDefinitelyExitedFromSomeCaseClause = possiblyAssignedAndNotDefinitelyExitedFromSomeCaseClause || this.possibly && !this.definitelyExited;
            this.declared = d;
            this.definitely = odefinitely;
            this.possibly = opossibly;
            this.possiblyExited = opossiblyExited;
            this.definitelyExited = odefinitelyExited;
            this.definitelyByLoopBreaks = odefinitelyByLoopBreaks;
            this.possiblyByLoopBreaks = opossiblyByLoopBreaks;
        }
        Tree.ElseClause elseClause = switchCaseList.getElseClause();
        if (elseClause != null) {
            boolean d = this.declared;
            boolean odefinitely = this.definitely;
            boolean opossibly = this.possibly;
            boolean opossiblyExited = this.possiblyExited;
            boolean odefinitelyExited = this.definitelyExited;
            boolean odefinitelyByLoopBreaks = this.definitelyByLoopBreaks;
            boolean opossiblyByLoopBreaks = this.possiblyByLoopBreaks;
            this.beginSpecificationScope();
            elseClause.visit(this);
            definitelyAssignedByEveryCaseClause = definitelyAssignedByEveryCaseClause && (this.definitely || this.definitelyExited);
            possiblyAssignedBySomeCaseClause = possiblyAssignedBySomeCaseClause || this.possibly;
            definitelyExitedFromEveryCaseClause = definitelyExitedFromEveryCaseClause && this.definitelyExited;
            possiblyExitedFromSomeCaseClause = possiblyExitedFromSomeCaseClause || this.possiblyExited;
            specifiedByExitsFromEveryCaseClause = specifiedByExitsFromEveryCaseClause && this.definitelyByLoopBreaks;
            specifiedByExitsFromSomeCaseClause = specifiedByExitsFromSomeCaseClause || this.possiblyByLoopBreaks;
            possiblyAssignedAndNotDefinitelyExitedFromSomeCaseClause = possiblyAssignedAndNotDefinitelyExitedFromSomeCaseClause || this.possibly && !this.definitelyExited;
            this.declared = d;
            this.definitely = odefinitely;
            this.possibly = opossibly;
            this.possiblyExited = opossiblyExited;
            this.definitelyExited = odefinitelyExited;
            this.definitelyByLoopBreaks = odefinitelyByLoopBreaks;
            this.possiblyByLoopBreaks = opossiblyByLoopBreaks;
        }
        this.possibly = this.possibly || possiblyAssignedAndNotDefinitelyExitedFromSomeCaseClause;
        this.definitely = this.definitely || definitelyAssignedByEveryCaseClause;
        this.definitelyExited = this.definitelyExited && definitelyExitedFromEveryCaseClause;
        this.possiblyExited = this.possiblyExited || possiblyExitedFromSomeCaseClause;
        this.definitelyByLoopBreaks = this.definitelyByLoopBreaks && specifiedByExitsFromEveryCaseClause;
        this.possiblyByLoopBreaks = this.possiblyByLoopBreaks && specifiedByExitsFromSomeCaseClause;
        this.checkDeclarationSection(that);
    }

    @Override
    public void visit(Tree.WhileStatement that) {
        Tree.WhileClause whileClause = that.getWhileClause();
        Tree.ConditionList conditionList = whileClause.getConditionList();
        if (conditionList != null) {
            conditionList.visit(this);
        }
        boolean d = this.declared;
        boolean odefinitely = this.definitely;
        boolean opossibly = this.possibly;
        boolean opossiblyExited = this.possiblyExited;
        boolean odefinitelyExited = this.definitelyExited;
        boolean odefinitelyByLoopBreaks = this.definitelyByLoopBreaks;
        boolean opossiblyByLoopBreaks = this.possiblyByLoopBreaks;
        this.beginSpecificationScope();
        Tree.Block block = whileClause.getBlock();
        if (block != null) {
            if (this.isVariable() || this.isLate()) {
                block.visit(this);
            } else {
                boolean aolb = this.allOuterLoopsBreak;
                this.allOuterLoopsBreak = this.loopDepth == this.brokenLoopDepth;
                boolean broken = this.blockEndsInBreak(block);
                if (broken) {
                    ++this.brokenLoopDepth;
                }
                ++this.loopDepth;
                block.visit(this);
                if (broken) {
                    --this.brokenLoopDepth;
                }
                --this.loopDepth;
                this.allOuterLoopsBreak = aolb;
            }
        }
        boolean definitelyAssignedByWhileClause = this.definitely || this.definitelyExited;
        boolean possiblyAssignedByWhileClause = this.possibly;
        boolean definitelySpecifiedByLoopBreaks = this.definitelyByLoopBreaks;
        boolean possiblySpecifiedByLoopBreaks = this.possiblyByLoopBreaks;
        this.declared = d;
        this.definitely = odefinitely;
        this.possibly = opossibly;
        this.possiblyExited = opossiblyExited;
        this.definitelyExited = odefinitelyExited;
        this.definitelyByLoopBreaks = odefinitelyByLoopBreaks;
        this.possiblyByLoopBreaks = opossiblyByLoopBreaks;
        if (AnalyzerUtil.isAlwaysSatisfied(conditionList)) {
            this.definitely = this.definitely || definitelySpecifiedByLoopBreaks || definitelyAssignedByWhileClause;
            this.possibly = this.possibly || possiblyAssignedByWhileClause || possiblySpecifiedByLoopBreaks;
        } else if (!AnalyzerUtil.isNeverSatisfied(conditionList)) {
            this.possibly = this.possibly || possiblyAssignedByWhileClause || possiblySpecifiedByLoopBreaks;
        }
        this.checkDeclarationSection(that);
    }

    @Override
    public void visit(Tree.ForStatement that) {
        boolean definitelyExitedFromElseClause;
        boolean possiblyAssignedByElseClause;
        boolean definitelyAssignedByElseClause;
        boolean d = this.declared;
        boolean odefinitely = this.definitely;
        boolean opossibly = this.possibly;
        boolean opossiblyExited = this.possiblyExited;
        boolean odefinitelyExited = this.definitelyExited;
        boolean odefinitelyByLoopBreaks = this.definitelyByLoopBreaks;
        boolean opossiblyByLoopBreaks = this.possiblyByLoopBreaks;
        this.beginSpecificationScope();
        boolean atLeastOneIteration = false;
        Tree.ForClause forClause = that.getForClause();
        Tree.Block block = forClause.getBlock();
        if (block != null) {
            if (this.isVariable() || this.isLate()) {
                forClause.visit(this);
            } else {
                boolean aolb = this.allOuterLoopsBreak;
                this.allOuterLoopsBreak = this.loopDepth == this.brokenLoopDepth;
                boolean broken = this.blockEndsInBreak(block);
                if (broken) {
                    ++this.brokenLoopDepth;
                }
                ++this.loopDepth;
                forClause.visit(this);
                if (broken) {
                    --this.brokenLoopDepth;
                }
                --this.loopDepth;
                this.allOuterLoopsBreak = aolb;
            }
        }
        atLeastOneIteration = AnalyzerUtil.isAtLeastOne(forClause);
        boolean possiblyAssignedByForClause = this.possibly;
        boolean definitelyAssignedByForClause = this.definitely;
        boolean possiblyExitedFromForClause = this.possiblyExited;
        boolean definitelyExitedFromForClause = this.definitelyExited;
        boolean definitelySpecifiedByLoopBreaks = this.definitelyByLoopBreaks;
        boolean possiblySpecifiedByLoopBreaks = this.possiblyByLoopBreaks;
        this.declared = d;
        this.definitely = odefinitely;
        this.possibly = opossibly;
        this.possiblyExited = opossiblyExited;
        this.definitelyExited = odefinitelyExited;
        this.definitelyByLoopBreaks = odefinitelyByLoopBreaks;
        this.possiblyByLoopBreaks = opossiblyByLoopBreaks;
        Tree.ElseClause elseClause = that.getElseClause();
        if (elseClause != null) {
            d = this.declared;
            boolean pdefinitely = this.definitely;
            boolean ppossibly = this.possibly;
            boolean ppossiblyExited = this.possiblyExited;
            boolean pdefinitelyExited = this.definitelyExited;
            boolean pdefinitelyByLoopBreaks = this.definitelyByLoopBreaks;
            boolean ppossiblyByLoopBreaks = this.possiblyByLoopBreaks;
            this.beginSpecificationScope();
            elseClause.visit(this);
            definitelyAssignedByElseClause = this.definitely || this.definitelyExited;
            possiblyAssignedByElseClause = this.possibly;
            definitelyExitedFromElseClause = this.definitelyExited;
            this.declared = d;
            this.definitely = pdefinitely;
            this.possibly = ppossibly;
            this.possiblyExited = ppossiblyExited;
            this.definitelyExited = pdefinitelyExited;
            this.definitelyByLoopBreaks = pdefinitelyByLoopBreaks;
            this.possiblyByLoopBreaks = ppossiblyByLoopBreaks;
        } else {
            definitelyAssignedByElseClause = false;
            possiblyAssignedByElseClause = false;
            definitelyExitedFromElseClause = false;
        }
        this.definitely = this.definitely || !possiblyExitedFromForClause && definitelyAssignedByElseClause || atLeastOneIteration && definitelyAssignedByForClause && definitelySpecifiedByLoopBreaks || definitelyAssignedByElseClause && definitelySpecifiedByLoopBreaks;
        this.possibly = this.possibly || possiblyAssignedByForClause && !definitelyExitedFromForClause || possiblyAssignedByElseClause && !definitelyExitedFromElseClause || possiblySpecifiedByLoopBreaks;
        this.checkDeclarationSection(that);
    }

    private final class ContinueVisitor
    extends Visitor {
        Tree.Continue node;
        boolean found;
        Tree.Statement lastContinue;

        ContinueVisitor(Tree.Statement lastContinue) {
            this.lastContinue = lastContinue;
            this.node = null;
            this.found = false;
        }

        @Override
        public void visit(Tree.Declaration that) {
        }

        @Override
        public void visit(Tree.WhileStatement that) {
        }

        @Override
        public void visit(Tree.ForStatement that) {
        }

        @Override
        public void visit(Tree.Continue that) {
            this.node = that;
            if (that == this.lastContinue) {
                this.found = true;
            }
        }
    }
}

