/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.analyzer;

import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.compiler.typechecker.analyzer.AnalyzerUtil;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.TreeUtil;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.Cancellable;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassAlias;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.NothingType;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.SiteVariance;
import com.redhat.ceylon.model.typechecker.model.Specification;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeAlias;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.Unit;
import com.redhat.ceylon.model.typechecker.model.UnknownType;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.ArrayList;
import java.util.List;

public class TypeVisitor
extends Visitor {
    private Unit unit;
    private Cancellable cancellable;
    private boolean inDelegatedConstructor;
    private boolean inTypeLiteral;
    private boolean inExtendsOrClassAlias;

    public TypeVisitor(Cancellable cancellable) {
        this.cancellable = cancellable;
    }

    public TypeVisitor(Unit unit, Cancellable cancellable) {
        this.unit = unit;
        this.cancellable = cancellable;
    }

    @Override
    public void visit(Tree.CompilationUnit that) {
        this.unit = that.getUnit();
        super.visit(that);
    }

    @Override
    public void visit(Tree.GroupedType that) {
        super.visit(that);
        Tree.StaticType type = that.getType();
        if (type != null) {
            that.setTypeModel(type.getTypeModel());
        }
    }

    @Override
    public void visit(Tree.UnionType that) {
        super.visit(that);
        List<Tree.StaticType> sts = that.getStaticTypes();
        ArrayList<Type> types = new ArrayList<Type>(sts.size());
        for (Tree.StaticType st : sts) {
            Type t = st.getTypeModel();
            if (t == null) continue;
            types.add(t);
        }
        Type type = ModelUtil.union(types, this.unit);
        that.setTypeModel(type);
    }

    @Override
    public void visit(Tree.IntersectionType that) {
        super.visit(that);
        List<Tree.StaticType> sts = that.getStaticTypes();
        ArrayList<Type> types = new ArrayList<Type>(sts.size());
        for (Tree.StaticType st : sts) {
            Type t = st.getTypeModel();
            if (t == null) continue;
            types.add(t);
        }
        Type type = ModelUtil.intersection(types, this.unit);
        that.setTypeModel(type);
    }

    @Override
    public void visit(Tree.SequenceType that) {
        super.visit(that);
        Tree.StaticType elementType = that.getElementType();
        Tree.NaturalLiteral length = that.getLength();
        Type et = elementType.getTypeModel();
        if (et != null) {
            Type t;
            if (length == null) {
                t = this.unit.getSequentialType(et);
            } else {
                int len;
                try {
                    len = Integer.parseInt(length.getText());
                }
                catch (NumberFormatException nfe) {
                    length.addError("must be a positive decimal integer");
                    return;
                }
                if (len < 1) {
                    length.addError("must be positive");
                    return;
                }
                if (len > 1000) {
                    length.addError("may not be greater than 1000");
                    return;
                }
                Class td = this.unit.getTupleDeclaration();
                t = this.unit.getEmptyType();
                for (int i = 0; i < len; ++i) {
                    t = ModelUtil.appliedType((TypeDeclaration)td, et, et, t);
                }
            }
            that.setTypeModel(t);
        }
    }

    @Override
    public void visit(Tree.IterableType that) {
        super.visit(that);
        Tree.Type elem = that.getElementType();
        if (elem == null) {
            Type nt = this.unit.getNothingType();
            that.setTypeModel(this.unit.getIterableType(nt));
            that.addError("iterable type must have an element type");
        } else if (elem instanceof Tree.SequencedType) {
            Tree.SequencedType st = (Tree.SequencedType)elem;
            Type et = st.getType().getTypeModel();
            if (et != null) {
                Type t = st.getAtLeastOne() ? this.unit.getNonemptyIterableType(et) : this.unit.getIterableType(et);
                that.setTypeModel(t);
            }
        } else {
            that.addError("malformed iterable type");
        }
    }

    @Override
    public void visit(Tree.OptionalType that) {
        super.visit(that);
        ArrayList<Type> types = new ArrayList<Type>(2);
        types.add(this.unit.getNullType());
        Type dt = that.getDefiniteType().getTypeModel();
        if (dt != null) {
            types.add(dt);
        }
        that.setTypeModel(ModelUtil.union(types, this.unit));
    }

    @Override
    public void visit(Tree.EntryType that) {
        super.visit(that);
        Type kt = that.getKeyType().getTypeModel();
        Type vt = that.getValueType() == null ? new UnknownType(this.unit).getType() : that.getValueType().getTypeModel();
        that.setTypeModel(this.unit.getEntryType(kt, vt));
    }

    @Override
    public void visit(Tree.TypeConstructor that) {
        super.visit(that);
        TypeAlias ta = that.getDeclarationModel();
        ta.setExtendedType(that.getType().getTypeModel());
        Type type = ta.getType();
        type.setTypeConstructor(true);
        that.setTypeModel(type);
    }

    @Override
    public void visit(Tree.FunctionType that) {
        super.visit(that);
        Tree.StaticType rt = that.getReturnType();
        if (rt != null) {
            List<Tree.Type> argumentTypes = that.getArgumentTypes();
            Type tt = TypeVisitor.getTupleType(argumentTypes, this.unit);
            Interface cd = this.unit.getCallableDeclaration();
            Type pt = ModelUtil.appliedType((TypeDeclaration)cd, rt.getTypeModel(), tt);
            that.setTypeModel(pt);
        }
    }

    @Override
    public void visit(Tree.TupleType that) {
        super.visit(that);
        List<Tree.Type> elementTypes = that.getElementTypes();
        Type tt = TypeVisitor.getTupleType(elementTypes, this.unit);
        that.setTypeModel(tt);
    }

    static Type getTupleType(List<Tree.Type> ets, Unit unit) {
        ArrayList<Type> args = new ArrayList<Type>(ets.size());
        boolean sequenced = false;
        boolean atleastone = false;
        int firstDefaulted = -1;
        for (int i = 0; i < ets.size(); ++i) {
            Type arg;
            Tree.Type st = ets.get(i);
            Type type = arg = st == null ? null : st.getTypeModel();
            if (arg == null) {
                arg = new UnknownType(unit).getType();
            } else {
                if (st instanceof Tree.SpreadType) {
                    return st.getTypeModel();
                }
                if (st instanceof Tree.DefaultedType) {
                    if (firstDefaulted == -1) {
                        firstDefaulted = i;
                    }
                } else if (st instanceof Tree.SequencedType) {
                    if (i != ets.size() - 1) {
                        st.addError("variant element must occur last in a tuple type");
                    } else {
                        sequenced = true;
                        Tree.SequencedType sst = (Tree.SequencedType)st;
                        atleastone = sst.getAtLeastOne();
                        arg = sst.getType().getTypeModel();
                    }
                    if (firstDefaulted != -1 && atleastone) {
                        st.addError("nonempty variadic element must occur after defaulted elements in a tuple type");
                    }
                } else if (firstDefaulted != -1) {
                    st.addError("required element must occur after defaulted elements in a tuple type");
                }
            }
            args.add(arg);
        }
        return TypeVisitor.getTupleType(args, sequenced, atleastone, firstDefaulted, unit);
    }

    private static Type getTupleType(List<Type> elemTypes, boolean variadic, boolean atLeastOne, int firstDefaulted, Unit unit) {
        int last;
        Type emptyType;
        Class tupleDeclaration = unit.getTupleDeclaration();
        Type result = emptyType = unit.getEmptyType();
        Type union = unit.getNothingType();
        for (int i = last = elemTypes.size() - 1; i >= 0; --i) {
            Type elemType = elemTypes.get(i);
            union = TypeVisitor.addToUncanonicalizedUnion(unit, union, elemType);
            if (variadic && i == last) {
                result = atLeastOne ? unit.getSequenceType(elemType) : unit.getSequentialType(elemType);
                continue;
            }
            result = ModelUtil.appliedType((TypeDeclaration)tupleDeclaration, union, elemType, result);
            if (firstDefaulted < 0 || i < firstDefaulted) continue;
            result = TypeVisitor.addToUncanonicalizedUnion(unit, result, emptyType);
        }
        return result;
    }

    private static Type addToUncanonicalizedUnion(Unit unit, Type union, Type type) {
        if (union.isNothing() || type.isAnything()) {
            return type;
        }
        if (union.isAnything() || type.isNothing()) {
            return union;
        }
        ArrayList<Type> pair = new ArrayList<Type>();
        pair.add(type);
        pair.add(union);
        return ModelUtil.union(pair, unit);
    }

    @Override
    public void visit(Tree.BaseType that) {
        super.visit(that);
        Tree.Identifier id = that.getIdentifier();
        if (id != null) {
            String name = TreeUtil.name(id);
            Scope scope = that.getScope();
            TypeDeclaration type = that.getPackageQualified() ? AnalyzerUtil.getPackageTypeDeclaration(name, null, false, this.unit) : AnalyzerUtil.getTypeDeclaration(scope, name, null, false, this.unit);
            if (type == null) {
                if (!ModelUtil.isNativeForWrongBackend(scope, this.unit)) {
                    that.addError("type is not defined: '" + name + "'" + AnalyzerUtil.correctionMessage(name, scope, this.unit, this.cancellable), 102);
                    this.unit.setUnresolvedReferences();
                }
            } else {
                type = (TypeDeclaration)this.handleNativeHeader(type, that);
                Type outerType = scope.getDeclaringType(type);
                this.visitSimpleType(that, outerType, type);
            }
        }
    }

    @Override
    public void visit(Tree.SuperType that) {
        Scope scope = that.getScope();
        ClassOrInterface ci = ModelUtil.getContainingClassOrInterface(scope);
        if (ci != null) {
            if (scope instanceof Constructor) {
                that.setTypeModel(ModelUtil.intersectionOfSupertypes(ci));
            } else if (ci.isClassOrInterfaceMember()) {
                ClassOrInterface oci = (ClassOrInterface)ci.getContainer();
                that.setTypeModel(ModelUtil.intersectionOfSupertypes(oci));
            } else {
                that.addError("super appears in extends for non-member class");
            }
        }
    }

    @Override
    public void visit(Tree.MemberLiteral that) {
        Tree.TypeArgumentList tal;
        Type pt;
        super.visit(that);
        if (that.getType() != null && (pt = that.getType().getTypeModel()) != null && (tal = that.getTypeArgumentList()) != null && ModelUtil.isTypeUnknown(pt) && !pt.isUnknown()) {
            tal.addError("qualifying type does not fully-specify type arguments");
        }
    }

    @Override
    public void visit(Tree.QualifiedType that) {
        boolean onl = this.inTypeLiteral;
        boolean oiea = this.inExtendsOrClassAlias;
        boolean oidc = this.inDelegatedConstructor;
        this.inTypeLiteral = false;
        this.inExtendsOrClassAlias = false;
        this.inDelegatedConstructor = false;
        super.visit(that);
        this.inExtendsOrClassAlias = oiea;
        this.inDelegatedConstructor = oidc;
        this.inTypeLiteral = onl;
        Tree.StaticType ot = that.getOuterType();
        Type pt = ot.getTypeModel();
        if (pt != null) {
            Tree.TypeArgumentList tal = that.getTypeArgumentList();
            if (that.getMetamodel() && tal != null && ModelUtil.isTypeUnknown(pt) && !pt.isUnknown()) {
                tal.addError("qualifying type does not fully-specify type arguments");
            }
            TypeDeclaration d = pt.getDeclaration();
            Tree.Identifier id = that.getIdentifier();
            if (id != null) {
                Scope scope;
                String name = TreeUtil.name(id);
                TypeDeclaration type = AnalyzerUtil.getTypeMember(d, name, null, false, this.unit, scope = that.getScope());
                if (type == null) {
                    if (!ModelUtil.isNativeForWrongBackend(scope, this.unit)) {
                        if (d.isMemberAmbiguous(name, this.unit, null, false)) {
                            that.addError("member type declaration is ambiguous: '" + name + "' for type '" + d.getName() + "'");
                        } else {
                            that.addError("member type is not defined: '" + name + "' in type '" + d.getName() + "'" + AnalyzerUtil.memberCorrectionMessage(name, d, null, this.unit, this.cancellable), 100);
                            this.unit.setUnresolvedReferences();
                        }
                    }
                } else {
                    this.visitSimpleType(that, pt, type);
                    if (type.isStatic()) {
                        ot.setStaticTypePrimary(true);
                    }
                }
            }
        }
    }

    @Override
    public void visit(Tree.TypeLiteral that) {
        this.inTypeLiteral = true;
        super.visit(that);
        this.inTypeLiteral = false;
    }

    private void visitSimpleType(Tree.SimpleType that, Type ot, TypeDeclaration dec) {
        Type pt;
        block8: {
            List<Type> typeArgs;
            List<TypeParameter> params;
            Tree.TypeArgumentList tal;
            block7: {
                boolean functionTypeConstructor;
                if (dec instanceof Constructor && !this.inTypeLiteral && !this.inExtendsOrClassAlias && !this.inDelegatedConstructor) {
                    that.addError("constructor is not a type: '" + dec.getName(this.unit) + "' is a constructor");
                }
                if ((tal = that.getTypeArgumentList()) != null) {
                    dec = AnalyzerUtil.unwrapAliasedTypeConstructor(dec);
                }
                params = dec.getTypeParameters();
                typeArgs = AnalyzerUtil.getTypeArguments(tal, ot, params);
                pt = dec.appliedType(ot, typeArgs);
                if (tal != null) break block7;
                if (params.isEmpty()) break block8;
                Interface cd = this.unit.getCallableDeclaration();
                boolean bl = functionTypeConstructor = dec.isAlias() ? dec.inherits(cd) : dec.equals(cd);
                if (!functionTypeConstructor) break block8;
                pt.setTypeConstructor(true);
                break block8;
            }
            if (params.isEmpty()) {
                that.addError("type declaration does not accept type arguments: '" + dec.getName(this.unit) + "' is not a generic type");
            }
            tal.setTypeModels(typeArgs);
            List<Tree.Type> args = tal.getTypes();
            for (int i = 0; i < args.size() && i < params.size(); ++i) {
                Tree.StaticType st;
                Tree.TypeVariance variance;
                Tree.Type t = args.get(i);
                if (!(t instanceof Tree.StaticType) || (variance = (st = (Tree.StaticType)t).getTypeVariance()) == null) continue;
                TypeParameter p = params.get(i);
                String var = variance.getText();
                if (var.equals("out")) {
                    pt.setVariance(p, SiteVariance.OUT);
                } else if (var.equals("in")) {
                    pt.setVariance(p, SiteVariance.IN);
                }
                if (p.isInvariant()) continue;
                variance.addUnsupportedError("use-site variant instantiation of declaration-site variant types is not supported: type parameter '" + p.getName() + "' of '" + dec.getName(this.unit) + "' is declared " + (p.isCovariant() ? "covariant" : "contravariant") + " (remove the '" + var + "')");
            }
        }
        that.setTypeModel(pt);
        that.setDeclarationModel(dec);
    }

    @Override
    public void visit(Tree.VoidModifier that) {
        Class vtd = this.unit.getAnythingDeclaration();
        if (vtd != null) {
            that.setTypeModel(vtd.getType());
        }
    }

    @Override
    public void visit(Tree.SequencedType that) {
        super.visit(that);
        Type type = that.getType().getTypeModel();
        if (type != null) {
            Type et = that.getAtLeastOne() ? this.unit.getSequenceType(type) : this.unit.getSequentialType(type);
            that.setTypeModel(et);
        }
    }

    @Override
    public void visit(Tree.DefaultedType that) {
        super.visit(that);
        Type type = that.getType().getTypeModel();
        if (type != null) {
            that.setTypeModel(type);
        }
    }

    @Override
    public void visit(Tree.SpreadType that) {
        Type type;
        super.visit(that);
        Tree.Type t = that.getType();
        if (t != null && (type = t.getTypeModel()) != null) {
            that.setTypeModel(type);
        }
    }

    @Override
    public void visit(Tree.TypedDeclaration that) {
        super.visit(that);
        Tree.Type type = that.getType();
        TypedDeclaration dec = that.getDeclarationModel();
        this.setType(that, type, dec);
        if (dec instanceof FunctionOrValue) {
            FunctionOrValue mv = (FunctionOrValue)dec;
            if (dec.isLate() && mv.isParameter()) {
                that.addError("parameter may not be annotated late");
            }
        }
    }

    @Override
    public void visit(Tree.TypedArgument that) {
        super.visit(that);
        this.setType(that, that.getType(), that.getDeclarationModel());
    }

    private void setType(Node that, Tree.Type type, TypedDeclaration td) {
        Type t;
        if (type == null) {
            that.addError("missing type of declaration: '" + td.getName() + "'");
        } else if (!(type instanceof Tree.LocalModifier) && (t = type.getTypeModel()) != null) {
            td.setType(t);
        }
    }

    @Override
    public void visit(Tree.ObjectDefinition that) {
        Class o = that.getAnonymousClass();
        o.setExtendedType(this.unit.getBasicType());
        o.getSatisfiedTypes().clear();
        super.visit(that);
        Type type = o.getType();
        that.getDeclarationModel().setType(type);
        that.getType().setTypeModel(type);
    }

    @Override
    public void visit(Tree.ObjectArgument that) {
        Class o = that.getAnonymousClass();
        o.setExtendedType(this.unit.getBasicType());
        o.getSatisfiedTypes().clear();
        super.visit(that);
        Type type = o.getType();
        that.getDeclarationModel().setType(type);
        that.getType().setTypeModel(type);
    }

    @Override
    public void visit(Tree.ObjectExpression that) {
        Class o = that.getAnonymousClass();
        o.setExtendedType(this.unit.getBasicType());
        o.getSatisfiedTypes().clear();
        super.visit(that);
    }

    @Override
    public void visit(Tree.ClassDefinition that) {
        Class cd = that.getDeclarationModel();
        if (!AnalyzerUtil.isVeryAbstractClass(that, this.unit)) {
            cd.setExtendedType(this.unit.getBasicType());
        } else {
            cd.setExtendedType(null);
        }
        cd.getSatisfiedTypes().clear();
        super.visit(that);
        Tree.ParameterList pl = that.getParameterList();
        if (pl != null) {
            if (cd.hasConstructors()) {
                pl.addError("class with parameters may not declare constructors: class '" + cd.getName() + "' has a parameter list and a constructor", 1002);
            } else if (cd.hasEnumerated()) {
                pl.addError("class with parameters may not declare constructors: class '" + cd.getName() + "' has a parameter list and a value constructor", 1003);
            } else if (cd.hasStaticMembers()) {
                pl.addError("class with parameters may not declare static members: class '" + cd.getName() + "' has a parameter list and a static member", 1003);
            }
        } else if (!cd.hasConstructors() && !cd.hasEnumerated()) {
            Class hcd;
            Declaration hdr;
            boolean error = true;
            if (cd.isNativeImplementation() && (hdr = ModelUtil.getNativeHeader(cd)) instanceof Class && ((hcd = (Class)hdr).hasConstructors() || hcd.hasEnumerated())) {
                error = false;
            }
            if (error) {
                that.addError("class must have a parameter list or at least one constructor: class '" + cd.getName() + "' has neither parameter list nor constructor", 1001);
            }
        }
    }

    @Override
    public void visit(Tree.InterfaceDefinition that) {
        Interface id = that.getDeclarationModel();
        id.setExtendedType(null);
        id.getSatisfiedTypes().clear();
        Class od = this.unit.getObjectDeclaration();
        if (od != null) {
            id.setExtendedType(od.getType());
        }
        super.visit(that);
    }

    @Override
    public void visit(Tree.TypeParameterDeclaration that) {
        Tree.StaticType type;
        TypeParameter p = that.getDeclarationModel();
        p.setExtendedType(null);
        p.getSatisfiedTypes().clear();
        Class vd = this.unit.getAnythingDeclaration();
        if (vd != null) {
            p.setExtendedType(vd.getType());
        }
        super.visit(that);
        Tree.TypeSpecifier ts = that.getTypeSpecifier();
        if (ts != null && (type = ts.getType()) != null) {
            Type dta = type.getTypeModel();
            Declaration dec = p.getDeclaration();
            if (dta != null && dta.involvesDeclaration(dec)) {
                type.addError("default type argument involves parameterized type: '" + dta.asString(this.unit) + "' involves '" + dec.getName(this.unit) + "'");
                dta = null;
            }
            p.setDefaultTypeArgument(dta);
        }
    }

    @Override
    public void visit(Tree.TypeParameterList that) {
        super.visit(that);
        List<Tree.TypeParameterDeclaration> tpds = that.getTypeParameterDeclarations();
        ArrayList<TypeParameter> params = new ArrayList<TypeParameter>(tpds.size());
        for (int i = tpds.size() - 1; i >= 0; --i) {
            TypeParameter tp;
            Type dta;
            Tree.TypeParameterDeclaration tpd = tpds.get(i);
            if (tpd == null || (dta = (tp = tpd.getDeclarationModel()).getDefaultTypeArgument()) == null) continue;
            params.add(tp);
            if (!dta.involvesTypeParameters(params)) continue;
            tpd.getTypeSpecifier().addError("default type argument involves a type parameter not yet declared");
        }
    }

    @Override
    public void visit(Tree.ClassDeclaration that) {
        ClassAlias td = (ClassAlias)that.getDeclarationModel();
        td.setExtendedType(null);
        super.visit(that);
        Tree.ClassSpecifier cs = that.getClassSpecifier();
        if (cs == null) {
            that.addError("missing class body or aliased class reference");
        } else {
            Tree.SimpleType ct;
            Tree.CaseTypes cts;
            Tree.SatisfiedTypes sts;
            Tree.ExtendedType et = that.getExtendedType();
            if (et != null) {
                et.addError("class alias may not extend a type");
            }
            if ((sts = that.getSatisfiedTypes()) != null) {
                sts.addError("class alias may not satisfy a type");
            }
            if ((cts = that.getCaseTypes()) != null) {
                that.addError("class alias may not have cases or a self type");
            }
            if ((ct = cs.getType()) != null) {
                if (!(ct instanceof Tree.StaticType)) {
                    ct.addError("aliased type must be a class");
                } else {
                    Type type = ct.getTypeModel();
                    if (type != null && !type.isUnknown()) {
                        TypeDeclaration dec = type.getDeclaration();
                        td.setConstructor(dec);
                        if (dec instanceof Constructor) {
                            if (dec.isValueConstructor()) {
                                ct.addError("aliases a value constructor");
                            } else if (dec.isAbstract()) {
                                ct.addError("aliases a partial constructor: '" + dec.getName(this.unit) + "' is declared abstract");
                            }
                            if (td.isShared() && !dec.isShared()) {
                                ct.addError("shared alias of an unshared constructor: '" + dec.getName(this.unit) + "' is not shared");
                            }
                            type = type.getExtendedType();
                            dec = dec.getExtendedType().getDeclaration();
                        }
                        if (dec instanceof Class) {
                            td.setExtendedType(type);
                        } else {
                            ct.addError("not a class: '" + dec.getName(this.unit) + "'");
                        }
                        TypeDeclaration etd = ct.getDeclarationModel();
                        if (etd == td) {
                            ct.addError("directly aliases itself: '" + td.getName() + "'");
                        }
                    }
                }
            }
        }
    }

    @Override
    public void visit(Tree.InterfaceDeclaration that) {
        Interface id = that.getDeclarationModel();
        id.setExtendedType(null);
        super.visit(that);
        Tree.TypeSpecifier typeSpecifier = that.getTypeSpecifier();
        if (typeSpecifier == null) {
            if (!id.isNative()) {
                that.addError("missing interface body or aliased interface reference");
            }
        } else {
            Tree.StaticType et;
            Tree.CaseTypes cts;
            Tree.SatisfiedTypes sts = that.getSatisfiedTypes();
            if (sts != null) {
                sts.addError("interface alias may not satisfy a type");
            }
            if ((cts = that.getCaseTypes()) != null) {
                that.addError("class alias may not have cases or a self type");
            }
            if ((et = typeSpecifier.getType()) != null) {
                if (!(et instanceof Tree.StaticType)) {
                    typeSpecifier.addError("aliased type must be an interface");
                } else {
                    Type type = et.getTypeModel();
                    if (type != null && !type.isUnknown()) {
                        TypeDeclaration dec = type.getDeclaration();
                        if (dec instanceof Interface) {
                            id.setExtendedType(type);
                        } else {
                            et.addError("not an interface: '" + dec.getName(this.unit) + "'");
                        }
                    }
                }
            }
        }
    }

    @Override
    public void visit(Tree.TypeAliasDeclaration that) {
        TypeAlias ta = that.getDeclarationModel();
        ta.setExtendedType(null);
        super.visit(that);
        Tree.TypeSpecifier typeSpecifier = that.getTypeSpecifier();
        if (typeSpecifier == null) {
            that.addError("missing aliased type");
        } else {
            Tree.StaticType et = typeSpecifier.getType();
            if (et == null) {
                that.addError("malformed aliased type");
            } else {
                Type type = et.getTypeModel();
                if (type != null) {
                    AnalyzerUtil.setTypeConstructor(et, null);
                    ta.setExtendedType(type);
                }
            }
        }
    }

    private boolean isInitializerParameter(FunctionOrValue dec) {
        return dec != null && dec.isParameter() && dec.getInitializerParameter().isHidden();
    }

    @Override
    public void visit(Tree.MethodDeclaration that) {
        super.visit(that);
        Tree.SpecifierExpression sie = that.getSpecifierExpression();
        Function dec = that.getDeclarationModel();
        if (this.isInitializerParameter(dec) && sie != null) {
            sie.addError("function is an initializer parameter and may not have an initial value: '" + dec.getName() + "'");
        }
        if (sie == null && ModelUtil.isNativeImplementation(dec)) {
            that.addError("missing body for native function: '" + dec.getName() + "' must have a body");
        }
    }

    @Override
    public void visit(Tree.MethodDefinition that) {
        super.visit(that);
        Function dec = that.getDeclarationModel();
        if (this.isInitializerParameter(dec)) {
            that.getBlock().addError("function is an initializer parameter and may not have a body: '" + dec.getName() + "'");
        }
    }

    @Override
    public void visit(Tree.AttributeDeclaration that) {
        super.visit(that);
        Tree.SpecifierOrInitializerExpression sie = that.getSpecifierOrInitializerExpression();
        Value dec = that.getDeclarationModel();
        if (this.isInitializerParameter(dec)) {
            Parameter param = dec.getInitializerParameter();
            Tree.Type type = that.getType();
            if (type instanceof Tree.SequencedType) {
                param.setSequenced(true);
                Tree.SequencedType st = (Tree.SequencedType)type;
                param.setAtLeastOne(st.getAtLeastOne());
            }
            if (sie != null) {
                sie.addError("value is an initializer parameter and may not have an initial value: '" + dec.getName() + "'");
            }
        }
        if (sie == null && ModelUtil.isNativeImplementation(dec)) {
            that.addError("missing body for native value: '" + dec.getName() + "' must have a body");
        }
    }

    @Override
    public void visit(Tree.AttributeGetterDefinition that) {
        super.visit(that);
        Value dec = that.getDeclarationModel();
        if (this.isInitializerParameter(dec)) {
            that.getBlock().addError("value is an initializer parameter and may not have a body: '" + dec.getName() + "'");
        }
    }

    void checkExtendedTypeExpression(Tree.Type type) {
        TypeDeclaration otd;
        Tree.QualifiedType qualifiedType;
        Tree.StaticType outerType;
        if (type instanceof Tree.QualifiedType && !((outerType = (qualifiedType = (Tree.QualifiedType)type).getOuterType()) instanceof Tree.SuperType) && (otd = qualifiedType.getDeclarationModel()) != null) {
            if (otd.isStatic() || otd instanceof Constructor) {
                this.checkExtendedTypeExpression(outerType);
            } else {
                outerType.addError("illegal qualifier in constructor delegation (must be super)");
            }
        }
    }

    private static void inheritedType(Tree.StaticType st) {
        if (st instanceof Tree.SimpleType) {
            ((Tree.SimpleType)st).setInherited(true);
            if (st instanceof Tree.QualifiedType) {
                TypeVisitor.inheritedType(((Tree.QualifiedType)st).getOuterType());
            }
        }
    }

    @Override
    public void visit(Tree.DelegatedConstructor that) {
        this.inDelegatedConstructor = true;
        super.visit(that);
        this.inDelegatedConstructor = false;
        this.checkExtendedTypeExpression(that.getType());
        TypeVisitor.inheritedType(that.getType());
    }

    @Override
    public void visit(Tree.ClassSpecifier that) {
        this.inExtendsOrClassAlias = true;
        super.visit(that);
        this.inExtendsOrClassAlias = false;
        this.checkExtendedTypeExpression(that.getType());
        TypeVisitor.inheritedType(that.getType());
    }

    @Override
    public void visit(Tree.ExtendedType that) {
        TypeDeclaration etd;
        Type type;
        Tree.SimpleType et;
        this.inExtendsOrClassAlias = that.getInvocationExpression() != null;
        super.visit(that);
        this.inExtendsOrClassAlias = false;
        TypeVisitor.inheritedType(that.getType());
        this.checkExtendedTypeExpression(that.getType());
        TypeDeclaration td = (TypeDeclaration)that.getScope();
        if (!td.isAlias() && (et = that.getType()) != null && (type = et.getTypeModel()) != null && (etd = et.getDeclarationModel()) != null && !(etd instanceof UnknownType)) {
            if (etd instanceof Constructor) {
                type = type.getExtendedType();
                etd = etd.getExtendedType().getDeclaration();
            }
            if (etd != td) {
                if (etd instanceof TypeParameter) {
                    et.addError("directly extends a type parameter: '" + type.getDeclaration().getName(this.unit) + "'");
                } else if (etd instanceof Interface) {
                    et.addError("extends an interface: '" + type.getDeclaration().getName(this.unit) + "'");
                } else if (etd instanceof TypeAlias) {
                    et.addError("extends a type alias: '" + type.getDeclaration().getName(this.unit) + "'");
                } else if (etd instanceof NothingType) {
                    et.addError("extends the bottom type 'Nothing'");
                } else {
                    td.setExtendedType(type);
                }
            }
        }
    }

    @Override
    public void visit(Tree.SatisfiedTypes that) {
        super.visit(that);
        TypeDeclaration td = (TypeDeclaration)that.getScope();
        if (td.isAlias()) {
            return;
        }
        List<Tree.StaticType> types = that.getTypes();
        ArrayList<Type> list = new ArrayList<Type>(types.size());
        if (types.isEmpty()) {
            that.addError("missing types in satisfies");
        }
        boolean foundTypeParam = false;
        boolean foundClass = false;
        boolean foundInterface = false;
        for (Tree.StaticType st : types) {
            TypeDeclaration std;
            TypeVisitor.inheritedType(st);
            Type type = st.getTypeModel();
            if (type == null || (std = type.getDeclaration()) == null || std instanceof UnknownType || std == td) continue;
            if (std instanceof NothingType) {
                st.addError("satisfies the bottom type 'Nothing'");
                continue;
            }
            if (std instanceof TypeAlias) {
                st.addError("satisfies a type alias: '" + type.getDeclaration().getName(this.unit) + "'");
                continue;
            }
            if (std instanceof Constructor) continue;
            if (td instanceof TypeParameter) {
                if (foundTypeParam) {
                    st.addUnsupportedError("type parameter upper bounds are not yet supported in combination with other bounds");
                    continue;
                }
                if (std instanceof TypeParameter) {
                    if (foundClass || foundInterface) {
                        st.addUnsupportedError("type parameter upper bounds are not yet supported in combination with other bounds");
                    }
                    foundTypeParam = true;
                    list.add(type);
                    continue;
                }
                if (std instanceof Class) {
                    if (foundClass) {
                        st.addUnsupportedError("multiple class upper bounds are not yet supported");
                    }
                    foundClass = true;
                    list.add(type);
                    continue;
                }
                if (std instanceof Interface) {
                    foundInterface = true;
                    list.add(type);
                    continue;
                }
                st.addError("upper bound must be a class, interface, or type parameter");
                continue;
            }
            if (std instanceof TypeParameter) {
                st.addError("directly satisfies type parameter: '" + std.getName(this.unit) + "'");
                continue;
            }
            if (std instanceof Class) {
                st.addError("satisfies a class: '" + std.getName(this.unit) + "'");
                continue;
            }
            if (std instanceof Interface) {
                if (td.isDynamic() && !std.isDynamic()) {
                    st.addError("dynamic interface satisfies a non-dynamic interface: '" + std.getName(this.unit) + "'");
                    continue;
                }
                list.add(type);
                continue;
            }
            st.addError("satisfied type must be an interface");
        }
        td.setSatisfiedTypes(list);
    }

    @Override
    public void visit(Tree.CaseTypes that) {
        super.visit(that);
        TypeDeclaration td = (TypeDeclaration)that.getScope();
        List<Tree.StaticMemberOrTypeExpression> bmes = that.getBaseMemberExpressions();
        List<Tree.StaticType> cts = that.getTypes();
        ArrayList<TypedDeclaration> caseValues = new ArrayList<TypedDeclaration>(bmes.size());
        ArrayList<Type> caseTypes = new ArrayList<Type>(bmes.size() + cts.size());
        if (td instanceof TypeParameter) {
            if (!bmes.isEmpty()) {
                that.addError("cases of type parameter must be a types");
            }
        } else {
            for (Tree.StaticMemberOrTypeExpression bme : bmes) {
                String name = TreeUtil.name(bme.getIdentifier());
                TypedDeclaration od = bme instanceof Tree.BaseMemberExpression ? AnalyzerUtil.getTypedDeclaration(bme.getScope(), name, null, false, this.unit) : AnalyzerUtil.getPackageTypedDeclaration(name, null, false, this.unit);
                if (od == null) continue;
                caseValues.add(od);
                Type type = od.getType();
                if (type == null) continue;
                caseTypes.add(type);
            }
        }
        for (Tree.StaticType ct : cts) {
            TypeVisitor.inheritedType(ct);
            Type type = ct.getTypeModel();
            if (ModelUtil.isTypeUnknown(type)) continue;
            if (type.isUnion() || type.isIntersection() || type.isNothing()) {
                if (td instanceof TypeParameter) {
                    ct.addError("enumerated bound must be a class or interface type");
                    continue;
                }
                ct.addError("case type must be a class, interface, or self type");
                continue;
            }
            TypeDeclaration ctd = type.getDeclaration();
            if (ctd.equals(td)) {
                ct.addError("directly enumerates itself: '" + td.getName() + "'");
                continue;
            }
            if (type.isClassOrInterface()) {
                caseTypes.add(type);
                continue;
            }
            if (type.isTypeParameter()) {
                if (td instanceof TypeParameter) {
                    caseTypes.add(type);
                    continue;
                }
                TypeParameter tp = (TypeParameter)ctd;
                td.setSelfType(type);
                if (tp.isSelfType()) {
                    ct.addError("type parameter may not act as self type for two different types");
                } else {
                    tp.setSelfTypedDeclaration(td);
                    caseTypes.add(type);
                }
                if (cts.size() <= 1) continue;
                ct.addError("a type may not have more than one self type");
                continue;
            }
            if (td instanceof TypeParameter) {
                ct.addError("enumerated bound must be a class or interface type");
                continue;
            }
            ct.addError("case type must be a class, interface, or self type");
        }
        if (!caseTypes.isEmpty()) {
            Class c;
            ClassOrInterface ci;
            TypeDeclaration first = ((Type)caseTypes.get(0)).getDeclaration();
            if (caseTypes.size() == 1 && first.isSelfType()) {
                ClassOrInterface ci2;
                Scope scope = first.getContainer();
                if (scope instanceof ClassOrInterface && !(ci2 = (ClassOrInterface)scope).isAbstract()) {
                    Tree.StaticType ct = cts.get(0);
                    if (ci2.equals(td)) {
                        ct.addError("concrete class parameterized by self type: '" + ci2.getName() + "' is not abstract but has the self type '" + first.getName() + "' (make '" + ci2.getName() + "' abstract)", 905);
                    } else {
                        ct.addError("concrete class parameterized by self type: '" + ci2.getName() + "' is not abstract but declares the self type '" + first.getName() + "' of '" + td.getName() + "' (make '" + ci2.getName() + "' abstract)", 905);
                    }
                }
            } else if (td instanceof ClassOrInterface && !(ci = (ClassOrInterface)td).isAbstract() && !(c = (Class)ci).hasEnumerated()) {
                that.addError("concrete class has enumerated subtypes: enumerated class '" + ci.getName() + "' is not abstract" + " (make '" + ci.getName() + "' abstract)", 905);
            }
            td.setCaseTypes(caseTypes);
            td.setCaseValues(caseValues);
        }
    }

    @Override
    public void visit(Tree.InitializerParameter that) {
        super.visit(that);
        Parameter p = that.getParameterModel();
        String name = p.getName();
        Declaration a = that.getScope().getDirectMember(name, null, false);
        if (a != null) {
            if (!this.isLegalParameter(a)) {
                that.addError("parameter is not a reference value or function: '" + name + "' is not a value or function");
            } else {
                FunctionOrValue mov;
                if (a.isFormal()) {
                    that.addError("parameter is a formal attribute: '" + name + "' is annotated 'formal'", 320);
                }
                if ((mov = (FunctionOrValue)a).getInitializerParameter() != null) {
                    that.addError("duplicate parameter: '" + name + "' already occurs in the parameter list");
                } else {
                    mov.setInitializerParameter(p);
                    p.setModel(mov);
                }
            }
        }
        if (p.isDefaulted()) {
            this.checkDefaultArg(that.getSpecifierExpression(), p);
        }
    }

    public boolean isLegalParameter(Declaration a) {
        if (a instanceof Value) {
            Value v = (Value)a;
            if (v.isTransient()) {
                return false;
            }
            TypeDeclaration td = v.getTypeDeclaration();
            return td == null || !td.isObjectClass();
        }
        return a instanceof Function;
    }

    @Override
    public void visit(Tree.AnyAttribute that) {
        super.visit(that);
        Tree.Type type = that.getType();
        if (type instanceof Tree.SequencedType) {
            Value v = (Value)that.getDeclarationModel();
            Parameter p = v.getInitializerParameter();
            if (p == null) {
                type.addError("value is not a parameter, so may not be variadic: '" + v.getName() + "'");
            } else {
                p.setSequenced(true);
            }
        }
    }

    @Override
    public void visit(Tree.AnyMethod that) {
        super.visit(that);
        Tree.Type type = that.getType();
        if (type instanceof Tree.SequencedType) {
            type.addError("function type may not be variadic");
        }
    }

    @Override
    public void visit(Tree.QualifiedMemberOrTypeExpression that) {
        Tree.Primary primary = that.getPrimary();
        if (primary instanceof Tree.MemberOrTypeExpression) {
            Tree.MemberOrTypeExpression mte = (Tree.MemberOrTypeExpression)primary;
            if (mte instanceof Tree.BaseTypeExpression || mte instanceof Tree.QualifiedTypeExpression) {
                that.setStaticMethodReference(true);
                mte.setStaticMethodReferencePrimary(true);
                if (that.getDirectlyInvoked()) {
                    mte.setDirectlyInvoked(true);
                }
            }
            if (that.getIndirectlyInvoked()) {
                mte.setIndirectlyInvoked(true);
            }
        }
        if (primary instanceof Tree.Package) {
            Tree.Package pack = (Tree.Package)primary;
            pack.setQualifier(true);
        }
        super.visit(that);
    }

    @Override
    public void visit(Tree.InvocationExpression that) {
        Tree.Term primary = TreeUtil.unwrapExpressionUntilTerm(that.getPrimary());
        if (primary instanceof Tree.MemberOrTypeExpression) {
            Tree.MemberOrTypeExpression mte = (Tree.MemberOrTypeExpression)primary;
            mte.setDirectlyInvoked(true);
            mte.setIndirectlyInvoked(true);
        }
        super.visit(that);
    }

    private static Tree.SpecifierOrInitializerExpression getSpecifier(Tree.ParameterDeclaration that) {
        Tree.TypedDeclaration dec = that.getTypedDeclaration();
        if (dec instanceof Tree.AttributeDeclaration) {
            Tree.AttributeDeclaration ad = (Tree.AttributeDeclaration)dec;
            return ad.getSpecifierOrInitializerExpression();
        }
        if (dec instanceof Tree.MethodDeclaration) {
            Tree.MethodDeclaration md = (Tree.MethodDeclaration)dec;
            return md.getSpecifierExpression();
        }
        return null;
    }

    private void checkDefaultArg(Tree.SpecifierOrInitializerExpression se, Parameter p) {
        if (se != null) {
            if (se.getScope().getContainer() instanceof Specification) {
                se.addError("parameter of specification statement may not define default value");
            } else {
                Declaration d = p.getDeclaration();
                if (d.isActual()) {
                    se.addError("parameter of actual declaration may not define default value: parameter '" + p.getName() + "' of '" + p.getDeclaration().getName() + "'");
                }
            }
        }
    }

    @Override
    public void visit(Tree.ParameterDeclaration that) {
        super.visit(that);
        Parameter p = that.getParameterModel();
        if (p.isDefaulted()) {
            if (p.getDeclaration().isParameter()) {
                TypeVisitor.getSpecifier(that).addError("parameter of callable parameter may not have default argument");
            }
            this.checkDefaultArg(TypeVisitor.getSpecifier(that), p);
        }
    }

    private Declaration handleNativeHeader(Declaration hdr, Node that) {
        if (hdr.isNativeHeader()) {
            Backends inBackends;
            Scope scope = that.getScope();
            if (scope == hdr) {
                scope = scope.getScope();
            }
            Backends backends = (inBackends = scope.getScopedBackends()).none() ? this.unit.getSupportedBackends() : inBackends;
            Declaration impl2 = ModelUtil.getNativeDeclaration(hdr, backends);
            return inBackends == null || impl2 == null ? hdr : impl2;
        }
        return hdr;
    }
}

