/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.analyzer;

import com.redhat.ceylon.compiler.typechecker.analyzer.AnalyzerUtil;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Element;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.ModuleImport;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeAlias;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class VisibilityVisitor
extends Visitor {
    private List<Module> modules = new ArrayList<Module>(1);

    private String exportHint() {
        StringBuilder hint = new StringBuilder(" (mark module import");
        if (this.modules.size() > 1) {
            hint.append("s");
        }
        hint.append(" 'shared' for ");
        boolean first = true;
        for (Module m : this.modules) {
            if (first) {
                first = false;
            } else {
                hint.append(", ");
            }
            hint.append("'").append(m.getNameAsString()).append("'");
        }
        hint.append(")");
        this.modules.clear();
        return hint.toString();
    }

    @Override
    public void visit(Tree.TypedDeclaration that) {
        this.checkVisibility(that, that.getDeclarationModel());
        super.visit(that);
    }

    @Override
    public void visit(Tree.TypedArgument that) {
        this.checkVisibility(that, that.getDeclarationModel());
        super.visit(that);
    }

    @Override
    public void visit(Tree.AnyClass that) {
        super.visit(that);
        this.checkParameterVisibility(that.getDeclarationModel(), that.getParameterList());
    }

    @Override
    public void visit(Tree.AnyMethod that) {
        super.visit(that);
        this.checkParameterVisibility(that.getDeclarationModel(), that.getParameterLists());
    }

    @Override
    public void visit(Tree.Constructor that) {
        super.visit(that);
        this.checkParameterVisibility((Declaration)that.getDeclarationModel(), that.getParameterList());
    }

    @Override
    public void visit(Tree.MethodArgument that) {
        super.visit(that);
        this.checkParameterVisibility(that.getDeclarationModel(), that.getParameterLists());
    }

    @Override
    public void visit(Tree.FunctionArgument that) {
        super.visit(that);
        Function m = that.getDeclarationModel();
        this.checkVisibility(that, m);
        this.checkParameterVisibility(m, that.getParameterLists());
    }

    private void checkParameterVisibility(Function m, List<Tree.ParameterList> parameterLists) {
        for (Tree.ParameterList list : parameterLists) {
            this.checkParameterVisibility((Declaration)m, list);
        }
    }

    private void checkParameterVisibility(Declaration m, Tree.ParameterList list) {
        if (list != null) {
            for (Tree.Parameter tp : list.getParameters()) {
                Parameter p;
                if (tp == null || (p = tp.getParameterModel()) == null) continue;
                this.checkParameterVisibility(tp, m, p);
            }
        }
    }

    @Override
    public void visit(Tree.TypeDeclaration that) {
        this.validateSupertypes(that, that.getDeclarationModel());
        super.visit(that);
    }

    @Override
    public void visit(Tree.ObjectDefinition that) {
        this.validateSupertypes(that, that.getAnonymousClass());
        super.visit(that);
    }

    @Override
    public void visit(Tree.ObjectArgument that) {
        this.validateSupertypes(that, that.getAnonymousClass());
        super.visit(that);
    }

    @Override
    public void visit(Tree.ObjectExpression that) {
        this.validateSupertypes(that, that.getAnonymousClass());
        super.visit(that);
    }

    private void validateSupertypes(Node that, TypeDeclaration td) {
        block5: {
            block4: {
                if (!(td instanceof TypeAlias)) break block4;
                Type at = td.getExtendedType();
                if (at == null) break block5;
                if (!ModelUtil.isCompletelyVisible(td, at)) {
                    that.addError("aliased type is not visible everywhere type alias '" + td.getName() + "' is visible: '" + at.asString(that.getUnit()) + "' involves an unshared type declaration", 713);
                }
                if (VisibilityVisitor.checkModuleVisibility(td, at, this.modules)) break block5;
                that.addError("aliased type of type alias '" + td.getName() + "' that is visible outside this module comes from an imported module that is not re-exported: '" + at.asString(that.getUnit()) + "' involves an unexported type declaration" + this.exportHint(), 714);
                break block5;
            }
            List<Type> supertypes = td.getType().getSupertypes();
            if (!td.isInconsistentType()) {
                for (Type st : supertypes) {
                    if (!(that instanceof Tree.Declaration) || st.getDeclaration().equals(td)) continue;
                    if (!ModelUtil.isCompletelyVisible(td, st)) {
                        that.addError("supertype is not visible everywhere type '" + td.getName() + "' is visible: '" + st.asString(that.getUnit()) + "' involves an unshared or restricted type declaration", 713);
                    }
                    if (VisibilityVisitor.checkModuleVisibility(td, st, this.modules)) continue;
                    that.addError("supertype of type '" + td.getName() + "' that is visible outside this module comes from an imported module that is not re-exported: '" + st.asString(that.getUnit()) + "' involves an unexported type declaration" + this.exportHint(), 714);
                }
            }
        }
    }

    private static boolean checkModuleVisibility(Declaration member, Type pt, List<Module> modules) {
        Module declarationModule;
        if (VisibilityVisitor.inExportedScope(member) && (declarationModule = VisibilityVisitor.getModule(member)) != null) {
            return VisibilityVisitor.isCompletelyVisibleFromOtherModules(member, pt, declarationModule, modules);
        }
        return true;
    }

    private static boolean inExportedScope(Declaration decl) {
        if (decl.getVisibleScope() != null) {
            return false;
        }
        Package p = decl.getUnit().getPackage();
        return p != null && p.isShared();
    }

    static boolean isCompletelyVisibleFromOtherModules(Declaration member, Type pt, Module thisModule, List<Module> modules) {
        if (pt.isUnion()) {
            for (Type ct : pt.getCaseTypes()) {
                if (VisibilityVisitor.isCompletelyVisibleFromOtherModules(member, ct.substitute(pt), thisModule, modules)) continue;
                return false;
            }
            return true;
        }
        if (pt.isIntersection()) {
            for (Type st : pt.getSatisfiedTypes()) {
                if (VisibilityVisitor.isCompletelyVisibleFromOtherModules(member, st.substitute(pt), thisModule, modules)) continue;
                return false;
            }
            return true;
        }
        if (!VisibilityVisitor.isVisibleFromOtherModules(member, thisModule, pt.getDeclaration(), modules)) {
            return false;
        }
        for (Type at : pt.getTypeArgumentList()) {
            if (at == null || VisibilityVisitor.isCompletelyVisibleFromOtherModules(member, at, thisModule, modules)) continue;
            return false;
        }
        return true;
    }

    private static String getName(Declaration td) {
        if (td.isAnonymous()) {
            return "anonymous function";
        }
        return "'" + td.getName() + "'";
    }

    private void checkVisibility(Node that, TypedDeclaration td) {
        Type type = td.getType();
        if (type != null) {
            Node typeNode = AnalyzerUtil.getTypeErrorNode(that);
            if (!ModelUtil.isCompletelyVisible(td, type)) {
                typeNode.addError("type of declaration " + VisibilityVisitor.getName(td) + " is not visible everywhere declaration is visible: '" + type.asString(that.getUnit()) + "' involves an unshared type declaration", 711);
            }
            if (!VisibilityVisitor.checkModuleVisibility(td, type, this.modules)) {
                typeNode.addError("type of declaration " + VisibilityVisitor.getName(td) + " that is visible outside this module comes from an imported module that is not re-exported: '" + type.asString(that.getUnit()) + "' involves an unexported type declaration" + this.exportHint(), 712);
            }
        }
    }

    private void checkParameterVisibility(Tree.Parameter tp, Declaration td, Parameter p) {
        Type pt;
        if (p.getModel() != null && (pt = p.getType()) != null) {
            if (!ModelUtil.isCompletelyVisible(td, pt)) {
                AnalyzerUtil.getParameterTypeErrorNode(tp).addError("type of parameter '" + p.getName() + "' of " + VisibilityVisitor.getName(td) + " is not visible everywhere declaration is visible: '" + pt.asString(tp.getUnit()) + "' involves an unshared type declaration", 710);
            }
            if (!VisibilityVisitor.checkModuleVisibility(td, pt, this.modules)) {
                AnalyzerUtil.getParameterTypeErrorNode(tp).addError("type of parameter '" + p.getName() + "' of " + VisibilityVisitor.getName(td) + " that is visible outside this module comes from an imported module that is not re-exported: '" + pt.asString(tp.getUnit()) + "' involves an unexported type declaration" + this.exportHint(), 714);
            }
        }
    }

    private static boolean isVisibleFromOtherModules(Declaration member, Module thisModule, TypeDeclaration type, List<Module> modules) {
        if (type instanceof TypeParameter) {
            return true;
        }
        Module typeModule = VisibilityVisitor.getModule(type);
        if (typeModule != null && thisModule != null && !thisModule.equals(typeModule)) {
            if (typeModule.isLanguageModule()) {
                return true;
            }
            for (ModuleImport imp : thisModule.getImports()) {
                if (!imp.isExport() || !imp.getModule().equals(typeModule)) continue;
                return true;
            }
            HashSet<Module> visited = new HashSet<Module>();
            visited.add(thisModule);
            for (ModuleImport imp : thisModule.getImports()) {
                if (!imp.isExport() || !VisibilityVisitor.includedImplicitly(imp.getModule(), typeModule, visited)) continue;
                return true;
            }
            modules.add(typeModule);
            return false;
        }
        return true;
    }

    private static boolean includedImplicitly(Module importedModule, Module targetModule, Set<Module> visited) {
        if (visited.add(importedModule)) {
            for (ModuleImport imp : importedModule.getImports()) {
                if (!imp.isExport() || !imp.getModule().equals(targetModule) && !VisibilityVisitor.includedImplicitly(imp.getModule(), targetModule, visited)) continue;
                return true;
            }
        }
        return false;
    }

    private static Module getModule(Element element) {
        Package typePackage = element.getUnit().getPackage();
        return typePackage != null ? typePackage.getModule() : null;
    }
}

