/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.context;

import com.redhat.ceylon.compiler.typechecker.analyzer.AliasVisitor;
import com.redhat.ceylon.compiler.typechecker.analyzer.AnnotationVisitor;
import com.redhat.ceylon.compiler.typechecker.analyzer.ControlFlowVisitor;
import com.redhat.ceylon.compiler.typechecker.analyzer.DeclarationVisitor;
import com.redhat.ceylon.compiler.typechecker.analyzer.DefaultTypeArgVisitor;
import com.redhat.ceylon.compiler.typechecker.analyzer.ExpressionVisitor;
import com.redhat.ceylon.compiler.typechecker.analyzer.ImportVisitor;
import com.redhat.ceylon.compiler.typechecker.analyzer.InheritanceVisitor;
import com.redhat.ceylon.compiler.typechecker.analyzer.LiteralVisitor;
import com.redhat.ceylon.compiler.typechecker.analyzer.LocalDeclarationVisitor;
import com.redhat.ceylon.compiler.typechecker.analyzer.ModuleSourceMapper;
import com.redhat.ceylon.compiler.typechecker.analyzer.ModuleVisitor;
import com.redhat.ceylon.compiler.typechecker.analyzer.RefinementVisitor;
import com.redhat.ceylon.compiler.typechecker.analyzer.SelfReferenceVisitor;
import com.redhat.ceylon.compiler.typechecker.analyzer.SpecificationVisitor;
import com.redhat.ceylon.compiler.typechecker.analyzer.SupertypeVisitor;
import com.redhat.ceylon.compiler.typechecker.analyzer.TypeArgumentVisitor;
import com.redhat.ceylon.compiler.typechecker.analyzer.TypeHierarchyVisitor;
import com.redhat.ceylon.compiler.typechecker.analyzer.TypeVisitor;
import com.redhat.ceylon.compiler.typechecker.analyzer.VisibilityVisitor;
import com.redhat.ceylon.compiler.typechecker.analyzer.Warning;
import com.redhat.ceylon.compiler.typechecker.context.Context;
import com.redhat.ceylon.compiler.typechecker.context.TypecheckerUnit;
import com.redhat.ceylon.compiler.typechecker.io.VirtualFile;
import com.redhat.ceylon.compiler.typechecker.io.impl.Helper;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.TreeUtil;
import com.redhat.ceylon.compiler.typechecker.tree.Validator;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.compiler.typechecker.util.AssertionVisitor;
import com.redhat.ceylon.compiler.typechecker.util.DeprecationVisitor;
import com.redhat.ceylon.compiler.typechecker.util.PrintVisitor;
import com.redhat.ceylon.compiler.typechecker.util.ReferenceCounter;
import com.redhat.ceylon.compiler.typechecker.util.StatisticsVisitor;
import com.redhat.ceylon.compiler.typechecker.util.UsageVisitor;
import com.redhat.ceylon.model.typechecker.context.TypeCache;
import com.redhat.ceylon.model.typechecker.model.Cancellable;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.Unit;
import com.redhat.ceylon.model.typechecker.util.ModuleManager;
import java.lang.ref.WeakReference;
import java.util.EnumSet;
import java.util.List;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;

public class PhasedUnit
implements Visitor.ExceptionHandler {
    private Tree.CompilationUnit rootNode;
    private Package pkg;
    private TypecheckerUnit unit;
    private String fileName;
    private WeakReference<ModuleManager> moduleManagerRef;
    private WeakReference<ModuleSourceMapper> moduleSourceMapperRef;
    private final String pathRelativeToSrcDir;
    private VirtualFile unitFile;
    private List<? extends Token> tokens;
    private ModuleVisitor moduleVisitor;
    private Tree.ModuleDescriptor moduleDescriptor;
    private VirtualFile srcDir;
    private boolean treeValidated = false;
    private boolean declarationsScanned = false;
    private boolean scanningDeclarations = false;
    private boolean typeDeclarationsScanned = false;
    private boolean refinementValidated = false;
    private boolean flowAnalyzed = false;
    private boolean fullyTyped = false;
    private boolean usageAnalyzed = false;
    private boolean literalsProcessed = false;
    private boolean moduleVisited = false;
    private EnumSet<Warning> suppressedWarnings = EnumSet.noneOf(Warning.class);

    public VirtualFile getSrcDir() {
        return this.srcDir;
    }

    public PhasedUnit(VirtualFile unitFile, VirtualFile srcDir, Tree.CompilationUnit rootNode, Package p, ModuleManager moduleManager, ModuleSourceMapper moduleManagerUtil, Context context, List<? extends Token> tokenStream) {
        this.rootNode = rootNode;
        this.pkg = p;
        this.unitFile = unitFile;
        this.srcDir = srcDir;
        this.fileName = unitFile.getName();
        this.pathRelativeToSrcDir = Helper.computeRelativePath(unitFile, srcDir);
        this.moduleManagerRef = new WeakReference<ModuleManager>(moduleManager);
        this.moduleSourceMapperRef = new WeakReference<ModuleSourceMapper>(moduleManagerUtil);
        this.tokens = tokenStream;
        this.unit = this.createUnit();
        this.unit.setFilename(this.fileName);
        this.unit.setFullPath(unitFile.getPath());
        this.unit.setRelativePath(this.pathRelativeToSrcDir);
        this.unit.setPackage(this.pkg);
        this.unit.setSupportedBackends(moduleManager.getSupportedBackends());
        this.pkg.removeUnit(this.unit);
        this.pkg.addUnit(this.unit);
        rootNode.setUnit(this.unit);
    }

    public PhasedUnit(PhasedUnit other) {
        this.rootNode = other.rootNode;
        this.pkg = other.pkg;
        this.unit = other.unit;
        this.fileName = other.fileName;
        this.moduleManagerRef = new WeakReference(other.moduleManagerRef.get());
        this.moduleSourceMapperRef = new WeakReference(other.moduleSourceMapperRef.get());
        this.pathRelativeToSrcDir = other.pathRelativeToSrcDir;
        this.unitFile = other.unitFile;
        this.tokens = other.tokens;
        this.moduleVisitor = other.moduleVisitor;
        this.srcDir = other.srcDir;
        this.treeValidated = other.treeValidated;
        this.declarationsScanned = other.declarationsScanned;
        this.scanningDeclarations = other.scanningDeclarations;
        this.typeDeclarationsScanned = other.typeDeclarationsScanned;
        this.fullyTyped = other.fullyTyped;
        this.refinementValidated = other.refinementValidated;
        this.fullyTyped = other.fullyTyped;
        this.flowAnalyzed = other.flowAnalyzed;
    }

    protected boolean shouldIgnoreOverload(Declaration overload, Declaration currentDeclaration) {
        return false;
    }

    protected boolean isAllowedToChangeModel(Declaration declaration) {
        return true;
    }

    public Tree.ModuleDescriptor findModuleDescriptor() {
        if ("module.ceylon".equals(this.fileName)) {
            this.rootNode.visit(new Visitor(){

                @Override
                public void visit(Tree.ModuleDescriptor that) {
                    PhasedUnit.this.moduleDescriptor = that;
                }
            });
        }
        return this.moduleDescriptor;
    }

    public Module visitSrcModulePhase() {
        boolean moduleFile = "module.ceylon".equals(this.fileName);
        boolean packageFile = "package.ceylon".equals(this.fileName);
        if ((moduleFile || packageFile) && !this.moduleVisited) {
            this.moduleVisited = true;
            this.processLiterals();
            this.moduleVisitor = new ModuleVisitor((ModuleManager)this.moduleManagerRef.get(), (ModuleSourceMapper)this.moduleSourceMapperRef.get(), this.pkg, moduleFile);
            this.moduleVisitor.setExceptionHandler(this);
            this.moduleVisitor.setCompleteOnlyAST(!this.isAllowedToChangeModel(null));
            this.rootNode.visit(this.moduleVisitor);
            return this.moduleVisitor.getMainModule();
        }
        return null;
    }

    protected ModuleSourceMapper getModuleSourceMapper() {
        return (ModuleSourceMapper)this.moduleSourceMapperRef.get();
    }

    protected TypecheckerUnit createUnit() {
        return new TypecheckerUnit((ModuleSourceMapper)this.moduleSourceMapperRef.get());
    }

    public void visitRemainingModulePhase() {
        if (this.moduleVisitor != null) {
            this.moduleVisitor.setPhase(ModuleVisitor.Phase.REMAINING);
            this.rootNode.visit(this.moduleVisitor);
            this.moduleVisitor = null;
        }
    }

    public boolean isFullyTyped() {
        return this.fullyTyped;
    }

    public void setFullyTyped(boolean fullyTyped) {
        this.fullyTyped = fullyTyped;
    }

    public boolean isFlowAnalyzed() {
        return this.flowAnalyzed;
    }

    public void setFlowAnalyzed(boolean flowAnalyzed) {
        this.flowAnalyzed = flowAnalyzed;
    }

    public boolean isTreeValidated() {
        return this.treeValidated;
    }

    public void setTreeValidated(boolean treeValidated) {
        this.treeValidated = treeValidated;
    }

    public boolean isDeclarationsScanned() {
        return this.declarationsScanned;
    }

    public void setDeclarationsScanned(boolean declarationsScanned) {
        this.declarationsScanned = declarationsScanned;
    }

    public boolean isTypeDeclarationsScanned() {
        return this.typeDeclarationsScanned;
    }

    public void setTypeDeclarationsScanned(boolean typeDeclarationsScanned) {
        this.typeDeclarationsScanned = typeDeclarationsScanned;
    }

    public boolean isRefinementValidated() {
        return this.refinementValidated;
    }

    public void setRefinementValidated(boolean refinementValidated) {
        this.refinementValidated = refinementValidated;
    }

    public void validateTree() {
        if (!this.treeValidated) {
            String fn = this.unit.getRelativePath();
            int i = 0;
            while (i < fn.length()) {
                int cp = fn.codePointAt(i);
                if (cp > 127) {
                    this.rootNode.addUsageWarning(Warning.filenameNonAscii, "source file name has non-ASCII characters: " + fn);
                }
                i = fn.offsetByCodePoints(i, 1);
            }
            String ufn = this.unit.getFilename();
            for (Unit u : this.unit.getPackage().getUnits()) {
                if (u.equals(this.unit) || !u.getFilename().equalsIgnoreCase(ufn)) continue;
                if (u.getFilename().equals(ufn)) {
                    String errorMessage = "identical source files: " + this.unit.getFullPath() + " and " + u.getFullPath();
                    if (u.getFilename().equals("module.ceylon") || u.getFilename().equals("package.ceylon")) {
                        errorMessage = errorMessage + " (a module/package descriptor should be defined only once, even in case of multiple source directories)";
                    }
                    this.rootNode.addError(errorMessage);
                    continue;
                }
                this.rootNode.addUsageWarning(Warning.filenameCaselessCollision, "source file names differ only by case: " + this.unit.getFullPath() + " and " + u.getFullPath());
            }
            this.rootNode.visit(new Validator().setExceptionHandler(this));
            this.rootNode.visit(new Visitor(){

                @Override
                public void visit(Tree.ModuleDescriptor that) {
                    super.visit(that);
                    Tree.ImportPath importPath = that.getImportPath();
                    if (importPath != null) {
                        String moduleName = TreeUtil.formatPath(importPath.getIdentifiers());
                        ModuleSourceMapper moduleManagerUtil = (ModuleSourceMapper)PhasedUnit.this.moduleSourceMapperRef.get();
                        if (moduleManagerUtil != null) {
                            for (Module otherModule : moduleManagerUtil.getCompiledModules()) {
                                String otherModuleName = otherModule.getNameAsString();
                                if (!moduleName.startsWith(otherModuleName + ".") && !otherModuleName.startsWith(moduleName + ".")) continue;
                                StringBuilder error = new StringBuilder().append("Found two modules within the same hierarchy: '").append(otherModule.getNameAsString()).append("' and '").append(moduleName).append("'");
                                that.addError(error.toString());
                            }
                        }
                    }
                }
            }.setExceptionHandler(this));
            this.treeValidated = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanDeclarations() {
        Boolean enabled = TypeCache.setEnabled(false);
        try {
            if (!this.declarationsScanned) {
                this.processLiterals();
                this.scanningDeclarations = true;
                DeclarationVisitor dv = new DeclarationVisitor(this.unit){

                    @Override
                    protected boolean shouldIgnoreOverload(Declaration overload, Declaration declaration) {
                        return PhasedUnit.this.shouldIgnoreOverload(overload, declaration);
                    }

                    @Override
                    protected boolean isAllowedToChangeModel(Declaration declaration) {
                        return PhasedUnit.this.isAllowedToChangeModel(declaration);
                    }
                };
                this.rootNode.visit(dv.setExceptionHandler(this));
                this.rootNode.visit(new LocalDeclarationVisitor().setExceptionHandler(this));
                this.declarationsScanned = true;
                this.scanningDeclarations = false;
            }
        }
        finally {
            TypeCache.setEnabled(enabled);
        }
    }

    private void processLiterals() {
        if (!this.literalsProcessed) {
            this.rootNode.visit(new LiteralVisitor().setExceptionHandler(this));
            this.literalsProcessed = true;
        }
    }

    public void scanTypeDeclarations() {
        this.scanTypeDeclarations(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanTypeDeclarations(Cancellable cancellable) {
        Boolean enabled = TypeCache.setEnabled(false);
        try {
            if (!this.typeDeclarationsScanned) {
                this.rootNode.visit(new ImportVisitor(cancellable).setExceptionHandler(this));
                this.rootNode.visit(new DefaultTypeArgVisitor().setExceptionHandler(this));
                this.rootNode.visit(new SupertypeVisitor(false).setExceptionHandler(this));
                this.rootNode.visit(new TypeVisitor(cancellable).setExceptionHandler(this));
                this.typeDeclarationsScanned = true;
            }
        }
        finally {
            TypeCache.setEnabled(enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void validateRefinement() {
        Boolean enabled = TypeCache.setEnabled(false);
        try {
            if (!this.refinementValidated) {
                Type.resetDepth(0);
                this.rootNode.visit(new AliasVisitor().setExceptionHandler(this));
                this.rootNode.visit(new SupertypeVisitor(true).setExceptionHandler(this));
                this.rootNode.visit(new InheritanceVisitor().setExceptionHandler(this));
                this.rootNode.visit(new RefinementVisitor().setExceptionHandler(this));
                this.refinementValidated = true;
            }
        }
        finally {
            TypeCache.setEnabled(enabled);
        }
    }

    public synchronized void analyseTypes() {
        this.analyseTypes(null);
    }

    public synchronized void analyseTypes(Cancellable cancellable) {
        if (!this.fullyTyped) {
            Type.resetDepth(-100);
            this.rootNode.visit(new ExpressionVisitor(cancellable).setExceptionHandler(this));
            this.rootNode.visit(new VisibilityVisitor().setExceptionHandler(this));
            this.rootNode.visit(new AnnotationVisitor().setExceptionHandler(this));
            this.rootNode.visit(new TypeArgumentVisitor().setExceptionHandler(this));
            this.fullyTyped = true;
        }
    }

    public synchronized void analyseFlow() {
        if (!this.flowAnalyzed) {
            this.rootNode.visit(new TypeHierarchyVisitor().setExceptionHandler(this));
            this.rootNode.visit(new ControlFlowVisitor().setExceptionHandler(this));
            for (Declaration d : this.unit.getDeclarations()) {
                if (d.getName() == null && !(d instanceof Constructor)) continue;
                this.rootNode.visit(new SpecificationVisitor(d).setExceptionHandler(this));
                if (!(d instanceof TypeDeclaration)) continue;
                TypeDeclaration td = (TypeDeclaration)d;
                this.rootNode.visit(new SelfReferenceVisitor(td).setExceptionHandler(this));
            }
            this.flowAnalyzed = true;
        }
    }

    public synchronized void analyseUsage() {
        if (!this.usageAnalyzed) {
            ReferenceCounter rc = new ReferenceCounter();
            this.rootNode.visit(rc.setExceptionHandler(this));
            this.rootNode.visit(new UsageVisitor(rc).setExceptionHandler(this));
            this.rootNode.visit(new DeprecationVisitor().setExceptionHandler(this));
            this.usageAnalyzed = true;
        }
    }

    public void generateStatistics(StatisticsVisitor statsVisitor) {
        this.rootNode.visit(statsVisitor);
    }

    public void runAssertions(AssertionVisitor av) {
        this.rootNode.visit(av);
    }

    public void display() {
        System.out.println("Displaying " + this.fileName);
        this.rootNode.visit(new PrintVisitor());
    }

    public Package getPackage() {
        return this.pkg;
    }

    public TypecheckerUnit getUnit() {
        return this.unit;
    }

    public List<Declaration> getDeclarations() {
        if (!this.declarationsScanned) {
            this.scanDeclarations();
        }
        return this.unit.getDeclarations();
    }

    public String getPathRelativeToSrcDir() {
        return this.pathRelativeToSrcDir;
    }

    public VirtualFile getUnitFile() {
        return this.unitFile;
    }

    public String toString() {
        return "PhasedUnit" + "[filename=" + this.fileName + ", compilationUnit=" + this.unit + ", pkg=" + this.pkg + ']';
    }

    public Tree.CompilationUnit getCompilationUnit() {
        return this.rootNode;
    }

    public List<CommonToken> getTokens() {
        return this.tokens;
    }

    public boolean isScanningDeclarations() {
        return this.scanningDeclarations;
    }

    public void setSuppressedWarnings(EnumSet<Warning> suppressedWarnings) {
        this.suppressedWarnings = suppressedWarnings;
    }

    public EnumSet<Warning> getSuppressedWarnings() {
        return this.suppressedWarnings;
    }

    @Override
    public boolean handleException(Exception e, Node that) {
        return false;
    }
}

