/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.io.impl;

import com.redhat.ceylon.compiler.typechecker.io.VirtualFile;
import com.redhat.ceylon.compiler.typechecker.io.impl.Helper;
import com.redhat.ceylon.compiler.typechecker.io.impl.ZipFileVirtualFile;
import com.redhat.ceylon.compiler.typechecker.io.impl.ZipFolderVirtualFile;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class ZipEntryVirtualFile
implements VirtualFile {
    public static final List<VirtualFile> EMPTY_CHILDREN = Collections.unmodifiableList(new ArrayList(0));
    private final String name;
    private final String path;
    private final ZipEntry entry;
    private final ZipFile zipFile;

    public ZipEntryVirtualFile(ZipEntry entry, ZipFile zipFile) {
        this.name = Helper.getSimpleName(entry);
        this.entry = entry;
        String tempPath = zipFile.getName() + "!/" + entry.getName();
        this.path = tempPath.endsWith("/") ? tempPath.substring(0, tempPath.length() - 1) : tempPath;
        this.zipFile = zipFile;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean isFolder() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getRelativePath(VirtualFile ancestor) {
        if (ancestor instanceof ZipEntryVirtualFile || ancestor instanceof ZipFolderVirtualFile) {
            if (this.getPath().equals(ancestor.getPath())) {
                return "";
            }
            if (this.getPath().startsWith(ancestor.getPath() + "/")) {
                return this.getPath().substring(ancestor.getPath().length() + 1);
            }
        } else if (ancestor instanceof ZipFileVirtualFile) {
            if (this.getPath().equals(ancestor.getPath())) {
                return "";
            }
            if (this.getPath().startsWith(ancestor.getPath() + "!/")) {
                return this.getPath().substring(ancestor.getPath().length() + 2);
            }
        }
        return null;
    }

    @Override
    public InputStream getInputStream() {
        try {
            return new FilterInputStream(this.zipFile.getInputStream(this.entry)){

                @Override
                public void close() throws IOException {
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<VirtualFile> getChildren() {
        return EMPTY_CHILDREN;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ZipEntryVirtualFile");
        sb.append("{name='").append(this.name).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof VirtualFile) {
            return ((VirtualFile)obj).getPath().equals(this.getPath());
        }
        return super.equals(obj);
    }

    @Override
    public int compareTo(VirtualFile o) {
        return this.getPath().compareTo(o.getPath());
    }
}

