/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.tree;

import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import java.util.List;

public class Walker {
    public static void walkCompilationUnit(Visitor visitor, Tree.CompilationUnit node) {
        List<Tree.CompilerAnnotation> CompilerAnnotations = node.getCompilerAnnotations();
        int l = CompilerAnnotations.size();
        for (int i = 0; i < l; ++i) {
            Tree.CompilerAnnotation subnode = CompilerAnnotations.get(i);
            subnode.visit(visitor);
        }
        if (node.getImportList() != null) {
            node.getImportList().visit(visitor);
        }
        List<Tree.ModuleDescriptor> ModuleDescriptors = node.getModuleDescriptors();
        int l2 = ModuleDescriptors.size();
        for (int i = 0; i < l2; ++i) {
            Tree.ModuleDescriptor subnode = ModuleDescriptors.get(i);
            subnode.visit(visitor);
        }
        List<Tree.PackageDescriptor> PackageDescriptors = node.getPackageDescriptors();
        int l3 = PackageDescriptors.size();
        for (int i = 0; i < l3; ++i) {
            Tree.PackageDescriptor subnode = PackageDescriptors.get(i);
            subnode.visit(visitor);
        }
        List<Tree.Declaration> Declarations = node.getDeclarations();
        int l4 = Declarations.size();
        for (int i = 0; i < l4; ++i) {
            Tree.Declaration subnode = Declarations.get(i);
            subnode.visit(visitor);
        }
    }

    public static void walkModuleDescriptor(Visitor visitor, Tree.ModuleDescriptor node) {
        Walker.walkStatementOrArgument(visitor, node);
        if (node.getAnnotationList() != null) {
            node.getAnnotationList().visit(visitor);
        }
        if (node.getImportPath() != null) {
            node.getImportPath().visit(visitor);
        }
        if (node.getNamespace() != null) {
            node.getNamespace().visit(visitor);
        }
        if (node.getGroupImportPath() != null) {
            node.getGroupImportPath().visit(visitor);
        }
        if (node.getGroupQuotedLiteral() != null) {
            node.getGroupQuotedLiteral().visit(visitor);
        }
        if (node.getArtifact() != null) {
            node.getArtifact().visit(visitor);
        }
        if (node.getClassifier() != null) {
            node.getClassifier().visit(visitor);
        }
        if (node.getVersion() != null) {
            node.getVersion().visit(visitor);
        }
        if (node.getImportModuleList() != null) {
            node.getImportModuleList().visit(visitor);
        }
    }

    public static void walkPackageDescriptor(Visitor visitor, Tree.PackageDescriptor node) {
        Walker.walkStatementOrArgument(visitor, node);
        if (node.getAnnotationList() != null) {
            node.getAnnotationList().visit(visitor);
        }
        if (node.getImportPath() != null) {
            node.getImportPath().visit(visitor);
        }
    }

    public static void walkImportModuleList(Visitor visitor, Tree.ImportModuleList node) {
        List<Tree.AnyAttribute> AnyAttributes = node.getConstants();
        int l = AnyAttributes.size();
        for (int i = 0; i < l; ++i) {
            Tree.AnyAttribute subnode = AnyAttributes.get(i);
            subnode.visit(visitor);
        }
        List<Tree.ImportModule> ImportModules = node.getImportModules();
        int l2 = ImportModules.size();
        for (int i = 0; i < l2; ++i) {
            Tree.ImportModule subnode = ImportModules.get(i);
            subnode.visit(visitor);
        }
    }

    public static void walkImportModule(Visitor visitor, Tree.ImportModule node) {
        Walker.walkStatementOrArgument(visitor, node);
        if (node.getAnnotationList() != null) {
            node.getAnnotationList().visit(visitor);
        }
        if (node.getNamespace() != null) {
            node.getNamespace().visit(visitor);
        }
        if (node.getImportPath() != null) {
            node.getImportPath().visit(visitor);
        }
        if (node.getQuotedLiteral() != null) {
            node.getQuotedLiteral().visit(visitor);
        }
        if (node.getArtifact() != null) {
            node.getArtifact().visit(visitor);
        }
        if (node.getClassifier() != null) {
            node.getClassifier().visit(visitor);
        }
        if (node.getVersion() != null) {
            node.getVersion().visit(visitor);
        }
        if (node.getConstantVersion() != null) {
            node.getConstantVersion().visit(visitor);
        }
    }

    public static void walkImportList(Visitor visitor, Tree.ImportList node) {
        List<Tree.Import> Imports = node.getImports();
        int l = Imports.size();
        for (int i = 0; i < l; ++i) {
            Tree.Import subnode = Imports.get(i);
            subnode.visit(visitor);
        }
    }

    public static void walkImport(Visitor visitor, Tree.Import node) {
        Walker.walkStatementOrArgument(visitor, node);
        if (node.getImportPath() != null) {
            node.getImportPath().visit(visitor);
        }
        if (node.getImportMemberOrTypeList() != null) {
            node.getImportMemberOrTypeList().visit(visitor);
        }
    }

    public static void walkImportPath(Visitor visitor, Tree.ImportPath node) {
        List<Tree.Identifier> Identifiers = node.getIdentifiers();
        int l = Identifiers.size();
        for (int i = 0; i < l; ++i) {
            Tree.Identifier subnode = Identifiers.get(i);
            subnode.visit(visitor);
        }
    }

    public static void walkImportMemberOrTypeList(Visitor visitor, Tree.ImportMemberOrTypeList node) {
        List<Tree.ImportMemberOrType> ImportMemberOrTypes = node.getImportMemberOrTypes();
        int l = ImportMemberOrTypes.size();
        for (int i = 0; i < l; ++i) {
            Tree.ImportMemberOrType subnode = ImportMemberOrTypes.get(i);
            subnode.visit(visitor);
        }
        if (node.getImportWildcard() != null) {
            node.getImportWildcard().visit(visitor);
        }
    }

    public static void walkImportMemberOrType(Visitor visitor, Tree.ImportMemberOrType node) {
        Walker.walkStatementOrArgument(visitor, node);
        if (node.getAlias() != null) {
            node.getAlias().visit(visitor);
        }
        if (node.getIdentifier() != null) {
            node.getIdentifier().visit(visitor);
        }
        if (node.getImportMemberOrTypeList() != null) {
            node.getImportMemberOrTypeList().visit(visitor);
        }
    }

    public static void walkImportMember(Visitor visitor, Tree.ImportMember node) {
        Walker.walkImportMemberOrType(visitor, node);
    }

    public static void walkImportType(Visitor visitor, Tree.ImportType node) {
        Walker.walkImportMemberOrType(visitor, node);
    }

    public static void walkAlias(Visitor visitor, Tree.Alias node) {
        if (node.getIdentifier() != null) {
            node.getIdentifier().visit(visitor);
        }
    }

    public static void walkImportWildcard(Visitor visitor, Tree.ImportWildcard node) {
    }

    public static void walkDeclaration(Visitor visitor, Tree.Declaration node) {
        Walker.walkStatement(visitor, node);
        if (node.getAnnotationList() != null) {
            node.getAnnotationList().visit(visitor);
        }
        if (node.getIdentifier() != null) {
            node.getIdentifier().visit(visitor);
        }
    }

    public static void walkMissingDeclaration(Visitor visitor, Tree.MissingDeclaration node) {
        Walker.walkDeclaration(visitor, node);
    }

    public static void walkTypeDeclaration(Visitor visitor, Tree.TypeDeclaration node) {
        Walker.walkDeclaration(visitor, node);
        if (node.getTypeParameterList() != null) {
            node.getTypeParameterList().visit(visitor);
        }
    }

    public static void walkClassOrInterface(Visitor visitor, Tree.ClassOrInterface node) {
        Walker.walkTypeDeclaration(visitor, node);
    }

    public static void walkTypeAliasDeclaration(Visitor visitor, Tree.TypeAliasDeclaration node) {
        Walker.walkTypeDeclaration(visitor, node);
        if (node.getTypeConstraintList() != null) {
            node.getTypeConstraintList().visit(visitor);
        }
        if (node.getTypeSpecifier() != null) {
            node.getTypeSpecifier().visit(visitor);
        }
    }

    public static void walkSatisfiedTypes(Visitor visitor, Tree.SatisfiedTypes node) {
        List<Tree.StaticType> StaticTypes = node.getTypes();
        int l = StaticTypes.size();
        for (int i = 0; i < l; ++i) {
            Tree.StaticType subnode = StaticTypes.get(i);
            subnode.visit(visitor);
        }
    }

    public static void walkAbstractedType(Visitor visitor, Tree.AbstractedType node) {
        if (node.getType() != null) {
            node.getType().visit(visitor);
        }
    }

    public static void walkCaseTypes(Visitor visitor, Tree.CaseTypes node) {
        List<Tree.StaticType> StaticTypes = node.getTypes();
        int l = StaticTypes.size();
        for (int i = 0; i < l; ++i) {
            Tree.StaticType subnode = StaticTypes.get(i);
            subnode.visit(visitor);
        }
        List<Tree.StaticMemberOrTypeExpression> StaticMemberOrTypeExpressions = node.getBaseMemberExpressions();
        int l2 = StaticMemberOrTypeExpressions.size();
        for (int i = 0; i < l2; ++i) {
            Tree.StaticMemberOrTypeExpression subnode = StaticMemberOrTypeExpressions.get(i);
            subnode.visit(visitor);
        }
    }

    public static void walkExtendedType(Visitor visitor, Tree.ExtendedType node) {
        if (node.getType() != null) {
            node.getType().visit(visitor);
        }
        if (node.getInvocationExpression() != null) {
            node.getInvocationExpression().visit(visitor);
        }
    }

    public static void walkTypeConstraintList(Visitor visitor, Tree.TypeConstraintList node) {
        List<Tree.TypeConstraint> TypeConstraints = node.getTypeConstraints();
        int l = TypeConstraints.size();
        for (int i = 0; i < l; ++i) {
            Tree.TypeConstraint subnode = TypeConstraints.get(i);
            subnode.visit(visitor);
        }
    }

    public static void walkTypeConstraint(Visitor visitor, Tree.TypeConstraint node) {
        Walker.walkTypeDeclaration(visitor, node);
        if (node.getCaseTypes() != null) {
            node.getCaseTypes().visit(visitor);
        }
        if (node.getSatisfiedTypes() != null) {
            node.getSatisfiedTypes().visit(visitor);
        }
        if (node.getAbstractedType() != null) {
            node.getAbstractedType().visit(visitor);
        }
    }

    public static void walkTypeSpecifier(Visitor visitor, Tree.TypeSpecifier node) {
        if (node.getType() != null) {
            node.getType().visit(visitor);
        }
    }

    public static void walkDefaultTypeArgument(Visitor visitor, Tree.DefaultTypeArgument node) {
        Walker.walkTypeSpecifier(visitor, node);
    }

    public static void walkClassSpecifier(Visitor visitor, Tree.ClassSpecifier node) {
        if (node.getType() != null) {
            node.getType().visit(visitor);
        }
        if (node.getInvocationExpression() != null) {
            node.getInvocationExpression().visit(visitor);
        }
    }

    public static void walkAnyClass(Visitor visitor, Tree.AnyClass node) {
        Walker.walkClassOrInterface(visitor, node);
        if (node.getParameterList() != null) {
            node.getParameterList().visit(visitor);
        }
        if (node.getCaseTypes() != null) {
            node.getCaseTypes().visit(visitor);
        }
        if (node.getExtendedType() != null) {
            node.getExtendedType().visit(visitor);
        }
        if (node.getSatisfiedTypes() != null) {
            node.getSatisfiedTypes().visit(visitor);
        }
        if (node.getTypeConstraintList() != null) {
            node.getTypeConstraintList().visit(visitor);
        }
    }

    public static void walkClassDefinition(Visitor visitor, Tree.ClassDefinition node) {
        Walker.walkAnyClass(visitor, node);
        if (node.getClassBody() != null) {
            node.getClassBody().visit(visitor);
        }
    }

    public static void walkEnumerated(Visitor visitor, Tree.Enumerated node) {
        Walker.walkDeclaration(visitor, node);
        if (node.getDelegatedConstructor() != null) {
            node.getDelegatedConstructor().visit(visitor);
        }
        if (node.getBlock() != null) {
            node.getBlock().visit(visitor);
        }
    }

    public static void walkConstructor(Visitor visitor, Tree.Constructor node) {
        Walker.walkDeclaration(visitor, node);
        if (node.getParameterList() != null) {
            node.getParameterList().visit(visitor);
        }
        if (node.getDelegatedConstructor() != null) {
            node.getDelegatedConstructor().visit(visitor);
        }
        if (node.getBlock() != null) {
            node.getBlock().visit(visitor);
        }
    }

    public static void walkDelegatedConstructor(Visitor visitor, Tree.DelegatedConstructor node) {
        if (node.getType() != null) {
            node.getType().visit(visitor);
        }
        if (node.getInvocationExpression() != null) {
            node.getInvocationExpression().visit(visitor);
        }
    }

    public static void walkClassDeclaration(Visitor visitor, Tree.ClassDeclaration node) {
        Walker.walkAnyClass(visitor, node);
        if (node.getClassSpecifier() != null) {
            node.getClassSpecifier().visit(visitor);
        }
    }

    public static void walkAnyInterface(Visitor visitor, Tree.AnyInterface node) {
        Walker.walkClassOrInterface(visitor, node);
        if (node.getCaseTypes() != null) {
            node.getCaseTypes().visit(visitor);
        }
        if (node.getSatisfiedTypes() != null) {
            node.getSatisfiedTypes().visit(visitor);
        }
        if (node.getTypeConstraintList() != null) {
            node.getTypeConstraintList().visit(visitor);
        }
    }

    public static void walkInterfaceDefinition(Visitor visitor, Tree.InterfaceDefinition node) {
        Walker.walkAnyInterface(visitor, node);
        if (node.getInterfaceBody() != null) {
            node.getInterfaceBody().visit(visitor);
        }
    }

    public static void walkInterfaceDeclaration(Visitor visitor, Tree.InterfaceDeclaration node) {
        Walker.walkAnyInterface(visitor, node);
        if (node.getTypeSpecifier() != null) {
            node.getTypeSpecifier().visit(visitor);
        }
    }

    public static void walkTypedDeclaration(Visitor visitor, Tree.TypedDeclaration node) {
        Walker.walkDeclaration(visitor, node);
        if (node.getType() != null) {
            node.getType().visit(visitor);
        }
    }

    public static void walkAnyAttribute(Visitor visitor, Tree.AnyAttribute node) {
        Walker.walkTypedDeclaration(visitor, node);
    }

    public static void walkAttributeDeclaration(Visitor visitor, Tree.AttributeDeclaration node) {
        Walker.walkAnyAttribute(visitor, node);
        if (node.getSpecifierOrInitializerExpression() != null) {
            node.getSpecifierOrInitializerExpression().visit(visitor);
        }
    }

    public static void walkAttributeGetterDefinition(Visitor visitor, Tree.AttributeGetterDefinition node) {
        Walker.walkAnyAttribute(visitor, node);
        if (node.getBlock() != null) {
            node.getBlock().visit(visitor);
        }
    }

    public static void walkAttributeSetterDefinition(Visitor visitor, Tree.AttributeSetterDefinition node) {
        Walker.walkTypedDeclaration(visitor, node);
        if (node.getBlock() != null) {
            node.getBlock().visit(visitor);
        }
        if (node.getSpecifierExpression() != null) {
            node.getSpecifierExpression().visit(visitor);
        }
    }

    public static void walkAnyMethod(Visitor visitor, Tree.AnyMethod node) {
        Walker.walkTypedDeclaration(visitor, node);
        if (node.getTypeParameterList() != null) {
            node.getTypeParameterList().visit(visitor);
        }
        List<Tree.ParameterList> ParameterLists = node.getParameterLists();
        int l = ParameterLists.size();
        for (int i = 0; i < l; ++i) {
            Tree.ParameterList subnode = ParameterLists.get(i);
            subnode.visit(visitor);
        }
        if (node.getTypeConstraintList() != null) {
            node.getTypeConstraintList().visit(visitor);
        }
    }

    public static void walkMethodDefinition(Visitor visitor, Tree.MethodDefinition node) {
        Walker.walkAnyMethod(visitor, node);
        if (node.getBlock() != null) {
            node.getBlock().visit(visitor);
        }
    }

    public static void walkMethodDeclaration(Visitor visitor, Tree.MethodDeclaration node) {
        Walker.walkAnyMethod(visitor, node);
        if (node.getSpecifierExpression() != null) {
            node.getSpecifierExpression().visit(visitor);
        }
    }

    public static void walkVoidModifier(Visitor visitor, Tree.VoidModifier node) {
        Walker.walkType(visitor, node);
    }

    public static void walkObjectDefinition(Visitor visitor, Tree.ObjectDefinition node) {
        Walker.walkTypedDeclaration(visitor, node);
        if (node.getExtendedType() != null) {
            node.getExtendedType().visit(visitor);
        }
        if (node.getSatisfiedTypes() != null) {
            node.getSatisfiedTypes().visit(visitor);
        }
        if (node.getClassBody() != null) {
            node.getClassBody().visit(visitor);
        }
    }

    public static void walkParameterList(Visitor visitor, Tree.ParameterList node) {
        List<Tree.Parameter> Parameters2 = node.getParameters();
        int l = Parameters2.size();
        for (int i = 0; i < l; ++i) {
            Tree.Parameter subnode = Parameters2.get(i);
            subnode.visit(visitor);
        }
    }

    public static void walkParameter(Visitor visitor, Tree.Parameter node) {
    }

    public static void walkParameterDeclaration(Visitor visitor, Tree.ParameterDeclaration node) {
        Walker.walkParameter(visitor, node);
        if (node.getTypedDeclaration() != null) {
            node.getTypedDeclaration().visit(visitor);
        }
    }

    public static void walkValueParameterDeclaration(Visitor visitor, Tree.ValueParameterDeclaration node) {
        Walker.walkParameterDeclaration(visitor, node);
    }

    public static void walkFunctionalParameterDeclaration(Visitor visitor, Tree.FunctionalParameterDeclaration node) {
        Walker.walkParameterDeclaration(visitor, node);
    }

    public static void walkInitializerParameter(Visitor visitor, Tree.InitializerParameter node) {
        Walker.walkParameter(visitor, node);
        if (node.getIdentifier() != null) {
            node.getIdentifier().visit(visitor);
        }
        if (node.getSpecifierExpression() != null) {
            node.getSpecifierExpression().visit(visitor);
        }
    }

    public static void walkPatternParameter(Visitor visitor, Tree.PatternParameter node) {
        Walker.walkParameter(visitor, node);
        if (node.getPattern() != null) {
            node.getPattern().visit(visitor);
        }
    }

    public static void walkTypeParameterList(Visitor visitor, Tree.TypeParameterList node) {
        List<Tree.TypeParameterDeclaration> TypeParameterDeclarations = node.getTypeParameterDeclarations();
        int l = TypeParameterDeclarations.size();
        for (int i = 0; i < l; ++i) {
            Tree.TypeParameterDeclaration subnode = TypeParameterDeclarations.get(i);
            subnode.visit(visitor);
        }
    }

    public static void walkTypeParameterDeclaration(Visitor visitor, Tree.TypeParameterDeclaration node) {
        Walker.walkDeclaration(visitor, node);
        if (node.getTypeVariance() != null) {
            node.getTypeVariance().visit(visitor);
        }
        if (node.getTypeSpecifier() != null) {
            node.getTypeSpecifier().visit(visitor);
        }
    }

    public static void walkTypeVariance(Visitor visitor, Tree.TypeVariance node) {
    }

    public static void walkBody(Visitor visitor, Tree.Body node) {
        if (node.getImportList() != null) {
            node.getImportList().visit(visitor);
        }
        List<Tree.Statement> Statements = node.getStatements();
        int l = Statements.size();
        for (int i = 0; i < l; ++i) {
            Tree.Statement subnode = Statements.get(i);
            subnode.visit(visitor);
        }
    }

    public static void walkBlock(Visitor visitor, Tree.Block node) {
        Walker.walkBody(visitor, node);
    }

    public static void walkClassBody(Visitor visitor, Tree.ClassBody node) {
        Walker.walkBody(visitor, node);
    }

    public static void walkInterfaceBody(Visitor visitor, Tree.InterfaceBody node) {
        Walker.walkBody(visitor, node);
    }

    public static void walkType(Visitor visitor, Tree.Type node) {
    }

    public static void walkStaticType(Visitor visitor, Tree.StaticType node) {
        Walker.walkType(visitor, node);
        if (node.getTypeVariance() != null) {
            node.getTypeVariance().visit(visitor);
        }
    }

    public static void walkGroupedType(Visitor visitor, Tree.GroupedType node) {
        Walker.walkStaticType(visitor, node);
        if (node.getType() != null) {
            node.getType().visit(visitor);
        }
    }

    public static void walkSimpleType(Visitor visitor, Tree.SimpleType node) {
        Walker.walkStaticType(visitor, node);
        if (node.getIdentifier() != null) {
            node.getIdentifier().visit(visitor);
        }
        if (node.getTypeArgumentList() != null) {
            node.getTypeArgumentList().visit(visitor);
        }
    }

    public static void walkBaseType(Visitor visitor, Tree.BaseType node) {
        Walker.walkSimpleType(visitor, node);
    }

    public static void walkQualifiedType(Visitor visitor, Tree.QualifiedType node) {
        Walker.walkSimpleType(visitor, node);
        if (node.getOuterType() != null) {
            node.getOuterType().visit(visitor);
        }
    }

    public static void walkUnionType(Visitor visitor, Tree.UnionType node) {
        Walker.walkStaticType(visitor, node);
        List<Tree.StaticType> StaticTypes = node.getStaticTypes();
        int l = StaticTypes.size();
        for (int i = 0; i < l; ++i) {
            Tree.StaticType subnode = StaticTypes.get(i);
            subnode.visit(visitor);
        }
    }

    public static void walkIntersectionType(Visitor visitor, Tree.IntersectionType node) {
        Walker.walkStaticType(visitor, node);
        List<Tree.StaticType> StaticTypes = node.getStaticTypes();
        int l = StaticTypes.size();
        for (int i = 0; i < l; ++i) {
            Tree.StaticType subnode = StaticTypes.get(i);
            subnode.visit(visitor);
        }
    }

    public static void walkSequenceType(Visitor visitor, Tree.SequenceType node) {
        Walker.walkStaticType(visitor, node);
        if (node.getElementType() != null) {
            node.getElementType().visit(visitor);
        }
        if (node.getLength() != null) {
            node.getLength().visit(visitor);
        }
    }

    public static void walkIterableType(Visitor visitor, Tree.IterableType node) {
        Walker.walkStaticType(visitor, node);
        if (node.getElementType() != null) {
            node.getElementType().visit(visitor);
        }
    }

    public static void walkOptionalType(Visitor visitor, Tree.OptionalType node) {
        Walker.walkStaticType(visitor, node);
        if (node.getDefiniteType() != null) {
            node.getDefiniteType().visit(visitor);
        }
    }

    public static void walkTupleType(Visitor visitor, Tree.TupleType node) {
        Walker.walkStaticType(visitor, node);
        List<Tree.Type> Types2 = node.getElementTypes();
        int l = Types2.size();
        for (int i = 0; i < l; ++i) {
            Tree.Type subnode = Types2.get(i);
            subnode.visit(visitor);
        }
    }

    public static void walkFunctionType(Visitor visitor, Tree.FunctionType node) {
        Walker.walkStaticType(visitor, node);
        if (node.getReturnType() != null) {
            node.getReturnType().visit(visitor);
        }
        List<Tree.Type> Types2 = node.getArgumentTypes();
        int l = Types2.size();
        for (int i = 0; i < l; ++i) {
            Tree.Type subnode = Types2.get(i);
            subnode.visit(visitor);
        }
    }

    public static void walkEntryType(Visitor visitor, Tree.EntryType node) {
        Walker.walkStaticType(visitor, node);
        if (node.getKeyType() != null) {
            node.getKeyType().visit(visitor);
        }
        if (node.getValueType() != null) {
            node.getValueType().visit(visitor);
        }
    }

    public static void walkTypeConstructor(Visitor visitor, Tree.TypeConstructor node) {
        Walker.walkStaticType(visitor, node);
        if (node.getTypeParameterList() != null) {
            node.getTypeParameterList().visit(visitor);
        }
        if (node.getType() != null) {
            node.getType().visit(visitor);
        }
        if (node.getTypeConstraintList() != null) {
            node.getTypeConstraintList().visit(visitor);
        }
    }

    public static void walkSuperType(Visitor visitor, Tree.SuperType node) {
        Walker.walkStaticType(visitor, node);
    }

    public static void walkMetaLiteral(Visitor visitor, Tree.MetaLiteral node) {
        Walker.walkPrimary(visitor, node);
    }

    public static void walkTypeLiteral(Visitor visitor, Tree.TypeLiteral node) {
        Walker.walkMetaLiteral(visitor, node);
        if (node.getType() != null) {
            node.getType().visit(visitor);
        }
    }

    public static void walkMemberLiteral(Visitor visitor, Tree.MemberLiteral node) {
        Walker.walkMetaLiteral(visitor, node);
        if (node.getType() != null) {
            node.getType().visit(visitor);
        }
        if (node.getIdentifier() != null) {
            node.getIdentifier().visit(visitor);
        }
        if (node.getTypeArgumentList() != null) {
            node.getTypeArgumentList().visit(visitor);
        }
    }

    public static void walkClassLiteral(Visitor visitor, Tree.ClassLiteral node) {
        Walker.walkTypeLiteral(visitor, node);
    }

    public static void walkNewLiteral(Visitor visitor, Tree.NewLiteral node) {
        Walker.walkTypeLiteral(visitor, node);
    }

    public static void walkInterfaceLiteral(Visitor visitor, Tree.InterfaceLiteral node) {
        Walker.walkTypeLiteral(visitor, node);
    }

    public static void walkAliasLiteral(Visitor visitor, Tree.AliasLiteral node) {
        Walker.walkTypeLiteral(visitor, node);
    }

    public static void walkTypeParameterLiteral(Visitor visitor, Tree.TypeParameterLiteral node) {
        Walker.walkTypeLiteral(visitor, node);
    }

    public static void walkValueLiteral(Visitor visitor, Tree.ValueLiteral node) {
        Walker.walkMemberLiteral(visitor, node);
    }

    public static void walkFunctionLiteral(Visitor visitor, Tree.FunctionLiteral node) {
        Walker.walkMemberLiteral(visitor, node);
    }

    public static void walkModuleLiteral(Visitor visitor, Tree.ModuleLiteral node) {
        Walker.walkMetaLiteral(visitor, node);
        if (node.getImportPath() != null) {
            node.getImportPath().visit(visitor);
        }
    }

    public static void walkPackageLiteral(Visitor visitor, Tree.PackageLiteral node) {
        Walker.walkMetaLiteral(visitor, node);
        if (node.getImportPath() != null) {
            node.getImportPath().visit(visitor);
        }
    }

    public static void walkDynamicModifier(Visitor visitor, Tree.DynamicModifier node) {
        Walker.walkType(visitor, node);
    }

    public static void walkLocalModifier(Visitor visitor, Tree.LocalModifier node) {
        Walker.walkType(visitor, node);
    }

    public static void walkValueModifier(Visitor visitor, Tree.ValueModifier node) {
        Walker.walkLocalModifier(visitor, node);
    }

    public static void walkFunctionModifier(Visitor visitor, Tree.FunctionModifier node) {
        Walker.walkLocalModifier(visitor, node);
    }

    public static void walkSyntheticVariable(Visitor visitor, Tree.SyntheticVariable node) {
        Walker.walkValueModifier(visitor, node);
    }

    public static void walkTypeArguments(Visitor visitor, Tree.TypeArguments node) {
    }

    public static void walkTypeArgumentList(Visitor visitor, Tree.TypeArgumentList node) {
        Walker.walkTypeArguments(visitor, node);
        List<Tree.Type> Types2 = node.getTypes();
        int l = Types2.size();
        for (int i = 0; i < l; ++i) {
            Tree.Type subnode = Types2.get(i);
            subnode.visit(visitor);
        }
    }

    public static void walkInferredTypeArguments(Visitor visitor, Tree.InferredTypeArguments node) {
        Walker.walkTypeArguments(visitor, node);
    }

    public static void walkSequencedType(Visitor visitor, Tree.SequencedType node) {
        Walker.walkType(visitor, node);
        if (node.getType() != null) {
            node.getType().visit(visitor);
        }
    }

    public static void walkDefaultedType(Visitor visitor, Tree.DefaultedType node) {
        Walker.walkType(visitor, node);
        if (node.getType() != null) {
            node.getType().visit(visitor);
        }
    }

    public static void walkSpreadType(Visitor visitor, Tree.SpreadType node) {
        Walker.walkType(visitor, node);
        if (node.getType() != null) {
            node.getType().visit(visitor);
        }
    }

    public static void walkDirective(Visitor visitor, Tree.Directive node) {
        Walker.walkExecutableStatement(visitor, node);
    }

    public static void walkReturn(Visitor visitor, Tree.Return node) {
        Walker.walkDirective(visitor, node);
        if (node.getExpression() != null) {
            node.getExpression().visit(visitor);
        }
    }

    public static void walkThrow(Visitor visitor, Tree.Throw node) {
        Walker.walkDirective(visitor, node);
        if (node.getExpression() != null) {
            node.getExpression().visit(visitor);
        }
    }

    public static void walkContinue(Visitor visitor, Tree.Continue node) {
        Walker.walkDirective(visitor, node);
    }

    public static void walkBreak(Visitor visitor, Tree.Break node) {
        Walker.walkDirective(visitor, node);
    }

    public static void walkStatementOrArgument(Visitor visitor, Tree.StatementOrArgument node) {
        List<Tree.CompilerAnnotation> CompilerAnnotations = node.getCompilerAnnotations();
        int l = CompilerAnnotations.size();
        for (int i = 0; i < l; ++i) {
            Tree.CompilerAnnotation subnode = CompilerAnnotations.get(i);
            subnode.visit(visitor);
        }
    }

    public static void walkStatement(Visitor visitor, Tree.Statement node) {
        Walker.walkStatementOrArgument(visitor, node);
    }

    public static void walkCompilerAnnotation(Visitor visitor, Tree.CompilerAnnotation node) {
        if (node.getIdentifier() != null) {
            node.getIdentifier().visit(visitor);
        }
        if (node.getStringLiteral() != null) {
            node.getStringLiteral().visit(visitor);
        }
    }

    public static void walkExecutableStatement(Visitor visitor, Tree.ExecutableStatement node) {
        Walker.walkStatement(visitor, node);
    }

    public static void walkAssertion(Visitor visitor, Tree.Assertion node) {
        Walker.walkExecutableStatement(visitor, node);
        if (node.getAnnotationList() != null) {
            node.getAnnotationList().visit(visitor);
        }
        if (node.getConditionList() != null) {
            node.getConditionList().visit(visitor);
        }
    }

    public static void walkSpecifierStatement(Visitor visitor, Tree.SpecifierStatement node) {
        Walker.walkExecutableStatement(visitor, node);
        if (node.getBaseMemberExpression() != null) {
            node.getBaseMemberExpression().visit(visitor);
        }
        if (node.getSpecifierExpression() != null) {
            node.getSpecifierExpression().visit(visitor);
        }
    }

    public static void walkExpressionStatement(Visitor visitor, Tree.ExpressionStatement node) {
        Walker.walkExecutableStatement(visitor, node);
        if (node.getExpression() != null) {
            node.getExpression().visit(visitor);
        }
    }

    public static void walkPattern(Visitor visitor, Tree.Pattern node) {
    }

    public static void walkVariablePattern(Visitor visitor, Tree.VariablePattern node) {
        Walker.walkPattern(visitor, node);
        if (node.getVariable() != null) {
            node.getVariable().visit(visitor);
        }
    }

    public static void walkTuplePattern(Visitor visitor, Tree.TuplePattern node) {
        Walker.walkPattern(visitor, node);
        List<Tree.Pattern> Patterns = node.getPatterns();
        int l = Patterns.size();
        for (int i = 0; i < l; ++i) {
            Tree.Pattern subnode = Patterns.get(i);
            subnode.visit(visitor);
        }
    }

    public static void walkKeyValuePattern(Visitor visitor, Tree.KeyValuePattern node) {
        Walker.walkPattern(visitor, node);
        if (node.getKey() != null) {
            node.getKey().visit(visitor);
        }
        if (node.getValue() != null) {
            node.getValue().visit(visitor);
        }
    }

    public static void walkDestructure(Visitor visitor, Tree.Destructure node) {
        Walker.walkExecutableStatement(visitor, node);
        if (node.getType() != null) {
            node.getType().visit(visitor);
        }
        if (node.getPattern() != null) {
            node.getPattern().visit(visitor);
        }
        if (node.getSpecifierExpression() != null) {
            node.getSpecifierExpression().visit(visitor);
        }
    }

    public static void walkControlStatement(Visitor visitor, Tree.ControlStatement node) {
        Walker.walkExecutableStatement(visitor, node);
    }

    public static void walkControlClause(Visitor visitor, Tree.ControlClause node) {
    }

    public static void walkDynamicStatement(Visitor visitor, Tree.DynamicStatement node) {
        Walker.walkControlStatement(visitor, node);
        if (node.getDynamicClause() != null) {
            node.getDynamicClause().visit(visitor);
        }
    }

    public static void walkDynamicClause(Visitor visitor, Tree.DynamicClause node) {
        Walker.walkControlClause(visitor, node);
        if (node.getBlock() != null) {
            node.getBlock().visit(visitor);
        }
    }

    public static void walkLetExpression(Visitor visitor, Tree.LetExpression node) {
        Walker.walkTerm(visitor, node);
        if (node.getLetClause() != null) {
            node.getLetClause().visit(visitor);
        }
    }

    public static void walkLetClause(Visitor visitor, Tree.LetClause node) {
        Walker.walkControlClause(visitor, node);
        List<Tree.Statement> Statements = node.getVariables();
        int l = Statements.size();
        for (int i = 0; i < l; ++i) {
            Tree.Statement subnode = Statements.get(i);
            subnode.visit(visitor);
        }
        if (node.getExpression() != null) {
            node.getExpression().visit(visitor);
        }
    }

    public static void walkIfStatement(Visitor visitor, Tree.IfStatement node) {
        Walker.walkControlStatement(visitor, node);
        if (node.getIfClause() != null) {
            node.getIfClause().visit(visitor);
        }
        if (node.getElseClause() != null) {
            node.getElseClause().visit(visitor);
        }
    }

    public static void walkIfClause(Visitor visitor, Tree.IfClause node) {
        Walker.walkControlClause(visitor, node);
        if (node.getConditionList() != null) {
            node.getConditionList().visit(visitor);
        }
        if (node.getBlock() != null) {
            node.getBlock().visit(visitor);
        }
        if (node.getExpression() != null) {
            node.getExpression().visit(visitor);
        }
    }

    public static void walkElseClause(Visitor visitor, Tree.ElseClause node) {
        Walker.walkControlClause(visitor, node);
        if (node.getVariable() != null) {
            node.getVariable().visit(visitor);
        }
        if (node.getBlock() != null) {
            node.getBlock().visit(visitor);
        }
        if (node.getExpression() != null) {
            node.getExpression().visit(visitor);
        }
    }

    public static void walkSwitchStatement(Visitor visitor, Tree.SwitchStatement node) {
        Walker.walkControlStatement(visitor, node);
        if (node.getSwitchClause() != null) {
            node.getSwitchClause().visit(visitor);
        }
        if (node.getSwitchCaseList() != null) {
            node.getSwitchCaseList().visit(visitor);
        }
    }

    public static void walkSwitchClause(Visitor visitor, Tree.SwitchClause node) {
        if (node.getSwitched() != null) {
            node.getSwitched().visit(visitor);
        }
    }

    public static void walkSwitched(Visitor visitor, Tree.Switched node) {
        if (node.getVariable() != null) {
            node.getVariable().visit(visitor);
        }
        if (node.getExpression() != null) {
            node.getExpression().visit(visitor);
        }
    }

    public static void walkSwitchCaseList(Visitor visitor, Tree.SwitchCaseList node) {
        List<Tree.CaseClause> CaseClauses = node.getCaseClauses();
        int l = CaseClauses.size();
        for (int i = 0; i < l; ++i) {
            Tree.CaseClause subnode = CaseClauses.get(i);
            subnode.visit(visitor);
        }
        if (node.getElseClause() != null) {
            node.getElseClause().visit(visitor);
        }
    }

    public static void walkCaseClause(Visitor visitor, Tree.CaseClause node) {
        Walker.walkControlClause(visitor, node);
        if (node.getCaseItem() != null) {
            node.getCaseItem().visit(visitor);
        }
        if (node.getBlock() != null) {
            node.getBlock().visit(visitor);
        }
        if (node.getExpression() != null) {
            node.getExpression().visit(visitor);
        }
    }

    public static void walkCaseItem(Visitor visitor, Tree.CaseItem node) {
    }

    public static void walkMatchCase(Visitor visitor, Tree.MatchCase node) {
        Walker.walkCaseItem(visitor, node);
        if (node.getExpressionList() != null) {
            node.getExpressionList().visit(visitor);
        }
    }

    public static void walkIsCase(Visitor visitor, Tree.IsCase node) {
        Walker.walkCaseItem(visitor, node);
        if (node.getType() != null) {
            node.getType().visit(visitor);
        }
        if (node.getVariable() != null) {
            node.getVariable().visit(visitor);
        }
    }

    public static void walkPatternCase(Visitor visitor, Tree.PatternCase node) {
        Walker.walkCaseItem(visitor, node);
        if (node.getPattern() != null) {
            node.getPattern().visit(visitor);
        }
    }

    public static void walkSatisfiesCase(Visitor visitor, Tree.SatisfiesCase node) {
        Walker.walkCaseItem(visitor, node);
        if (node.getType() != null) {
            node.getType().visit(visitor);
        }
    }

    public static void walkTryCatchStatement(Visitor visitor, Tree.TryCatchStatement node) {
        Walker.walkControlStatement(visitor, node);
        if (node.getTryClause() != null) {
            node.getTryClause().visit(visitor);
        }
        List<Tree.CatchClause> CatchClauses = node.getCatchClauses();
        int l = CatchClauses.size();
        for (int i = 0; i < l; ++i) {
            Tree.CatchClause subnode = CatchClauses.get(i);
            subnode.visit(visitor);
        }
        if (node.getFinallyClause() != null) {
            node.getFinallyClause().visit(visitor);
        }
    }

    public static void walkTryClause(Visitor visitor, Tree.TryClause node) {
        Walker.walkControlClause(visitor, node);
        if (node.getResourceList() != null) {
            node.getResourceList().visit(visitor);
        }
        if (node.getBlock() != null) {
            node.getBlock().visit(visitor);
        }
    }

    public static void walkCatchClause(Visitor visitor, Tree.CatchClause node) {
        Walker.walkControlClause(visitor, node);
        if (node.getCatchVariable() != null) {
            node.getCatchVariable().visit(visitor);
        }
        if (node.getBlock() != null) {
            node.getBlock().visit(visitor);
        }
    }

    public static void walkFinallyClause(Visitor visitor, Tree.FinallyClause node) {
        Walker.walkControlClause(visitor, node);
        if (node.getBlock() != null) {
            node.getBlock().visit(visitor);
        }
    }

    public static void walkResourceList(Visitor visitor, Tree.ResourceList node) {
        List<Tree.Resource> Resources2 = node.getResources();
        int l = Resources2.size();
        for (int i = 0; i < l; ++i) {
            Tree.Resource subnode = Resources2.get(i);
            subnode.visit(visitor);
        }
    }

    public static void walkResource(Visitor visitor, Tree.Resource node) {
        if (node.getVariable() != null) {
            node.getVariable().visit(visitor);
        }
        if (node.getExpression() != null) {
            node.getExpression().visit(visitor);
        }
    }

    public static void walkCatchVariable(Visitor visitor, Tree.CatchVariable node) {
        if (node.getVariable() != null) {
            node.getVariable().visit(visitor);
        }
    }

    public static void walkForStatement(Visitor visitor, Tree.ForStatement node) {
        Walker.walkControlStatement(visitor, node);
        if (node.getForClause() != null) {
            node.getForClause().visit(visitor);
        }
        if (node.getElseClause() != null) {
            node.getElseClause().visit(visitor);
        }
    }

    public static void walkForClause(Visitor visitor, Tree.ForClause node) {
        Walker.walkControlClause(visitor, node);
        if (node.getForIterator() != null) {
            node.getForIterator().visit(visitor);
        }
        if (node.getBlock() != null) {
            node.getBlock().visit(visitor);
        }
    }

    public static void walkForIterator(Visitor visitor, Tree.ForIterator node) {
        Walker.walkStatementOrArgument(visitor, node);
        if (node.getSpecifierExpression() != null) {
            node.getSpecifierExpression().visit(visitor);
        }
    }

    public static void walkValueIterator(Visitor visitor, Tree.ValueIterator node) {
        Walker.walkForIterator(visitor, node);
        if (node.getVariable() != null) {
            node.getVariable().visit(visitor);
        }
    }

    public static void walkPatternIterator(Visitor visitor, Tree.PatternIterator node) {
        Walker.walkForIterator(visitor, node);
        if (node.getPattern() != null) {
            node.getPattern().visit(visitor);
        }
    }

    public static void walkWhileStatement(Visitor visitor, Tree.WhileStatement node) {
        Walker.walkControlStatement(visitor, node);
        if (node.getWhileClause() != null) {
            node.getWhileClause().visit(visitor);
        }
    }

    public static void walkWhileClause(Visitor visitor, Tree.WhileClause node) {
        Walker.walkControlClause(visitor, node);
        if (node.getConditionList() != null) {
            node.getConditionList().visit(visitor);
        }
        if (node.getBlock() != null) {
            node.getBlock().visit(visitor);
        }
    }

    public static void walkConditionList(Visitor visitor, Tree.ConditionList node) {
        List<Tree.Condition> Conditions = node.getConditions();
        int l = Conditions.size();
        for (int i = 0; i < l; ++i) {
            Tree.Condition subnode = Conditions.get(i);
            subnode.visit(visitor);
        }
    }

    public static void walkCondition(Visitor visitor, Tree.Condition node) {
    }

    public static void walkBooleanCondition(Visitor visitor, Tree.BooleanCondition node) {
        Walker.walkCondition(visitor, node);
        if (node.getExpression() != null) {
            node.getExpression().visit(visitor);
        }
    }

    public static void walkExistsOrNonemptyCondition(Visitor visitor, Tree.ExistsOrNonemptyCondition node) {
        Walker.walkCondition(visitor, node);
        if (node.getVariable() != null) {
            node.getVariable().visit(visitor);
        }
        if (node.getBrokenExpression() != null) {
            node.getBrokenExpression().visit(visitor);
        }
    }

    public static void walkExistsCondition(Visitor visitor, Tree.ExistsCondition node) {
        Walker.walkExistsOrNonemptyCondition(visitor, node);
    }

    public static void walkNonemptyCondition(Visitor visitor, Tree.NonemptyCondition node) {
        Walker.walkExistsOrNonemptyCondition(visitor, node);
    }

    public static void walkIsCondition(Visitor visitor, Tree.IsCondition node) {
        Walker.walkCondition(visitor, node);
        if (node.getType() != null) {
            node.getType().visit(visitor);
        }
        if (node.getVariable() != null) {
            node.getVariable().visit(visitor);
        }
    }

    public static void walkSatisfiesCondition(Visitor visitor, Tree.SatisfiesCondition node) {
        Walker.walkCondition(visitor, node);
        if (node.getType() != null) {
            node.getType().visit(visitor);
        }
        if (node.getIdentifier() != null) {
            node.getIdentifier().visit(visitor);
        }
    }

    public static void walkVariable(Visitor visitor, Tree.Variable node) {
        Walker.walkTypedDeclaration(visitor, node);
        List<Tree.ParameterList> ParameterLists = node.getParameterLists();
        int l = ParameterLists.size();
        for (int i = 0; i < l; ++i) {
            Tree.ParameterList subnode = ParameterLists.get(i);
            subnode.visit(visitor);
        }
        if (node.getSpecifierExpression() != null) {
            node.getSpecifierExpression().visit(visitor);
        }
    }

    public static void walkTerm(Visitor visitor, Tree.Term node) {
    }

    public static void walkOperatorExpression(Visitor visitor, Tree.OperatorExpression node) {
        Walker.walkTerm(visitor, node);
    }

    public static void walkBinaryOperatorExpression(Visitor visitor, Tree.BinaryOperatorExpression node) {
        Walker.walkOperatorExpression(visitor, node);
        if (node.getLeftTerm() != null) {
            node.getLeftTerm().visit(visitor);
        }
        if (node.getRightTerm() != null) {
            node.getRightTerm().visit(visitor);
        }
    }

    public static void walkArithmeticOp(Visitor visitor, Tree.ArithmeticOp node) {
        Walker.walkBinaryOperatorExpression(visitor, node);
    }

    public static void walkSumOp(Visitor visitor, Tree.SumOp node) {
        Walker.walkArithmeticOp(visitor, node);
    }

    public static void walkDifferenceOp(Visitor visitor, Tree.DifferenceOp node) {
        Walker.walkArithmeticOp(visitor, node);
    }

    public static void walkProductOp(Visitor visitor, Tree.ProductOp node) {
        Walker.walkArithmeticOp(visitor, node);
    }

    public static void walkQuotientOp(Visitor visitor, Tree.QuotientOp node) {
        Walker.walkArithmeticOp(visitor, node);
    }

    public static void walkPowerOp(Visitor visitor, Tree.PowerOp node) {
        Walker.walkArithmeticOp(visitor, node);
    }

    public static void walkRemainderOp(Visitor visitor, Tree.RemainderOp node) {
        Walker.walkArithmeticOp(visitor, node);
    }

    public static void walkAssignmentOp(Visitor visitor, Tree.AssignmentOp node) {
        Walker.walkBinaryOperatorExpression(visitor, node);
    }

    public static void walkAssignOp(Visitor visitor, Tree.AssignOp node) {
        Walker.walkAssignmentOp(visitor, node);
    }

    public static void walkArithmeticAssignmentOp(Visitor visitor, Tree.ArithmeticAssignmentOp node) {
        Walker.walkAssignmentOp(visitor, node);
    }

    public static void walkAddAssignOp(Visitor visitor, Tree.AddAssignOp node) {
        Walker.walkArithmeticAssignmentOp(visitor, node);
    }

    public static void walkSubtractAssignOp(Visitor visitor, Tree.SubtractAssignOp node) {
        Walker.walkArithmeticAssignmentOp(visitor, node);
    }

    public static void walkMultiplyAssignOp(Visitor visitor, Tree.MultiplyAssignOp node) {
        Walker.walkArithmeticAssignmentOp(visitor, node);
    }

    public static void walkDivideAssignOp(Visitor visitor, Tree.DivideAssignOp node) {
        Walker.walkArithmeticAssignmentOp(visitor, node);
    }

    public static void walkRemainderAssignOp(Visitor visitor, Tree.RemainderAssignOp node) {
        Walker.walkArithmeticAssignmentOp(visitor, node);
    }

    public static void walkBitwiseAssignmentOp(Visitor visitor, Tree.BitwiseAssignmentOp node) {
        Walker.walkAssignmentOp(visitor, node);
    }

    public static void walkIntersectAssignOp(Visitor visitor, Tree.IntersectAssignOp node) {
        Walker.walkBitwiseAssignmentOp(visitor, node);
    }

    public static void walkUnionAssignOp(Visitor visitor, Tree.UnionAssignOp node) {
        Walker.walkBitwiseAssignmentOp(visitor, node);
    }

    public static void walkComplementAssignOp(Visitor visitor, Tree.ComplementAssignOp node) {
        Walker.walkBitwiseAssignmentOp(visitor, node);
    }

    public static void walkLogicalAssignmentOp(Visitor visitor, Tree.LogicalAssignmentOp node) {
        Walker.walkAssignmentOp(visitor, node);
    }

    public static void walkAndAssignOp(Visitor visitor, Tree.AndAssignOp node) {
        Walker.walkLogicalAssignmentOp(visitor, node);
    }

    public static void walkOrAssignOp(Visitor visitor, Tree.OrAssignOp node) {
        Walker.walkLogicalAssignmentOp(visitor, node);
    }

    public static void walkLogicalOp(Visitor visitor, Tree.LogicalOp node) {
        Walker.walkBinaryOperatorExpression(visitor, node);
    }

    public static void walkAndOp(Visitor visitor, Tree.AndOp node) {
        Walker.walkLogicalOp(visitor, node);
    }

    public static void walkOrOp(Visitor visitor, Tree.OrOp node) {
        Walker.walkLogicalOp(visitor, node);
    }

    public static void walkBitwiseOp(Visitor visitor, Tree.BitwiseOp node) {
        Walker.walkBinaryOperatorExpression(visitor, node);
    }

    public static void walkIntersectionOp(Visitor visitor, Tree.IntersectionOp node) {
        Walker.walkBitwiseOp(visitor, node);
    }

    public static void walkUnionOp(Visitor visitor, Tree.UnionOp node) {
        Walker.walkBitwiseOp(visitor, node);
    }

    public static void walkComplementOp(Visitor visitor, Tree.ComplementOp node) {
        Walker.walkBitwiseOp(visitor, node);
    }

    public static void walkEqualityOp(Visitor visitor, Tree.EqualityOp node) {
        Walker.walkBinaryOperatorExpression(visitor, node);
    }

    public static void walkEqualOp(Visitor visitor, Tree.EqualOp node) {
        Walker.walkEqualityOp(visitor, node);
    }

    public static void walkNotEqualOp(Visitor visitor, Tree.NotEqualOp node) {
        Walker.walkEqualityOp(visitor, node);
    }

    public static void walkComparisonOp(Visitor visitor, Tree.ComparisonOp node) {
        Walker.walkBinaryOperatorExpression(visitor, node);
    }

    public static void walkLargerOp(Visitor visitor, Tree.LargerOp node) {
        Walker.walkComparisonOp(visitor, node);
    }

    public static void walkSmallerOp(Visitor visitor, Tree.SmallerOp node) {
        Walker.walkComparisonOp(visitor, node);
    }

    public static void walkLargeAsOp(Visitor visitor, Tree.LargeAsOp node) {
        Walker.walkComparisonOp(visitor, node);
    }

    public static void walkSmallAsOp(Visitor visitor, Tree.SmallAsOp node) {
        Walker.walkComparisonOp(visitor, node);
    }

    public static void walkScaleOp(Visitor visitor, Tree.ScaleOp node) {
        Walker.walkBinaryOperatorExpression(visitor, node);
    }

    public static void walkBound(Visitor visitor, Tree.Bound node) {
        Walker.walkTerm(visitor, node);
        if (node.getTerm() != null) {
            node.getTerm().visit(visitor);
        }
    }

    public static void walkOpenBound(Visitor visitor, Tree.OpenBound node) {
        Walker.walkBound(visitor, node);
    }

    public static void walkClosedBound(Visitor visitor, Tree.ClosedBound node) {
        Walker.walkBound(visitor, node);
    }

    public static void walkWithinOp(Visitor visitor, Tree.WithinOp node) {
        Walker.walkOperatorExpression(visitor, node);
        if (node.getUpperBound() != null) {
            node.getUpperBound().visit(visitor);
        }
        if (node.getLowerBound() != null) {
            node.getLowerBound().visit(visitor);
        }
        if (node.getTerm() != null) {
            node.getTerm().visit(visitor);
        }
    }

    public static void walkDefaultOp(Visitor visitor, Tree.DefaultOp node) {
        Walker.walkBinaryOperatorExpression(visitor, node);
    }

    public static void walkThenOp(Visitor visitor, Tree.ThenOp node) {
        Walker.walkBinaryOperatorExpression(visitor, node);
    }

    public static void walkIdenticalOp(Visitor visitor, Tree.IdenticalOp node) {
        Walker.walkBinaryOperatorExpression(visitor, node);
    }

    public static void walkEntryOp(Visitor visitor, Tree.EntryOp node) {
        Walker.walkBinaryOperatorExpression(visitor, node);
    }

    public static void walkRangeOp(Visitor visitor, Tree.RangeOp node) {
        Walker.walkBinaryOperatorExpression(visitor, node);
    }

    public static void walkSegmentOp(Visitor visitor, Tree.SegmentOp node) {
        Walker.walkBinaryOperatorExpression(visitor, node);
    }

    public static void walkCompareOp(Visitor visitor, Tree.CompareOp node) {
        Walker.walkBinaryOperatorExpression(visitor, node);
    }

    public static void walkInOp(Visitor visitor, Tree.InOp node) {
        Walker.walkBinaryOperatorExpression(visitor, node);
    }

    public static void walkUnaryOperatorExpression(Visitor visitor, Tree.UnaryOperatorExpression node) {
        Walker.walkOperatorExpression(visitor, node);
        if (node.getTerm() != null) {
            node.getTerm().visit(visitor);
        }
    }

    public static void walkNotOp(Visitor visitor, Tree.NotOp node) {
        Walker.walkUnaryOperatorExpression(visitor, node);
    }

    public static void walkExists(Visitor visitor, Tree.Exists node) {
        Walker.walkUnaryOperatorExpression(visitor, node);
    }

    public static void walkNonempty(Visitor visitor, Tree.Nonempty node) {
        Walker.walkUnaryOperatorExpression(visitor, node);
    }

    public static void walkNegativeOp(Visitor visitor, Tree.NegativeOp node) {
        Walker.walkUnaryOperatorExpression(visitor, node);
    }

    public static void walkPositiveOp(Visitor visitor, Tree.PositiveOp node) {
        Walker.walkUnaryOperatorExpression(visitor, node);
    }

    public static void walkTypeOperatorExpression(Visitor visitor, Tree.TypeOperatorExpression node) {
        Walker.walkUnaryOperatorExpression(visitor, node);
        if (node.getType() != null) {
            node.getType().visit(visitor);
        }
    }

    public static void walkIsOp(Visitor visitor, Tree.IsOp node) {
        Walker.walkTypeOperatorExpression(visitor, node);
    }

    public static void walkSatisfies(Visitor visitor, Tree.Satisfies node) {
        Walker.walkTypeOperatorExpression(visitor, node);
    }

    public static void walkExtends(Visitor visitor, Tree.Extends node) {
        Walker.walkTypeOperatorExpression(visitor, node);
    }

    public static void walkOfOp(Visitor visitor, Tree.OfOp node) {
        Walker.walkTypeOperatorExpression(visitor, node);
    }

    public static void walkPrefixOperatorExpression(Visitor visitor, Tree.PrefixOperatorExpression node) {
        Walker.walkUnaryOperatorExpression(visitor, node);
    }

    public static void walkIncrementOp(Visitor visitor, Tree.IncrementOp node) {
        Walker.walkPrefixOperatorExpression(visitor, node);
    }

    public static void walkDecrementOp(Visitor visitor, Tree.DecrementOp node) {
        Walker.walkPrefixOperatorExpression(visitor, node);
    }

    public static void walkPostfixOperatorExpression(Visitor visitor, Tree.PostfixOperatorExpression node) {
        Walker.walkUnaryOperatorExpression(visitor, node);
    }

    public static void walkPostfixIncrementOp(Visitor visitor, Tree.PostfixIncrementOp node) {
        Walker.walkPostfixOperatorExpression(visitor, node);
    }

    public static void walkPostfixDecrementOp(Visitor visitor, Tree.PostfixDecrementOp node) {
        Walker.walkPostfixOperatorExpression(visitor, node);
    }

    public static void walkExpressionList(Visitor visitor, Tree.ExpressionList node) {
        List<Tree.Expression> Expressions = node.getExpressions();
        int l = Expressions.size();
        for (int i = 0; i < l; ++i) {
            Tree.Expression subnode = Expressions.get(i);
            subnode.visit(visitor);
        }
    }

    public static void walkExpression(Visitor visitor, Tree.Expression node) {
        Walker.walkAtom(visitor, node);
        if (node.getTerm() != null) {
            node.getTerm().visit(visitor);
        }
    }

    public static void walkParExpression(Visitor visitor, Tree.ParExpression node) {
        Walker.walkExpression(visitor, node);
    }

    public static void walkPrimary(Visitor visitor, Tree.Primary node) {
        Walker.walkTerm(visitor, node);
    }

    public static void walkPostfixExpression(Visitor visitor, Tree.PostfixExpression node) {
        Walker.walkPrimary(visitor, node);
        if (node.getPrimary() != null) {
            node.getPrimary().visit(visitor);
        }
    }

    public static void walkInvocationExpression(Visitor visitor, Tree.InvocationExpression node) {
        Walker.walkPostfixExpression(visitor, node);
        if (node.getPositionalArgumentList() != null) {
            node.getPositionalArgumentList().visit(visitor);
        }
        if (node.getNamedArgumentList() != null) {
            node.getNamedArgumentList().visit(visitor);
        }
    }

    public static void walkParameterizedExpression(Visitor visitor, Tree.ParameterizedExpression node) {
        Walker.walkPrimary(visitor, node);
        if (node.getPrimary() != null) {
            node.getPrimary().visit(visitor);
        }
        if (node.getTypeParameterList() != null) {
            node.getTypeParameterList().visit(visitor);
        }
        List<Tree.ParameterList> ParameterLists = node.getParameterLists();
        int l = ParameterLists.size();
        for (int i = 0; i < l; ++i) {
            Tree.ParameterList subnode = ParameterLists.get(i);
            subnode.visit(visitor);
        }
    }

    public static void walkMemberOrTypeExpression(Visitor visitor, Tree.MemberOrTypeExpression node) {
        Walker.walkPrimary(visitor, node);
    }

    public static void walkExtendedTypeExpression(Visitor visitor, Tree.ExtendedTypeExpression node) {
        Walker.walkMemberOrTypeExpression(visitor, node);
    }

    public static void walkStaticMemberOrTypeExpression(Visitor visitor, Tree.StaticMemberOrTypeExpression node) {
        Walker.walkMemberOrTypeExpression(visitor, node);
        if (node.getIdentifier() != null) {
            node.getIdentifier().visit(visitor);
        }
        if (node.getTypeArguments() != null) {
            node.getTypeArguments().visit(visitor);
        }
    }

    public static void walkBaseMemberOrTypeExpression(Visitor visitor, Tree.BaseMemberOrTypeExpression node) {
        Walker.walkStaticMemberOrTypeExpression(visitor, node);
    }

    public static void walkBaseMemberExpression(Visitor visitor, Tree.BaseMemberExpression node) {
        Walker.walkBaseMemberOrTypeExpression(visitor, node);
    }

    public static void walkBaseTypeExpression(Visitor visitor, Tree.BaseTypeExpression node) {
        Walker.walkBaseMemberOrTypeExpression(visitor, node);
    }

    public static void walkQualifiedMemberOrTypeExpression(Visitor visitor, Tree.QualifiedMemberOrTypeExpression node) {
        Walker.walkStaticMemberOrTypeExpression(visitor, node);
        if (node.getPrimary() != null) {
            node.getPrimary().visit(visitor);
        }
        if (node.getMemberOperator() != null) {
            node.getMemberOperator().visit(visitor);
        }
    }

    public static void walkQualifiedMemberExpression(Visitor visitor, Tree.QualifiedMemberExpression node) {
        Walker.walkQualifiedMemberOrTypeExpression(visitor, node);
    }

    public static void walkQualifiedTypeExpression(Visitor visitor, Tree.QualifiedTypeExpression node) {
        Walker.walkQualifiedMemberOrTypeExpression(visitor, node);
    }

    public static void walkMemberOperator(Visitor visitor, Tree.MemberOperator node) {
    }

    public static void walkMemberOp(Visitor visitor, Tree.MemberOp node) {
        Walker.walkMemberOperator(visitor, node);
    }

    public static void walkSafeMemberOp(Visitor visitor, Tree.SafeMemberOp node) {
        Walker.walkMemberOperator(visitor, node);
    }

    public static void walkSpreadOp(Visitor visitor, Tree.SpreadOp node) {
        Walker.walkMemberOperator(visitor, node);
    }

    public static void walkIndexExpression(Visitor visitor, Tree.IndexExpression node) {
        Walker.walkPostfixExpression(visitor, node);
        if (node.getElementOrRange() != null) {
            node.getElementOrRange().visit(visitor);
        }
    }

    public static void walkElementOrRange(Visitor visitor, Tree.ElementOrRange node) {
    }

    public static void walkElement(Visitor visitor, Tree.Element node) {
        Walker.walkElementOrRange(visitor, node);
        if (node.getExpression() != null) {
            node.getExpression().visit(visitor);
        }
    }

    public static void walkElementRange(Visitor visitor, Tree.ElementRange node) {
        Walker.walkElementOrRange(visitor, node);
        if (node.getLowerBound() != null) {
            node.getLowerBound().visit(visitor);
        }
        if (node.getUpperBound() != null) {
            node.getUpperBound().visit(visitor);
        }
        if (node.getLength() != null) {
            node.getLength().visit(visitor);
        }
    }

    public static void walkOuter(Visitor visitor, Tree.Outer node) {
        Walker.walkAtom(visitor, node);
    }

    public static void walkPackage(Visitor visitor, Tree.Package node) {
        Walker.walkAtom(visitor, node);
    }

    public static void walkArgumentList(Visitor visitor, Tree.ArgumentList node) {
    }

    public static void walkNamedArgumentList(Visitor visitor, Tree.NamedArgumentList node) {
        Walker.walkArgumentList(visitor, node);
        List<Tree.NamedArgument> NamedArguments = node.getNamedArguments();
        int l = NamedArguments.size();
        for (int i = 0; i < l; ++i) {
            Tree.NamedArgument subnode = NamedArguments.get(i);
            subnode.visit(visitor);
        }
        if (node.getSequencedArgument() != null) {
            node.getSequencedArgument().visit(visitor);
        }
    }

    public static void walkSequencedArgument(Visitor visitor, Tree.SequencedArgument node) {
        Walker.walkStatementOrArgument(visitor, node);
        List<Tree.PositionalArgument> PositionalArguments = node.getPositionalArguments();
        int l = PositionalArguments.size();
        for (int i = 0; i < l; ++i) {
            Tree.PositionalArgument subnode = PositionalArguments.get(i);
            subnode.visit(visitor);
        }
    }

    public static void walkPositionalArgumentList(Visitor visitor, Tree.PositionalArgumentList node) {
        Walker.walkArgumentList(visitor, node);
        List<Tree.PositionalArgument> PositionalArguments = node.getPositionalArguments();
        int l = PositionalArguments.size();
        for (int i = 0; i < l; ++i) {
            Tree.PositionalArgument subnode = PositionalArguments.get(i);
            subnode.visit(visitor);
        }
    }

    public static void walkPositionalArgument(Visitor visitor, Tree.PositionalArgument node) {
    }

    public static void walkListedArgument(Visitor visitor, Tree.ListedArgument node) {
        Walker.walkPositionalArgument(visitor, node);
        if (node.getExpression() != null) {
            node.getExpression().visit(visitor);
        }
    }

    public static void walkSpreadArgument(Visitor visitor, Tree.SpreadArgument node) {
        Walker.walkPositionalArgument(visitor, node);
        if (node.getExpression() != null) {
            node.getExpression().visit(visitor);
        }
    }

    public static void walkFunctionArgument(Visitor visitor, Tree.FunctionArgument node) {
        Walker.walkTerm(visitor, node);
        if (node.getType() != null) {
            node.getType().visit(visitor);
        }
        if (node.getTypeParameterList() != null) {
            node.getTypeParameterList().visit(visitor);
        }
        List<Tree.ParameterList> ParameterLists = node.getParameterLists();
        int l = ParameterLists.size();
        for (int i = 0; i < l; ++i) {
            Tree.ParameterList subnode = ParameterLists.get(i);
            subnode.visit(visitor);
        }
        if (node.getTypeConstraintList() != null) {
            node.getTypeConstraintList().visit(visitor);
        }
        if (node.getExpression() != null) {
            node.getExpression().visit(visitor);
        }
        if (node.getBlock() != null) {
            node.getBlock().visit(visitor);
        }
    }

    public static void walkObjectExpression(Visitor visitor, Tree.ObjectExpression node) {
        Walker.walkPrimary(visitor, node);
        if (node.getExtendedType() != null) {
            node.getExtendedType().visit(visitor);
        }
        if (node.getSatisfiedTypes() != null) {
            node.getSatisfiedTypes().visit(visitor);
        }
        if (node.getClassBody() != null) {
            node.getClassBody().visit(visitor);
        }
    }

    public static void walkIfExpression(Visitor visitor, Tree.IfExpression node) {
        Walker.walkTerm(visitor, node);
        if (node.getIfClause() != null) {
            node.getIfClause().visit(visitor);
        }
        if (node.getElseClause() != null) {
            node.getElseClause().visit(visitor);
        }
    }

    public static void walkSwitchExpression(Visitor visitor, Tree.SwitchExpression node) {
        Walker.walkTerm(visitor, node);
        if (node.getSwitchClause() != null) {
            node.getSwitchClause().visit(visitor);
        }
        if (node.getSwitchCaseList() != null) {
            node.getSwitchCaseList().visit(visitor);
        }
    }

    public static void walkNamedArgument(Visitor visitor, Tree.NamedArgument node) {
        Walker.walkStatementOrArgument(visitor, node);
        if (node.getIdentifier() != null) {
            node.getIdentifier().visit(visitor);
        }
    }

    public static void walkSpecifiedArgument(Visitor visitor, Tree.SpecifiedArgument node) {
        Walker.walkNamedArgument(visitor, node);
        if (node.getSpecifierExpression() != null) {
            node.getSpecifierExpression().visit(visitor);
        }
    }

    public static void walkTypedArgument(Visitor visitor, Tree.TypedArgument node) {
        Walker.walkNamedArgument(visitor, node);
        if (node.getType() != null) {
            node.getType().visit(visitor);
        }
    }

    public static void walkMethodArgument(Visitor visitor, Tree.MethodArgument node) {
        Walker.walkTypedArgument(visitor, node);
        if (node.getTypeParameterList() != null) {
            node.getTypeParameterList().visit(visitor);
        }
        List<Tree.ParameterList> ParameterLists = node.getParameterLists();
        int l = ParameterLists.size();
        for (int i = 0; i < l; ++i) {
            Tree.ParameterList subnode = ParameterLists.get(i);
            subnode.visit(visitor);
        }
        if (node.getBlock() != null) {
            node.getBlock().visit(visitor);
        }
        if (node.getSpecifierExpression() != null) {
            node.getSpecifierExpression().visit(visitor);
        }
    }

    public static void walkAttributeArgument(Visitor visitor, Tree.AttributeArgument node) {
        Walker.walkTypedArgument(visitor, node);
        if (node.getBlock() != null) {
            node.getBlock().visit(visitor);
        }
        if (node.getSpecifierExpression() != null) {
            node.getSpecifierExpression().visit(visitor);
        }
    }

    public static void walkObjectArgument(Visitor visitor, Tree.ObjectArgument node) {
        Walker.walkTypedArgument(visitor, node);
        if (node.getExtendedType() != null) {
            node.getExtendedType().visit(visitor);
        }
        if (node.getSatisfiedTypes() != null) {
            node.getSatisfiedTypes().visit(visitor);
        }
        if (node.getClassBody() != null) {
            node.getClassBody().visit(visitor);
        }
    }

    public static void walkSpecifierOrInitializerExpression(Visitor visitor, Tree.SpecifierOrInitializerExpression node) {
        if (node.getExpression() != null) {
            node.getExpression().visit(visitor);
        }
    }

    public static void walkSpecifierExpression(Visitor visitor, Tree.SpecifierExpression node) {
        Walker.walkSpecifierOrInitializerExpression(visitor, node);
    }

    public static void walkLazySpecifierExpression(Visitor visitor, Tree.LazySpecifierExpression node) {
        Walker.walkSpecifierExpression(visitor, node);
    }

    public static void walkInitializerExpression(Visitor visitor, Tree.InitializerExpression node) {
        Walker.walkSpecifierOrInitializerExpression(visitor, node);
    }

    public static void walkAtom(Visitor visitor, Tree.Atom node) {
        Walker.walkPrimary(visitor, node);
    }

    public static void walkLiteral(Visitor visitor, Tree.Literal node) {
        Walker.walkAtom(visitor, node);
    }

    public static void walkNaturalLiteral(Visitor visitor, Tree.NaturalLiteral node) {
        Walker.walkLiteral(visitor, node);
    }

    public static void walkFloatLiteral(Visitor visitor, Tree.FloatLiteral node) {
        Walker.walkLiteral(visitor, node);
    }

    public static void walkCharLiteral(Visitor visitor, Tree.CharLiteral node) {
        Walker.walkLiteral(visitor, node);
    }

    public static void walkStringLiteral(Visitor visitor, Tree.StringLiteral node) {
        Walker.walkLiteral(visitor, node);
        List<Tree.DocLink> DocLinks = node.getDocLinks();
        int l = DocLinks.size();
        for (int i = 0; i < l; ++i) {
            Tree.DocLink subnode = DocLinks.get(i);
            subnode.visit(visitor);
        }
    }

    public static void walkQuotedLiteral(Visitor visitor, Tree.QuotedLiteral node) {
        Walker.walkLiteral(visitor, node);
    }

    public static void walkDocLink(Visitor visitor, Tree.DocLink node) {
    }

    public static void walkSelfExpression(Visitor visitor, Tree.SelfExpression node) {
        Walker.walkAtom(visitor, node);
    }

    public static void walkThis(Visitor visitor, Tree.This node) {
        Walker.walkSelfExpression(visitor, node);
    }

    public static void walkSuper(Visitor visitor, Tree.Super node) {
        Walker.walkSelfExpression(visitor, node);
    }

    public static void walkSequenceEnumeration(Visitor visitor, Tree.SequenceEnumeration node) {
        Walker.walkAtom(visitor, node);
        if (node.getSequencedArgument() != null) {
            node.getSequencedArgument().visit(visitor);
        }
        List<Tree.Statement> Statements = node.getStatements();
        int l = Statements.size();
        for (int i = 0; i < l; ++i) {
            Tree.Statement subnode = Statements.get(i);
            subnode.visit(visitor);
        }
    }

    public static void walkTuple(Visitor visitor, Tree.Tuple node) {
        Walker.walkAtom(visitor, node);
        if (node.getSequencedArgument() != null) {
            node.getSequencedArgument().visit(visitor);
        }
    }

    public static void walkDynamic(Visitor visitor, Tree.Dynamic node) {
        Walker.walkAtom(visitor, node);
        if (node.getNamedArgumentList() != null) {
            node.getNamedArgumentList().visit(visitor);
        }
    }

    public static void walkStringTemplate(Visitor visitor, Tree.StringTemplate node) {
        Walker.walkAtom(visitor, node);
        List<Tree.StringLiteral> StringLiterals = node.getStringLiterals();
        int l = StringLiterals.size();
        for (int i = 0; i < l; ++i) {
            Tree.StringLiteral subnode = StringLiterals.get(i);
            subnode.visit(visitor);
        }
        List<Tree.Expression> Expressions = node.getExpressions();
        int l2 = Expressions.size();
        for (int i = 0; i < l2; ++i) {
            Tree.Expression subnode = Expressions.get(i);
            subnode.visit(visitor);
        }
    }

    public static void walkAnnotation(Visitor visitor, Tree.Annotation node) {
        Walker.walkInvocationExpression(visitor, node);
    }

    public static void walkAnonymousAnnotation(Visitor visitor, Tree.AnonymousAnnotation node) {
        if (node.getStringLiteral() != null) {
            node.getStringLiteral().visit(visitor);
        }
        if (node.getStringTemplate() != null) {
            node.getStringTemplate().visit(visitor);
        }
    }

    public static void walkAnnotationList(Visitor visitor, Tree.AnnotationList node) {
        if (node.getAnonymousAnnotation() != null) {
            node.getAnonymousAnnotation().visit(visitor);
        }
        List<Tree.Annotation> Annotations2 = node.getAnnotations();
        int l = Annotations2.size();
        for (int i = 0; i < l; ++i) {
            Tree.Annotation subnode = Annotations2.get(i);
            subnode.visit(visitor);
        }
    }

    public static void walkIdentifier(Visitor visitor, Tree.Identifier node) {
    }

    public static void walkComprehension(Visitor visitor, Tree.Comprehension node) {
        Walker.walkPositionalArgument(visitor, node);
        if (node.getInitialComprehensionClause() != null) {
            node.getInitialComprehensionClause().visit(visitor);
        }
    }

    public static void walkComprehensionClause(Visitor visitor, Tree.ComprehensionClause node) {
        Walker.walkControlClause(visitor, node);
    }

    public static void walkInitialComprehensionClause(Visitor visitor, Tree.InitialComprehensionClause node) {
        Walker.walkComprehensionClause(visitor, node);
    }

    public static void walkExpressionComprehensionClause(Visitor visitor, Tree.ExpressionComprehensionClause node) {
        Walker.walkComprehensionClause(visitor, node);
        if (node.getExpression() != null) {
            node.getExpression().visit(visitor);
        }
    }

    public static void walkForComprehensionClause(Visitor visitor, Tree.ForComprehensionClause node) {
        Walker.walkInitialComprehensionClause(visitor, node);
        if (node.getForIterator() != null) {
            node.getForIterator().visit(visitor);
        }
        if (node.getComprehensionClause() != null) {
            node.getComprehensionClause().visit(visitor);
        }
    }

    public static void walkIfComprehensionClause(Visitor visitor, Tree.IfComprehensionClause node) {
        Walker.walkInitialComprehensionClause(visitor, node);
        if (node.getConditionList() != null) {
            node.getConditionList().visit(visitor);
        }
        if (node.getComprehensionClause() != null) {
            node.getComprehensionClause().visit(visitor);
        }
    }
}

