/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.util;

import com.redhat.ceylon.common.OSUtil;
import com.redhat.ceylon.compiler.typechecker.analyzer.AnalysisError;
import com.redhat.ceylon.compiler.typechecker.analyzer.UnsupportedError;
import com.redhat.ceylon.compiler.typechecker.analyzer.UsageWarning;
import com.redhat.ceylon.compiler.typechecker.parser.LexError;
import com.redhat.ceylon.compiler.typechecker.parser.ParseError;
import com.redhat.ceylon.compiler.typechecker.tree.AnalysisMessage;
import com.redhat.ceylon.compiler.typechecker.tree.Message;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.UnexpectedError;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.Unit;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class AssertionVisitor
extends Visitor {
    private boolean expectingError = false;
    private String errorMessage;
    private boolean expectingWarning = false;
    private String warningType;
    private List<Message> foundErrors = new ArrayList<Message>();
    private int errors = 0;
    private int warnings = 0;
    private boolean usageWarnings = false;
    boolean ignore;

    @Override
    public void visit(Tree.TypedDeclaration that) {
        if (that.getType() != null) {
            this.checkType(that, that.getType().getTypeModel(), that.getType());
        }
        super.visit(that);
    }

    @Override
    public void visit(Tree.ExpressionStatement that) {
        this.checkType(that, that.getExpression().getTypeModel(), that.getExpression());
        super.visit(that);
    }

    protected void checkType(Tree.Statement that, Type type, Node typedNode) {
        for (Tree.CompilerAnnotation c : that.getCompilerAnnotations()) {
            if (!c.getIdentifier().getText().equals("type")) continue;
            Tree.StringLiteral sl = c.getStringLiteral();
            if (sl == null) {
                this.out((Node)that, "missing asserted type");
                continue;
            }
            String expectedType = sl.getText().replace(" ", "");
            if (typedNode == null || type == null || type.getDeclaration() == null) {
                this.out((Node)that, "type not known");
                continue;
            }
            String actualType = type.asString(false).replace(" ", "");
            String abbreviatedActualType = type.asString().replace(" ", "");
            if (actualType.equals(expectedType) || abbreviatedActualType.equals(expectedType)) continue;
            String desc = "'" + abbreviatedActualType + "'";
            if (!actualType.equals(abbreviatedActualType)) {
                desc = desc + " ('" + actualType + "')";
            }
            this.out((Node)that, "type " + desc + " not of expected type '" + expectedType + "'");
        }
    }

    @Override
    public void visit(Tree.StatementOrArgument that) {
        if (this.ignore) {
            super.visit(that);
            return;
        }
        if (that instanceof Tree.Variable && ((Tree.Variable)that).getType() instanceof Tree.SyntheticVariable) {
            super.visit(that);
            return;
        }
        if (that instanceof Tree.ForIterator) {
            super.visit(that);
            return;
        }
        boolean b = this.expectingError;
        boolean c = this.expectingWarning;
        List<Message> f = this.foundErrors;
        this.expectingError = false;
        this.expectingWarning = false;
        this.errorMessage = null;
        this.warningType = null;
        this.foundErrors = new ArrayList<Message>();
        this.initExpectingError(that.getCompilerAnnotations());
        super.visit(that);
        this.checkErrors(that);
        this.expectingError = b;
        this.expectingWarning = c;
        this.errorMessage = null;
        this.warningType = null;
        this.foundErrors = f;
    }

    @Override
    public void visit(Tree.ParameterDeclaration that) {
        boolean b = this.expectingError;
        boolean c = this.expectingWarning;
        List<Message> f = this.foundErrors;
        this.expectingError = false;
        this.expectingWarning = false;
        this.errorMessage = null;
        this.warningType = null;
        this.foundErrors = new ArrayList<Message>();
        this.initExpectingError(that.getTypedDeclaration().getCompilerAnnotations());
        this.ignore = true;
        super.visit(that);
        this.ignore = false;
        this.checkErrors(that);
        this.expectingError = b;
        this.expectingWarning = c;
        this.errorMessage = null;
        this.warningType = null;
        this.foundErrors = f;
    }

    @Override
    public void visit(Tree.CompilationUnit that) {
        this.expectingError = false;
        this.expectingWarning = false;
        this.errorMessage = null;
        this.warningType = null;
        this.foundErrors = new ArrayList<Message>();
        this.initExpectingError(that.getCompilerAnnotations());
        this.foundErrors.addAll(that.getErrors());
        this.checkErrors(that);
        this.foundErrors = new ArrayList<Message>();
        this.expectingError = false;
        this.expectingWarning = false;
        this.errorMessage = null;
        this.warningType = null;
        super.visitAny(that);
    }

    protected void out(PrintStream ps, String level, String message, String at, String of) {
        StringBuffer buf = new StringBuffer();
        if (level != null) {
            if (level.contains("error")) {
                String red = OSUtil.color(level, OSUtil.Color.red);
                buf.append(red);
            } else if (level.contains("warning")) {
                String yellow = OSUtil.color(level, OSUtil.Color.yellow);
                buf.append(yellow);
            } else {
                buf.append(level);
            }
            buf.append(" [");
            buf.append(message);
            buf.append("]");
        } else {
            buf.append(message);
        }
        if (at != null) {
            buf.append(" at ");
            buf.append(at);
        }
        if (of != null) {
            buf.append(" of ");
            String blue = OSUtil.color(of, OSUtil.Color.blue);
            buf.append(blue);
        }
        ps.println(buf.toString());
    }

    protected void out(PrintStream ps, String level, AnalysisMessage err) {
        this.out(ps, level, err.getMessage(), err.getTreeNode().getLocation(), this.file(err.getTreeNode()));
    }

    protected void out(Node that, String message) {
        this.out(System.err, null, message, that.getLocation(), this.file(that));
    }

    protected void out(Node that, LexError err) {
        ++this.errors;
        this.out(System.err, "lex error", err.getMessage(), err.getHeader(), this.file(that));
    }

    protected void out(Node that, ParseError err) {
        ++this.errors;
        this.out(System.err, "parse error", err.getMessage(), err.getHeader(), this.file(that));
    }

    protected void out(UnexpectedError err) {
        ++this.errors;
        this.out(System.err, "unexpected error", err);
    }

    protected void out(AnalysisError err) {
        ++this.errors;
        this.out(System.err, "error", err);
    }

    protected void out(UnsupportedError err) {
        ++this.warnings;
        this.out(System.out, "warning", err);
    }

    protected void out(UsageWarning err) {
        this.out(System.out, "warning", err);
    }

    private String file(Node that) {
        Unit unit = that.getUnit();
        if (unit == null) {
            return null;
        }
        String relativePath = unit.getRelativePath();
        return !relativePath.isEmpty() ? relativePath : unit.getFilename();
    }

    private void checkErrors(Node that) {
        try {
            for (Message err : this.foundErrors) {
                if (!this.includeError(err, 1) || !(err instanceof UnexpectedError)) continue;
                this.out((UnexpectedError)err);
            }
            if (this.expectingError) {
                boolean found = false;
                for (Message err : this.foundErrors) {
                    if (!this.includeError(err, 2) || !(err instanceof AnalysisError) && !(err instanceof LexError) && !(err instanceof ParseError)) continue;
                    if (this.errorMessage == null || err.getMessage().contains(this.errorMessage)) {
                        return;
                    }
                    found = true;
                }
                if (found) {
                    this.out(that, "error message should contain \"" + this.errorMessage);
                } else {
                    this.out(that, "no errors");
                    return;
                }
            }
            if (this.expectingWarning) {
                boolean found = false;
                for (Message err : this.foundErrors) {
                    if (!this.includeError(err, 2) || !(err instanceof UsageWarning)) continue;
                    if (this.warningType == null || ((UsageWarning)err).getWarningName().equals(this.warningType)) {
                        return;
                    }
                    found = true;
                }
                if (found) {
                    this.out(that, "warning type should be \"" + this.warningType);
                } else {
                    this.out(that, "no warnings");
                    return;
                }
            }
            for (Message err : this.foundErrors) {
                if (!this.includeError(err, 3)) continue;
                if (err instanceof LexError) {
                    this.out(that, (LexError)err);
                    continue;
                }
                if (err instanceof ParseError) {
                    this.out(that, (ParseError)err);
                    continue;
                }
                if (err instanceof UnsupportedError) {
                    this.out((UnsupportedError)err);
                    continue;
                }
                if (err instanceof AnalysisError) {
                    this.out((AnalysisError)err);
                    continue;
                }
                if (!(err instanceof UsageWarning) || !this.usageWarnings) continue;
                this.out((UsageWarning)err);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void initExpectingError(List<Tree.CompilerAnnotation> annotations) {
        for (Tree.CompilerAnnotation c : annotations) {
            Tree.StringLiteral sl;
            if (c.getIdentifier().getText().equals("error")) {
                this.expectingError = true;
                sl = c.getStringLiteral();
                if (sl != null) {
                    this.errorMessage = sl.getText();
                }
            }
            if (!c.getIdentifier().getText().equals("warn")) continue;
            this.expectingWarning = true;
            sl = c.getStringLiteral();
            if (sl == null) continue;
            this.warningType = sl.getText();
        }
    }

    protected boolean includeError(Message err, int phase) {
        return true;
    }

    public void includeUsageWarnings(boolean usageWarnings) {
        this.usageWarnings = usageWarnings;
    }

    @Override
    public void visitAny(Node that) {
        this.foundErrors.addAll(that.getErrors());
        super.visitAny(that);
    }

    public void print(boolean verbose) {
        if (!verbose && this.errors == 0 && this.warnings == 0) {
            return;
        }
        System.out.println(this.errors + " errors, " + this.warnings + " warnings");
    }

    public List<Message> getFoundErrors() {
        return this.foundErrors;
    }

    public int getErrors() {
        return this.errors;
    }

    public int getWarnings() {
        return this.warnings;
    }
}

