/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.util;

import com.redhat.ceylon.compiler.typechecker.analyzer.UsageWarning;
import com.redhat.ceylon.compiler.typechecker.tree.Message;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.Reference;
import com.redhat.ceylon.model.typechecker.model.Type;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;

public class PrintVisitor
extends Visitor {
    int depth = 0;
    Writer stream;

    public PrintVisitor() {
        this.stream = new OutputStreamWriter(System.out);
    }

    public PrintVisitor(Writer w) {
        this.stream = w;
    }

    protected void print(String str) {
        try {
            this.stream.write(str);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    void newline() {
        this.print("\n");
    }

    void indent() {
        for (int i = 0; i < this.depth; ++i) {
            this.print("|  ");
        }
    }

    @Override
    public void visitAny(Node node) {
        if (this.depth > 0) {
            this.newline();
        }
        this.indent();
        this.print("+ ");
        this.print(node);
        ++this.depth;
        super.visitAny(node);
        --this.depth;
        if (this.depth == 0) {
            this.newline();
        }
        try {
            this.stream.flush();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private void print(Node node) {
        Parameter p;
        Declaration container;
        Declaration d;
        List<Type> types;
        Type type;
        this.print(node.getText());
        this.print(" [" + node.getNodeType() + "]");
        if (node.getToken() != null) {
            this.print(" (" + node.getLocation() + ")");
        }
        if (node instanceof Tree.Term && (type = ((Tree.Term)node).getTypeModel()) != null) {
            this.print(" : " + type.asString() + "");
        }
        if (node instanceof Tree.ComprehensionClause && (type = ((Tree.ComprehensionClause)node).getTypeModel()) != null) {
            this.print(" : " + type.asString() + "");
        }
        if (node instanceof Tree.Type && (type = ((Tree.Type)node).getTypeModel()) != null) {
            this.print(" : " + type.asString() + "");
        }
        if (node instanceof Tree.TypeArguments && (types = ((Tree.TypeArguments)node).getTypeModels()) != null && !types.isEmpty()) {
            this.print(" : <");
            int i = 0;
            for (Type pt : types) {
                if (pt != null) {
                    this.print(pt.asString());
                }
                if (++i == types.size()) continue;
                this.print(", ");
            }
            this.print(">");
        }
        if (node instanceof Tree.MemberOrTypeExpression) {
            Reference t = ((Tree.MemberOrTypeExpression)node).getTarget();
            Declaration d2 = ((Tree.MemberOrTypeExpression)node).getDeclaration();
            if (t != null) {
                this.print(" : " + t.asString() + "");
            }
            if (d2 != null) {
                this.print(" : " + d2);
            }
        }
        if (node instanceof Tree.Outer && (d = ((Tree.Outer)node).getDeclarationModel()) != null) {
            this.print(" : " + d);
        }
        if (node instanceof Tree.SelfExpression && (d = ((Tree.SelfExpression)node).getDeclarationModel()) != null) {
            this.print(" : " + d);
        }
        if (node instanceof Tree.Declaration && (d = ((Tree.Declaration)node).getDeclarationModel()) != null) {
            if (d.isCaptured() || d.isJsCaptured()) {
                this.print("[captured]");
            }
            this.print(" : " + d);
            Declaration rd = d.getRefinedDeclaration();
            if (rd != null && !rd.equals(d)) {
                container = (Declaration)((Object)rd.getContainer());
                this.print(" (refines " + container.getName() + "." + rd.getName() + ")");
            }
        }
        if (node instanceof Tree.SpecifierStatement) {
            Declaration rd;
            d = ((Tree.SpecifierStatement)node).getDeclaration();
            if (d != null) {
                this.print(" : " + d);
            }
            if (((Tree.SpecifierStatement)node).getRefinement() && (rd = d.getRefinedDeclaration()) != null && !rd.equals(d)) {
                container = (Declaration)((Object)rd.getContainer());
                this.print(" (refines " + container.getName() + "." + rd.getName() + ")");
            }
        }
        if (node instanceof Tree.SimpleType && (d = ((Tree.SimpleType)node).getDeclarationModel()) != null) {
            this.print(" : " + d);
        }
        if (node instanceof Tree.ImportMemberOrType && (d = ((Tree.ImportMemberOrType)node).getDeclarationModel()) != null) {
            this.print(" : " + d);
        }
        if (node instanceof Tree.Return && (d = ((Tree.Return)node).getDeclaration()) != null) {
            this.print(" : " + d);
        }
        if (node instanceof Tree.PositionalArgument && (p = ((Tree.PositionalArgument)node).getParameter()) != null) {
            this.print(" : " + p);
        }
        if (node instanceof Tree.NamedArgument && (p = ((Tree.NamedArgument)node).getParameter()) != null) {
            this.print(" : " + p);
        }
        if (node instanceof Tree.SequencedArgument && (p = ((Tree.SequencedArgument)node).getParameter()) != null) {
            this.print(" : " + p);
        }
        if (!node.getErrors().isEmpty()) {
            String icon = " [!]";
            for (Message e : node.getErrors()) {
                if (e instanceof UsageWarning) continue;
                icon = " [X]";
            }
            this.print(icon + node.getErrors());
        }
    }
}

