/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.javax.annotation.processing;

import com.redhat.ceylon.javax.annotation.processing.Completion;
import com.redhat.ceylon.javax.annotation.processing.ProcessingEnvironment;
import com.redhat.ceylon.javax.annotation.processing.Processor;
import com.redhat.ceylon.javax.annotation.processing.RoundEnvironment;
import com.redhat.ceylon.javax.annotation.processing.SupportedAnnotationTypes;
import com.redhat.ceylon.javax.annotation.processing.SupportedOptions;
import com.redhat.ceylon.javax.annotation.processing.SupportedSourceVersion;
import com.redhat.ceylon.javax.lang.model.SourceVersion;
import com.redhat.ceylon.javax.lang.model.element.AnnotationMirror;
import com.redhat.ceylon.javax.lang.model.element.Element;
import com.redhat.ceylon.javax.lang.model.element.ExecutableElement;
import com.redhat.ceylon.javax.lang.model.element.TypeElement;
import com.redhat.ceylon.javax.tools.Diagnostic;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractProcessor
implements Processor {
    protected ProcessingEnvironment processingEnv;
    private boolean initialized = false;

    protected AbstractProcessor() {
    }

    @Override
    public Set<String> getSupportedOptions() {
        SupportedOptions so = this.getClass().getAnnotation(SupportedOptions.class);
        if (so == null) {
            return Collections.emptySet();
        }
        return AbstractProcessor.arrayToSet(so.value());
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        SupportedAnnotationTypes sat = this.getClass().getAnnotation(SupportedAnnotationTypes.class);
        if (sat == null) {
            if (this.isInitialized()) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "No SupportedAnnotationTypes annotation found on " + this.getClass().getName() + ", returning an empty set.");
            }
            return Collections.emptySet();
        }
        return AbstractProcessor.arrayToSet(sat.value());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        SupportedSourceVersion ssv = this.getClass().getAnnotation(SupportedSourceVersion.class);
        SourceVersion sv = null;
        if (ssv == null) {
            sv = SourceVersion.RELEASE_6;
            if (this.isInitialized()) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "No SupportedSourceVersion annotation found on " + this.getClass().getName() + ", returning " + (Object)((Object)sv) + ".");
            }
        } else {
            sv = ssv.value();
        }
        return sv;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot call init more than once.");
        }
        Objects.requireNonNull(processingEnv, "Tool provided null ProcessingEnvironment");
        this.processingEnv = processingEnv;
        this.initialized = true;
    }

    @Override
    public abstract boolean process(Set<? extends TypeElement> var1, RoundEnvironment var2);

    @Override
    public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotation, ExecutableElement member, String userText) {
        return Collections.emptyList();
    }

    protected synchronized boolean isInitialized() {
        return this.initialized;
    }

    private static Set<String> arrayToSet(String[] array) {
        assert (array != null);
        HashSet<String> set = new HashSet<String>(array.length);
        for (String s : array) {
            set.add(s);
        }
        return Collections.unmodifiableSet(set);
    }
}

