/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.javax.tools;

import com.redhat.ceylon.javax.tools.JavaFileManager;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public enum StandardLocation implements JavaFileManager.Location
{
    CLASS_OUTPUT,
    SOURCE_OUTPUT,
    CLASS_PATH,
    SOURCE_PATH,
    ANNOTATION_PROCESSOR_PATH,
    PLATFORM_CLASS_PATH,
    NATIVE_HEADER_OUTPUT;

    private static final ConcurrentMap<String, JavaFileManager.Location> locations;

    public static JavaFileManager.Location locationFor(final String name) {
        if (locations.isEmpty()) {
            for (StandardLocation location : StandardLocation.values()) {
                locations.putIfAbsent(location.getName(), location);
            }
        }
        locations.putIfAbsent(name.toString(), new JavaFileManager.Location(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public boolean isOutputLocation() {
                return name.endsWith("_OUTPUT");
            }
        });
        return (JavaFileManager.Location)locations.get(name);
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public boolean isOutputLocation() {
        switch (this) {
            case CLASS_OUTPUT: 
            case SOURCE_OUTPUT: 
            case NATIVE_HEADER_OUTPUT: {
                return true;
            }
        }
        return false;
    }

    static {
        locations = new ConcurrentHashMap<String, JavaFileManager.Location>();
    }
}

