/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.langtools.classfile;

import com.redhat.ceylon.langtools.classfile.AccessFlags;
import com.redhat.ceylon.langtools.classfile.Attribute;
import com.redhat.ceylon.langtools.classfile.Attributes;
import com.redhat.ceylon.langtools.classfile.ClassReader;
import com.redhat.ceylon.langtools.classfile.ConstantPool;
import com.redhat.ceylon.langtools.classfile.ConstantPoolException;
import com.redhat.ceylon.langtools.classfile.Field;
import com.redhat.ceylon.langtools.classfile.Method;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class ClassFile {
    public final int magic;
    public final int minor_version;
    public final int major_version;
    public final ConstantPool constant_pool;
    public final AccessFlags access_flags;
    public final int this_class;
    public final int super_class;
    public final int[] interfaces;
    public final Field[] fields;
    public final Method[] methods;
    public final Attributes attributes;

    public static ClassFile read(File file) throws IOException, ConstantPoolException {
        return ClassFile.read(file.toPath(), new Attribute.Factory());
    }

    public static ClassFile read(Path input) throws IOException, ConstantPoolException {
        return ClassFile.read(input, new Attribute.Factory());
    }

    public static ClassFile read(Path input, Attribute.Factory attributeFactory) throws IOException, ConstantPoolException {
        try (InputStream in = Files.newInputStream(input, new OpenOption[0]);){
            ClassFile classFile = new ClassFile(in, attributeFactory);
            return classFile;
        }
    }

    public static ClassFile read(File file, Attribute.Factory attributeFactory) throws IOException, ConstantPoolException {
        return ClassFile.read(file.toPath(), attributeFactory);
    }

    public static ClassFile read(InputStream in) throws IOException, ConstantPoolException {
        return new ClassFile(in, new Attribute.Factory());
    }

    public static ClassFile read(InputStream in, Attribute.Factory attributeFactory) throws IOException, ConstantPoolException {
        return new ClassFile(in, attributeFactory);
    }

    ClassFile(InputStream in, Attribute.Factory attributeFactory) throws IOException, ConstantPoolException {
        ClassReader cr = new ClassReader(this, in, attributeFactory);
        this.magic = cr.readInt();
        this.minor_version = cr.readUnsignedShort();
        this.major_version = cr.readUnsignedShort();
        this.constant_pool = new ConstantPool(cr);
        this.access_flags = new AccessFlags(cr);
        this.this_class = cr.readUnsignedShort();
        this.super_class = cr.readUnsignedShort();
        int interfaces_count = cr.readUnsignedShort();
        this.interfaces = new int[interfaces_count];
        for (int i = 0; i < interfaces_count; ++i) {
            this.interfaces[i] = cr.readUnsignedShort();
        }
        int fields_count = cr.readUnsignedShort();
        this.fields = new Field[fields_count];
        for (int i = 0; i < fields_count; ++i) {
            this.fields[i] = new Field(cr);
        }
        int methods_count = cr.readUnsignedShort();
        this.methods = new Method[methods_count];
        for (int i = 0; i < methods_count; ++i) {
            this.methods[i] = new Method(cr);
        }
        this.attributes = new Attributes(cr);
    }

    public ClassFile(int magic, int minor_version, int major_version, ConstantPool constant_pool, AccessFlags access_flags, int this_class, int super_class, int[] interfaces, Field[] fields, Method[] methods, Attributes attributes) {
        this.magic = magic;
        this.minor_version = minor_version;
        this.major_version = major_version;
        this.constant_pool = constant_pool;
        this.access_flags = access_flags;
        this.this_class = this_class;
        this.super_class = super_class;
        this.interfaces = interfaces;
        this.fields = fields;
        this.methods = methods;
        this.attributes = attributes;
    }

    public String getName() throws ConstantPoolException {
        return this.constant_pool.getClassInfo(this.this_class).getName();
    }

    public String getSuperclassName() throws ConstantPoolException {
        return this.constant_pool.getClassInfo(this.super_class).getName();
    }

    public String getInterfaceName(int i) throws ConstantPoolException {
        return this.constant_pool.getClassInfo(this.interfaces[i]).getName();
    }

    public Attribute getAttribute(String name) {
        return this.attributes.get(name);
    }

    public boolean isClass() {
        return !this.isInterface();
    }

    public boolean isInterface() {
        return this.access_flags.is(512);
    }

    public int byteLength() {
        return 8 + this.constant_pool.byteLength() + 2 + 2 + 2 + this.byteLength(this.interfaces) + this.byteLength(this.fields) + this.byteLength(this.methods) + this.attributes.byteLength();
    }

    private int byteLength(int[] indices) {
        return 2 + 2 * indices.length;
    }

    private int byteLength(Field[] fields) {
        int length = 2;
        for (Field f : fields) {
            length += f.byteLength();
        }
        return length;
    }

    private int byteLength(Method[] methods) {
        int length = 2;
        for (Method m : methods) {
            length += m.byteLength();
        }
        return length;
    }
}

