/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.langtools.classfile;

import com.redhat.ceylon.langtools.classfile.ClassReader;
import com.redhat.ceylon.langtools.classfile.ConstantPoolException;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;

public class ConstantPool {
    public static final int CONSTANT_Utf8 = 1;
    public static final int CONSTANT_Integer = 3;
    public static final int CONSTANT_Float = 4;
    public static final int CONSTANT_Long = 5;
    public static final int CONSTANT_Double = 6;
    public static final int CONSTANT_Class = 7;
    public static final int CONSTANT_String = 8;
    public static final int CONSTANT_Fieldref = 9;
    public static final int CONSTANT_Methodref = 10;
    public static final int CONSTANT_InterfaceMethodref = 11;
    public static final int CONSTANT_NameAndType = 12;
    public static final int CONSTANT_MethodHandle = 15;
    public static final int CONSTANT_MethodType = 16;
    public static final int CONSTANT_InvokeDynamic = 18;
    public static final int CONSTANT_Module = 19;
    public static final int CONSTANT_Package = 20;
    private CPInfo[] pool;

    ConstantPool(ClassReader cr) throws IOException, InvalidEntry {
        int count = cr.readUnsignedShort();
        this.pool = new CPInfo[count];
        block18: for (int i = 1; i < count; ++i) {
            int tag = cr.readUnsignedByte();
            switch (tag) {
                case 7: {
                    this.pool[i] = new CONSTANT_Class_info(this, cr);
                    continue block18;
                }
                case 6: {
                    this.pool[i] = new CONSTANT_Double_info(cr);
                    ++i;
                    continue block18;
                }
                case 9: {
                    this.pool[i] = new CONSTANT_Fieldref_info(this, cr);
                    continue block18;
                }
                case 4: {
                    this.pool[i] = new CONSTANT_Float_info(cr);
                    continue block18;
                }
                case 3: {
                    this.pool[i] = new CONSTANT_Integer_info(cr);
                    continue block18;
                }
                case 11: {
                    this.pool[i] = new CONSTANT_InterfaceMethodref_info(this, cr);
                    continue block18;
                }
                case 18: {
                    this.pool[i] = new CONSTANT_InvokeDynamic_info(this, cr);
                    continue block18;
                }
                case 5: {
                    this.pool[i] = new CONSTANT_Long_info(cr);
                    ++i;
                    continue block18;
                }
                case 15: {
                    this.pool[i] = new CONSTANT_MethodHandle_info(this, cr);
                    continue block18;
                }
                case 16: {
                    this.pool[i] = new CONSTANT_MethodType_info(this, cr);
                    continue block18;
                }
                case 10: {
                    this.pool[i] = new CONSTANT_Methodref_info(this, cr);
                    continue block18;
                }
                case 19: {
                    this.pool[i] = new CONSTANT_Module_info(this, cr);
                    continue block18;
                }
                case 12: {
                    this.pool[i] = new CONSTANT_NameAndType_info(this, cr);
                    continue block18;
                }
                case 20: {
                    this.pool[i] = new CONSTANT_Package_info(this, cr);
                    continue block18;
                }
                case 8: {
                    this.pool[i] = new CONSTANT_String_info(this, cr);
                    continue block18;
                }
                case 1: {
                    this.pool[i] = new CONSTANT_Utf8_info(cr);
                    continue block18;
                }
                default: {
                    throw new InvalidEntry(i, tag);
                }
            }
        }
    }

    public ConstantPool(CPInfo[] pool) {
        this.pool = pool;
    }

    public int size() {
        return this.pool.length;
    }

    public int byteLength() {
        CPInfo cpInfo;
        int length = 2;
        for (int i = 1; i < this.size(); i += cpInfo.size()) {
            cpInfo = this.pool[i];
            length += cpInfo.byteLength();
        }
        return length;
    }

    public CPInfo get(int index) throws InvalidIndex {
        if (index <= 0 || index >= this.pool.length) {
            throw new InvalidIndex(index);
        }
        CPInfo info = this.pool[index];
        if (info == null) {
            throw new InvalidIndex(index);
        }
        return this.pool[index];
    }

    private CPInfo get(int index, int expected_type) throws InvalidIndex, UnexpectedEntry {
        CPInfo info = this.get(index);
        if (info.getTag() != expected_type) {
            throw new UnexpectedEntry(index, expected_type, info.getTag());
        }
        return info;
    }

    public CONSTANT_Utf8_info getUTF8Info(int index) throws InvalidIndex, UnexpectedEntry {
        return (CONSTANT_Utf8_info)this.get(index, 1);
    }

    public CONSTANT_Class_info getClassInfo(int index) throws InvalidIndex, UnexpectedEntry {
        return (CONSTANT_Class_info)this.get(index, 7);
    }

    public CONSTANT_Module_info getModuleInfo(int index) throws InvalidIndex, UnexpectedEntry {
        return (CONSTANT_Module_info)this.get(index, 19);
    }

    public CONSTANT_NameAndType_info getNameAndTypeInfo(int index) throws InvalidIndex, UnexpectedEntry {
        return (CONSTANT_NameAndType_info)this.get(index, 12);
    }

    public CONSTANT_Package_info getPackageInfo(int index) throws InvalidIndex, UnexpectedEntry {
        return (CONSTANT_Package_info)this.get(index, 20);
    }

    public String getUTF8Value(int index) throws InvalidIndex, UnexpectedEntry {
        return this.getUTF8Info((int)index).value;
    }

    public int getUTF8Index(String value) throws EntryNotFound {
        for (int i = 1; i < this.pool.length; ++i) {
            CPInfo info = this.pool[i];
            if (!(info instanceof CONSTANT_Utf8_info) || !((CONSTANT_Utf8_info)info).value.equals(value)) continue;
            return i;
        }
        throw new EntryNotFound((Object)value);
    }

    public Iterable<CPInfo> entries() {
        return new Iterable<CPInfo>(){

            @Override
            public Iterator<CPInfo> iterator() {
                return new Iterator<CPInfo>(){
                    private CPInfo current;
                    private int next = 1;

                    @Override
                    public boolean hasNext() {
                        return this.next < ConstantPool.this.pool.length;
                    }

                    @Override
                    public CPInfo next() {
                        this.current = ConstantPool.this.pool[this.next];
                        switch (this.current.getTag()) {
                            case 5: 
                            case 6: {
                                this.next += 2;
                                break;
                            }
                            default: {
                                ++this.next;
                            }
                        }
                        return this.current;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static class CONSTANT_Utf8_info
    extends CPInfo {
        public final String value;

        CONSTANT_Utf8_info(ClassReader cr) throws IOException {
            this.value = cr.readUTF();
        }

        public CONSTANT_Utf8_info(String value) {
            this.value = value;
        }

        @Override
        public int getTag() {
            return 1;
        }

        @Override
        public int byteLength() {
            class SizeOutputStream
            extends OutputStream {
                int size;

                SizeOutputStream() {
                }

                @Override
                public void write(int b) {
                    ++this.size;
                }
            }
            SizeOutputStream sizeOut = new SizeOutputStream();
            DataOutputStream out = new DataOutputStream(sizeOut);
            try {
                out.writeUTF(this.value);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return 1 + sizeOut.size;
        }

        public String toString() {
            if (this.value.length() < 32 && CONSTANT_Utf8_info.isPrintableAscii(this.value)) {
                return "CONSTANT_Utf8_info[value: \"" + this.value + "\"]";
            }
            return "CONSTANT_Utf8_info[value: (" + this.value.length() + " chars)]";
        }

        static boolean isPrintableAscii(String s) {
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c >= ' ' && c < '\u007f') continue;
                return false;
            }
            return true;
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D data) {
            return visitor.visitUtf8(this, data);
        }
    }

    public static class CONSTANT_String_info
    extends CPInfo {
        public final int string_index;

        CONSTANT_String_info(ConstantPool cp, ClassReader cr) throws IOException {
            super(cp);
            this.string_index = cr.readUnsignedShort();
        }

        public CONSTANT_String_info(ConstantPool cp, int string_index) {
            super(cp);
            this.string_index = string_index;
        }

        @Override
        public int getTag() {
            return 8;
        }

        @Override
        public int byteLength() {
            return 3;
        }

        public String getString() throws ConstantPoolException {
            return this.cp.getUTF8Value(this.string_index);
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D data) {
            return visitor.visitString(this, data);
        }

        public String toString() {
            return "CONSTANT_String_info[class_index: " + this.string_index + "]";
        }
    }

    public static class CONSTANT_Package_info
    extends CPInfo {
        public final int name_index;

        CONSTANT_Package_info(ConstantPool cp, ClassReader cr) throws IOException {
            super(cp);
            this.name_index = cr.readUnsignedShort();
        }

        public CONSTANT_Package_info(ConstantPool cp, int name_index) {
            super(cp);
            this.name_index = name_index;
        }

        @Override
        public int getTag() {
            return 20;
        }

        @Override
        public int byteLength() {
            return 3;
        }

        public String getName() throws ConstantPoolException {
            return this.cp.getUTF8Value(this.name_index);
        }

        public String toString() {
            return "CONSTANT_Package_info[name_index: " + this.name_index + "]";
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D data) {
            return visitor.visitPackage(this, data);
        }
    }

    public static class CONSTANT_NameAndType_info
    extends CPInfo {
        public final int name_index;
        public final int type_index;

        CONSTANT_NameAndType_info(ConstantPool cp, ClassReader cr) throws IOException {
            super(cp);
            this.name_index = cr.readUnsignedShort();
            this.type_index = cr.readUnsignedShort();
        }

        public CONSTANT_NameAndType_info(ConstantPool cp, int name_index, int type_index) {
            super(cp);
            this.name_index = name_index;
            this.type_index = type_index;
        }

        @Override
        public int getTag() {
            return 12;
        }

        @Override
        public int byteLength() {
            return 5;
        }

        public String getName() throws ConstantPoolException {
            return this.cp.getUTF8Value(this.name_index);
        }

        public String getType() throws ConstantPoolException {
            return this.cp.getUTF8Value(this.type_index);
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D data) {
            return visitor.visitNameAndType(this, data);
        }

        public String toString() {
            return "CONSTANT_NameAndType_info[name_index: " + this.name_index + ", type_index: " + this.type_index + "]";
        }
    }

    public static class CONSTANT_Module_info
    extends CPInfo {
        public final int name_index;

        CONSTANT_Module_info(ConstantPool cp, ClassReader cr) throws IOException {
            super(cp);
            this.name_index = cr.readUnsignedShort();
        }

        public CONSTANT_Module_info(ConstantPool cp, int name_index) {
            super(cp);
            this.name_index = name_index;
        }

        @Override
        public int getTag() {
            return 19;
        }

        @Override
        public int byteLength() {
            return 3;
        }

        public String getName() throws ConstantPoolException {
            return this.cp.getUTF8Value(this.name_index);
        }

        public String toString() {
            return "CONSTANT_Module_info[name_index: " + this.name_index + "]";
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D data) {
            return visitor.visitModule(this, data);
        }
    }

    public static class CONSTANT_Methodref_info
    extends CPRefInfo {
        CONSTANT_Methodref_info(ConstantPool cp, ClassReader cr) throws IOException {
            super(cp, cr, 10);
        }

        public CONSTANT_Methodref_info(ConstantPool cp, int class_index, int name_and_type_index) {
            super(cp, 10, class_index, name_and_type_index);
        }

        public String toString() {
            return "CONSTANT_Methodref_info[class_index: " + this.class_index + ", name_and_type_index: " + this.name_and_type_index + "]";
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D data) {
            return visitor.visitMethodref(this, data);
        }
    }

    public static class CONSTANT_MethodType_info
    extends CPInfo {
        public final int descriptor_index;

        CONSTANT_MethodType_info(ConstantPool cp, ClassReader cr) throws IOException {
            super(cp);
            this.descriptor_index = cr.readUnsignedShort();
        }

        public CONSTANT_MethodType_info(ConstantPool cp, int signature_index) {
            super(cp);
            this.descriptor_index = signature_index;
        }

        @Override
        public int getTag() {
            return 16;
        }

        @Override
        public int byteLength() {
            return 3;
        }

        public String toString() {
            return "CONSTANT_MethodType_info[signature_index: " + this.descriptor_index + "]";
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D data) {
            return visitor.visitMethodType(this, data);
        }

        public String getType() throws ConstantPoolException {
            return this.cp.getUTF8Value(this.descriptor_index);
        }
    }

    public static class CONSTANT_MethodHandle_info
    extends CPInfo {
        public final RefKind reference_kind;
        public final int reference_index;

        CONSTANT_MethodHandle_info(ConstantPool cp, ClassReader cr) throws IOException {
            super(cp);
            this.reference_kind = RefKind.getRefkind(cr.readUnsignedByte());
            this.reference_index = cr.readUnsignedShort();
        }

        public CONSTANT_MethodHandle_info(ConstantPool cp, RefKind ref_kind, int member_index) {
            super(cp);
            this.reference_kind = ref_kind;
            this.reference_index = member_index;
        }

        @Override
        public int getTag() {
            return 15;
        }

        @Override
        public int byteLength() {
            return 4;
        }

        public String toString() {
            return "CONSTANT_MethodHandle_info[ref_kind: " + (Object)((Object)this.reference_kind) + ", member_index: " + this.reference_index + "]";
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D data) {
            return visitor.visitMethodHandle(this, data);
        }

        public CPRefInfo getCPRefInfo() throws ConstantPoolException {
            int expected = 10;
            int actual = this.cp.get(this.reference_index).getTag();
            switch (actual) {
                case 9: 
                case 11: {
                    expected = actual;
                }
            }
            return (CPRefInfo)this.cp.get(this.reference_index, expected);
        }
    }

    public static class CONSTANT_Long_info
    extends CPInfo {
        public final long value;

        CONSTANT_Long_info(ClassReader cr) throws IOException {
            this.value = cr.readLong();
        }

        public CONSTANT_Long_info(long value) {
            this.value = value;
        }

        @Override
        public int getTag() {
            return 5;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public int byteLength() {
            return 9;
        }

        public String toString() {
            return "CONSTANT_Long_info[value: " + this.value + "]";
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D data) {
            return visitor.visitLong(this, data);
        }
    }

    public static class CONSTANT_InvokeDynamic_info
    extends CPInfo {
        public final int bootstrap_method_attr_index;
        public final int name_and_type_index;

        CONSTANT_InvokeDynamic_info(ConstantPool cp, ClassReader cr) throws IOException {
            super(cp);
            this.bootstrap_method_attr_index = cr.readUnsignedShort();
            this.name_and_type_index = cr.readUnsignedShort();
        }

        public CONSTANT_InvokeDynamic_info(ConstantPool cp, int bootstrap_method_index, int name_and_type_index) {
            super(cp);
            this.bootstrap_method_attr_index = bootstrap_method_index;
            this.name_and_type_index = name_and_type_index;
        }

        @Override
        public int getTag() {
            return 18;
        }

        @Override
        public int byteLength() {
            return 5;
        }

        public String toString() {
            return "CONSTANT_InvokeDynamic_info[bootstrap_method_index: " + this.bootstrap_method_attr_index + ", name_and_type_index: " + this.name_and_type_index + "]";
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D data) {
            return visitor.visitInvokeDynamic(this, data);
        }

        public CONSTANT_NameAndType_info getNameAndTypeInfo() throws ConstantPoolException {
            return this.cp.getNameAndTypeInfo(this.name_and_type_index);
        }
    }

    public static class CONSTANT_InterfaceMethodref_info
    extends CPRefInfo {
        CONSTANT_InterfaceMethodref_info(ConstantPool cp, ClassReader cr) throws IOException {
            super(cp, cr, 11);
        }

        public CONSTANT_InterfaceMethodref_info(ConstantPool cp, int class_index, int name_and_type_index) {
            super(cp, 11, class_index, name_and_type_index);
        }

        public String toString() {
            return "CONSTANT_InterfaceMethodref_info[class_index: " + this.class_index + ", name_and_type_index: " + this.name_and_type_index + "]";
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D data) {
            return visitor.visitInterfaceMethodref(this, data);
        }
    }

    public static class CONSTANT_Integer_info
    extends CPInfo {
        public final int value;

        CONSTANT_Integer_info(ClassReader cr) throws IOException {
            this.value = cr.readInt();
        }

        public CONSTANT_Integer_info(int value) {
            this.value = value;
        }

        @Override
        public int getTag() {
            return 3;
        }

        @Override
        public int byteLength() {
            return 5;
        }

        public String toString() {
            return "CONSTANT_Integer_info[value: " + this.value + "]";
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D data) {
            return visitor.visitInteger(this, data);
        }
    }

    public static class CONSTANT_Float_info
    extends CPInfo {
        public final float value;

        CONSTANT_Float_info(ClassReader cr) throws IOException {
            this.value = cr.readFloat();
        }

        public CONSTANT_Float_info(float value) {
            this.value = value;
        }

        @Override
        public int getTag() {
            return 4;
        }

        @Override
        public int byteLength() {
            return 5;
        }

        public String toString() {
            return "CONSTANT_Float_info[value: " + this.value + "]";
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D data) {
            return visitor.visitFloat(this, data);
        }
    }

    public static class CONSTANT_Fieldref_info
    extends CPRefInfo {
        CONSTANT_Fieldref_info(ConstantPool cp, ClassReader cr) throws IOException {
            super(cp, cr, 9);
        }

        public CONSTANT_Fieldref_info(ConstantPool cp, int class_index, int name_and_type_index) {
            super(cp, 9, class_index, name_and_type_index);
        }

        public String toString() {
            return "CONSTANT_Fieldref_info[class_index: " + this.class_index + ", name_and_type_index: " + this.name_and_type_index + "]";
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D data) {
            return visitor.visitFieldref(this, data);
        }
    }

    public static class CONSTANT_Double_info
    extends CPInfo {
        public final double value;

        CONSTANT_Double_info(ClassReader cr) throws IOException {
            this.value = cr.readDouble();
        }

        public CONSTANT_Double_info(double value) {
            this.value = value;
        }

        @Override
        public int getTag() {
            return 6;
        }

        @Override
        public int byteLength() {
            return 9;
        }

        @Override
        public int size() {
            return 2;
        }

        public String toString() {
            return "CONSTANT_Double_info[value: " + this.value + "]";
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D data) {
            return visitor.visitDouble(this, data);
        }
    }

    public static class CONSTANT_Class_info
    extends CPInfo {
        public final int name_index;

        CONSTANT_Class_info(ConstantPool cp, ClassReader cr) throws IOException {
            super(cp);
            this.name_index = cr.readUnsignedShort();
        }

        public CONSTANT_Class_info(ConstantPool cp, int name_index) {
            super(cp);
            this.name_index = name_index;
        }

        @Override
        public int getTag() {
            return 7;
        }

        @Override
        public int byteLength() {
            return 3;
        }

        public String getName() throws ConstantPoolException {
            return this.cp.getUTF8Value(this.name_index);
        }

        public String getBaseName() throws ConstantPoolException {
            String name = this.getName();
            if (name.startsWith("[")) {
                int index = name.indexOf("[L");
                if (index == -1) {
                    return null;
                }
                return name.substring(index + 2, name.length() - 1);
            }
            return name;
        }

        public int getDimensionCount() throws ConstantPoolException {
            String name = this.getName();
            int count = 0;
            while (name.charAt(count) == '[') {
                ++count;
            }
            return count;
        }

        public String toString() {
            return "CONSTANT_Class_info[name_index: " + this.name_index + "]";
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D data) {
            return visitor.visitClass(this, data);
        }
    }

    public static abstract class CPRefInfo
    extends CPInfo {
        public final int tag;
        public final int class_index;
        public final int name_and_type_index;

        protected CPRefInfo(ConstantPool cp, ClassReader cr, int tag) throws IOException {
            super(cp);
            this.tag = tag;
            this.class_index = cr.readUnsignedShort();
            this.name_and_type_index = cr.readUnsignedShort();
        }

        protected CPRefInfo(ConstantPool cp, int tag, int class_index, int name_and_type_index) {
            super(cp);
            this.tag = tag;
            this.class_index = class_index;
            this.name_and_type_index = name_and_type_index;
        }

        @Override
        public int getTag() {
            return this.tag;
        }

        @Override
        public int byteLength() {
            return 5;
        }

        public CONSTANT_Class_info getClassInfo() throws ConstantPoolException {
            return this.cp.getClassInfo(this.class_index);
        }

        public String getClassName() throws ConstantPoolException {
            return this.cp.getClassInfo(this.class_index).getName();
        }

        public CONSTANT_NameAndType_info getNameAndTypeInfo() throws ConstantPoolException {
            return this.cp.getNameAndTypeInfo(this.name_and_type_index);
        }
    }

    public static abstract class CPInfo {
        protected final ConstantPool cp;

        CPInfo() {
            this.cp = null;
        }

        CPInfo(ConstantPool cp) {
            this.cp = cp;
        }

        public abstract int getTag();

        public int size() {
            return 1;
        }

        public abstract int byteLength();

        public abstract <R, D> R accept(Visitor<R, D> var1, D var2);
    }

    public static interface Visitor<R, P> {
        public R visitClass(CONSTANT_Class_info var1, P var2);

        public R visitDouble(CONSTANT_Double_info var1, P var2);

        public R visitFieldref(CONSTANT_Fieldref_info var1, P var2);

        public R visitFloat(CONSTANT_Float_info var1, P var2);

        public R visitInteger(CONSTANT_Integer_info var1, P var2);

        public R visitInterfaceMethodref(CONSTANT_InterfaceMethodref_info var1, P var2);

        public R visitInvokeDynamic(CONSTANT_InvokeDynamic_info var1, P var2);

        public R visitLong(CONSTANT_Long_info var1, P var2);

        public R visitMethodref(CONSTANT_Methodref_info var1, P var2);

        public R visitMethodHandle(CONSTANT_MethodHandle_info var1, P var2);

        public R visitMethodType(CONSTANT_MethodType_info var1, P var2);

        public R visitModule(CONSTANT_Module_info var1, P var2);

        public R visitNameAndType(CONSTANT_NameAndType_info var1, P var2);

        public R visitPackage(CONSTANT_Package_info var1, P var2);

        public R visitString(CONSTANT_String_info var1, P var2);

        public R visitUtf8(CONSTANT_Utf8_info var1, P var2);
    }

    public static enum RefKind {
        REF_getField(1, "getfield"),
        REF_getStatic(2, "getstatic"),
        REF_putField(3, "putfield"),
        REF_putStatic(4, "putstatic"),
        REF_invokeVirtual(5, "invokevirtual"),
        REF_invokeStatic(6, "invokestatic"),
        REF_invokeSpecial(7, "invokespecial"),
        REF_newInvokeSpecial(8, "newinvokespecial"),
        REF_invokeInterface(9, "invokeinterface");

        public final int tag;
        public final String name;

        private RefKind(int tag, String name) {
            this.tag = tag;
            this.name = name;
        }

        static RefKind getRefkind(int tag) {
            switch (tag) {
                case 1: {
                    return REF_getField;
                }
                case 2: {
                    return REF_getStatic;
                }
                case 3: {
                    return REF_putField;
                }
                case 4: {
                    return REF_putStatic;
                }
                case 5: {
                    return REF_invokeVirtual;
                }
                case 6: {
                    return REF_invokeStatic;
                }
                case 7: {
                    return REF_invokeSpecial;
                }
                case 8: {
                    return REF_newInvokeSpecial;
                }
                case 9: {
                    return REF_invokeInterface;
                }
            }
            return null;
        }
    }

    public static class EntryNotFound
    extends ConstantPoolException {
        private static final long serialVersionUID = 2885537606468581850L;
        public final Object value;

        EntryNotFound(Object value) {
            super(-1);
            this.value = value;
        }

        @Override
        public String getMessage() {
            return "value not found: " + this.value;
        }
    }

    public static class InvalidEntry
    extends ConstantPoolException {
        private static final long serialVersionUID = 1000087545585204447L;
        public final int tag;

        InvalidEntry(int index, int tag) {
            super(index);
            this.tag = tag;
        }

        @Override
        public String getMessage() {
            return "unexpected tag at #" + this.index + ": " + this.tag;
        }
    }

    public static class UnexpectedEntry
    extends ConstantPoolException {
        private static final long serialVersionUID = 6986335935377933211L;
        public final int expected_tag;
        public final int found_tag;

        UnexpectedEntry(int index, int expected_tag, int found_tag) {
            super(index);
            this.expected_tag = expected_tag;
            this.found_tag = found_tag;
        }

        @Override
        public String getMessage() {
            return "unexpected entry at #" + this.index + " -- expected tag " + this.expected_tag + ", found " + this.found_tag;
        }
    }

    public static class InvalidIndex
    extends ConstantPoolException {
        private static final long serialVersionUID = -4350294289300939730L;

        InvalidIndex(int index) {
            super(index);
        }

        @Override
        public String getMessage() {
            return "invalid index #" + this.index;
        }
    }
}

