/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.langtools.classfile;

import com.redhat.ceylon.langtools.classfile.ClassReader;
import com.redhat.ceylon.langtools.classfile.ConstantPool;
import com.redhat.ceylon.langtools.classfile.ConstantPoolException;
import com.redhat.ceylon.langtools.classfile.DescriptorException;
import java.io.IOException;

public class Descriptor {
    public final int index;
    private int count;

    public Descriptor(ClassReader cr) throws IOException {
        this(cr.readUnsignedShort());
    }

    public Descriptor(int index) {
        this.index = index;
    }

    public String getValue(ConstantPool constant_pool) throws ConstantPoolException {
        return constant_pool.getUTF8Value(this.index);
    }

    public int getParameterCount(ConstantPool constant_pool) throws ConstantPoolException, InvalidDescriptor {
        String desc = this.getValue(constant_pool);
        int end = desc.indexOf(")");
        if (end == -1) {
            throw new InvalidDescriptor(desc);
        }
        this.parse(desc, 0, end + 1);
        return this.count;
    }

    public String getParameterTypes(ConstantPool constant_pool) throws ConstantPoolException, InvalidDescriptor {
        String desc = this.getValue(constant_pool);
        int end = desc.indexOf(")");
        if (end == -1) {
            throw new InvalidDescriptor(desc);
        }
        return this.parse(desc, 0, end + 1);
    }

    public String getReturnType(ConstantPool constant_pool) throws ConstantPoolException, InvalidDescriptor {
        String desc = this.getValue(constant_pool);
        int end = desc.indexOf(")");
        if (end == -1) {
            throw new InvalidDescriptor(desc);
        }
        return this.parse(desc, end + 1, desc.length());
    }

    public String getFieldType(ConstantPool constant_pool) throws ConstantPoolException, InvalidDescriptor {
        String desc = this.getValue(constant_pool);
        return this.parse(desc, 0, desc.length());
    }

    private String parse(String desc, int start, int end) throws InvalidDescriptor {
        int p = start;
        StringBuilder sb = new StringBuilder();
        int dims = 0;
        this.count = 0;
        block15: while (p < end) {
            String type;
            char ch = desc.charAt(p++);
            switch (ch) {
                case '(': {
                    sb.append('(');
                    continue block15;
                }
                case ')': {
                    sb.append(')');
                    continue block15;
                }
                case '[': {
                    ++dims;
                    continue block15;
                }
                case 'B': {
                    type = "byte";
                    break;
                }
                case 'C': {
                    type = "char";
                    break;
                }
                case 'D': {
                    type = "double";
                    break;
                }
                case 'F': {
                    type = "float";
                    break;
                }
                case 'I': {
                    type = "int";
                    break;
                }
                case 'J': {
                    type = "long";
                    break;
                }
                case 'L': {
                    int sep = desc.indexOf(59, p);
                    if (sep == -1) {
                        throw new InvalidDescriptor(desc, p - 1);
                    }
                    type = desc.substring(p, sep).replace('/', '.');
                    p = sep + 1;
                    break;
                }
                case 'S': {
                    type = "short";
                    break;
                }
                case 'Z': {
                    type = "boolean";
                    break;
                }
                case 'V': {
                    type = "void";
                    break;
                }
                default: {
                    throw new InvalidDescriptor(desc, p - 1);
                }
            }
            if (sb.length() > 1 && sb.charAt(0) == '(') {
                sb.append(", ");
            }
            sb.append(type);
            while (dims > 0) {
                sb.append("[]");
                --dims;
            }
            ++this.count;
        }
        return sb.toString();
    }

    public static class InvalidDescriptor
    extends DescriptorException {
        private static final long serialVersionUID = 1L;
        public final String desc;
        public final int index;

        InvalidDescriptor(String desc) {
            this.desc = desc;
            this.index = -1;
        }

        InvalidDescriptor(String desc, int index) {
            this.desc = desc;
            this.index = index;
        }

        @Override
        public String getMessage() {
            if (this.index == -1) {
                return "invalid descriptor \"" + this.desc + "\"";
            }
            return "descriptor is invalid at offset " + this.index + " in \"" + this.desc + "\"";
        }
    }
}

