/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.langtools.classfile;

import com.redhat.ceylon.langtools.classfile.AccessFlags;
import com.redhat.ceylon.langtools.classfile.Attributes;
import com.redhat.ceylon.langtools.classfile.ClassReader;
import com.redhat.ceylon.langtools.classfile.ConstantPool;
import com.redhat.ceylon.langtools.classfile.ConstantPoolException;
import com.redhat.ceylon.langtools.classfile.Descriptor;
import java.io.IOException;

public class Method {
    public final AccessFlags access_flags;
    public final int name_index;
    public final Descriptor descriptor;
    public final Attributes attributes;

    Method(ClassReader cr) throws IOException {
        this.access_flags = new AccessFlags(cr);
        this.name_index = cr.readUnsignedShort();
        this.descriptor = new Descriptor(cr);
        this.attributes = new Attributes(cr);
    }

    public Method(AccessFlags access_flags, int name_index, Descriptor descriptor, Attributes attributes) {
        this.access_flags = access_flags;
        this.name_index = name_index;
        this.descriptor = descriptor;
        this.attributes = attributes;
    }

    public int byteLength() {
        return 6 + this.attributes.byteLength();
    }

    public String getName(ConstantPool constant_pool) throws ConstantPoolException {
        return constant_pool.getUTF8Value(this.name_index);
    }
}

