/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.langtools.classfile;

import com.redhat.ceylon.langtools.classfile.Attribute;
import com.redhat.ceylon.langtools.classfile.ClassReader;
import com.redhat.ceylon.langtools.classfile.ConstantPool;
import com.redhat.ceylon.langtools.classfile.ConstantPoolException;
import java.io.IOException;

public class ModulePackages_attribute
extends Attribute {
    public final int packages_count;
    public final int[] packages_index;

    ModulePackages_attribute(ClassReader cr, int name_index, int length) throws IOException {
        super(name_index, length);
        this.packages_count = cr.readUnsignedShort();
        this.packages_index = new int[this.packages_count];
        for (int i = 0; i < this.packages_count; ++i) {
            this.packages_index[i] = cr.readUnsignedShort();
        }
    }

    public ModulePackages_attribute(ConstantPool constant_pool, int[] packages_index) throws ConstantPoolException {
        this(constant_pool.getUTF8Index("ModulePackages"), packages_index);
    }

    public ModulePackages_attribute(int name_index, int[] packages_index) {
        super(name_index, 2 + packages_index.length * 2);
        this.packages_count = packages_index.length;
        this.packages_index = packages_index;
    }

    public String getPackage(int index, ConstantPool constant_pool) throws ConstantPoolException {
        int package_index = this.packages_index[index];
        ConstantPool.CONSTANT_Package_info info = constant_pool.getPackageInfo(package_index);
        return info.getName();
    }

    @Override
    public <R, D> R accept(Attribute.Visitor<R, D> visitor, D data) {
        return visitor.visitModulePackages(this, data);
    }
}

