/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.langtools.tools.javac.api;

import com.redhat.ceylon.javax.lang.model.SourceVersion;
import com.redhat.ceylon.javax.tools.DiagnosticListener;
import com.redhat.ceylon.javax.tools.JavaCompiler;
import com.redhat.ceylon.javax.tools.JavaFileManager;
import com.redhat.ceylon.javax.tools.JavaFileObject;
import com.redhat.ceylon.langtools.source.util.JavacTask;
import com.redhat.ceylon.langtools.tools.javac.Main;
import com.redhat.ceylon.langtools.tools.javac.api.ClientCodeWrapper;
import com.redhat.ceylon.langtools.tools.javac.api.JavacTaskImpl;
import com.redhat.ceylon.langtools.tools.javac.file.JavacFileManager;
import com.redhat.ceylon.langtools.tools.javac.main.Option;
import com.redhat.ceylon.langtools.tools.javac.main.OptionHelper;
import com.redhat.ceylon.langtools.tools.javac.util.ClientCodeException;
import com.redhat.ceylon.langtools.tools.javac.util.Context;
import com.redhat.ceylon.langtools.tools.javac.util.Log;
import com.redhat.ceylon.langtools.tools.javac.util.Options;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class JavacTool
implements JavaCompiler {
    @Deprecated
    public JavacTool() {
    }

    public static JavacTool create() {
        return new JavacTool();
    }

    @Override
    public JavacFileManager getStandardFileManager(DiagnosticListener<? super JavaFileObject> diagnosticListener, Locale locale, Charset charset) {
        Context context = new Context();
        context.put(Locale.class, locale);
        if (diagnosticListener != null) {
            context.put(DiagnosticListener.class, diagnosticListener);
        }
        PrintWriter pw = charset == null ? new PrintWriter(System.err, true) : new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.err, charset), true);
        context.put(Log.outKey, pw);
        return new JavacFileManager(context, true, charset);
    }

    @Override
    public JavacTask getTask(Writer out, JavaFileManager fileManager, DiagnosticListener<? super JavaFileObject> diagnosticListener, Iterable<String> options, Iterable<String> classes, Iterable<? extends JavaFileObject> compilationUnits) {
        Context context = new Context();
        return this.getTask(out, fileManager, diagnosticListener, options, classes, compilationUnits, context);
    }

    public JavacTask getTask(Writer out, JavaFileManager fileManager, DiagnosticListener<? super JavaFileObject> diagnosticListener, Iterable<String> options, Iterable<String> classes, Iterable<? extends JavaFileObject> compilationUnits, Context context) {
        try {
            ClientCodeWrapper ccw = ClientCodeWrapper.instance(context);
            if (options != null) {
                for (String string : options) {
                    string.getClass();
                }
            }
            if (classes != null) {
                for (String string : classes) {
                    if (SourceVersion.isName(string)) continue;
                    throw new IllegalArgumentException("Not a valid class name: " + string);
                }
            }
            if (compilationUnits != null) {
                compilationUnits = ccw.wrapJavaFileObjects(compilationUnits);
                for (JavaFileObject javaFileObject : compilationUnits) {
                    if (javaFileObject.getKind() == JavaFileObject.Kind.SOURCE) continue;
                    String kindMsg = "Compilation unit is not of SOURCE kind: \"" + javaFileObject.getName() + "\"";
                    throw new IllegalArgumentException(kindMsg);
                }
            }
            if (diagnosticListener != null) {
                context.put(DiagnosticListener.class, ccw.wrap(diagnosticListener));
            }
            if (out == null) {
                context.put(Log.outKey, new PrintWriter(System.err, true));
            } else {
                context.put(Log.outKey, new PrintWriter(out, true));
            }
            if (fileManager == null) {
                fileManager = this.getStandardFileManager((DiagnosticListener)diagnosticListener, (Locale)null, (Charset)null);
            }
            fileManager = ccw.wrap(fileManager);
            context.put(JavaFileManager.class, fileManager);
            JavacTool.processOptions(context, fileManager, options);
            com.redhat.ceylon.langtools.tools.javac.main.Main compiler = new com.redhat.ceylon.langtools.tools.javac.main.Main("javacTask", context.get(Log.outKey));
            return new JavacTaskImpl(compiler, options, context, classes, compilationUnits);
        }
        catch (ClientCodeException ex) {
            throw new RuntimeException(ex.getCause());
        }
    }

    public static void processOptions(Context context, JavaFileManager fileManager, Iterable<String> options) {
        if (options == null) {
            return;
        }
        final Options optionTable = Options.instance(context);
        Log log = Log.instance(context);
        Option[] recognizedOptions = Option.getJavacToolOptions().toArray(new Option[0]);
        OptionHelper.GrumpyHelper optionHelper = new OptionHelper.GrumpyHelper(log){

            @Override
            public String get(Option option) {
                return optionTable.get(option.getText());
            }

            @Override
            public List<String> getMulti(Option option) {
                return optionTable.getMulti(option);
            }

            @Override
            public void put(String name, String value) {
                optionTable.put(name, value);
            }

            @Override
            public void addMulti(String name, String value) {
                optionTable.addMulti(name, value);
            }

            @Override
            public void remove(String name) {
                optionTable.remove(name);
            }
        };
        Iterator<String> flags = options.iterator();
        while (flags.hasNext()) {
            Option ro;
            int j;
            String flag = flags.next();
            for (j = 0; j < recognizedOptions.length && !(ro = recognizedOptions[j]).matches(flag); ++j) {
            }
            if (j == recognizedOptions.length) {
                if (fileManager.handleOption(flag, flags)) continue;
                String msg = log.localize(Log.PrefixKind.JAVAC, "err.invalid.flag", flag);
                throw new IllegalArgumentException(msg);
            }
            Option option = recognizedOptions[j];
            if (option.hasArg()) {
                if (!flags.hasNext()) {
                    String msg = log.localize(Log.PrefixKind.JAVAC, "err.req.arg", flag);
                    throw new IllegalArgumentException(msg);
                }
                String operand = flags.next();
                if (!option.process(optionHelper, flag, operand)) continue;
                throw new IllegalArgumentException(flag + " " + operand);
            }
            if (!option.process(optionHelper, flag)) continue;
            throw new IllegalArgumentException(flag);
        }
        optionTable.notifyListeners();
    }

    @Override
    public int run(InputStream in, OutputStream out, OutputStream err, String ... arguments) {
        if (err == null) {
            err = System.err;
        }
        for (String argument : arguments) {
            argument.getClass();
        }
        return Main.compile(arguments, new PrintWriter(err, true));
    }

    @Override
    public Set<SourceVersion> getSourceVersions() {
        return Collections.unmodifiableSet(EnumSet.range(SourceVersion.RELEASE_3, SourceVersion.latest()));
    }

    @Override
    public int isSupportedOption(String option) {
        Set<Option> recognizedOptions = Option.getJavacToolOptions();
        for (Option o : recognizedOptions) {
            if (!o.matches(option)) continue;
            return o.hasArg() ? 1 : 0;
        }
        return -1;
    }
}

