/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.langtools.tools.javac.api;

import com.redhat.ceylon.javax.annotation.processing.ProcessingEnvironment;
import com.redhat.ceylon.javax.lang.model.element.AnnotationMirror;
import com.redhat.ceylon.javax.lang.model.element.AnnotationValue;
import com.redhat.ceylon.javax.lang.model.element.Element;
import com.redhat.ceylon.javax.lang.model.element.ExecutableElement;
import com.redhat.ceylon.javax.lang.model.element.TypeElement;
import com.redhat.ceylon.javax.lang.model.type.DeclaredType;
import com.redhat.ceylon.javax.lang.model.type.ErrorType;
import com.redhat.ceylon.javax.lang.model.type.TypeKind;
import com.redhat.ceylon.javax.lang.model.type.TypeMirror;
import com.redhat.ceylon.javax.tools.Diagnostic;
import com.redhat.ceylon.javax.tools.JavaCompiler;
import com.redhat.ceylon.javax.tools.JavaFileObject;
import com.redhat.ceylon.langtools.source.tree.CatchTree;
import com.redhat.ceylon.langtools.source.tree.CompilationUnitTree;
import com.redhat.ceylon.langtools.source.tree.Scope;
import com.redhat.ceylon.langtools.source.tree.Tree;
import com.redhat.ceylon.langtools.source.util.JavacTask;
import com.redhat.ceylon.langtools.source.util.SourcePositions;
import com.redhat.ceylon.langtools.source.util.TreePath;
import com.redhat.ceylon.langtools.source.util.Trees;
import com.redhat.ceylon.langtools.tools.javac.api.BasicJavacTask;
import com.redhat.ceylon.langtools.tools.javac.api.JavacScope;
import com.redhat.ceylon.langtools.tools.javac.api.JavacTaskImpl;
import com.redhat.ceylon.langtools.tools.javac.code.Scope;
import com.redhat.ceylon.langtools.tools.javac.code.Symbol;
import com.redhat.ceylon.langtools.tools.javac.code.Type;
import com.redhat.ceylon.langtools.tools.javac.code.TypeTag;
import com.redhat.ceylon.langtools.tools.javac.code.Types;
import com.redhat.ceylon.langtools.tools.javac.comp.Attr;
import com.redhat.ceylon.langtools.tools.javac.comp.AttrContext;
import com.redhat.ceylon.langtools.tools.javac.comp.Enter;
import com.redhat.ceylon.langtools.tools.javac.comp.Env;
import com.redhat.ceylon.langtools.tools.javac.comp.MemberEnter;
import com.redhat.ceylon.langtools.tools.javac.comp.Resolve;
import com.redhat.ceylon.langtools.tools.javac.model.JavacElements;
import com.redhat.ceylon.langtools.tools.javac.processing.JavacProcessingEnvironment;
import com.redhat.ceylon.langtools.tools.javac.tree.JCTree;
import com.redhat.ceylon.langtools.tools.javac.tree.TreeCopier;
import com.redhat.ceylon.langtools.tools.javac.tree.TreeInfo;
import com.redhat.ceylon.langtools.tools.javac.tree.TreeMaker;
import com.redhat.ceylon.langtools.tools.javac.util.Assert;
import com.redhat.ceylon.langtools.tools.javac.util.Context;
import com.redhat.ceylon.langtools.tools.javac.util.JCDiagnostic;
import com.redhat.ceylon.langtools.tools.javac.util.List;
import com.redhat.ceylon.langtools.tools.javac.util.Log;
import com.redhat.ceylon.langtools.tools.javac.util.Name;
import com.redhat.ceylon.langtools.tools.javac.util.Names;
import com.redhat.ceylon.langtools.tools.javac.util.Pair;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class JavacTrees
extends Trees {
    private Resolve resolve;
    private Enter enter;
    private Log log;
    private MemberEnter memberEnter;
    private Attr attr;
    private TreeMaker treeMaker;
    private JavacElements elements;
    private JavacTaskImpl javacTaskImpl;
    private Names names;
    private Types types;
    Types.TypeRelation fuzzyMatcher = new Types.TypeRelation(){

        @Override
        public Boolean visitType(Type t, Type s) {
            if (t == s) {
                return true;
            }
            if (s.isPartial()) {
                return (Boolean)this.visit(s, t);
            }
            switch (t.getTag()) {
                case BYTE: 
                case CHAR: 
                case SHORT: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case BOOLEAN: 
                case VOID: 
                case BOT: 
                case NONE: {
                    return t.hasTag(s.getTag());
                }
            }
            throw new AssertionError((Object)("fuzzyMatcher " + (Object)((Object)t.getTag())));
        }

        @Override
        public Boolean visitArrayType(Type.ArrayType t, Type s) {
            if (t == s) {
                return true;
            }
            if (s.isPartial()) {
                return (Boolean)this.visit(s, t);
            }
            return s.hasTag(TypeTag.ARRAY) && (Boolean)this.visit(t.elemtype, JavacTrees.this.types.elemtype(s)) != false;
        }

        @Override
        public Boolean visitClassType(Type.ClassType t, Type s) {
            if (t == s) {
                return true;
            }
            if (s.isPartial()) {
                return (Boolean)this.visit(s, t);
            }
            return t.tsym == s.tsym;
        }

        @Override
        public Boolean visitErrorType(Type.ErrorType t, Type s) {
            return s.hasTag(TypeTag.CLASS) && t.tsym.name == ((Type.ClassType)s).tsym.name;
        }
    };

    public static JavacTrees instance(JavaCompiler.CompilationTask task) {
        if (!(task instanceof BasicJavacTask)) {
            throw new IllegalArgumentException();
        }
        return JavacTrees.instance(((BasicJavacTask)task).getContext());
    }

    public static JavacTrees instance(ProcessingEnvironment env) {
        if (!(env instanceof JavacProcessingEnvironment)) {
            throw new IllegalArgumentException();
        }
        return JavacTrees.instance(((JavacProcessingEnvironment)env).getContext());
    }

    public static JavacTrees instance(Context context) {
        JavacTrees instance = context.get(JavacTrees.class);
        if (instance == null) {
            instance = new JavacTrees(context);
        }
        return instance;
    }

    protected JavacTrees(Context context) {
        context.put(JavacTrees.class, this);
        this.init(context);
    }

    public void updateContext(Context context) {
        this.init(context);
    }

    private void init(Context context) {
        this.attr = Attr.instance(context);
        this.enter = Enter.instance(context);
        this.elements = JavacElements.instance(context);
        this.log = Log.instance(context);
        this.resolve = Resolve.instance(context);
        this.treeMaker = TreeMaker.instance(context);
        this.memberEnter = MemberEnter.instance(context);
        this.names = Names.instance(context);
        this.types = Types.instance(context);
        JavacTask t = context.get(JavacTask.class);
        if (t instanceof JavacTaskImpl) {
            this.javacTaskImpl = (JavacTaskImpl)t;
        }
    }

    @Override
    public JCTree.JCClassDecl getTree(TypeElement element) {
        return (JCTree.JCClassDecl)this.getTree((Element)element);
    }

    @Override
    public JCTree.JCMethodDecl getTree(ExecutableElement method) {
        return (JCTree.JCMethodDecl)this.getTree((Element)method);
    }

    @Override
    public JCTree getTree(Element element) {
        Symbol symbol = (Symbol)element;
        Symbol.ClassSymbol enclosing = symbol.enclClass();
        Env<AttrContext> env = this.enter.getEnv(enclosing);
        if (env == null) {
            return null;
        }
        JCTree.JCClassDecl classNode = env.enclClass;
        if (classNode != null) {
            if (TreeInfo.symbolFor(classNode) == element) {
                return classNode;
            }
            for (JCTree node : classNode.getMembers()) {
                if (TreeInfo.symbolFor(node) != element) continue;
                return node;
            }
        }
        return null;
    }

    @Override
    public JCTree getTree(Element e, AnnotationMirror a) {
        return this.getTree(e, a, null);
    }

    @Override
    public JCTree getTree(Element e, AnnotationMirror a, AnnotationValue v) {
        Pair<JCTree, JCTree.JCCompilationUnit> treeTopLevel = this.elements.getTreeAndTopLevel(e, a, v);
        if (treeTopLevel == null) {
            return null;
        }
        return (JCTree)treeTopLevel.fst;
    }

    @Override
    public TreePath getPath(CompilationUnitTree unit, Tree node) {
        return TreePath.getPath(unit, node);
    }

    @Override
    public TreePath getPath(Element e) {
        return this.getPath(e, null, null);
    }

    @Override
    public TreePath getPath(Element e, AnnotationMirror a) {
        return this.getPath(e, a, null);
    }

    @Override
    public TreePath getPath(Element e, AnnotationMirror a, AnnotationValue v) {
        Pair<JCTree, JCTree.JCCompilationUnit> treeTopLevel = this.elements.getTreeAndTopLevel(e, a, v);
        if (treeTopLevel == null) {
            return null;
        }
        return TreePath.getPath((CompilationUnitTree)treeTopLevel.snd, (Tree)treeTopLevel.fst);
    }

    @Override
    public Symbol getElement(TreePath path) {
        JCTree tree = (JCTree)path.getLeaf();
        Symbol sym = TreeInfo.symbolFor(tree);
        if (sym == null && TreeInfo.isDeclaration(tree)) {
            for (TreePath p = path; p != null; p = p.getParentPath()) {
                JCTree t = (JCTree)p.getLeaf();
                if (!t.hasTag(JCTree.Tag.CLASSDEF)) continue;
                JCTree.JCClassDecl ct = (JCTree.JCClassDecl)t;
                if (ct.sym == null) continue;
                if ((ct.sym.flags_field & 0x10000000L) == 0L) break;
                this.attr.attribClass(ct.pos(), ct.sym);
                sym = TreeInfo.symbolFor(tree);
                break;
            }
        }
        return sym;
    }

    private Symbol.VarSymbol findField(Symbol.ClassSymbol tsym, Name fieldName) {
        return this.searchField(tsym, fieldName, new HashSet<Symbol.ClassSymbol>());
    }

    private Symbol.VarSymbol searchField(Symbol.ClassSymbol tsym, Name fieldName, Set<Symbol.ClassSymbol> searched) {
        List intfs;
        Symbol.VarSymbol vsym;
        Symbol.VarSymbol vsym2;
        if (searched.contains(tsym)) {
            return null;
        }
        searched.add(tsym);
        Scope.Entry e = tsym.members().lookup(fieldName);
        while (e.scope != null) {
            if (e.sym.kind == 4) {
                return (Symbol.VarSymbol)e.sym;
            }
            e = e.next();
        }
        Symbol.ClassSymbol encl = tsym.owner.enclClass();
        if (encl != null && (vsym2 = this.searchField(encl, fieldName, searched)) != null) {
            return vsym2;
        }
        Type superclass = tsym.getSuperclass();
        if (superclass.tsym != null && (vsym = this.searchField((Symbol.ClassSymbol)superclass.tsym, fieldName, searched)) != null) {
            return vsym;
        }
        List l = intfs = tsym.getInterfaces();
        while (l.nonEmpty()) {
            Symbol.VarSymbol vsym3;
            Type intf = (Type)l.head;
            if (!intf.isErroneous() && (vsym3 = this.searchField((Symbol.ClassSymbol)intf.tsym, fieldName, searched)) != null) {
                return vsym3;
            }
            l = l.tail;
        }
        return null;
    }

    Symbol.MethodSymbol findConstructor(Symbol.ClassSymbol tsym, List<Type> paramTypes) {
        Scope.Entry e = tsym.members().lookup(this.names.init);
        while (e.scope != null) {
            if (e.sym.kind == 16 && this.hasParameterTypes((Symbol.MethodSymbol)e.sym, paramTypes)) {
                return (Symbol.MethodSymbol)e.sym;
            }
            e = e.next();
        }
        return null;
    }

    private Symbol.MethodSymbol findMethod(Symbol.ClassSymbol tsym, Name methodName, List<Type> paramTypes) {
        return this.searchMethod(tsym, methodName, paramTypes, new HashSet<Symbol.ClassSymbol>());
    }

    private Symbol.MethodSymbol searchMethod(Symbol.ClassSymbol tsym, Name methodName, List<Type> paramTypes, Set<Symbol.ClassSymbol> searched) {
        Symbol.MethodSymbol msym;
        List intfs;
        Symbol.MethodSymbol msym2;
        if (methodName == this.names.init) {
            return null;
        }
        if (searched.contains(tsym)) {
            return null;
        }
        searched.add(tsym);
        Scope.Entry e = tsym.members().lookup(methodName);
        if (paramTypes == null) {
            Symbol.MethodSymbol lastFound = null;
            while (e.scope != null) {
                if (e.sym.kind == 16 && e.sym.name == methodName) {
                    lastFound = (Symbol.MethodSymbol)e.sym;
                }
                e = e.next();
            }
            if (lastFound != null) {
                return lastFound;
            }
        } else {
            while (e.scope != null) {
                if (e.sym != null && e.sym.kind == 16 && this.hasParameterTypes((Symbol.MethodSymbol)e.sym, paramTypes)) {
                    return (Symbol.MethodSymbol)e.sym;
                }
                e = e.next();
            }
        }
        Type superclass = tsym.getSuperclass();
        if (superclass.tsym != null && (msym2 = this.searchMethod((Symbol.ClassSymbol)superclass.tsym, methodName, paramTypes, searched)) != null) {
            return msym2;
        }
        List l = intfs = tsym.getInterfaces();
        while (l.nonEmpty()) {
            Symbol.MethodSymbol msym3;
            Type intf = (Type)l.head;
            if (!intf.isErroneous() && (msym3 = this.searchMethod((Symbol.ClassSymbol)intf.tsym, methodName, paramTypes, searched)) != null) {
                return msym3;
            }
            l = l.tail;
        }
        Symbol.ClassSymbol encl = tsym.owner.enclClass();
        if (encl != null && (msym = this.searchMethod(encl, methodName, paramTypes, searched)) != null) {
            return msym;
        }
        return null;
    }

    private boolean hasParameterTypes(Symbol.MethodSymbol method, List<Type> paramTypes) {
        if (paramTypes == null) {
            return true;
        }
        if (method.params().size() != paramTypes.size()) {
            return false;
        }
        List<Type> methodParamTypes = this.types.erasureRecursive((Type)method.asType()).getParameterTypes();
        return Type.isErroneous(paramTypes) ? this.fuzzyMatch(paramTypes, methodParamTypes) : this.types.isSameTypes(paramTypes, methodParamTypes);
    }

    boolean fuzzyMatch(List<Type> paramTypes, List<Type> methodParamTypes) {
        List<Type> l1 = paramTypes;
        List<Type> l2 = methodParamTypes;
        while (l1.nonEmpty()) {
            if (!this.fuzzyMatch((Type)l1.head, (Type)l2.head)) {
                return false;
            }
            l1 = l1.tail;
            l2 = l2.tail;
        }
        return true;
    }

    boolean fuzzyMatch(Type paramType, Type methodParamType) {
        Boolean b = (Boolean)this.fuzzyMatcher.visit(paramType, methodParamType);
        return b == Boolean.TRUE;
    }

    @Override
    public TypeMirror getTypeMirror(TreePath path) {
        Tree t = path.getLeaf();
        return ((JCTree)t).type;
    }

    @Override
    public JavacScope getScope(TreePath path) {
        return new JavacScope(this.getAttrContext(path));
    }

    @Override
    public boolean isAccessible(Scope scope, TypeElement type) {
        if (scope instanceof JavacScope && type instanceof Symbol.ClassSymbol) {
            Env<AttrContext> env = ((JavacScope)scope).env;
            return this.resolve.isAccessible(env, (Symbol.ClassSymbol)type, true);
        }
        return false;
    }

    @Override
    public boolean isAccessible(Scope scope, Element member, DeclaredType type) {
        if (scope instanceof JavacScope && member instanceof Symbol && type instanceof Type) {
            Env<AttrContext> env = ((JavacScope)scope).env;
            return this.resolve.isAccessible(env, (Type)((Object)type), (Symbol)member, true);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Env<AttrContext> getAttrContext(TreePath path) {
        if (!(path.getLeaf() instanceof JCTree)) {
            throw new IllegalArgumentException();
        }
        if (this.javacTaskImpl != null) {
            try {
                this.javacTaskImpl.enter(null);
            }
            catch (IOException e) {
                throw new Error("unexpected error while entering symbols: " + e);
            }
        }
        JCTree.JCCompilationUnit unit = (JCTree.JCCompilationUnit)path.getCompilationUnit();
        Copier copier = this.createCopier(this.treeMaker.forToplevel(unit));
        Env<AttrContext> env = null;
        JCTree.JCMethodDecl method = null;
        JCTree.JCVariableDecl field = null;
        List<Tree> l = List.nil();
        for (TreePath p = path; p != null; p = p.getParentPath()) {
            l = l.prepend(p.getLeaf());
        }
        while (l.nonEmpty()) {
            Tree tree = (Tree)l.head;
            switch (tree.getKind()) {
                case COMPILATION_UNIT: {
                    env = this.enter.getTopLevelEnv((JCTree.JCCompilationUnit)tree);
                    break;
                }
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    env = this.enter.getClassEnv(((JCTree.JCClassDecl)tree).sym);
                    break;
                }
                case METHOD: {
                    method = (JCTree.JCMethodDecl)tree;
                    env = this.memberEnter.getMethodEnv(method, env);
                    break;
                }
                case VARIABLE: {
                    field = (JCTree.JCVariableDecl)tree;
                    break;
                }
                case BLOCK: {
                    if (method != null) {
                        try {
                            Assert.check(method.body == tree);
                            method.body = copier.copy((JCTree.JCBlock)tree, (JCTree)path.getLeaf());
                            env = this.attribStatToTree(method.body, env, copier.leafCopy);
                        }
                        finally {
                            method.body = (JCTree.JCBlock)tree;
                        }
                    } else {
                        JCTree.JCBlock body = copier.copy((JCTree.JCBlock)tree, (JCTree)path.getLeaf());
                        env = this.attribStatToTree(body, env, copier.leafCopy);
                    }
                    return env;
                }
                default: {
                    if (field == null || field.getInitializer() != tree) break;
                    env = this.memberEnter.getInitEnv(field, env);
                    JCTree.JCExpression expr = copier.copy((JCTree.JCExpression)tree, (JCTree)path.getLeaf());
                    env = this.attribExprToTree(expr, env, copier.leafCopy);
                    return env;
                }
            }
            l = l.tail;
        }
        return field != null ? this.memberEnter.getInitEnv(field, env) : env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Env<AttrContext> attribStatToTree(JCTree stat, Env<AttrContext> env, JCTree tree) {
        JavaFileObject prev = this.log.useSource(env.toplevel.sourcefile);
        try {
            Env<AttrContext> env2 = this.attr.attribStatToTree(stat, env, tree);
            return env2;
        }
        finally {
            this.log.useSource(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Env<AttrContext> attribExprToTree(JCTree.JCExpression expr, Env<AttrContext> env, JCTree tree) {
        JavaFileObject prev = this.log.useSource(env.toplevel.sourcefile);
        try {
            Env<AttrContext> env2 = this.attr.attribExprToTree(expr, env, tree);
            return env2;
        }
        finally {
            this.log.useSource(prev);
        }
    }

    protected Copier createCopier(TreeMaker maker) {
        return new Copier(maker);
    }

    @Override
    public TypeMirror getOriginalType(ErrorType errorType) {
        if (errorType instanceof Type.ErrorType) {
            return ((Type.ErrorType)errorType).getOriginalType();
        }
        return Type.noType;
    }

    @Override
    public void printMessage(Diagnostic.Kind kind, CharSequence msg, Tree t, CompilationUnitTree root) {
        this.printMessage(kind, msg, ((JCTree)t).pos(), root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void printMessage(Diagnostic.Kind kind, CharSequence msg, JCDiagnostic.DiagnosticPosition pos, CompilationUnitTree root) {
        JavaFileObject oldSource = null;
        JavaFileObject newSource = null;
        newSource = root.getSourceFile();
        if (newSource == null) {
            pos = null;
        } else {
            oldSource = this.log.useSource(newSource);
        }
        try {
            switch (kind) {
                case ERROR: {
                    boolean prev = this.log.multipleErrors;
                    try {
                        this.log.error(pos, "proc.messager", msg.toString());
                        return;
                    }
                    finally {
                        this.log.multipleErrors = prev;
                    }
                }
                case WARNING: {
                    this.log.warning(pos, "proc.messager", msg.toString());
                    return;
                }
                case MANDATORY_WARNING: {
                    this.log.mandatoryWarning(pos, "proc.messager", msg.toString());
                    return;
                }
                default: {
                    this.log.note(pos, "proc.messager", msg.toString());
                    return;
                }
            }
        }
        finally {
            if (oldSource != null) {
                this.log.useSource(oldSource);
            }
        }
    }

    @Override
    public TypeMirror getLub(CatchTree tree) {
        JCTree.JCCatch ct = (JCTree.JCCatch)tree;
        JCTree.JCVariableDecl v = ct.param;
        if (v.type != null && v.type.getKind() == TypeKind.UNION) {
            Type.UnionClassType ut = (Type.UnionClassType)v.type;
            return ut.getLub();
        }
        return v.type;
    }

    @Override
    public SourcePositions getSourcePositions() {
        return null;
    }

    @Override
    public String getDocComment(TreePath path) {
        return null;
    }

    protected static class Copier
    extends TreeCopier<JCTree> {
        JCTree leafCopy = null;

        protected Copier(TreeMaker M) {
            super(M);
        }

        @Override
        public <T extends JCTree> T copy(T t, JCTree leaf) {
            T t2 = super.copy(t, leaf);
            if (t == leaf) {
                this.leafCopy = t2;
            }
            return t2;
        }
    }
}

