/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.langtools.tools.javac.code;

import com.redhat.ceylon.javax.lang.model.element.AnnotationMirror;
import com.redhat.ceylon.javax.lang.model.element.AnnotationValue;
import com.redhat.ceylon.javax.lang.model.element.AnnotationValueVisitor;
import com.redhat.ceylon.javax.lang.model.type.DeclaredType;
import com.redhat.ceylon.langtools.tools.javac.code.Symbol;
import com.redhat.ceylon.langtools.tools.javac.code.TargetType;
import com.redhat.ceylon.langtools.tools.javac.code.Type;
import com.redhat.ceylon.langtools.tools.javac.code.TypeAnnotationPosition;
import com.redhat.ceylon.langtools.tools.javac.code.Types;
import com.redhat.ceylon.langtools.tools.javac.util.Assert;
import com.redhat.ceylon.langtools.tools.javac.util.Constants;
import com.redhat.ceylon.langtools.tools.javac.util.Name;
import com.redhat.ceylon.langtools.tools.javac.util.Pair;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class Attribute
implements AnnotationValue {
    public Type type;

    public Attribute(Type type) {
        this.type = type;
    }

    public abstract void accept(Visitor var1);

    @Override
    public Object getValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <R, P> R accept(AnnotationValueVisitor<R, P> v, P p) {
        throw new UnsupportedOperationException();
    }

    public boolean isSynthesized() {
        return false;
    }

    public TypeAnnotationPosition getPosition() {
        return null;
    }

    public static enum RetentionPolicy {
        SOURCE,
        CLASS,
        RUNTIME;

    }

    public static interface Visitor {
        public void visitConstant(Constant var1);

        public void visitClass(Class var1);

        public void visitCompound(Compound var1);

        public void visitArray(Array var1);

        public void visitEnum(Enum var1);

        public void visitError(Error var1);
    }

    public static class UnresolvedClass
    extends Error {
        public Type classType;

        public UnresolvedClass(Type type, Type classType) {
            super(type);
            this.classType = classType;
        }
    }

    public static class Error
    extends Attribute {
        public Error(Type type) {
            super(type);
        }

        @Override
        public void accept(Visitor v) {
            v.visitError(this);
        }

        @Override
        public String toString() {
            return "<error>";
        }

        @Override
        public String getValue() {
            return this.toString();
        }

        @Override
        public <R, P> R accept(AnnotationValueVisitor<R, P> v, P p) {
            return v.visitString(this.toString(), p);
        }
    }

    public static class Enum
    extends Attribute {
        public Symbol.VarSymbol value;

        public Enum(Type type, Symbol.VarSymbol value) {
            super(type);
            this.value = Assert.checkNonNull(value);
        }

        @Override
        public void accept(Visitor v) {
            v.visitEnum(this);
        }

        @Override
        public String toString() {
            return this.value.enclClass() + "." + this.value;
        }

        @Override
        public Symbol.VarSymbol getValue() {
            return this.value;
        }

        @Override
        public <R, P> R accept(AnnotationValueVisitor<R, P> v, P p) {
            return v.visitEnumConstant(this.value, p);
        }
    }

    public static class Array
    extends Attribute {
        public final Attribute[] values;

        public Array(Type type, Attribute[] values) {
            super(type);
            this.values = values;
        }

        public Array(Type type, com.redhat.ceylon.langtools.tools.javac.util.List<Attribute> values) {
            super(type);
            this.values = values.toArray(new Attribute[values.size()]);
        }

        @Override
        public void accept(Visitor v) {
            v.visitArray(this);
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append('{');
            boolean first = true;
            for (Attribute value : this.values) {
                if (!first) {
                    buf.append(", ");
                }
                first = false;
                buf.append(value);
            }
            buf.append('}');
            return buf.toString();
        }

        @Override
        public com.redhat.ceylon.langtools.tools.javac.util.List<Attribute> getValue() {
            return com.redhat.ceylon.langtools.tools.javac.util.List.from(this.values);
        }

        @Override
        public <R, P> R accept(AnnotationValueVisitor<R, P> v, P p) {
            return v.visitArray((List<AnnotationValue>)this.getValue(), p);
        }

        @Override
        public TypeAnnotationPosition getPosition() {
            if (this.values.length != 0) {
                return this.values[0].getPosition();
            }
            return null;
        }
    }

    public static class TypeCompound
    extends Compound {
        public TypeAnnotationPosition position;

        public TypeCompound(Compound compound, TypeAnnotationPosition position) {
            this(compound.type, compound.values, position);
        }

        public TypeCompound(Type type, com.redhat.ceylon.langtools.tools.javac.util.List<Pair<Symbol.MethodSymbol, Attribute>> values, TypeAnnotationPosition position) {
            super(type, values);
            this.position = position;
        }

        @Override
        public TypeAnnotationPosition getPosition() {
            if (this.hasUnknownPosition()) {
                this.position = super.getPosition();
            }
            return this.position;
        }

        public boolean hasUnknownPosition() {
            return this.position.type == TargetType.UNKNOWN;
        }

        public boolean isContainerTypeCompound() {
            if (this.isSynthesized() && this.values.size() == 1) {
                return this.getFirstEmbeddedTC() != null;
            }
            return false;
        }

        private TypeCompound getFirstEmbeddedTC() {
            if (this.values.size() == 1) {
                Pair val = (Pair)this.values.get(0);
                if (((Name)((Symbol.MethodSymbol)val.fst).getSimpleName()).contentEquals("value") && val.snd instanceof Array) {
                    Array arr = (Array)val.snd;
                    if (arr.values.length != 0 && arr.values[0] instanceof TypeCompound) {
                        return (TypeCompound)arr.values[0];
                    }
                }
            }
            return null;
        }

        public boolean tryFixPosition() {
            if (!this.isContainerTypeCompound()) {
                return false;
            }
            TypeCompound from = this.getFirstEmbeddedTC();
            if (from != null && from.position != null && from.position.type != TargetType.UNKNOWN) {
                this.position = from.position;
                return true;
            }
            return false;
        }
    }

    public static class Compound
    extends Attribute
    implements AnnotationMirror {
        public final com.redhat.ceylon.langtools.tools.javac.util.List<Pair<Symbol.MethodSymbol, Attribute>> values;
        private boolean synthesized = false;

        @Override
        public boolean isSynthesized() {
            return this.synthesized;
        }

        public void setSynthesized(boolean synthesized) {
            this.synthesized = synthesized;
        }

        public Compound(Type type, com.redhat.ceylon.langtools.tools.javac.util.List<Pair<Symbol.MethodSymbol, Attribute>> values) {
            super(type);
            this.values = values;
        }

        @Override
        public void accept(Visitor v) {
            v.visitCompound(this);
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("@");
            buf.append(this.type);
            int len = this.values.length();
            if (len > 0) {
                buf.append('(');
                boolean first = true;
                for (Pair<Symbol.MethodSymbol, Attribute> value : this.values) {
                    if (!first) {
                        buf.append(", ");
                    }
                    first = false;
                    Name name = ((Symbol.MethodSymbol)value.fst).name;
                    if (len > 1 || name != name.table.names.value) {
                        buf.append(name);
                        buf.append('=');
                    }
                    buf.append(value.snd);
                }
                buf.append(')');
            }
            return buf.toString();
        }

        public Attribute member(Name member) {
            Pair<Symbol.MethodSymbol, Attribute> res = this.getElemPair(member);
            return res == null ? null : (Attribute)res.snd;
        }

        private Pair<Symbol.MethodSymbol, Attribute> getElemPair(Name member) {
            for (Pair<Symbol.MethodSymbol, Attribute> pair : this.values) {
                if (((Symbol.MethodSymbol)pair.fst).name != member) continue;
                return pair;
            }
            return null;
        }

        @Override
        public Compound getValue() {
            return this;
        }

        @Override
        public <R, P> R accept(AnnotationValueVisitor<R, P> v, P p) {
            return v.visitAnnotation(this, p);
        }

        @Override
        public DeclaredType getAnnotationType() {
            return (DeclaredType)((Object)this.type);
        }

        @Override
        public TypeAnnotationPosition getPosition() {
            if (this.values.size() != 0) {
                Name valueName = ((Symbol.MethodSymbol)((Pair)this.values.head).fst).name.table.names.value;
                Pair<Symbol.MethodSymbol, Attribute> res = this.getElemPair(valueName);
                return res == null ? null : ((Attribute)res.snd).getPosition();
            }
            return null;
        }

        public Map<Symbol.MethodSymbol, Attribute> getElementValues() {
            LinkedHashMap<Symbol.MethodSymbol, Attribute> valmap = new LinkedHashMap<Symbol.MethodSymbol, Attribute>();
            for (Pair<Symbol.MethodSymbol, Attribute> value : this.values) {
                valmap.put((Symbol.MethodSymbol)value.fst, (Attribute)value.snd);
            }
            return valmap;
        }
    }

    public static class Class
    extends Attribute {
        public final Type classType;

        @Override
        public void accept(Visitor v) {
            v.visitClass(this);
        }

        public Class(Types types, Type type) {
            super(Class.makeClassType(types, type));
            this.classType = type;
        }

        static Type makeClassType(Types types, Type type) {
            Type arg = type.isPrimitive() ? types.boxedClass((Type)type).type : types.erasure(type);
            return new Type.ClassType(types.syms.classType.getEnclosingType(), com.redhat.ceylon.langtools.tools.javac.util.List.of(arg), types.syms.classType.tsym);
        }

        @Override
        public String toString() {
            return this.classType + ".class";
        }

        @Override
        public Type getValue() {
            return this.classType;
        }

        @Override
        public <R, P> R accept(AnnotationValueVisitor<R, P> v, P p) {
            return v.visitType(this.classType, p);
        }
    }

    public static class Constant
    extends Attribute {
        public final Object value;

        @Override
        public void accept(Visitor v) {
            v.visitConstant(this);
        }

        public Constant(Type type, Object value) {
            super(type);
            this.value = value;
        }

        @Override
        public String toString() {
            return Constants.format(this.value, this.type);
        }

        @Override
        public Object getValue() {
            return Constants.decode(this.value, this.type);
        }

        @Override
        public <R, P> R accept(AnnotationValueVisitor<R, P> v, P p) {
            if (this.value instanceof String) {
                return v.visitString((String)this.value, p);
            }
            if (this.value instanceof Integer) {
                int i = (Integer)this.value;
                switch (this.type.getTag()) {
                    case BOOLEAN: {
                        return v.visitBoolean(i != 0, p);
                    }
                    case CHAR: {
                        return v.visitChar((char)i, p);
                    }
                    case BYTE: {
                        return v.visitByte((byte)i, p);
                    }
                    case SHORT: {
                        return v.visitShort((short)i, p);
                    }
                    case INT: {
                        return v.visitInt(i, p);
                    }
                }
            }
            switch (this.type.getTag()) {
                case LONG: {
                    return v.visitLong((Long)this.value, p);
                }
                case FLOAT: {
                    return v.visitFloat(((Float)this.value).floatValue(), p);
                }
                case DOUBLE: {
                    return v.visitDouble((Double)this.value, p);
                }
            }
            throw new AssertionError((Object)("Bad annotation element value: " + this.value));
        }
    }
}

