/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.langtools.tools.javac.code;

import com.redhat.ceylon.langtools.tools.javac.code.Symbol;
import com.redhat.ceylon.langtools.tools.javac.util.Assert;
import com.redhat.ceylon.langtools.tools.javac.util.Filter;
import com.redhat.ceylon.langtools.tools.javac.util.List;
import com.redhat.ceylon.langtools.tools.javac.util.Name;
import java.util.Iterator;

public class Scope {
    private int shared;
    public Scope next;
    public Symbol owner;
    Entry[] table;
    int hashMask;
    public Entry elems;
    int nelems = 0;
    List<ScopeListener> listeners = List.nil();
    private static final Entry sentinel = new Entry(null, null, null, null);
    private static final int INITIAL_SIZE = 16;
    public static final Scope emptyScope = new Scope(null, null, new Entry[0]);
    static final Filter<Symbol> noFilter = new Filter<Symbol>(){

        @Override
        public boolean accepts(Symbol s) {
            return true;
        }
    };

    private Scope(Scope next, Symbol owner, Entry[] table) {
        this.next = next;
        Assert.check(emptyScope == null || owner != null);
        this.owner = owner;
        this.table = table;
        this.hashMask = table.length - 1;
    }

    private Scope(Scope next, Symbol owner, Entry[] table, int nelems) {
        this(next, owner, table);
        this.nelems = nelems;
    }

    public Scope(Symbol owner) {
        this(null, owner, new Entry[16]);
    }

    public Scope dup() {
        return this.dup(this.owner);
    }

    public Scope dup(Symbol newOwner) {
        Scope result = new Scope(this, newOwner, this.table, this.nelems);
        ++this.shared;
        return result;
    }

    public Scope dupUnshared() {
        return new Scope(this, this.owner, (Entry[])this.table.clone(), this.nelems);
    }

    public Scope leave() {
        Assert.check(this.shared == 0);
        if (this.table != this.next.table) {
            return this.next;
        }
        while (this.elems != null) {
            int hash = this.getIndex(this.elems.sym.name);
            Entry e = this.table[hash];
            Assert.check(e == this.elems, this.elems.sym);
            this.table[hash] = this.elems.shadowed;
            this.elems = this.elems.sibling;
        }
        Assert.check(this.next.shared > 0);
        --this.next.shared;
        this.next.nelems = this.nelems;
        return this.next;
    }

    private void dble() {
        Assert.check(this.shared == 0);
        Entry[] oldtable = this.table;
        Entry[] newtable = new Entry[oldtable.length * 2];
        Scope s = this;
        while (s != null) {
            if (s.table == oldtable) {
                Assert.check(s == this || s.shared != 0);
                s.table = newtable;
                s.hashMask = newtable.length - 1;
            }
            s = s.next;
        }
        int n = 0;
        int i = oldtable.length;
        while (--i >= 0) {
            Entry e = oldtable[i];
            if (e == null || e == sentinel) continue;
            this.table[this.getIndex((Name)e.sym.name)] = e;
            ++n;
        }
        this.nelems = n;
    }

    public void enter(Symbol sym) {
        Assert.check(this.shared == 0);
        this.enter(sym, this);
    }

    public void enter(Symbol sym, Scope s) {
        this.enter(sym, s, s, false);
    }

    public void enter(Symbol sym, Scope s, Scope origin, boolean staticallyImported) {
        Entry e;
        int hash;
        Entry old;
        Assert.check(this.shared == 0);
        if (this.nelems * 3 >= this.hashMask * 2) {
            this.dble();
        }
        if ((old = this.table[hash = this.getIndex(sym.name)]) == null) {
            old = sentinel;
            ++this.nelems;
        }
        this.table[hash] = e = this.makeEntry(sym, old, this.elems, s, origin, staticallyImported);
        this.elems = e;
        List<ScopeListener> l = this.listeners;
        while (l.nonEmpty()) {
            ((ScopeListener)l.head).symbolAdded(sym, this);
            l = l.tail;
        }
    }

    Entry makeEntry(Symbol sym, Entry shadowed, Entry sibling, Scope scope, Scope origin, boolean staticallyImported) {
        return new Entry(sym, shadowed, sibling, scope);
    }

    public void addScopeListener(ScopeListener sl) {
        this.listeners = this.listeners.prepend(sl);
    }

    public void remove(final Symbol sym) {
        Assert.check(this.shared == 0);
        Entry e = this.lookup(sym.name, new Filter<Symbol>(){

            @Override
            public boolean accepts(Symbol candidate) {
                return candidate == sym;
            }
        });
        if (e.scope == null) {
            return;
        }
        int i = this.getIndex(sym.name);
        Entry te = this.table[i];
        if (te == e) {
            this.table[i] = e.shadowed;
        } else {
            while (true) {
                if (te.shadowed == e) {
                    te.shadowed = e.shadowed;
                    break;
                }
                te = te.shadowed;
            }
        }
        te = this.elems;
        if (te == e) {
            this.elems = e.sibling;
        } else {
            while (true) {
                if (te.sibling == e) {
                    te.sibling = e.sibling;
                    break;
                }
                te = te.sibling;
            }
        }
        List<ScopeListener> l = this.listeners;
        while (l.nonEmpty()) {
            ((ScopeListener)l.head).symbolRemoved(sym, this);
            l = l.tail;
        }
    }

    public void enterIfAbsent(Symbol sym) {
        Assert.check(this.shared == 0);
        Entry e = this.lookup(sym.name);
        while (e.scope == this && e.sym.kind != sym.kind) {
            e = e.next();
        }
        if (e.scope != this) {
            this.enter(sym);
        }
    }

    public boolean includes(Symbol c) {
        Entry e = this.lookup(c.name);
        while (e.scope == this) {
            if (e.sym == c) {
                return true;
            }
            e = e.next();
        }
        return false;
    }

    public Entry lookup(Name name) {
        return this.lookup(name, noFilter);
    }

    public Entry lookup(Name name, Filter<Symbol> sf) {
        Entry e = this.table[this.getIndex(name)];
        if (e == null || e == sentinel) {
            return sentinel;
        }
        while (!(e.scope == null || e.sym.name == name && sf.accepts(e.sym))) {
            e = e.shadowed;
        }
        return e;
    }

    int getIndex(Name name) {
        int h = name.hashCode();
        int i = h & this.hashMask;
        int x = this.hashMask - (h + (h >> 16) << 1);
        int d = -1;
        Entry e;
        while ((e = this.table[i]) != null) {
            if (e == sentinel) {
                if (d < 0) {
                    d = i;
                }
            } else if (e.sym.name == name) {
                return i;
            }
            i = i + x & this.hashMask;
        }
        return d >= 0 ? d : i;
    }

    public boolean anyMatch(Filter<Symbol> sf) {
        return this.getElements(sf).iterator().hasNext();
    }

    public Iterable<Symbol> getElements() {
        return this.getElements(noFilter);
    }

    public Iterable<Symbol> getElements(final Filter<Symbol> sf) {
        return new Iterable<Symbol>(){

            @Override
            public Iterator<Symbol> iterator() {
                return new Iterator<Symbol>(){
                    private Scope currScope;
                    private Entry currEntry;
                    {
                        this.currScope = Scope.this;
                        this.currEntry = Scope.this.elems;
                        this.update();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.currEntry != null;
                    }

                    @Override
                    public Symbol next() {
                        Symbol sym;
                        Symbol symbol = sym = this.currEntry == null ? null : this.currEntry.sym;
                        if (this.currEntry != null) {
                            this.currEntry = this.currEntry.sibling;
                        }
                        this.update();
                        return sym;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    private void update() {
                        this.skipToNextMatchingEntry();
                        while (this.currEntry == null && this.currScope.next != null) {
                            this.currScope = this.currScope.next;
                            this.currEntry = this.currScope.elems;
                            this.skipToNextMatchingEntry();
                        }
                    }

                    void skipToNextMatchingEntry() {
                        while (this.currEntry != null && !sf.accepts(this.currEntry.sym)) {
                            this.currEntry = this.currEntry.sibling;
                        }
                    }
                };
            }
        };
    }

    public Iterable<Symbol> getElementsByName(Name name) {
        return this.getElementsByName(name, noFilter);
    }

    public Iterable<Symbol> getElementsByName(final Name name, final Filter<Symbol> sf) {
        return new Iterable<Symbol>(){

            @Override
            public Iterator<Symbol> iterator() {
                return new Iterator<Symbol>(){
                    Entry currentEntry;
                    {
                        this.currentEntry = Scope.this.lookup(name, sf);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.currentEntry.scope != null;
                    }

                    @Override
                    public Symbol next() {
                        Entry prevEntry = this.currentEntry;
                        this.currentEntry = this.currentEntry.next(sf);
                        return prevEntry.sym;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Scope[");
        Scope s = this;
        while (s != null) {
            if (s != this) {
                result.append(" | ");
            }
            Entry e = s.elems;
            while (e != null) {
                if (e != s.elems) {
                    result.append(", ");
                }
                result.append(e.sym);
                e = e.sibling;
            }
            s = s.next;
        }
        result.append("]");
        return result.toString();
    }

    public static class ErrorScope
    extends Scope {
        ErrorScope(Scope next, Symbol errSymbol, Entry[] table) {
            super(next, errSymbol, table);
        }

        public ErrorScope(Symbol errSymbol) {
            super(errSymbol);
        }

        @Override
        public Scope dup() {
            return new ErrorScope(this, this.owner, this.table);
        }

        @Override
        public Scope dupUnshared() {
            return new ErrorScope(this, this.owner, (Entry[])this.table.clone());
        }

        @Override
        public Entry lookup(Name name) {
            Entry e = super.lookup(name);
            if (e.scope == null) {
                return new Entry(this.owner, null, null, null);
            }
            return e;
        }
    }

    public static class CompoundScope
    extends Scope
    implements ScopeListener {
        public static final Entry[] emptyTable = new Entry[0];
        private List<Scope> subScopes = List.nil();
        private int mark = 0;

        public CompoundScope(Symbol owner) {
            super(null, owner, emptyTable);
        }

        public void addSubScope(Scope that) {
            if (that != null) {
                this.subScopes = this.subScopes.prepend(that);
                that.addScopeListener(this);
                ++this.mark;
                for (ScopeListener sl : this.listeners) {
                    sl.symbolAdded(null, this);
                }
            }
        }

        @Override
        public void symbolAdded(Symbol sym, Scope s) {
            ++this.mark;
            for (ScopeListener sl : this.listeners) {
                sl.symbolAdded(sym, s);
            }
        }

        @Override
        public void symbolRemoved(Symbol sym, Scope s) {
            ++this.mark;
            for (ScopeListener sl : this.listeners) {
                sl.symbolRemoved(sym, s);
            }
        }

        public int getMark() {
            return this.mark;
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("CompoundScope{");
            String sep = "";
            for (Scope s : this.subScopes) {
                buf.append(sep);
                buf.append(s);
                sep = ",";
            }
            buf.append("}");
            return buf.toString();
        }

        @Override
        public Iterable<Symbol> getElements(final Filter<Symbol> sf) {
            return new Iterable<Symbol>(){

                @Override
                public Iterator<Symbol> iterator() {
                    return new CompoundScopeIterator(CompoundScope.this.subScopes){

                        @Override
                        Iterator<Symbol> nextIterator(Scope s) {
                            return s.getElements(sf).iterator();
                        }
                    };
                }
            };
        }

        @Override
        public Iterable<Symbol> getElementsByName(final Name name, final Filter<Symbol> sf) {
            return new Iterable<Symbol>(){

                @Override
                public Iterator<Symbol> iterator() {
                    return new CompoundScopeIterator(CompoundScope.this.subScopes){

                        @Override
                        Iterator<Symbol> nextIterator(Scope s) {
                            return s.getElementsByName(name, sf).iterator();
                        }
                    };
                }
            };
        }

        @Override
        public Entry lookup(Name name, Filter<Symbol> sf) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Scope dup(Symbol newOwner) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void enter(Symbol sym, Scope s, Scope origin, boolean staticallyImported) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove(Symbol sym) {
            throw new UnsupportedOperationException();
        }

        abstract class CompoundScopeIterator
        implements Iterator<Symbol> {
            private Iterator<Symbol> currentIterator;
            private List<Scope> scopesToScan;

            public CompoundScopeIterator(List<Scope> scopesToScan) {
                this.scopesToScan = scopesToScan;
                this.update();
            }

            abstract Iterator<Symbol> nextIterator(Scope var1);

            @Override
            public boolean hasNext() {
                return this.currentIterator != null;
            }

            @Override
            public Symbol next() {
                Symbol sym = this.currentIterator.next();
                if (!this.currentIterator.hasNext()) {
                    this.update();
                }
                return sym;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void update() {
                while (this.scopesToScan.nonEmpty()) {
                    this.currentIterator = this.nextIterator((Scope)this.scopesToScan.head);
                    this.scopesToScan = this.scopesToScan.tail;
                    if (!this.currentIterator.hasNext()) continue;
                    return;
                }
                this.currentIterator = null;
            }
        }
    }

    public static class DelegatedScope
    extends Scope {
        Scope delegatee;
        public static final Entry[] emptyTable = new Entry[0];

        public DelegatedScope(Scope outer) {
            super(outer, outer.owner, emptyTable);
            this.delegatee = outer;
        }

        @Override
        public Scope dup() {
            return new DelegatedScope(this.next);
        }

        @Override
        public Scope dupUnshared() {
            return new DelegatedScope(this.next);
        }

        @Override
        public Scope leave() {
            return this.next;
        }

        @Override
        public void enter(Symbol sym) {
        }

        @Override
        public void enter(Symbol sym, Scope s) {
        }

        @Override
        public void remove(Symbol sym) {
            throw new AssertionError(sym);
        }

        @Override
        public Entry lookup(Name name) {
            return this.delegatee.lookup(name);
        }
    }

    public static class StarImportScope
    extends ImportScope
    implements ScopeListener {
        public StarImportScope(Symbol owner) {
            super(owner);
        }

        public void importAll(Scope fromScope) {
            Entry e = fromScope.elems;
            while (e != null) {
                if (e.sym.kind == 2 && !this.includes(e.sym)) {
                    this.enter(e.sym, fromScope);
                }
                e = e.sibling;
            }
            fromScope.addScopeListener(this);
        }

        @Override
        public void symbolRemoved(Symbol sym, Scope s) {
            this.remove(sym);
        }

        @Override
        public void symbolAdded(Symbol sym, Scope s) {
        }
    }

    public static class ImportScope
    extends Scope {
        public ImportScope(Symbol owner) {
            super(owner);
        }

        @Override
        Entry makeEntry(Symbol sym, Entry shadowed, Entry sibling, Scope scope, final Scope origin, final boolean staticallyImported) {
            return new Entry(sym, shadowed, sibling, scope){

                @Override
                public Scope getOrigin() {
                    return origin;
                }

                @Override
                public boolean isStaticallyImported() {
                    return staticallyImported;
                }
            };
        }
    }

    public static class Entry {
        public Symbol sym;
        private Entry shadowed;
        public Entry sibling;
        public Scope scope;

        public Entry(Symbol sym, Entry shadowed, Entry sibling, Scope scope) {
            this.sym = sym;
            this.shadowed = shadowed;
            this.sibling = sibling;
            this.scope = scope;
        }

        public Entry next() {
            return this.shadowed;
        }

        public Entry next(Filter<Symbol> sf) {
            if (this.shadowed.sym == null || sf.accepts(this.shadowed.sym)) {
                return this.shadowed;
            }
            return this.shadowed.next(sf);
        }

        public boolean isStaticallyImported() {
            return false;
        }

        public Scope getOrigin() {
            return this.scope;
        }
    }

    public static interface ScopeListener {
        public void symbolAdded(Symbol var1, Scope var2);

        public void symbolRemoved(Symbol var1, Scope var2);
    }
}

