/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.langtools.tools.javac.processing;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;

class ServiceProxy {
    private static final String prefix = "META-INF/services/";

    ServiceProxy() {
    }

    private static void fail(Class<?> service, String msg) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(service.getName() + ": " + msg);
    }

    private static void fail(Class<?> service, URL u, int line, String msg) throws ServiceConfigurationError {
        ServiceProxy.fail(service, u + ":" + line + ": " + msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean parse(Class<?> service, URL u) throws ServiceConfigurationError {
        InputStream in = null;
        BufferedReader r = null;
        try {
            String ln;
            in = u.openStream();
            r = new BufferedReader(new InputStreamReader(in, "utf-8"));
            int lc = 1;
            while ((ln = r.readLine()) != null) {
                int cp;
                int n;
                int ci = ln.indexOf(35);
                if (ci >= 0) {
                    ln = ln.substring(0, ci);
                }
                if ((n = (ln = ln.trim()).length()) == 0) continue;
                if (ln.indexOf(32) >= 0 || ln.indexOf(9) >= 0) {
                    ServiceProxy.fail(service, u, lc, "Illegal configuration-file syntax");
                }
                if (!Character.isJavaIdentifierStart(cp = ln.codePointAt(0))) {
                    ServiceProxy.fail(service, u, lc, "Illegal provider-class name: " + ln);
                }
                for (int i = Character.charCount(cp); i < n; i += Character.charCount(cp)) {
                    cp = ln.codePointAt(i);
                    if (Character.isJavaIdentifierPart(cp) || cp == 46) continue;
                    ServiceProxy.fail(service, u, lc, "Illegal provider-class name: " + ln);
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (FileNotFoundException x) {
            boolean bl = false;
            return bl;
        }
        catch (IOException x) {
            ServiceProxy.fail(service, ": " + x);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException y) {
                ServiceProxy.fail(service, ": " + y);
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException y) {
                ServiceProxy.fail(service, ": " + y);
            }
        }
        return false;
    }

    public static boolean hasService(Class<?> service, URL[] urls) throws ServiceConfigurationError {
        for (URL url : urls) {
            try {
                String fullName = prefix + service.getName();
                URL u = new URL(url, fullName);
                boolean found = ServiceProxy.parse(service, u);
                if (!found) continue;
                return true;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return false;
    }

    static class ServiceConfigurationError
    extends Error {
        static final long serialVersionUID = 7732091036771098303L;

        ServiceConfigurationError(String msg) {
            super(msg);
        }
    }
}

