/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.launcher;

public class Java7Checker {
    public static void check() {
        String[] elems;
        String version2 = System.getProperty("java.version");
        String[] stringArray = elems = version2 != null ? version2.split("\\.|_|-") : null;
        if (version2 != null && !version2.isEmpty() && elems != null && elems.length >= 1) {
            try {
                int minor;
                int major = Integer.parseInt(elems[0]);
                int n = minor = elems.length > 1 ? Integer.parseInt(elems[1]) : 0;
                if (major == 1 && minor < 7) {
                    System.err.println("Your Java version is not supported: " + version2);
                    System.err.println("Ceylon needs Java 7 or newer. Please install it from http://www.java.com");
                    System.err.println("Aborting.");
                    System.exit(1);
                }
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        System.err.println("Unable to determine Java version (java.version property missing, empty or has unexpected format: '" + version2 + "'). Aborting.");
        System.exit(1);
    }
}

