/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.launcher;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.util.ArrayList;

public class LauncherUtil {
    private static final String CEYLON_REPO = "repo";
    private static final String CEYLON_LIBS = "lib";
    private static final boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0;

    private LauncherUtil() {
    }

    public static File determineHome() throws URISyntaxException {
        File ceylonHome;
        String ceylonHomeStr = System.getProperty("ceylon.home");
        if (ceylonHomeStr == null) {
            File script;
            File jar = LauncherUtil.determineRuntimeJar();
            ceylonHome = jar.getParentFile().getParentFile();
            if (ceylonHome.getName().equals("bootstrap") && ceylonHome.getParentFile().getName().equals("ceylon")) {
                ceylonHome = ceylonHome.getParentFile().getParentFile().getParentFile();
            }
            if (!LauncherUtil.checkHome(ceylonHome) && (ceylonHomeStr = System.getenv("CEYLON_HOME")) == null && (script = LauncherUtil.findCeylonScript()) != null) {
                ceylonHome = script.getParentFile().getParentFile();
            }
        } else {
            ceylonHome = new File(ceylonHomeStr);
        }
        return ceylonHome;
    }

    public static File determineRepo(File ceylonHome) throws URISyntaxException {
        String ceylonSystemRepo = System.getProperty("ceylon.system.repo");
        File ceylonRepo = ceylonSystemRepo != null ? new File(ceylonSystemRepo) : new File(ceylonHome, CEYLON_REPO);
        return ceylonRepo;
    }

    public static File determineLibs(File ceylonHome) throws URISyntaxException {
        String ceylonSystemRepo = System.getProperty("ceylon.system.libs");
        File ceylonLib = ceylonSystemRepo != null ? new File(ceylonSystemRepo) : new File(ceylonHome, CEYLON_LIBS);
        return ceylonLib;
    }

    public static String determineSystemVersion() {
        String ceylonVersion = System.getProperty("ceylon.system.version");
        if (ceylonVersion == null && (ceylonVersion = System.getenv("CEYLON_VERSION")) == null) {
            ceylonVersion = "1.3.3";
        }
        return ceylonVersion;
    }

    public static File determineRuntimeJar() throws URISyntaxException {
        return new File(LauncherUtil.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
    }

    private static File findCeylonScript() {
        String path = System.getenv("PATH");
        if (path != null) {
            String[] elems;
            String ceylonScriptName = IS_WINDOWS ? "ceylon.bat" : "ceylon";
            for (String elem : elems = path.split(File.pathSeparator)) {
                File script = new File(elem, ceylonScriptName);
                if (!script.isFile() || !script.canExecute() || !LauncherUtil.isSameScriptVersion(script)) continue;
                try {
                    return script.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private static boolean isSameScriptVersion(File script) {
        ArrayList<String> args = new ArrayList<String>(4);
        if (IS_WINDOWS) {
            args.add("cmd.exe");
            args.add("/C");
        }
        args.add(script.getAbsolutePath());
        args.add("--version");
        ProcessBuilder processBuilder = new ProcessBuilder(args);
        try {
            String line;
            Process process = processBuilder.start();
            InputStream in = process.getInputStream();
            InputStreamReader inread = new InputStreamReader(in);
            BufferedReader bufferedreader = new BufferedReader(inread);
            StringBuilder sb = new StringBuilder();
            while ((line = bufferedreader.readLine()) != null) {
                sb.append(line);
            }
            int exit = process.waitFor();
            bufferedreader.close();
            if (exit != 0) {
                return false;
            }
            return sb.toString().startsWith("ceylon version 1.3");
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean checkHome(File ceylonHome) {
        return new File(ceylonHome, CEYLON_REPO).isDirectory() && new File(ceylonHome, CEYLON_LIBS).isDirectory();
    }

    public static boolean hasArgument(String[] args, String test) {
        for (String arg : args) {
            if ("--".equals(arg)) break;
            if (!arg.equals(test) && !arg.startsWith(test + "=")) continue;
            return true;
        }
        return false;
    }

    public static String getArgument(String[] args, String test, boolean optionalArgument) {
        String arg;
        for (int i = 0; i < args.length && !"--".equals(arg = args[i]); ++i) {
            if (!optionalArgument && i < args.length - 1 && arg.equals(test)) {
                return args[i + 1];
            }
            if (!arg.startsWith(test + "=")) continue;
            return arg.substring(test.length() + 1);
        }
        return null;
    }

    public static File absoluteFile(File file) {
        if (file != null) {
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException e) {
                file = file.getAbsoluteFile();
            }
        }
        return file;
    }
}

