/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.loader;

import com.redhat.ceylon.langtools.classfile.Annotation;
import com.redhat.ceylon.langtools.classfile.ClassFile;
import com.redhat.ceylon.langtools.classfile.ConstantPool;
import com.redhat.ceylon.langtools.classfile.ConstantPoolException;
import com.redhat.ceylon.langtools.classfile.RuntimeAnnotations_attribute;

public class ClassFileUtil {
    private static final ConstantPool.Visitor<Object, ConstantPool> ConstantPoolConverter = new ConstantPool.Visitor<Object, ConstantPool>(){

        @Override
        public Object visitClass(ConstantPool.CONSTANT_Class_info info, ConstantPool p) {
            return null;
        }

        @Override
        public Object visitDouble(ConstantPool.CONSTANT_Double_info info, ConstantPool p) {
            return info.value;
        }

        @Override
        public Object visitFieldref(ConstantPool.CONSTANT_Fieldref_info info, ConstantPool p) {
            return null;
        }

        @Override
        public Object visitFloat(ConstantPool.CONSTANT_Float_info info, ConstantPool p) {
            return Float.valueOf(info.value);
        }

        @Override
        public Object visitInteger(ConstantPool.CONSTANT_Integer_info info, ConstantPool p) {
            return info.value;
        }

        @Override
        public Object visitInterfaceMethodref(ConstantPool.CONSTANT_InterfaceMethodref_info info, ConstantPool p) {
            return null;
        }

        @Override
        public Object visitInvokeDynamic(ConstantPool.CONSTANT_InvokeDynamic_info info, ConstantPool p) {
            return null;
        }

        @Override
        public Object visitLong(ConstantPool.CONSTANT_Long_info info, ConstantPool p) {
            return info.value;
        }

        @Override
        public Object visitNameAndType(ConstantPool.CONSTANT_NameAndType_info info, ConstantPool p) {
            return null;
        }

        @Override
        public Object visitMethodref(ConstantPool.CONSTANT_Methodref_info info, ConstantPool p) {
            return null;
        }

        @Override
        public Object visitMethodHandle(ConstantPool.CONSTANT_MethodHandle_info info, ConstantPool p) {
            return null;
        }

        @Override
        public Object visitMethodType(ConstantPool.CONSTANT_MethodType_info info, ConstantPool p) {
            return null;
        }

        @Override
        public Object visitString(ConstantPool.CONSTANT_String_info info, ConstantPool p) {
            try {
                return info.getString();
            }
            catch (ConstantPoolException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Object visitUtf8(ConstantPool.CONSTANT_Utf8_info info, ConstantPool p) {
            return info.value;
        }

        @Override
        public Object visitModule(ConstantPool.CONSTANT_Module_info info, ConstantPool p) {
            return null;
        }

        @Override
        public Object visitPackage(ConstantPool.CONSTANT_Package_info info, ConstantPool p) {
            return null;
        }
    };
    private static final Annotation.element_value.Visitor<Object, ConstantPool> AnnotationConverter = new Annotation.element_value.Visitor<Object, ConstantPool>(){

        @Override
        public Object visitPrimitive(Annotation.Primitive_element_value ev, ConstantPool p) {
            try {
                ConstantPool.CPInfo cpInfo = p.get(ev.const_value_index);
                Object ret = cpInfo.accept(ConstantPoolConverter, p);
                switch (ev.tag) {
                    case 66: {
                        return ((Integer)ret).byteValue();
                    }
                    case 67: {
                        return new Character((char)((Integer)ret).intValue());
                    }
                    case 83: {
                        return ((Integer)ret).shortValue();
                    }
                    case 90: {
                        int v = (Integer)ret;
                        return v == 0 ? Boolean.FALSE : Boolean.TRUE;
                    }
                }
                return ret;
            }
            catch (ConstantPool.InvalidIndex e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Object visitEnum(Annotation.Enum_element_value ev, ConstantPool p) {
            return null;
        }

        @Override
        public Object visitClass(Annotation.Class_element_value ev, ConstantPool p) {
            return null;
        }

        @Override
        public Object visitAnnotation(Annotation.Annotation_element_value ev, ConstantPool p) {
            return ev.annotation_value;
        }

        @Override
        public Object visitArray(Annotation.Array_element_value ev, ConstantPool p) {
            Object[] ret = new Object[ev.num_values];
            int i = 0;
            for (Annotation.element_value val : ev.values) {
                ret[i++] = val.accept(this, p);
            }
            return ret;
        }
    };

    public static Object getAnnotationValue(ClassFile classFile, Annotation moduleAnnotation, String name) {
        Annotation.element_value val = null;
        for (Annotation.element_value_pair pair : moduleAnnotation.element_value_pairs) {
            try {
                if (!classFile.constant_pool.getUTF8Value(pair.element_name_index).equals(name)) continue;
                val = pair.value;
                break;
            }
            catch (ConstantPoolException e) {
                throw new RuntimeException(e);
            }
        }
        if (val == null) {
            return null;
        }
        return val.accept(AnnotationConverter, classFile.constant_pool);
    }

    public static Annotation findAnnotation(ClassFile classFile, RuntimeAnnotations_attribute annotationsAttribute, Class<?> annotationClass) {
        return ClassFileUtil.findAnnotation(classFile, annotationsAttribute, annotationClass.getName());
    }

    public static Annotation findAnnotation(ClassFile classFile, RuntimeAnnotations_attribute annotationsAttribute, String annotationClassName) {
        if (annotationsAttribute == null) {
            return null;
        }
        String classNameAsFieldDescriptor = ClassFileUtil.toFieldDescriptor(annotationClassName);
        for (Annotation annot : annotationsAttribute.annotations) {
            String typeFieldDescriptor;
            try {
                typeFieldDescriptor = classFile.constant_pool.getUTF8Value(annot.type_index);
            }
            catch (ConstantPoolException e) {
                throw new RuntimeException(e);
            }
            if (!typeFieldDescriptor.equals(classNameAsFieldDescriptor)) continue;
            return annot;
        }
        return null;
    }

    private static String toFieldDescriptor(String annotationClassName) {
        return "L" + annotationClassName.replace('.', '/') + ";";
    }

    public static Annotation findAnnotation(ClassFile classFile, String moduleAnnotation) {
        RuntimeAnnotations_attribute attribute = (RuntimeAnnotations_attribute)classFile.getAttribute("RuntimeVisibleAnnotations");
        return ClassFileUtil.findAnnotation(classFile, attribute, moduleAnnotation);
    }
}

