/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.loader;

import com.redhat.ceylon.model.cmr.JDKUtils;
import com.redhat.ceylon.model.loader.JvmBackendUtil;
import com.redhat.ceylon.model.typechecker.model.Module;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.zip.ZipException;

public class JdkProvider {
    private boolean alternateJdk;
    private Map<String, Set<String>> jdkModules = new HashMap<String, Set<String>>();
    private Module module;
    private String name;

    public JdkProvider(String name, String version2, Module module, File jar) throws ZipException, IOException {
        this.module = module;
        this.name = name;
        this.loadJar(jar);
        this.alternateJdk = true;
    }

    public JdkProvider() {
    }

    private void loadJar(File jar) throws ZipException, IOException {
        SortedSet<String> packages = JvmBackendUtil.listPackages(jar, null);
        for (String pkg : packages) {
            String jdkModuleName = JDKUtils.getJDKModuleNameForPackage(pkg);
            if (jdkModuleName == null) continue;
            Set<String> modulePackages = this.jdkModules.get(jdkModuleName);
            if (modulePackages == null) {
                modulePackages = new HashSet<String>();
                this.jdkModules.put(jdkModuleName, modulePackages);
            }
            modulePackages.add(pkg);
        }
    }

    public boolean isJDKModule(String module) {
        if (this.alternateJdk) {
            return this.jdkModules.containsKey(module);
        }
        return JDKUtils.isJDKModule(module) || JDKUtils.isOracleJDKModule(module);
    }

    public boolean isJDKPackage(String pkg) {
        if (this.alternateJdk) {
            for (Set<String> packages : this.jdkModules.values()) {
                if (!packages.contains(pkg)) continue;
                return true;
            }
        }
        return JDKUtils.isJDKAnyPackage(pkg) || JDKUtils.isOracleJDKAnyPackage(pkg);
    }

    public boolean isJDKPackage(String module, String pkg) {
        if (this.alternateJdk) {
            Set<String> packages = this.jdkModules.get(module);
            return packages != null && packages.contains(pkg);
        }
        return JDKUtils.isJDKPackage(module, pkg) || JDKUtils.isOracleJDKPackage(module, pkg);
    }

    public Set<String> getJDKModuleNames() {
        if (this.alternateJdk) {
            return this.jdkModules.keySet();
        }
        HashSet<String> modules = new HashSet<String>();
        modules.addAll(JDKUtils.getJDKModuleNames());
        modules.addAll(JDKUtils.getOracleJDKModuleNames());
        return modules;
    }

    public String getJDKVersion() {
        if (this.alternateJdk) {
            return "7";
        }
        return JDKUtils.jdk.version;
    }

    public String getJDKModuleNameForPackage(String pkg) {
        if (this.alternateJdk) {
            for (Map.Entry<String, Set<String>> entry : this.jdkModules.entrySet()) {
                if (!entry.getValue().contains(pkg)) continue;
                return entry.getKey();
            }
        }
        return JDKUtils.getJDKModuleNameForPackage(pkg);
    }

    public boolean isImplementationSpecificJDKPackage(String pkg) {
        if (this.alternateJdk) {
            return false;
        }
        return JDKUtils.isOracleJDKAnyPackage(pkg);
    }

    public List<String> getJDKPackageList() {
        ArrayList<String> ret = new ArrayList<String>(50);
        for (String module : this.getJDKModuleNames()) {
            for (String pkg : this.getJDKPackages(module)) {
                ret.add(pkg);
            }
        }
        return ret;
    }

    public Set<String> getJDKPackages(String module) {
        if (this.alternateJdk) {
            return this.jdkModules.get(module);
        }
        if (JDKUtils.isJDKModule(module)) {
            return JDKUtils.getJDKPackagesByModule(module);
        }
        if (JDKUtils.isOracleJDKModule(module)) {
            return JDKUtils.getOracleJDKPackagesByModule(module);
        }
        return Collections.emptySet();
    }

    public Module getJdkContainerModule() {
        return this.module;
    }

    public String getJdkContainerModuleName() {
        return this.name;
    }

    public boolean isAlternateJdk() {
        return this.alternateJdk;
    }
}

