/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.loader;

import com.redhat.ceylon.model.loader.AbstractModelLoader;
import com.redhat.ceylon.model.loader.ModelLoader;
import com.redhat.ceylon.model.loader.ModelResolutionException;
import com.redhat.ceylon.model.loader.TypeLexer;
import com.redhat.ceylon.model.loader.TypeParserException;
import com.redhat.ceylon.model.loader.model.FunctionOrValueInterface;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.SiteVariance;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.Unit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class TypeParser {
    private ModelLoader loader;
    private Unit unit;
    private TypeLexer lexer = new TypeLexer();
    private Scope scope;
    private Module moduleScope;

    public TypeParser(ModelLoader loader) {
        this.loader = loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type decodeType(String type, Scope scope, Module moduleScope, Unit unit) {
        char[] oldType = this.lexer.type;
        int oldIndex = this.lexer.index;
        int oldMark = this.lexer.mark;
        Scope oldScope = this.scope;
        Module oldModuleScope = this.moduleScope;
        Unit oldUnit = this.unit;
        try {
            this.lexer.setup(type);
            this.scope = scope;
            this.moduleScope = moduleScope;
            this.unit = unit;
            Type ret = this.parseType();
            if (!this.lexer.lookingAt(7)) {
                throw new TypeParserException("Junk lexemes remaining: " + this.lexer.eatTokenString());
            }
            Type type2 = ret;
            return type2;
        }
        finally {
            this.lexer.type = oldType;
            this.lexer.index = oldIndex;
            this.lexer.mark = oldMark;
            this.scope = oldScope;
            this.moduleScope = oldModuleScope;
            this.unit = oldUnit;
        }
    }

    private Type parseType() {
        Type type = this.parseUnionType();
        if (this.lexer.lookingAt(19)) {
            this.lexer.eat(19);
            type = this.unit.getEntryType(type, this.parseUnionType());
        }
        return type;
    }

    private Type parseUnionType() {
        Type firstType = this.parseIntersectionType();
        if (this.lexer.lookingAt(2)) {
            LinkedList<Type> caseTypes = new LinkedList<Type>();
            caseTypes.add(firstType);
            while (this.lexer.lookingAt(2)) {
                this.lexer.eat();
                caseTypes.add(this.parseIntersectionType());
            }
            return ModelUtil.union(caseTypes, this.unit);
        }
        return firstType;
    }

    private Type parseIntersectionType() {
        Type firstType = this.parsePrimaryType();
        if (this.lexer.lookingAt(1)) {
            LinkedList<Type> satisfiedTypes = new LinkedList<Type>();
            satisfiedTypes.add(firstType);
            while (this.lexer.lookingAt(1)) {
                this.lexer.eat();
                satisfiedTypes.add(this.parsePrimaryType());
            }
            return ModelUtil.intersection(satisfiedTypes, this.unit);
        }
        return firstType;
    }

    private Type parsePrimaryType() {
        Type type = this.parseAtomicType();
        type = this.parsePrimaryType(type);
        return type;
    }

    protected Type parseAtomicType() {
        Type type = this.lexer.lookingAt(11) ? this.parseEmptyOrTupleType() : (this.lexer.lookingAt(13) ? this.parseIterableAbbreviatedType() : this.parseQualifiedType());
        return type;
    }

    protected Type parsePrimaryType(Type type) {
        while (this.lexer.lookingAt(20) || this.lexer.lookingAt(11) || this.lexer.lookingAt(15)) {
            if (this.lexer.lookingAt(20)) {
                type = this.parseOptionalType(type);
                continue;
            }
            if (this.lexer.lookingAt(11)) {
                type = this.parseSequenceType(type);
                continue;
            }
            if (!this.lexer.lookingAt(15)) continue;
            type = this.parseCallableType(type);
        }
        return type;
    }

    private Type parseCallableType(Type primaryType) {
        Type arguments;
        this.lexer.eat(15);
        if (this.lexer.lookingAt(17)) {
            this.lexer.eat(17);
            arguments = this.parseUnionType();
        } else if (!this.lexer.lookingAt(16)) {
            TypeList typeList = this.parseTypeList();
            arguments = typeList.asTuple();
        } else {
            arguments = this.unit.getEmptyType();
        }
        this.lexer.eat(16);
        return this.unit.getCallableDeclaration().appliedType(null, Arrays.asList(primaryType, arguments));
    }

    private Type parseSequenceType(Type elementType) {
        Type result;
        this.lexer.eat(11);
        if (this.lexer.lookingAt(8)) {
            result = this.unit.getEmptyType();
            for (int length = this.lexer.eatDigits(); length > 0; --length) {
                result = this.unit.getTupleDeclaration().appliedType(null, Arrays.asList(elementType, elementType, result));
            }
        } else {
            result = this.unit.getSequentialType(elementType);
        }
        this.lexer.eat(12);
        return result;
    }

    private Type parseOptionalType(Type type) {
        this.lexer.eat(20);
        return this.unit.getOptionalType(type);
    }

    private Type parseIterableAbbreviatedType() {
        this.lexer.eat(13);
        Type iterated = this.parseUnionType();
        Type result = null;
        if (this.lexer.lookingAt(18)) {
            this.lexer.eat(18);
            result = this.unit.getNonemptyIterableType(iterated);
        } else if (this.lexer.lookingAt(17)) {
            this.lexer.eat(17);
            result = this.unit.getIterableType(iterated);
        } else {
            throw new TypeParserException("Expected multiplicity in abbreviated Iterable type: " + this.lexer.index);
        }
        this.lexer.eat(14);
        return result;
    }

    private Type parseEmptyOrTupleType() {
        this.lexer.eat(11);
        if (this.lexer.lookingAt(12)) {
            return this.parseEmptyType();
        }
        TypeList typeList = this.parseTypeList();
        Type result = typeList.asTuple();
        this.lexer.eat(12);
        return result;
    }

    protected Type parseEmptyType() {
        this.lexer.eat(12);
        return this.unit.getEmptyType();
    }

    private TypeList parseTypeList() {
        boolean atLeastOne;
        boolean variadic;
        ArrayList<Type> types = new ArrayList<Type>();
        int defaulted = 0;
        types.add(this.parseType());
        if (this.lexer.lookingAt(21)) {
            ++defaulted;
            this.lexer.eat(21);
        }
        while (this.lexer.lookingAt(0)) {
            this.lexer.eat(0);
            types.add(this.parseType());
            if (this.lexer.lookingAt(21)) {
                this.lexer.eat(21);
                ++defaulted;
                continue;
            }
            if (defaulted <= 0 || this.lexer.lookingAt(17)) continue;
            throw new TypeParserException("Non-defaulted argument after defaulted one: " + this.lexer.index);
        }
        if (this.lexer.lookingAt(17)) {
            this.lexer.eat(17);
            variadic = true;
            atLeastOne = false;
        } else if (this.lexer.lookingAt(18)) {
            this.lexer.eat(18);
            variadic = true;
            atLeastOne = true;
            if (defaulted > 0) {
                throw new TypeParserException("Nonempty variadic argument after defaulted one: " + this.lexer.index);
            }
        } else {
            variadic = false;
            atLeastOne = false;
        }
        return new TypeList(types, variadic, atLeastOne, defaulted);
    }

    private Type parseGroupedType() {
        this.lexer.eat(3);
        Type unionType = this.parseType();
        this.lexer.eat(4);
        return unionType;
    }

    private Type parseQualifiedType() {
        Type qualifyingType;
        String fullName;
        Type baseType;
        if (this.lexer.lookingAt(3)) {
            baseType = this.parseGroupedType();
        } else {
            BaseType bt = this.parseBaseType();
            fullName = bt.fullName;
            qualifyingType = bt.qualifyingType;
            while (this.lexer.lookingAt(5)) {
                this.lexer.eat();
                Part part = this.parseTypeNameWithArguments();
                fullName = fullName + '.' + part.name;
                qualifyingType = this.loadType(bt.pkg, fullName, part, qualifyingType);
            }
            if (qualifyingType == null) {
                throw new ModelResolutionException("Could not find type '" + fullName + "'");
            }
            if (!(qualifyingType instanceof Type)) {
                throw new ModelResolutionException("Type is a declaration (should be a Type): '" + fullName + "'");
            }
            baseType = qualifyingType;
        }
        fullName = "";
        qualifyingType = baseType;
        while (this.lexer.lookingAt(5)) {
            this.lexer.eat();
            Part part = this.parseTypeNameWithArguments();
            fullName = fullName + '.' + part.name;
            qualifyingType = this.loadType("", fullName, part, qualifyingType);
        }
        if (qualifyingType == null) {
            throw new ModelResolutionException("Could not find type '" + fullName + "'");
        }
        if (!(qualifyingType instanceof Type)) {
            throw new ModelResolutionException("Type is a declaration (should be a Type): '" + fullName + "'");
        }
        return qualifyingType;
    }

    private BaseType parseBaseType() {
        String pkg;
        if (this.hasPackage()) {
            StringBuilder pkgstr = new StringBuilder(this.lexer.eatWord());
            while (this.lexer.lookingAt(5)) {
                this.lexer.eat();
                pkgstr = pkgstr.append('.').append(this.lexer.eatWord());
            }
            this.lexer.eat(6);
            pkg = pkgstr.toString();
        } else {
            pkg = "";
        }
        Part part = this.parseTypeNameWithArguments();
        String fullName = pkg.isEmpty() ? part.name : pkg + "." + part.name;
        Type qualifyingType = this.loadType(pkg, fullName, part, null);
        if (qualifyingType == null) {
            throw new ModelResolutionException("Could not find type '" + fullName + "'");
        }
        return new BaseType(pkg, qualifyingType, fullName);
    }

    private boolean hasPackage() {
        this.lexer.mark();
        while (this.lexer.lookingAt(8) || this.lexer.lookingAt(5)) {
            this.lexer.eat();
        }
        boolean result = this.lexer.lookingAt(6);
        this.lexer.reset();
        return result;
    }

    private Type loadType(String pkg, String fullName, Part part, Type qualifyingType) {
        try {
            Declaration newDeclaration;
            if (qualifyingType == null) {
                Package foundPackage = this.moduleScope.getPackage(pkg);
                newDeclaration = foundPackage != null ? this.loader.getDeclaration(foundPackage.getModule(), pkg, fullName, this.scope) : (this.scope != null && !pkg.isEmpty() && this.loader.isDynamicMetamodel() ? this.loader.getDeclaration(this.loader.getLoadedModule("default", null), pkg, fullName, this.scope) : (this.scope != null ? this.loader.getDeclaration(this.moduleScope, pkg, fullName, this.scope) : null));
            } else {
                Declaration qualifyingDeclaration = qualifyingType.getDeclaration();
                if (qualifyingType.isUnion() || qualifyingType.isIntersection()) {
                    newDeclaration = qualifyingDeclaration.getMember(part.name, null, false);
                } else {
                    if (qualifyingDeclaration instanceof FunctionOrValueInterface) {
                        qualifyingDeclaration = ((FunctionOrValueInterface)qualifyingDeclaration).getUnderlyingDeclaration();
                    }
                    newDeclaration = AbstractModelLoader.getDirectMember((Scope)((Object)qualifyingDeclaration), part.name);
                }
                if (newDeclaration == null) {
                    throw new ModelResolutionException("Failed to resolve inner type or declaration " + part.name + " in " + qualifyingDeclaration.getQualifiedNameString());
                }
            }
            if (newDeclaration == null) {
                return null;
            }
            TypeDeclaration newTypeDeclaration = newDeclaration instanceof TypeDeclaration ? (TypeDeclaration)newDeclaration : new FunctionOrValueInterface((TypedDeclaration)newDeclaration);
            Type ret = newTypeDeclaration.appliedType(qualifyingType, part.getParameters());
            if (!part.getVariance().isEmpty()) {
                List<TypeParameter> tps = newTypeDeclaration.getTypeParameters();
                List<SiteVariance> variance = part.getVariance();
                int l1 = tps.size();
                int l2 = variance.size();
                for (int i = 0; i < l1 && i < l2; ++i) {
                    SiteVariance siteVariance = variance.get(i);
                    if (siteVariance == null) continue;
                    ret.setVariance(tps.get(i), siteVariance);
                }
            }
            return ret;
        }
        catch (ModelResolutionException x) {
            if (qualifyingType != null || part.parameters != null && !part.parameters.isEmpty()) {
                throw x;
            }
            return null;
        }
    }

    private Part parseTypeNameWithArguments() {
        Part type = new Part();
        type.name = this.lexer.eatWord();
        if (this.lexer.lookingAt(3)) {
            this.lexer.eat();
            this.parseTypeArgumentVariance(type);
            type.parameters = new LinkedList<Type>();
            type.parameters.add(this.parseType());
            while (this.lexer.lookingAt(0)) {
                this.lexer.eat();
                this.parseTypeArgumentVariance(type);
                type.parameters.add(this.parseType());
            }
            this.lexer.eat(4);
        }
        return type;
    }

    private void parseTypeArgumentVariance(Part type) {
        SiteVariance variance = null;
        if (this.lexer.lookingAt(9)) {
            variance = SiteVariance.OUT;
            this.lexer.eat();
        } else if (this.lexer.lookingAt(10)) {
            variance = SiteVariance.IN;
            this.lexer.eat();
        }
        if (variance != null && type.variance == null) {
            type.variance = new LinkedList<SiteVariance>();
            int l = type.getParameters().size();
            for (int i = 0; i < l; ++i) {
                type.variance.add(null);
            }
        }
        if (type.variance != null) {
            type.variance.add(variance);
        }
    }

    static class BaseType {
        String pkg;
        String fullName;
        Type qualifyingType;

        public BaseType(String pkg, Type qualifyingType, String fullName) {
            this.pkg = pkg;
            this.qualifyingType = qualifyingType;
            this.fullName = fullName;
        }
    }

    class TypeList {
        List<Type> types;
        boolean variadic;
        boolean atLeastOne;
        int defaulted;

        public TypeList(List<Type> types, boolean variadic, boolean atLeastOne, int defaulted) {
            this.types = types;
            this.variadic = variadic;
            this.atLeastOne = atLeastOne;
            this.defaulted = defaulted;
        }

        public Type getFirst() {
            return this.types.get(0);
        }

        Type getLast() {
            return this.types.get(this.types.size() - 1);
        }

        Type asTuple() {
            Type result;
            if (this.types.size() == 0) {
                result = TypeParser.this.unit.getEmptyType();
            } else {
                Type sequentialType;
                Part part;
                if (this.variadic) {
                    part = new Part("Sequence", Collections.singletonList(this.getLast()));
                    sequentialType = TypeParser.this.loadType("ceylon.language", this.atLeastOne ? "ceylon.language.Sequence" : "ceylon.language.Sequential", part, null);
                } else {
                    sequentialType = TypeParser.this.unit.getEmptyType();
                }
                if (this.variadic && this.types.size() == 1) {
                    result = sequentialType;
                } else {
                    part = new Part();
                    Type union = this.variadic ? this.getLast() : null;
                    Type tupleType = sequentialType;
                    int makeDefaulted = this.defaulted;
                    for (int ii = this.types.size() - (this.variadic ? 2 : 1); ii >= 0; --ii) {
                        Type t = this.types.get(ii);
                        union = union != null ? ModelUtil.unionType(union, t, TypeParser.this.unit) : t;
                        part.parameters = Arrays.asList(union, t, tupleType);
                        part.name = "Tuple";
                        tupleType = TypeParser.this.loadType("ceylon.language", "ceylon.language.Tuple", part, null);
                        if (makeDefaulted <= 0) continue;
                        --makeDefaulted;
                        tupleType = ModelUtil.union(Arrays.asList(TypeParser.this.unit.getEmptyType(), tupleType), TypeParser.this.unit);
                    }
                    result = tupleType;
                }
            }
            return result;
        }
    }

    public class Part {
        String name;
        List<Type> parameters;
        List<SiteVariance> variance;

        public Part() {
        }

        public Part(String name) {
            this.name = name;
        }

        public Part(String name, List<Type> parameters) {
            this.name = name;
            this.parameters = parameters;
        }

        List<Type> getParameters() {
            return this.parameters != null ? this.parameters : Collections.emptyList();
        }

        List<SiteVariance> getVariance() {
            return this.variance != null ? this.variance : Collections.emptyList();
        }
    }
}

