/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.loader.impl.reflect.model;

import com.redhat.ceylon.model.loader.AbstractModelLoader;
import com.redhat.ceylon.model.loader.impl.reflect.model.ReflectionModuleManager;
import com.redhat.ceylon.model.loader.model.LazyModule;
import com.redhat.ceylon.model.typechecker.model.Package;
import java.util.List;

public class ReflectionModule
extends LazyModule {
    private ReflectionModuleManager modelManager;
    private boolean packagesLoaded = false;

    public ReflectionModule(ReflectionModuleManager reflectionModuleManager) {
        this.modelManager = reflectionModuleManager;
    }

    @Override
    protected AbstractModelLoader getModelLoader() {
        return this.modelManager.getModelLoader();
    }

    @Override
    public List<Package> getPackages() {
        final AbstractModelLoader modelLoader = this.getModelLoader();
        if (!this.packagesLoaded) {
            modelLoader.synchronizedRun(new Runnable(){

                @Override
                public void run() {
                    if (!ReflectionModule.this.packagesLoaded) {
                        String name = ReflectionModule.this.getNameAsString();
                        for (String pkg : ReflectionModule.this.getJarPackages()) {
                            if (name.equals("ceylon.language") && !pkg.startsWith("ceylon.language")) continue;
                            modelLoader.findOrCreatePackage(ReflectionModule.this, pkg);
                        }
                        ReflectionModule.this.packagesLoaded = true;
                    }
                }
            });
        }
        return super.getPackages();
    }
}

