/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.loader.model;

import com.redhat.ceylon.model.loader.mirror.AnnotationMirror;
import com.redhat.ceylon.model.loader.model.AnnotationProxyClass;
import com.redhat.ceylon.model.loader.model.LazyInterface;
import com.redhat.ceylon.model.loader.model.OutputElement;
import com.redhat.ceylon.model.typechecker.model.Class;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public enum AnnotationTarget {
    TYPE{

        @Override
        public Set<OutputElement> outputs() {
            return Collections.singleton(OutputElement.TYPE);
        }
    }
    ,
    FIELD{

        @Override
        public Set<OutputElement> outputs() {
            return Collections.singleton(OutputElement.FIELD);
        }
    }
    ,
    METHOD{

        @Override
        public Set<OutputElement> outputs() {
            HashSet<OutputElement> result = new HashSet<OutputElement>(3);
            result.add(OutputElement.METHOD);
            result.add(OutputElement.GETTER);
            result.add(OutputElement.SETTER);
            return result;
        }
    }
    ,
    PARAMETER{

        @Override
        public Set<OutputElement> outputs() {
            return Collections.singleton(OutputElement.PARAMETER);
        }
    }
    ,
    CONSTRUCTOR{

        @Override
        public Set<OutputElement> outputs() {
            return Collections.singleton(OutputElement.CONSTRUCTOR);
        }
    }
    ,
    LOCAL_VARIABLE{

        @Override
        public Set<OutputElement> outputs() {
            return Collections.singleton(OutputElement.LOCAL_VARIABLE);
        }
    }
    ,
    ANNOTATION_TYPE{

        @Override
        public Set<OutputElement> outputs() {
            return Collections.singleton(OutputElement.ANNOTATION_TYPE);
        }
    }
    ,
    PACKAGE{

        @Override
        public Set<OutputElement> outputs() {
            return EnumSet.of(OutputElement.PACKAGE, OutputElement.TYPE);
        }
    }
    ,
    TYPE_USE{

        @Override
        public Set<OutputElement> outputs() {
            return Collections.emptySet();
        }
    }
    ,
    TYPE_PARAMETER{

        @Override
        public Set<OutputElement> outputs() {
            return Collections.emptySet();
        }
    };


    public abstract Set<OutputElement> outputs();

    public static EnumSet<AnnotationTarget> getAnnotationTarget(LazyInterface annotationType) {
        AnnotationMirror targetAnno = annotationType.classMirror.getAnnotation("java.lang.annotation.Target");
        if (targetAnno != null) {
            List targets = (List)targetAnno.getValue();
            EnumSet<AnnotationTarget> result = EnumSet.noneOf(AnnotationTarget.class);
            for (String name : targets) {
                result.add(AnnotationTarget.valueOf(name));
            }
            return result;
        }
        return null;
    }

    private static EnumSet<AnnotationTarget> annotationTargets(Class annotationClass) {
        if (annotationClass instanceof AnnotationProxyClass) {
            return AnnotationTarget.getAnnotationTarget(((AnnotationProxyClass)annotationClass).iface);
        }
        return null;
    }

    private static EnumSet<OutputElement> possibleCeylonTargets(EnumSet<AnnotationTarget> targets) {
        if (targets == null) {
            targets = EnumSet.allOf(AnnotationTarget.class);
        }
        EnumSet<OutputElement> result = EnumSet.noneOf(OutputElement.class);
        for (AnnotationTarget t : targets) {
            result.addAll(t.outputs());
        }
        return result;
    }

    public static EnumSet<OutputElement> outputTargets(Class annotationClass) {
        return AnnotationTarget.possibleCeylonTargets(AnnotationTarget.annotationTargets(annotationClass));
    }
}

