/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.loader.model;

import com.redhat.ceylon.model.loader.JvmBackendUtil;
import com.redhat.ceylon.model.loader.ModelCompleter;
import com.redhat.ceylon.model.loader.NamingBase;
import com.redhat.ceylon.model.loader.mirror.ClassMirror;
import com.redhat.ceylon.model.loader.model.LazyContainer;
import com.redhat.ceylon.model.typechecker.model.Annotation;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.Reference;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.Unit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LazyInterface
extends Interface
implements LazyContainer {
    public final ClassMirror classMirror;
    private ModelCompleter completer;
    private String realName;
    private boolean isCeylon;
    private Map<String, Declaration> localDeclarations;
    private boolean isLoaded = false;
    private boolean isLoaded2 = false;
    private boolean isTypeParamsLoaded = false;
    private boolean isTypeParamsLoaded2 = false;
    private boolean isAnnotationType = false;
    private boolean local;
    public ClassMirror companionClass;

    @Override
    protected Class<?> getModelClass() {
        return this.getClass().getSuperclass();
    }

    public LazyInterface(ClassMirror classMirror, ModelCompleter completer) {
        this.classMirror = classMirror;
        this.completer = completer;
        this.realName = classMirror.getName();
        this.isAnnotationType = classMirror.isAnnotationType();
        this.isCeylon = classMirror.getAnnotation("com.redhat.ceylon.compiler.java.metadata.Ceylon") != null;
        String ceylonName = JvmBackendUtil.getMirrorName(classMirror);
        if (!this.isCeylon && JvmBackendUtil.isInitialLowerCase(ceylonName)) {
            ceylonName = NamingBase.capitalize(ceylonName);
        }
        this.setName(ceylonName);
    }

    @Override
    public boolean isErasedTypeArguments() {
        return !this.isCeylon();
    }

    @Override
    public boolean isCeylon() {
        return this.isCeylon;
    }

    public boolean isAnnotationType() {
        return this.isAnnotationType;
    }

    public String getRealName() {
        return this.realName;
    }

    private void load() {
        if (!this.isLoaded2) {
            this.completer.synchronizedRun(new Runnable(){

                @Override
                public void run() {
                    LazyInterface.this.loadTypeParams();
                    if (!LazyInterface.this.isLoaded) {
                        LazyInterface.this.isLoaded = true;
                        LazyInterface.this.completer.complete(LazyInterface.this);
                        LazyInterface.this.isLoaded2 = true;
                    }
                }
            });
        }
    }

    private void loadTypeParams() {
        if (!this.isTypeParamsLoaded2) {
            this.completer.synchronizedRun(new Runnable(){

                @Override
                public void run() {
                    if (!LazyInterface.this.isTypeParamsLoaded) {
                        LazyInterface.this.isTypeParamsLoaded = true;
                        LazyInterface.this.completer.completeTypeParameters(LazyInterface.this);
                        LazyInterface.this.isTypeParamsLoaded2 = true;
                    }
                }
            });
        }
    }

    @Override
    public String toString() {
        if (!this.isLoaded) {
            return "UNLOADED:" + super.toString();
        }
        return super.toString();
    }

    @Override
    public List<Declaration> getMembers() {
        this.load();
        return super.getMembers();
    }

    @Override
    public Type getType() {
        this.loadTypeParams();
        return super.getType();
    }

    @Override
    public Type getExtendedType() {
        this.load();
        return super.getExtendedType();
    }

    @Override
    public List<TypeParameter> getTypeParameters() {
        this.loadTypeParams();
        return super.getTypeParameters();
    }

    @Override
    public boolean isMember() {
        return super.isMember();
    }

    @Override
    public Type getDeclaringType(Declaration d) {
        this.load();
        return super.getDeclaringType(d);
    }

    @Override
    public boolean isParameterized() {
        this.loadTypeParams();
        return super.isParameterized();
    }

    @Override
    public List<Type> getSatisfiedTypes() {
        this.load();
        return super.getSatisfiedTypes();
    }

    @Override
    public List<Type> getCaseTypes() {
        this.load();
        return super.getCaseTypes();
    }

    @Override
    public Reference appliedReference(Type pt, List<Type> typeArguments) {
        this.loadTypeParams();
        return super.appliedReference(pt, typeArguments);
    }

    @Override
    public Type appliedType(Type outerType, List<Type> typeArguments) {
        this.loadTypeParams();
        return super.appliedType(outerType, typeArguments);
    }

    @Override
    public List<Declaration> getInheritedMembers(String name) {
        this.load();
        return super.getInheritedMembers(name);
    }

    @Override
    public Declaration getRefinedMember(String name, List<Type> signature, boolean ellipsis) {
        this.load();
        return super.getRefinedMember(name, signature, ellipsis);
    }

    @Override
    public Declaration getMember(String name, List<Type> signature, boolean ellipsis) {
        this.load();
        return super.getMember(name, signature, ellipsis);
    }

    @Override
    public Declaration getMemberOrParameter(String name, List<Type> signature, boolean ellipsis) {
        this.load();
        return super.getMemberOrParameter(name, signature, ellipsis);
    }

    @Override
    public boolean isAlias() {
        return super.isAlias();
    }

    @Override
    public Type getSelfType() {
        this.load();
        return super.getSelfType();
    }

    @Override
    public Scope getVisibleScope() {
        return super.getVisibleScope();
    }

    @Override
    public List<Annotation> getAnnotations() {
        this.load();
        return super.getAnnotations();
    }

    @Override
    public String getQualifiedNameString() {
        return super.getQualifiedNameString();
    }

    @Override
    public boolean isActual() {
        this.load();
        return super.isActual();
    }

    @Override
    public boolean isFormal() {
        this.load();
        return super.isFormal();
    }

    @Override
    public boolean isDefault() {
        this.load();
        return super.isDefault();
    }

    @Override
    public boolean isVisible(Scope scope) {
        return super.isVisible(scope);
    }

    @Override
    public boolean isDefinedInScope(Scope scope) {
        this.load();
        return super.isDefinedInScope(scope);
    }

    @Override
    public boolean isCaptured() {
        this.load();
        return super.isCaptured();
    }

    @Override
    public boolean isToplevel() {
        return super.isToplevel();
    }

    @Override
    public boolean isClassMember() {
        return super.isClassMember();
    }

    @Override
    public boolean isInterfaceMember() {
        return super.isInterfaceMember();
    }

    @Override
    public boolean isClassOrInterfaceMember() {
        return super.isClassOrInterfaceMember();
    }

    @Override
    public Unit getUnit() {
        return super.getUnit();
    }

    @Override
    public Scope getContainer() {
        return super.getContainer();
    }

    @Override
    public Declaration getDirectMember(String name, List<Type> signature, boolean ellipsis) {
        this.load();
        return super.getDirectMember(name, signature, ellipsis);
    }

    @Override
    public Declaration getMemberOrParameter(Unit unit, String name, List<Type> signature, boolean ellipsis) {
        this.load();
        return super.getMemberOrParameter(unit, name, signature, ellipsis);
    }

    @Override
    public void addMember(Declaration decl) {
        super.addMember(decl);
    }

    @Override
    public boolean isLoaded() {
        return this.isLoaded;
    }

    @Override
    public void setLocal(boolean local) {
        this.local = local;
    }

    @Override
    public boolean isLocal() {
        return this.local;
    }

    @Override
    public Declaration getLocalDeclaration(String name) {
        this.load();
        if (this.localDeclarations == null) {
            return null;
        }
        return this.localDeclarations.get(name);
    }

    @Override
    public void addLocalDeclaration(Declaration declaration) {
        if (this.localDeclarations == null) {
            this.localDeclarations = new HashMap<String, Declaration>();
        }
        this.localDeclarations.put(declaration.getPrefixedName(), declaration);
    }

    @Override
    public boolean isDeprecated() {
        return super.isDeprecated();
    }

    @Override
    public boolean isJava() {
        return !this.isCeylon;
    }

    @Override
    public String getSamName() {
        this.load();
        return super.getSamName();
    }
}

