/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.loader.model;

import com.redhat.ceylon.model.loader.JvmBackendUtil;
import com.redhat.ceylon.model.loader.ModelCompleter;
import com.redhat.ceylon.model.loader.mirror.ClassMirror;
import com.redhat.ceylon.model.loader.model.LazyContainer;
import com.redhat.ceylon.model.typechecker.model.Annotation;
import com.redhat.ceylon.model.typechecker.model.Cancellable;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.DeclarationKind;
import com.redhat.ceylon.model.typechecker.model.DeclarationWithProximity;
import com.redhat.ceylon.model.typechecker.model.Import;
import com.redhat.ceylon.model.typechecker.model.Reference;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeAlias;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.Unit;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class LazyTypeAlias
extends TypeAlias
implements LazyContainer {
    public ClassMirror classMirror;
    private ModelCompleter completer;
    private boolean isLoaded = false;
    private boolean isLoaded2 = false;
    private boolean isTypeParamsLoaded = false;
    private boolean isTypeParamsLoaded2 = false;
    private boolean local;

    @Override
    protected Class<?> getModelClass() {
        return this.getClass().getSuperclass();
    }

    public LazyTypeAlias(ClassMirror classMirror, ModelCompleter completer) {
        this.classMirror = classMirror;
        this.completer = completer;
        this.setName(JvmBackendUtil.getMirrorName(classMirror));
    }

    private void load() {
        if (!this.isLoaded2) {
            this.completer.synchronizedRun(new Runnable(){

                @Override
                public void run() {
                    LazyTypeAlias.this.loadTypeParams();
                    if (!LazyTypeAlias.this.isLoaded) {
                        LazyTypeAlias.this.isLoaded = true;
                        LazyTypeAlias.this.completer.complete(LazyTypeAlias.this);
                        LazyTypeAlias.this.isLoaded2 = true;
                    }
                }
            });
        }
    }

    private void loadTypeParams() {
        if (!this.isTypeParamsLoaded2) {
            this.completer.synchronizedRun(new Runnable(){

                @Override
                public void run() {
                    if (!LazyTypeAlias.this.isTypeParamsLoaded) {
                        LazyTypeAlias.this.isTypeParamsLoaded = true;
                        LazyTypeAlias.this.completer.completeTypeParameters(LazyTypeAlias.this);
                        LazyTypeAlias.this.isTypeParamsLoaded2 = true;
                    }
                }
            });
        }
    }

    @Override
    public String toString() {
        if (!this.isLoaded) {
            return "UNLOADED:" + super.toString();
        }
        return super.toString();
    }

    @Override
    public boolean isLoaded() {
        return this.isLoaded;
    }

    @Override
    public void addMember(Declaration decl) {
        super.getMembers().add(decl);
    }

    @Override
    public Type appliedType(Type outerType, List<Type> typeArguments) {
        this.loadTypeParams();
        return super.appliedType(outerType, typeArguments);
    }

    @Override
    public DeclarationKind getDeclarationKind() {
        this.load();
        return super.getDeclarationKind();
    }

    @Override
    public boolean isAlias() {
        return super.isAlias();
    }

    @Override
    protected TypeDeclaration clone() {
        this.load();
        return super.clone();
    }

    @Override
    public boolean isParameterized() {
        this.loadTypeParams();
        return super.isParameterized();
    }

    @Override
    public List<TypeParameter> getTypeParameters() {
        this.loadTypeParams();
        return super.getTypeParameters();
    }

    @Override
    public Type getExtendedType() {
        this.load();
        return super.getExtendedType();
    }

    @Override
    public List<Type> getSatisfiedTypes() {
        this.load();
        return super.getSatisfiedTypes();
    }

    @Override
    public List<Type> getCaseTypes() {
        this.load();
        return super.getCaseTypes();
    }

    @Override
    public Reference appliedReference(Type pt, List<Type> typeArguments) {
        this.loadTypeParams();
        return super.appliedReference(pt, typeArguments);
    }

    @Override
    public Type getType() {
        this.loadTypeParams();
        return super.getType();
    }

    @Override
    public List<Declaration> getInheritedMembers(String name) {
        this.load();
        return super.getInheritedMembers(name);
    }

    @Override
    public boolean isMember(Declaration dec) {
        this.load();
        return super.isMember(dec);
    }

    @Override
    public boolean inherits(TypeDeclaration dec) {
        this.load();
        return super.inherits(dec);
    }

    @Override
    public Declaration getRefinedMember(String name, List<Type> signature, boolean ellipsis) {
        this.load();
        return super.getRefinedMember(name, signature, ellipsis);
    }

    @Override
    public Declaration getMember(String name, Unit unit, List<Type> signature, boolean ellipsis) {
        this.load();
        return super.getMember(name, unit, signature, ellipsis);
    }

    @Override
    public Declaration getMember(String name, List<Type> signature, boolean ellipsis) {
        this.load();
        return super.getMember(name, signature, ellipsis);
    }

    @Override
    public Declaration getMemberOrParameter(String name, List<Type> signature, boolean ellipsis) {
        this.load();
        return super.getMemberOrParameter(name, signature, ellipsis);
    }

    @Override
    public boolean isInherited(Declaration d) {
        this.load();
        return super.isInherited(d);
    }

    @Override
    public TypeDeclaration getInheritingDeclaration(Declaration d) {
        this.load();
        return super.getInheritingDeclaration(d);
    }

    @Override
    public boolean isInheritedFromSupertype(Declaration member) {
        this.load();
        return super.isInheritedFromSupertype(member);
    }

    @Override
    public Type getSelfType() {
        this.load();
        return super.getSelfType();
    }

    @Override
    public Map<String, DeclarationWithProximity> getImportableDeclarations(Unit unit, String startingWith, List<Import> imports, int proximity, Cancellable canceller) {
        if (canceller != null && canceller.isCancelled()) {
            return Collections.emptyMap();
        }
        this.load();
        return super.getImportableDeclarations(unit, startingWith, imports, proximity, canceller);
    }

    @Override
    public Map<String, DeclarationWithProximity> getMatchingDeclarations(Unit unit, String startingWith, int proximity, Cancellable canceller) {
        if (canceller != null && canceller.isCancelled()) {
            return Collections.emptyMap();
        }
        this.load();
        return super.getMatchingDeclarations(unit, startingWith, proximity, canceller);
    }

    @Override
    public Map<String, DeclarationWithProximity> getMatchingMemberDeclarations(Unit unit, Scope scope, String startingWith, int proximity, Cancellable canceller) {
        if (canceller != null && canceller.isCancelled()) {
            return Collections.emptyMap();
        }
        this.load();
        return super.getMatchingMemberDeclarations(unit, scope, startingWith, proximity, canceller);
    }

    @Override
    public Scope getVisibleScope() {
        return super.getVisibleScope();
    }

    @Override
    public String getName() {
        return super.getName();
    }

    @Override
    public boolean isShared() {
        return super.isShared();
    }

    @Override
    public List<Annotation> getAnnotations() {
        this.load();
        return super.getAnnotations();
    }

    @Override
    public String getQualifiedNameString() {
        this.load();
        return super.getQualifiedNameString();
    }

    @Override
    public boolean isActual() {
        this.load();
        return super.isActual();
    }

    @Override
    public boolean isFormal() {
        this.load();
        return super.isFormal();
    }

    @Override
    public boolean isDefault() {
        this.load();
        return super.isDefault();
    }

    @Override
    public Declaration getRefinedDeclaration() {
        this.load();
        return super.getRefinedDeclaration();
    }

    @Override
    public boolean isVisible(Scope scope) {
        return super.isVisible(scope);
    }

    @Override
    public boolean isDefinedInScope(Scope scope) {
        this.load();
        return super.isDefinedInScope(scope);
    }

    @Override
    public boolean isCaptured() {
        this.load();
        return super.isCaptured();
    }

    @Override
    public boolean isToplevel() {
        return super.isToplevel();
    }

    @Override
    public boolean isClassMember() {
        return super.isClassMember();
    }

    @Override
    public boolean isInterfaceMember() {
        return super.isInterfaceMember();
    }

    @Override
    public boolean isClassOrInterfaceMember() {
        return super.isClassOrInterfaceMember();
    }

    @Override
    public boolean isMember() {
        return super.isMember();
    }

    @Override
    public boolean isStatic() {
        return super.isStatic();
    }

    @Override
    public boolean isProtectedVisibility() {
        return super.isProtectedVisibility();
    }

    @Override
    public boolean isPackageVisibility() {
        return super.isPackageVisibility();
    }

    @Override
    public boolean refines(Declaration other) {
        this.load();
        return super.refines(other);
    }

    @Override
    public boolean isAnonymous() {
        this.load();
        return super.isAnonymous();
    }

    @Override
    public String getNameAsString() {
        this.load();
        return super.getNameAsString();
    }

    @Override
    public Unit getUnit() {
        return super.getUnit();
    }

    @Override
    public Scope getContainer() {
        return super.getContainer();
    }

    @Override
    public List<Declaration> getMembers() {
        this.load();
        return super.getMembers();
    }

    @Override
    public Declaration getDirectMember(String name, List<Type> signature, boolean ellipsis) {
        this.load();
        return super.getDirectMember(name, signature, ellipsis);
    }

    @Override
    public Type getDeclaringType(Declaration d) {
        this.load();
        return super.getDeclaringType(d);
    }

    @Override
    public Declaration getMemberOrParameter(Unit unit, String name, List<Type> signature, boolean ellipsis) {
        this.load();
        return super.getMemberOrParameter(unit, name, signature, ellipsis);
    }

    @Override
    public void setLocal(boolean local) {
        this.local = local;
    }

    @Override
    public boolean isLocal() {
        return this.local;
    }

    @Override
    public Declaration getLocalDeclaration(String name) {
        return null;
    }

    @Override
    public void addLocalDeclaration(Declaration declaration) {
        throw new RuntimeException("type aliases do not contain any local declarations");
    }

    @Override
    public boolean isDeprecated() {
        return super.isDeprecated();
    }

    @Override
    public boolean isCeylon() {
        return true;
    }
}

