/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.typechecker.model;

import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import com.redhat.ceylon.model.typechecker.model.Reference;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import java.util.Collections;
import java.util.List;

public class Class
extends ClassOrInterface
implements Functional {
    private static final int EMPTY_VALUE = 0x800000;
    private static final int FALSE_VALUE = 0x400000;
    private static final int TRUE_VALUE = 0x200000;
    private static final int NULL_VALUE = 0x100000;
    private static final int RANGE = 4096;
    private static final int ARRAY = 8192;
    private static final int THROWABLE = 16384;
    private static final int EXCEPTION = 32768;
    private static final int ENTRY = 2048;
    private static final int TUPLE = 1024;
    private static final int BYTE = 512;
    private static final int INTEGER = 256;
    private static final int FLOAT = 128;
    private static final int CHARACTER = 64;
    private static final int STRING = 32;
    private static final int BOOLEAN = 16;
    private static final int BASIC = 8;
    private static final int NULL = 4;
    private static final int OBJECT = 2;
    private static final int ANYTHING = 1;
    private ParameterList parameterList;
    private List<Reference> unimplementedFormals = Collections.emptyList();
    private int code;
    private int sequentialType;
    private int sequenceType;
    private Class realClass;

    public boolean hasConstructors() {
        return (this.flags & 0x1000L) != 0L;
    }

    public void setConstructors(boolean constructors) {
        this.flags = constructors ? (this.flags |= 0x1000L) : (this.flags &= 0xFFFFFFFFFFFFEFFFL);
    }

    public boolean hasEnumerated() {
        return (this.flags & 0x2000L) != 0L;
    }

    public void setEnumerated(boolean enumerated) {
        this.flags = enumerated ? (this.flags |= 0x2000L) : (this.flags &= 0xFFFFFFFFFFFFDFFFL);
    }

    public boolean hasStaticMembers() {
        for (Declaration dec : this.getMembers()) {
            if (!dec.isStatic()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAnonymous() {
        return (this.flags & 0x20000L) != 0L;
    }

    public void setAnonymous(boolean anonymous) {
        this.flags = anonymous ? (this.flags |= 0x20000L) : (this.flags &= 0xFFFFFFFFFFFDFFFFL);
    }

    @Override
    public boolean isObjectClass() {
        return (this.flags & 0x20000L) != 0L;
    }

    @Override
    public boolean isNamed() {
        return (this.flags & 0x400000L) == 0L;
    }

    public void setNamed(boolean named) {
        this.flags = !named ? (this.flags |= 0x400000L) : (this.flags &= 0xFFFFFFFFFFBFFFFFL);
    }

    @Override
    public boolean isAbstract() {
        return (this.flags & 0x4000L) != 0L;
    }

    public void setAbstract(boolean abstr) {
        this.flags = abstr ? (this.flags |= 0x4000L) : (this.flags &= 0xFFFFFFFFFFFFBFFFL);
    }

    public Constructor getDefaultConstructor() {
        if (this.hasConstructors()) {
            for (Declaration dec : this.getMembers()) {
                if (!(dec instanceof Constructor) || dec.getName() != null) continue;
                return (Constructor)dec;
            }
            return null;
        }
        return null;
    }

    public FunctionOrValue getDefaultConstructorFunctionOrValue() {
        if (this.hasConstructors()) {
            for (Declaration dec : this.getMembers()) {
                if (!(dec instanceof FunctionOrValue) || dec.getName() != null) continue;
                return (FunctionOrValue)dec;
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean isSealed() {
        if (this.parameterList == null) {
            Constructor defaultConstructor = this.getDefaultConstructor();
            return defaultConstructor != null && defaultConstructor.isSealed();
        }
        return super.isSealed();
    }

    @Override
    public ParameterList getFirstParameterList() {
        return this.getParameterList();
    }

    public ParameterList getParameterList() {
        if (this.hasConstructors()) {
            Constructor defaultConstructor = this.getDefaultConstructor();
            return defaultConstructor == null ? null : defaultConstructor.getParameterList();
        }
        return this.parameterList;
    }

    public void setParameterList(ParameterList parameterList) {
        this.parameterList = parameterList;
    }

    @Override
    public List<ParameterList> getParameterLists() {
        ParameterList parameterList = this.getParameterList();
        if (parameterList == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(parameterList);
    }

    @Override
    public void addParameterList(ParameterList pl) {
        this.parameterList = pl;
    }

    @Override
    public Parameter getParameter(String name) {
        for (Declaration d : this.getMembers()) {
            if (!d.isParameter() || !ModelUtil.isNamed(name, d)) continue;
            FunctionOrValue fov = (FunctionOrValue)d;
            return fov.getInitializerParameter();
        }
        return null;
    }

    @Override
    public boolean isOverloaded() {
        return (this.flags & 0x100000L) != 0L;
    }

    public void setOverloaded(boolean overloaded) {
        this.flags = overloaded ? (this.flags |= 0x100000L) : (this.flags &= 0xFFFFFFFFFFEFFFFFL);
    }

    @Override
    public Type getExtendedType() {
        Type et = super.getExtendedType();
        if (et == null) {
            return null;
        }
        if (et.isUnknown()) {
            return et;
        }
        if (et.isClass()) {
            return et;
        }
        return this.unit.getAnythingType();
    }

    public void setAbstraction(boolean abstraction) {
        this.flags = abstraction ? (this.flags |= 0x200000L) : (this.flags &= 0xFFFFFFFFFFDFFFFFL);
    }

    @Override
    public boolean isAbstraction() {
        return (this.flags & 0x200000L) != 0L;
    }

    @Override
    public boolean isFinal() {
        return (this.flags & 0x8000L) != 0L || (this.flags & 0x20000L) != 0L;
    }

    public void setFinal(boolean fin) {
        this.flags = fin ? (this.flags |= 0x8000L) : (this.flags &= 0xFFFFFFFFFFFF7FFFL);
    }

    @Override
    public boolean isDeclaredVoid() {
        return false;
    }

    @Override
    public boolean isFunctional() {
        return true;
    }

    private void setCode() {
        String name;
        Package p;
        Scope scope;
        if (this.code == 0 && (scope = this.getContainer()) instanceof Package && (p = (Package)scope).isLanguagePackage() && (name = this.getName()) != null) {
            switch (name) {
                case "Anything": {
                    this.code = 1;
                    break;
                }
                case "Object": {
                    this.code = 2;
                    break;
                }
                case "Null": {
                    this.code = 4;
                    break;
                }
                case "Basic": {
                    this.code = 8;
                    break;
                }
                case "Boolean": {
                    this.code = 16;
                    break;
                }
                case "String": {
                    this.code = 32;
                    break;
                }
                case "Character": {
                    this.code = 64;
                    break;
                }
                case "Float": {
                    this.code = 128;
                    break;
                }
                case "Integer": {
                    this.code = 256;
                    break;
                }
                case "Byte": {
                    this.code = 512;
                    break;
                }
                case "Tuple": {
                    this.code = 1024;
                    break;
                }
                case "Entry": {
                    this.code = 2048;
                    break;
                }
                case "Range": {
                    this.code = 4096;
                    break;
                }
                case "Array": {
                    this.code = 8192;
                    break;
                }
                case "Throwable": {
                    this.code = 16384;
                    break;
                }
                case "Exception": {
                    this.code = 32768;
                    break;
                }
                case "null": {
                    this.code = 0x100000;
                    break;
                }
                case "true": {
                    this.code = 0x200000;
                    break;
                }
                case "false": {
                    this.code = 0x400000;
                    break;
                }
                case "empty": {
                    this.code = 0x800000;
                    break;
                }
                default: {
                    this.code = -1;
                }
            }
        }
    }

    @Override
    public boolean isAnything() {
        this.setCode();
        return this.code == 1;
    }

    @Override
    public boolean isObject() {
        this.setCode();
        return this.code == 2;
    }

    @Override
    public boolean isNull() {
        this.setCode();
        return this.code == 4;
    }

    @Override
    public boolean isNullValue() {
        this.setCode();
        return this.code == 0x100000;
    }

    @Override
    public boolean isTrueValue() {
        this.setCode();
        return this.code == 0x200000;
    }

    @Override
    public boolean isFalseValue() {
        this.setCode();
        return this.code == 0x400000;
    }

    @Override
    boolean isEmptyValue() {
        this.setCode();
        return this.code == 0x800000;
    }

    @Override
    public boolean isBasic() {
        this.setCode();
        return this.code == 8;
    }

    @Override
    public boolean isBoolean() {
        this.setCode();
        return this.code == 16;
    }

    @Override
    public boolean isString() {
        this.setCode();
        return this.code == 32;
    }

    @Override
    public boolean isCharacter() {
        this.setCode();
        return this.code == 64;
    }

    @Override
    public boolean isFloat() {
        this.setCode();
        return this.code == 128;
    }

    @Override
    public boolean isInteger() {
        this.setCode();
        return this.code == 256;
    }

    @Override
    public boolean isByte() {
        this.setCode();
        return this.code == 512;
    }

    @Override
    public boolean isTuple() {
        this.setCode();
        return this.code == 1024;
    }

    @Override
    public boolean isEntry() {
        this.setCode();
        return this.code == 2048;
    }

    @Override
    public boolean isRange() {
        this.setCode();
        return this.code == 4096;
    }

    @Override
    public boolean isArray() {
        this.setCode();
        return this.code == 8192;
    }

    @Override
    public boolean isThrowable() {
        this.setCode();
        return this.code == 16384;
    }

    @Override
    public boolean isException() {
        this.setCode();
        return this.code == 32768;
    }

    @Override
    public boolean inherits(TypeDeclaration dec) {
        if (dec == null) {
            return false;
        }
        if (dec.isAnything()) {
            return true;
        }
        if (dec.isObject()) {
            return !this.isAnything() && !this.isNull() && !this.isNullValue();
        }
        if (dec.isNull()) {
            return this.isNull() || this.isNullValue();
        }
        if (dec instanceof Class && this.equals(dec)) {
            return true;
        }
        if (dec.isFinal() && !dec.isAbstraction()) {
            return false;
        }
        Type et = this.getExtendedType();
        if (et != null && et.getDeclaration().inherits(dec)) {
            return true;
        }
        if (dec instanceof Interface) {
            List<Type> sts = this.getSatisfiedTypes();
            int s = sts.size();
            for (int i = 0; i < s; ++i) {
                Type st = sts.get(i);
                if (!st.getDeclaration().inherits(dec)) continue;
                return true;
            }
        }
        return false;
    }

    public List<Reference> getUnimplementedFormals() {
        return this.unimplementedFormals;
    }

    public void setUnimplementedFormals(List<Reference> unimplementedFormals) {
        this.unimplementedFormals = unimplementedFormals;
    }

    public boolean isSerializable() {
        return (this.flags & 0x10000L) != 0L;
    }

    public void setSerializable(boolean serializable) {
        this.flags = serializable ? (this.flags |= 0x10000L) : (this.flags &= 0xFFFFFFFFFFFEFFFFL);
    }

    @Override
    public boolean isEmptyType() {
        return this.isEmptyValue();
    }

    @Override
    public boolean isTupleType() {
        return this.isTuple();
    }

    @Override
    public boolean isSequentialType() {
        if (this.sequentialType == 0) {
            this.sequentialType = this.isSequentialTypeInternal() ? 1 : -1;
        }
        return this.sequentialType > 0;
    }

    @Override
    public boolean isSequenceType() {
        if (this.sequenceType == 0) {
            this.sequenceType = this.isSequenceTypeInternal() ? 1 : -1;
        }
        return this.sequenceType > 0;
    }

    private boolean isSequentialTypeInternal() {
        if (!this.getUnit().getPackage().isLanguagePackage()) {
            return false;
        }
        if (this.isAnything() || this.isObject() || this.isNull() || this.isBasic()) {
            return false;
        }
        if (this.isEmptyValue() || this.isRange() || this.isTuple()) {
            return true;
        }
        Type et = this.getExtendedType();
        if (et != null && et.isRange()) {
            return true;
        }
        List<Type> sts = this.getSatisfiedTypes();
        for (Type st : sts) {
            if (!st.isSequence()) continue;
            return true;
        }
        return false;
    }

    private boolean isSequenceTypeInternal() {
        if (!this.getUnit().getPackage().isLanguagePackage()) {
            return false;
        }
        if (this.isAnything() || this.isObject() || this.isNull() || this.isBasic()) {
            return false;
        }
        if (this.isRange() || this.isTuple()) {
            return true;
        }
        Type et = this.getExtendedType();
        if (et != null && et.isRange()) {
            return true;
        }
        List<Type> sts = this.getSatisfiedTypes();
        for (Type st : sts) {
            if (!st.isSequence()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder params = new StringBuilder();
        ParameterList list = this.getParameterList();
        if (list != null) {
            params.append("(");
            boolean first = true;
            for (Parameter p : list.getParameters()) {
                if (first) {
                    first = false;
                } else {
                    params.append(", ");
                }
                FunctionOrValue model = p.getModel();
                if (model != null && model.getType() != null) {
                    if (model.isFunctional()) {
                        params.append(model.getTypedReference().getFullType().asString());
                    } else {
                        params.append(model.getType().asString());
                    }
                    params.append(" ");
                }
                params.append(p.getName());
            }
            params.append(")");
        }
        return "class " + this.toStringName() + params;
    }

    public Class getRealClass() {
        return this.realClass;
    }

    public void setRealClass(Class realClass) {
        this.realClass = realClass;
    }
}

