/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.typechecker.model;

import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import java.util.List;

public class Interface
extends ClassOrInterface {
    private static final int ITERABLE = 2;
    private static final int EMPTY = 4;
    private static final int SEQUENCE = 8;
    private static final int SEQUENTIAL = 16;
    private static final int CALLABLE = 32;
    private static final int IDENTIFIABLE = 64;
    private String javaCompanionClassName;
    private Boolean companionClassNeeded;
    private int code;

    @Override
    public boolean isAbstract() {
        return true;
    }

    private void setCode() {
        String name;
        Package p;
        Scope scope;
        if (this.code == 0 && (scope = this.getContainer()) instanceof Package && (p = (Package)scope).isLanguagePackage() && (name = this.getName()) != null) {
            switch (name) {
                case "Iterable": {
                    this.code = 2;
                    break;
                }
                case "Empty": {
                    this.code = 4;
                    break;
                }
                case "Sequence": {
                    this.code = 8;
                    break;
                }
                case "Sequential": {
                    this.code = 16;
                    break;
                }
                case "Callable": {
                    this.code = 32;
                    break;
                }
                case "Identifiable": {
                    this.code = 64;
                    break;
                }
                default: {
                    this.code = -1;
                }
            }
        }
    }

    @Override
    public boolean isEmpty() {
        this.setCode();
        return this.code == 4;
    }

    @Override
    public boolean isSequence() {
        this.setCode();
        return this.code == 8;
    }

    @Override
    public boolean isSequential() {
        this.setCode();
        return this.code == 16;
    }

    @Override
    public boolean isIterable() {
        this.setCode();
        return this.code == 2;
    }

    @Override
    public boolean isCallable() {
        this.setCode();
        return this.code == 32;
    }

    @Override
    public boolean isIdentifiable() {
        this.setCode();
        return this.code == 64;
    }

    @Override
    public boolean inherits(TypeDeclaration dec) {
        if (dec == null) {
            return false;
        }
        if (dec.isAnything() || dec.isObject()) {
            return true;
        }
        if (dec instanceof Class) {
            return false;
        }
        if (dec instanceof Interface && this.equals(dec)) {
            return true;
        }
        if (dec instanceof Interface) {
            List<Type> sts = this.getSatisfiedTypes();
            int s = sts.size();
            for (int i = 0; i < s; ++i) {
                Type st = sts.get(i);
                if (!st.getDeclaration().inherits(dec)) continue;
                return true;
            }
        }
        return false;
    }

    public void setJavaCompanionClassName(String name) {
        this.javaCompanionClassName = name;
    }

    public String getJavaCompanionClassName() {
        return this.javaCompanionClassName;
    }

    public Boolean isCompanionClassNeeded() {
        return this.companionClassNeeded;
    }

    public void setCompanionClassNeeded(Boolean companionClassNeeded) {
        this.companionClassNeeded = companionClassNeeded;
    }

    @Override
    public boolean isEmptyType() {
        return this.isEmpty();
    }

    @Override
    public boolean isSequentialType() {
        return this.isSequential() || this.isSequence() || this.isEmpty();
    }

    @Override
    public boolean isSequenceType() {
        return this.isSequence();
    }

    @Override
    public String toString() {
        return "interface " + this.toStringName();
    }
}

