/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.typechecker.model;

import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.model.typechecker.context.TypeCache;
import com.redhat.ceylon.model.typechecker.model.Annotated;
import com.redhat.ceylon.model.typechecker.model.Annotation;
import com.redhat.ceylon.model.typechecker.model.Cancellable;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.DeclarationWithProximity;
import com.redhat.ceylon.model.typechecker.model.LanguageModuleCache;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.ModuleImport;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Referenceable;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.Unit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class Module
implements Referenceable,
Annotated,
Comparable<Module> {
    public static final String LANGUAGE_MODULE_NAME = "ceylon.language";
    public static final String DEFAULT_MODULE_NAME = "default";
    private List<String> name;
    private String version;
    private int jvmMajor;
    private int jvmMinor;
    private int jsMajor;
    private int jsMinor;
    private List<Package> packages = new ArrayList<Package>();
    private List<ModuleImport> imports = new ArrayList<ModuleImport>();
    private Module languageModule;
    private boolean available;
    private List<Annotation> annotations = new ArrayList<Annotation>();
    private Unit unit;
    private String nameAsString;
    private TypeCache cache = new TypeCache();
    private String signature;
    private List<ModuleImport> overridenImports = null;
    private Backends nativeBackends = Backends.ANY;
    private Map<ClassOrInterface, Set<Class>> services = null;
    private String groupId;
    private String artifactId;
    private String classifier;
    private LanguageModuleCache languageModuleCache = null;

    public LanguageModuleCache getLanguageModuleCache() {
        if (this.languageModuleCache == null) {
            assert (this.isLanguageModule());
            this.languageModuleCache = new LanguageModuleCache(this);
        }
        return this.languageModuleCache;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public List<String> getName() {
        return this.name;
    }

    public void setName(List<String> name) {
        this.name = name;
    }

    public List<Package> getPackages() {
        return this.packages;
    }

    public List<ModuleImport> getImports() {
        return Collections.unmodifiableList(this.imports);
    }

    public void addImport(ModuleImport modImport) {
        this.imports.add(modImport);
    }

    public boolean isLanguageModule() {
        List<String> name = this.getName();
        return name.size() == 2 && name.get(0).equals("ceylon") && name.get(1).equals("language");
    }

    public boolean isDefaultModule() {
        List<String> name = this.getName();
        return name.size() == 1 && name.get(0).equals(DEFAULT_MODULE_NAME);
    }

    public Module getLanguageModule() {
        return this.languageModule;
    }

    public void setLanguageModule(Module languageModule) {
        this.languageModule = languageModule;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version2) {
        this.version = version2;
    }

    public List<Package> getAllVisiblePackages() {
        ArrayList<Package> list = new ArrayList<Package>(this.getPackages());
        this.addVisiblePackagesOfTransitiveDependencies(list, new HashSet<String>(), true);
        return list;
    }

    private void addVisiblePackagesOfTransitiveDependencies(List<Package> list, Set<String> alreadyScannedModules, boolean firstLevel) {
        for (ModuleImport mi : this.getImports()) {
            Module importedModule;
            String imn;
            if (!firstLevel && !mi.isExport() || !alreadyScannedModules.add(imn = (importedModule = mi.getModule()).getNameAsString())) continue;
            for (Package p : importedModule.getPackages()) {
                if (!p.isShared()) continue;
                list.add(p);
            }
            importedModule.addVisiblePackagesOfTransitiveDependencies(list, alreadyScannedModules, false);
        }
    }

    public List<Package> getAllReachablePackages() {
        ArrayList<Package> list = new ArrayList<Package>();
        list.addAll(this.getPackages());
        this.addAllPackagesOfTransitiveDependencies(list, new HashSet<String>());
        return list;
    }

    private void addAllPackagesOfTransitiveDependencies(List<Package> list, Set<String> alreadyScannedModules) {
        for (ModuleImport mi : this.getImports()) {
            Module importedModule = mi.getModule();
            String imn = importedModule.getNameAsString();
            if (!alreadyScannedModules.add(imn)) continue;
            for (Package p : importedModule.getPackages()) {
                list.add(p);
            }
            importedModule.addAllPackagesOfTransitiveDependencies(list, alreadyScannedModules);
        }
    }

    private List<Package> getPackagesToScan(String startingWith) {
        if (startingWith.isEmpty()) {
            List<Package> packs = this.getPackages();
            List<Package> langPacks = this.getLanguageModule().getPackages();
            ArrayList<Package> list = new ArrayList<Package>(packs.size() + langPacks.size());
            list.addAll(packs);
            list.addAll(langPacks);
            return list;
        }
        return this.getAllVisiblePackages();
    }

    public Map<String, DeclarationWithProximity> getAvailableDeclarationsInCurrentModule(Unit unit, String startingWith, int proximity, Cancellable canceller) {
        return this.getAvailableDeclarationsInternal(unit, startingWith, proximity, canceller, this.getPackages());
    }

    private Map<String, DeclarationWithProximity> getAvailableDeclarationsInternal(Unit unit, String startingWith, int proximity, Cancellable canceller, List<Package> packages) {
        TreeMap<String, DeclarationWithProximity> result = new TreeMap<String, DeclarationWithProximity>();
        for (Package p : packages) {
            if (canceller != null && canceller.isCancelled()) {
                return Collections.emptyMap();
            }
            boolean isLanguagePackage = p.isLanguagePackage();
            boolean isDefaultPackage = p.isDefaultPackage();
            if (isDefaultPackage) continue;
            for (Declaration d : p.getMembers()) {
                if (canceller != null && canceller.isCancelled()) {
                    return Collections.emptyMap();
                }
                try {
                    if (!ModelUtil.isResolvable(d) || !d.isShared() || ModelUtil.isOverloadedVersion(d) || !ModelUtil.isNameMatching(startingWith, d)) continue;
                    result.put(d.getQualifiedNameString(), new DeclarationWithProximity(d, Module.getUnimportedProximity(proximity, isLanguagePackage, d.getName()), !isLanguagePackage));
                }
                catch (Exception exception) {}
            }
        }
        if ("Nothing".startsWith(startingWith)) {
            result.put("Nothing", new DeclarationWithProximity((Declaration)unit.getNothingDeclaration(), proximity + 2));
        }
        return result;
    }

    public Map<String, DeclarationWithProximity> getAvailableDeclarations(Unit unit, String startingWith, int proximity, Cancellable canceller) {
        return this.getAvailableDeclarationsInternal(unit, startingWith, proximity, canceller, this.getPackagesToScan(startingWith));
    }

    public static int getUnimportedProximity(int initialProximity, boolean isLanguagePackage, String name) {
        boolean isSpecialType;
        boolean isSpecialValue = isLanguagePackage && name.equals("true") || name.equals("false") || name.equals("null");
        boolean bl = isSpecialType = isLanguagePackage && name.equals("String") || name.equals("Integer") || name.equals("Float") || name.equals("Character") || name.equals("Boolean") || name.equals("Byte") || name.equals("Object") || name.equals("Anything");
        int prox = isSpecialValue ? -1 : (isSpecialType ? initialProximity + 2 : (isLanguagePackage ? initialProximity + 3 : initialProximity + 4));
        return prox;
    }

    protected boolean isJdkModule(String moduleName) {
        return false;
    }

    protected boolean isJdkPackage(String moduleName, String packageName) {
        return false;
    }

    public Package getDirectPackage(String name) {
        for (Package pkg : this.packages) {
            if (!pkg.getQualifiedNameString().equals(name)) continue;
            return pkg;
        }
        return null;
    }

    public Package getPackage(String name) {
        Package pkg = this.getDirectPackage(name);
        if (pkg != null) {
            return pkg;
        }
        for (ModuleImport mi : this.imports) {
            pkg = mi.getModule().getDirectPackage(name);
            if (pkg == null) continue;
            return pkg;
        }
        return null;
    }

    public Package getRootPackage() {
        return this.getPackage(this.getNameAsString());
    }

    @Override
    public String getNameAsString() {
        if (this.nameAsString == null) {
            this.nameAsString = ModelUtil.formatPath(this.name);
        }
        return this.nameAsString;
    }

    public String toString() {
        return "module " + this.getNameAsString() + " \"" + this.getVersion() + "\"";
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public boolean isJava() {
        return false;
    }

    public boolean isNative() {
        return !this.getNativeBackends().none();
    }

    public Backends getNativeBackends() {
        return this.nativeBackends;
    }

    public void setNativeBackends(Backends backends) {
        this.nativeBackends = backends;
    }

    @Override
    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    @Override
    public int compareTo(Module other) {
        String otherName;
        if (this == other) {
            return 0;
        }
        if (this.isDefaultModule()) {
            return -1;
        }
        String name = this.getNameAsString();
        int cmp = name.compareTo(otherName = other.getNameAsString());
        if (cmp != 0) {
            return cmp;
        }
        String version2 = this.getVersion();
        String otherVersion = other.getVersion();
        return version2.compareTo(otherVersion);
    }

    public TypeCache getCache() {
        return this.cache;
    }

    public void clearCache(TypeDeclaration declaration) {
        TypeCache cache = this.getCache();
        if (cache != null) {
            cache.clearForDeclaration(declaration);
        }
    }

    public String getSignature() {
        if (this.signature == null) {
            if (this.isDefaultModule()) {
                this.signature = this.getNameAsString();
            } else if (this.getVersion() != null) {
                this.signature = this.getNameAsString() + "/" + this.getVersion();
            } else {
                return this.getNameAsString() + "/null";
            }
        }
        return this.signature;
    }

    public List<ModuleImport> getOverridenImports() {
        return this.overridenImports == null ? null : Collections.unmodifiableList(this.overridenImports);
    }

    public boolean overrideImports(List<ModuleImport> newModuleImports) {
        if (this.overridenImports == null && newModuleImports != null) {
            this.overridenImports = this.imports;
            this.imports = newModuleImports;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.getSignature().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Module) {
            Module b = (Module)obj;
            return this.getSignature().equals(b.getSignature());
        }
        return false;
    }

    public int getJvmMajor() {
        return this.jvmMajor;
    }

    public void setJvmMajor(int jvmMajor) {
        this.jvmMajor = jvmMajor;
    }

    public int getJvmMinor() {
        return this.jvmMinor;
    }

    public void setJvmMinor(int jvmMinor) {
        this.jvmMinor = jvmMinor;
    }

    public int getJsMajor() {
        return this.jsMajor;
    }

    public void setJsMajor(int jsMajor) {
        this.jsMajor = jsMajor;
    }

    public int getJsMinor() {
        return this.jsMinor;
    }

    public void setJsMinor(int jsMinor) {
        this.jsMinor = jsMinor;
    }

    public void addService(ClassOrInterface serviceIface, Class serviceImpl) {
        Set<Class> impls;
        if (this.services == null) {
            this.services = new HashMap<ClassOrInterface, Set<Class>>();
        }
        if ((impls = this.services.get(serviceIface)) == null) {
            impls = new HashSet<Class>(1);
            this.services.put(serviceIface, impls);
        }
        impls.add(serviceImpl);
    }

    public Map<ClassOrInterface, Set<Class>> getServices() {
        return this.services != null ? this.services : Collections.emptyMap();
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }
}

