/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.typechecker.model;

import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.model.typechecker.model.Cancellable;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.DeclarationWithProximity;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.Unit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ModuleImportList
implements Scope {
    private Scope container;
    private Unit unit;
    private List<Declaration> members = new ArrayList<Declaration>();

    public void setContainer(Scope container) {
        this.container = container;
    }

    @Override
    public String getQualifiedNameString() {
        return this.getContainer().getQualifiedNameString();
    }

    @Override
    public Scope getContainer() {
        return this.container;
    }

    @Override
    public Scope getScope() {
        return this.container;
    }

    @Override
    public Map<String, DeclarationWithProximity> getMatchingDeclarations(Unit unit, String startingWith, int proximity, Cancellable canceller) {
        return this.getContainer().getMatchingDeclarations(unit, startingWith, proximity, canceller);
    }

    @Override
    public List<Declaration> getMembers() {
        return this.members;
    }

    @Override
    public Declaration getMember(String name, List<Type> signature, boolean variadic) {
        return this.getDirectMember(name, signature, variadic);
    }

    @Override
    public Declaration getMemberOrParameter(Unit unit, String name, List<Type> signature, boolean variadic) {
        Declaration d = this.getDirectMember(name, signature, variadic);
        if (d != null) {
            return d;
        }
        return this.getContainer().getMemberOrParameter(unit, name, signature, variadic);
    }

    @Override
    public Declaration getDirectMember(String name, List<Type> signature, boolean variadic) {
        return ModelUtil.lookupMember(this.getMembers(), name, signature, variadic);
    }

    @Override
    public Declaration getDirectMemberForBackend(String name, Backends backends) {
        return ModelUtil.lookupMemberForBackend(this.getMembers(), name, backends);
    }

    @Override
    public boolean isInherited(Declaration d) {
        return false;
    }

    @Override
    public TypeDeclaration getInheritingDeclaration(Declaration d) {
        return null;
    }

    @Override
    public Type getDeclaringType(Declaration d) {
        return null;
    }

    @Override
    public boolean isToplevel() {
        return false;
    }

    @Override
    public Backends getScopedBackends() {
        return this.getContainer().getScopedBackends();
    }

    @Override
    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    @Override
    public void addMember(Declaration declaration) {
        this.members.add(declaration);
    }
}

