/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.typechecker.model;

import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.model.typechecker.model.Annotated;
import com.redhat.ceylon.model.typechecker.model.Annotation;
import com.redhat.ceylon.model.typechecker.model.Cancellable;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.DeclarationWithProximity;
import com.redhat.ceylon.model.typechecker.model.Import;
import com.redhat.ceylon.model.typechecker.model.ImportableScope;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.Referenceable;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.Unit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Package
implements ImportableScope,
Referenceable,
Annotated {
    private List<String> name;
    private Module module;
    private List<Unit> units = new ArrayList<Unit>();
    private boolean shared = false;
    private List<String> restrictions;
    private List<Annotation> annotations = new ArrayList<Annotation>();
    private Unit unit;
    private String nameAsString;
    private List<Declaration> members;

    @Override
    public boolean isToplevel() {
        return false;
    }

    public Module getModule() {
        return this.module;
    }

    public void setModule(Module module) {
        this.module = module;
    }

    public List<String> getName() {
        return this.name;
    }

    public void setName(List<String> name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<Unit> getUnits() {
        List<Unit> list = this.units;
        synchronized (list) {
            return new ArrayList<Unit>(this.units);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUnit(Unit unit) {
        List<Unit> list = this.units;
        synchronized (list) {
            this.units.add(unit);
            this.members = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUnit(Unit unit) {
        List<Unit> list = this.units;
        synchronized (list) {
            this.units.remove(unit);
            this.members = null;
        }
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public List<String> getRestrictions() {
        return this.restrictions;
    }

    public void setRestrictions(List<String> restrictions) {
        this.restrictions = restrictions;
    }

    public boolean withinRestrictions(Unit unit) {
        return this.withinRestrictions(unit.getPackage().getModule());
    }

    private boolean withinRestrictions(Module module) {
        List<String> restrictions = this.getRestrictions();
        if (restrictions == null) {
            return true;
        }
        String name = module.getNameAsString();
        for (String mod : restrictions) {
            if (!name.equals(mod)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Declaration> getMembers() {
        List<Unit> list = this.units;
        synchronized (list) {
            if (this.members == null) {
                this.members = this.getMembersInternal();
            }
            return this.members;
        }
    }

    @Override
    public void addMember(Declaration declaration) {
        this.members = null;
    }

    private List<Declaration> getMembersInternal() {
        ArrayList<Declaration> result = new ArrayList<Declaration>();
        for (Unit unit : this.units) {
            for (Declaration d : unit.getDeclarations()) {
                if (!d.getContainer().equals(this)) continue;
                result.add(d);
            }
        }
        return result;
    }

    @Override
    public Scope getContainer() {
        return null;
    }

    @Override
    public Scope getScope() {
        return null;
    }

    @Override
    public String getNameAsString() {
        if (this.nameAsString == null) {
            this.nameAsString = ModelUtil.formatPath(this.name);
        }
        return this.nameAsString;
    }

    public boolean isLanguagePackage() {
        List<String> name = this.getName();
        return name.size() == 2 && name.get(0).equals("ceylon") && name.get(1).equals("language");
    }

    public boolean isDefaultPackage() {
        return this.getName().isEmpty();
    }

    public String toString() {
        return "package " + this.getNameAsString();
    }

    @Override
    public String getQualifiedNameString() {
        return this.getNameAsString();
    }

    @Override
    public Declaration getMember(String name, List<Type> signature, boolean variadic) {
        if (signature == null && name.equals("Nothing") && this.isLanguagePackage()) {
            return this.getUnit().getNothingDeclaration();
        }
        return this.getDirectMember(name, signature, variadic);
    }

    @Override
    public Declaration getDirectMember(String name, List<Type> signature, boolean variadic) {
        return ModelUtil.lookupMember(this.getMembers(), name, signature, variadic);
    }

    @Override
    public Declaration getDirectMemberForBackend(String name, Backends backends) {
        return ModelUtil.lookupMemberForBackend(this.getMembers(), name, backends);
    }

    @Override
    public Type getDeclaringType(Declaration d) {
        Class containingAnonClass;
        if (d.isClassMember() && (containingAnonClass = (Class)d.getContainer()).isAnonymous()) {
            return containingAnonClass.getType();
        }
        return null;
    }

    @Override
    public Declaration getMemberOrParameter(Unit unit, String name, List<Type> signature, boolean variadic) {
        Declaration d = unit.getImportedDeclaration(name, signature, variadic);
        if (d != null) {
            return d;
        }
        d = this.getDirectMember(name, signature, variadic);
        if (d != null) {
            return d;
        }
        return unit.getLanguageModuleDeclaration(name);
    }

    @Override
    public boolean isInherited(Declaration d) {
        return false;
    }

    @Override
    public TypeDeclaration getInheritingDeclaration(Declaration d) {
        return null;
    }

    @Override
    public Map<String, DeclarationWithProximity> getMatchingDeclarations(Unit unit, String startingWith, int proximity, Cancellable canceller) {
        Map<String, DeclarationWithProximity> result = this.getMatchingDirectDeclarations(startingWith, proximity + 1, canceller);
        if (unit != null) {
            result.putAll(unit.getMatchingImportedDeclarations(startingWith, proximity, canceller));
        }
        Map<String, DeclarationWithProximity> importables = this.getModule().getAvailableDeclarations(unit, startingWith, proximity, canceller);
        ArrayList<Map.Entry<String, DeclarationWithProximity>> entriesToAdd = new ArrayList<Map.Entry<String, DeclarationWithProximity>>(importables.size());
        for (Map.Entry<String, DeclarationWithProximity> e : importables.entrySet()) {
            boolean already = false;
            DeclarationWithProximity existing = e.getValue();
            for (DeclarationWithProximity importable : result.values()) {
                Declaration ed;
                Declaration id = importable.getDeclaration();
                if (!id.equals(ed = existing.getDeclaration())) continue;
                already = true;
                break;
            }
            if (already) continue;
            entriesToAdd.add(e);
        }
        for (Map.Entry<String, DeclarationWithProximity> e : entriesToAdd) {
            result.put(e.getKey(), e.getValue());
        }
        return result;
    }

    public Map<String, DeclarationWithProximity> getMatchingDirectDeclarations(String startingWith, int proximity, Cancellable canceller) {
        TreeMap<String, DeclarationWithProximity> result = new TreeMap<String, DeclarationWithProximity>();
        for (Declaration d : this.getMembers()) {
            if (canceller != null && canceller.isCancelled()) {
                return Collections.emptyMap();
            }
            if (!ModelUtil.isResolvable(d) || ModelUtil.isOverloadedVersion(d) || !ModelUtil.isNameMatching(startingWith, d)) continue;
            result.put(d.getName(this.unit), new DeclarationWithProximity(d, proximity));
        }
        return result;
    }

    @Override
    public Map<String, DeclarationWithProximity> getImportableDeclarations(Unit unit, String startingWith, List<Import> imports, int proximity, Cancellable canceller) {
        TreeMap<String, DeclarationWithProximity> result = new TreeMap<String, DeclarationWithProximity>();
        for (Declaration d : this.getMembers()) {
            if (canceller != null && canceller.isCancelled()) {
                return Collections.emptyMap();
            }
            if (!ModelUtil.isResolvable(d) || !d.isShared() || ModelUtil.isOverloadedVersion(d) || !ModelUtil.isNameMatching(startingWith, d)) continue;
            boolean already = false;
            for (Import i : imports) {
                if (i.isWildcardImport() || !i.getDeclaration().equals(d)) continue;
                already = true;
                break;
            }
            if (already) continue;
            result.put(d.getName(), new DeclarationWithProximity(d, proximity));
        }
        return result;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public int hashCode() {
        return this.getNameAsString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Package) {
            Package p = (Package)obj;
            return p.getNameAsString().equals(this.getNameAsString());
        }
        return false;
    }

    @Override
    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    @Override
    public Backends getScopedBackends() {
        return this.getModule().getNativeBackends();
    }
}

