/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.typechecker.model;

import com.redhat.ceylon.model.typechecker.context.TypeCache;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Generic;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import com.redhat.ceylon.model.typechecker.model.SiteVariance;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.TypedReference;
import com.redhat.ceylon.model.typechecker.model.Unit;
import com.redhat.ceylon.model.typechecker.model.UnknownType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Reference {
    protected Map<TypeParameter, Type> typeArguments = ModelUtil.EMPTY_TYPE_ARG_MAP;
    protected Type qualifyingType;
    private Map<TypeParameter, Type> typeArgumentsWithDefaults;

    Reference() {
    }

    public Type getQualifyingType() {
        return this.qualifyingType;
    }

    void setQualifyingType(Type qualifyingType) {
        this.qualifyingType = qualifyingType;
    }

    public abstract Declaration getDeclaration();

    public Map<TypeParameter, Type> getTypeArguments() {
        Declaration declaration = this.getDeclaration();
        if (declaration instanceof Generic) {
            if (TypeCache.isEnabled()) {
                if (this.typeArgumentsWithDefaults == null) {
                    this.typeArgumentsWithDefaults = this.getTypeArgumentsInternal(declaration);
                }
                return this.typeArgumentsWithDefaults;
            }
            return this.getTypeArgumentsInternal(declaration);
        }
        return this.typeArguments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<TypeParameter, Type> getTypeArgumentsInternal(Declaration declaration) {
        Type.checkDepth();
        Type.incDepth();
        try {
            Map<TypeParameter, Type> map = Reference.fillInDefaultTypeArguments(declaration, this.typeArguments);
            return map;
        }
        finally {
            Type.decDepth();
        }
    }

    private static Map<TypeParameter, Type> fillInDefaultTypeArguments(Declaration declaration, Map<TypeParameter, Type> typeArguments) {
        Map<TypeParameter, Type> typeArgs = typeArguments;
        List<TypeParameter> typeParameters = declaration.getTypeParameters();
        int l = typeParameters.size();
        for (int i = 0; i < l; ++i) {
            TypeParameter typeParam = typeParameters.get(i);
            Type dta = typeParam.getDefaultTypeArgument();
            if (dta == null || typeArguments.containsKey(typeParam)) continue;
            if (typeArguments == typeArgs) {
                typeArgs = new HashMap<TypeParameter, Type>(typeParameters.size());
                typeArgs.putAll(typeArguments);
            }
            typeArgs.put(typeParam, dta.substitute(typeArgs, ModelUtil.EMPTY_VARIANCE_MAP));
        }
        return typeArgs;
    }

    void setTypeArguments(Map<TypeParameter, Type> typeArguments) {
        this.typeArguments = typeArguments;
    }

    public List<Type> getTypeArgumentList() {
        Declaration declaration = this.getDeclaration();
        if (declaration.isParameterized()) {
            return Reference.getTypeArgumentList(declaration.getUnit(), declaration.getTypeParameters(), this.getTypeArguments());
        }
        return ModelUtil.NO_TYPE_ARGS;
    }

    private static List<Type> getTypeArgumentList(Unit unit, List<TypeParameter> typeParams, Map<TypeParameter, Type> typeArgs) {
        int size = typeParams.size();
        ArrayList<Type> argList = new ArrayList<Type>(size);
        for (int i = 0; i < size; ++i) {
            TypeParameter tp = typeParams.get(i);
            Type arg = typeArgs.get(tp);
            if (arg == null) {
                arg = unit.getUnknownType();
            }
            argList.add(arg);
        }
        return argList;
    }

    public abstract Type getType();

    public Type getFullType() {
        return this.getFullType(this.getType());
    }

    public Type getFullType(Type wrappedType) {
        Declaration declaration = this.getDeclaration();
        if (declaration instanceof Functional) {
            Unit unit = declaration.getUnit();
            if (ModelUtil.isAbstraction(declaration)) {
                return ModelUtil.appliedType((TypeDeclaration)unit.getCallableDeclaration(), wrappedType, new UnknownType(unit).getType());
            }
            return unit.getCallableType(this, wrappedType);
        }
        return wrappedType;
    }

    public boolean isFunctional() {
        return this.getDeclaration() instanceof Functional;
    }

    public TypedReference getTypedParameterWithWildcardCaputure(Parameter p) {
        TypedReference typedParameter = this.getTypedParameter(p);
        this.captureWildcards(typedParameter);
        return typedParameter;
    }

    public TypedReference getTypedParameter(Parameter p) {
        TypedReference typedParam = new TypedReference(false, true);
        FunctionOrValue model = p.getModel();
        if (model != null) {
            typedParam.setDeclaration(model);
        }
        typedParam.setQualifyingType(this.getQualifyingType());
        typedParam.setTypeArguments(this.getTypeArguments());
        return typedParam;
    }

    private void captureWildcards(TypedReference parameter) {
        Declaration declaration = this.getDeclaration();
        if (declaration.isJava() && declaration.isParameterized()) {
            HashMap<TypeParameter, SiteVariance> capturedWildcards = new HashMap<TypeParameter, SiteVariance>(1);
            for (TypeParameter tp : declaration.getTypeParameters()) {
                if (!this.canCaptureWildcard(tp)) continue;
                capturedWildcards.put(tp, SiteVariance.OUT);
            }
            parameter.setCapturedWildcards(capturedWildcards);
        }
    }

    private boolean canCaptureWildcard(TypeParameter tp) {
        Declaration dec = this.getDeclaration();
        if (dec instanceof Function) {
            Function func = (Function)dec;
            Type returnType = func.getType();
            if (returnType.occursContravariantly(tp) || returnType.occursInvariantly(tp)) {
                return false;
            }
            ParameterList paramList = func.getFirstParameterList();
            if (paramList != null) {
                boolean found = false;
                for (Parameter p : paramList.getParameters()) {
                    Type paramType;
                    FunctionOrValue model = p.getModel();
                    if (model == null || (paramType = model.getReference().getFullType()) == null) continue;
                    if (paramType.occursContravariantly(tp) || paramType.occursCovariantly(tp)) {
                        return false;
                    }
                    if (!paramType.occursInvariantly(tp)) continue;
                    if (found) {
                        return false;
                    }
                    found = true;
                }
                return found;
            }
        }
        return false;
    }

    public abstract String asString();
}

