/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.typechecker.model;

import com.redhat.ceylon.model.typechecker.model.Cancellable;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.DeclarationWithProximity;
import com.redhat.ceylon.model.typechecker.model.Element;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Generic;
import com.redhat.ceylon.model.typechecker.model.Import;
import com.redhat.ceylon.model.typechecker.model.ImportableScope;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Reference;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.Typed;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.UnionType;
import com.redhat.ceylon.model.typechecker.model.Unit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class TypeDeclaration
extends Declaration
implements ImportableScope,
Cloneable,
Generic,
Typed {
    private Type extendedType;
    private List<Type> satisfiedTypes = this.needsSatisfiedTypes() ? new ArrayList(3) : Collections.emptyList();
    private List<Type> caseTypes = null;
    private Type selfType;
    private List<Type> brokenSupertypes = null;
    private boolean inconsistentType;
    private boolean sealed;
    private List<TypedDeclaration> caseValues;
    private String samName;

    public boolean isErasedTypeArguments() {
        return false;
    }

    public boolean isSealed() {
        return this.sealed;
    }

    public void setSealed(boolean sealed) {
        this.sealed = sealed;
    }

    public boolean isInconsistentType() {
        return this.inconsistentType;
    }

    protected boolean needsSatisfiedTypes() {
        return true;
    }

    public void setInconsistentType(boolean inconsistentType) {
        this.inconsistentType = inconsistentType;
    }

    public boolean isAbstract() {
        return true;
    }

    protected TypeDeclaration clone() {
        try {
            return (TypeDeclaration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isSelfType() {
        return false;
    }

    public boolean isFinal() {
        return false;
    }

    public boolean isObjectClass() {
        return false;
    }

    public boolean isValueConstructor() {
        return false;
    }

    @Override
    public void setTypeParameters(List<TypeParameter> params) {
        throw new UnsupportedOperationException();
    }

    public Type getExtendedType() {
        return this.extendedType;
    }

    public void setExtendedType(Type extendedType) {
        this.extendedType = extendedType;
    }

    public List<Type> getSatisfiedTypes() {
        return this.satisfiedTypes;
    }

    public void setSatisfiedTypes(List<Type> satisfiedTypes) {
        this.satisfiedTypes = satisfiedTypes;
    }

    public List<Type> getCaseTypes() {
        return this.caseTypes;
    }

    public void setCaseTypes(List<Type> caseTypes) {
        this.caseTypes = caseTypes;
    }

    public List<Type> getBrokenSupertypes() {
        return this.brokenSupertypes == null ? Collections.emptyList() : this.brokenSupertypes;
    }

    public void addBrokenSupertype(Type type) {
        if (this.brokenSupertypes == null) {
            this.brokenSupertypes = new ArrayList<Type>(1);
        }
        this.brokenSupertypes.add(type);
    }

    @Override
    public Reference appliedReference(Type pt, List<Type> typeArguments) {
        return this.appliedType(pt, typeArguments);
    }

    @Override
    public final Type getReference() {
        return this.getType();
    }

    public Type appliedType(Type qualifyingType, List<Type> typeArguments) {
        if (qualifyingType != null && qualifyingType.isNothing()) {
            return qualifyingType;
        }
        Type pt = new Type();
        pt.setDeclaration(this);
        pt.setQualifyingType(qualifyingType);
        pt.setTypeArguments(ModelUtil.getTypeArgumentMap(this, qualifyingType, typeArguments));
        return pt;
    }

    @Override
    public Type getType() {
        Type type = new Type();
        type.setQualifyingType(this.getMemberContainerType());
        type.setDeclaration(this);
        type.setTypeArguments(this.getTypeParametersAsArguments());
        return type;
    }

    private List<Declaration> getInheritableMembers(String name, List<TypeDeclaration> visited) {
        if (visited.contains(this)) {
            return Collections.emptyList();
        }
        visited.add(this);
        ArrayList<Declaration> members = new ArrayList<Declaration>();
        for (Declaration d : this.getMembers()) {
            if (!d.isShared() || d.getName() == null || !d.getName().equals(name) || !ModelUtil.isResolvable(d)) continue;
            members.add(d);
        }
        if (members.isEmpty()) {
            members.addAll(this.getInheritedMembers(name, visited));
        }
        return members;
    }

    public List<Declaration> getInheritedMembers(String name) {
        return this.getInheritedMembers(name, new ArrayList<TypeDeclaration>());
    }

    private static <T> boolean contains(Iterable<T> iter, T object) {
        for (T elem : iter) {
            if (elem != object) continue;
            return true;
        }
        return false;
    }

    private List<Declaration> getInheritedMembers(String name, List<TypeDeclaration> visited) {
        ArrayList<Declaration> members = new ArrayList<Declaration>();
        for (Type st : this.getSatisfiedTypes()) {
            for (Declaration member : st.getDeclaration().getInheritableMembers(name, visited)) {
                if (TypeDeclaration.contains(members, member)) continue;
                members.add(member);
            }
        }
        Type et = this.getExtendedType();
        if (et != null) {
            for (Declaration member : et.getDeclaration().getInheritableMembers(name, visited)) {
                if (TypeDeclaration.contains(members, member)) continue;
                members.add(member);
            }
        }
        return members;
    }

    public boolean isMember(Declaration dec) {
        return this.isMember(dec, new ArrayList<TypeDeclaration>());
    }

    private boolean isMember(Declaration dec, List<TypeDeclaration> visited) {
        if (visited.contains(this)) {
            return false;
        }
        visited.add(this);
        for (Declaration member : this.getMembers()) {
            if (!dec.equals(member)) continue;
            return true;
        }
        for (Type t : this.getSatisfiedTypes()) {
            if (!t.getDeclaration().isMember(dec, visited)) continue;
            return true;
        }
        Type et = this.getExtendedType();
        return et != null && et.getDeclaration().isMember(dec, visited);
    }

    public abstract boolean inherits(TypeDeclaration var1);

    public Declaration getRefinedMember(String name, List<Type> signature, boolean variadic) {
        return this.getRefinedMember(name, signature, variadic, false);
    }

    public Declaration getRefinedMember(String name, List<Type> signature, boolean variadic, boolean onlyExactMatches) {
        return this.getRefinedMember(name, signature, variadic, onlyExactMatches, new HashSet<TypeDeclaration>());
    }

    protected Declaration getRefinedMember(String name, List<Type> signature, boolean variadic, boolean onlyExactMatches, Set<TypeDeclaration> visited) {
        Declaration ed;
        if (!visited.add(this)) {
            return null;
        }
        Declaration result = null;
        Type et = this.getExtendedType();
        if (et != null && this.isBetterRefinement(signature, variadic, result, ed = et.getDeclaration().getRefinedMember(name, signature, variadic, onlyExactMatches, visited))) {
            result = ed;
        }
        for (Type st : this.getSatisfiedTypes()) {
            Declaration sd = st.getDeclaration().getRefinedMember(name, signature, variadic, onlyExactMatches, visited);
            if (!this.isBetterRefinement(signature, variadic, result, sd)) continue;
            result = sd;
        }
        Declaration dd = this.getDirectMember(name, signature, variadic, onlyExactMatches);
        if (this.isBetterRefinement(signature, variadic, result, dd)) {
            result = dd;
        }
        return result;
    }

    public boolean isBetterRefinement(List<Type> signature, boolean variadic, Declaration result, Declaration candidate) {
        if (candidate == null || candidate.isActual() || !candidate.isShared()) {
            return false;
        }
        if (result == null) {
            return true;
        }
        if (!(result instanceof Functional)) {
            return signature != null;
        }
        if (!(candidate instanceof Functional)) {
            return signature == null;
        }
        if (signature == null) {
            throw new RuntimeException("missing signature");
        }
        if (candidate.isAbstraction() && !result.isAbstraction()) {
            return false;
        }
        if (!candidate.isAbstraction() && result.isAbstraction()) {
            return true;
        }
        if (ModelUtil.hasMatchingSignature(candidate, signature, variadic)) {
            return !ModelUtil.hasMatchingSignature(result, signature, variadic) || ModelUtil.strictlyBetterMatch(candidate, result);
        }
        return false;
    }

    public Declaration getImportedMember(Scope scope, String alias, List<Type> signature, boolean variadic) {
        while (scope != null) {
            Element elem;
            Declaration dec;
            if (scope instanceof Element && (dec = (elem = (Element)((Object)scope)).getImportedDeclaration(this, alias, signature, variadic)) != null) {
                return dec;
            }
            scope = scope.getContainer();
        }
        return null;
    }

    public Declaration getMember(String name, Unit unit, List<Type> signature, boolean variadic) {
        Declaration dec = unit.getImportedDeclaration(this, name, signature, variadic);
        if (dec == null) {
            return this.getMemberInternal(name, signature, variadic, false).getMember();
        }
        return dec;
    }

    public boolean isMemberAmbiguous(String name, Unit unit, List<Type> signature, boolean variadic) {
        Declaration dec = unit.getImportedDeclaration(this, name, signature, variadic);
        if (dec == null) {
            return this.getMemberInternal(name, signature, variadic, false).isAmbiguous();
        }
        return false;
    }

    @Override
    public Declaration getMember(String name, List<Type> signature, boolean variadic, boolean onlyExactMatches) {
        return this.getMemberInternal(name, signature, variadic, onlyExactMatches).getMember();
    }

    private SupertypeDeclaration getMemberInternal(String name, List<Type> signature, boolean variadic, boolean onlyExactMatches) {
        SupertypeDeclaration sd;
        if (!onlyExactMatches && signature != null && ((sd = this.getMemberInternal(name, signature, variadic, true)).getMember() != null || sd.isAmbiguous())) {
            return sd;
        }
        Declaration dec = this.getDirectMember(name, signature, variadic, onlyExactMatches);
        if (dec != null && dec.isShared()) {
            return new SupertypeDeclaration(dec, false);
        }
        SupertypeDeclaration sd2 = this.getSupertypeDeclaration(name, signature, variadic, onlyExactMatches, false);
        if (sd2.getMember() != null || sd2.isAmbiguous()) {
            return sd2;
        }
        return new SupertypeDeclaration(dec, false);
    }

    @Override
    protected Declaration getMemberOrParameter(String name, List<Type> signature, boolean variadic, boolean onlyExactMatches) {
        Declaration dec = this.getDirectMember(name, signature, variadic, onlyExactMatches);
        if (dec != null) {
            Declaration supertype;
            if (signature != null && dec.isAbstraction() && (supertype = this.getSupertypeDeclaration(name, signature, variadic, onlyExactMatches, true).getMember()) != null && !supertype.isAbstraction()) {
                return supertype;
            }
        } else {
            Declaration hdr;
            if (this.isNativeImplementation() && (hdr = ModelUtil.getNativeHeader(this)) != null) {
                dec = hdr.getDirectMember(name, signature, variadic, onlyExactMatches);
            }
            if (dec == null) {
                dec = this.getSupertypeDeclaration(name, signature, variadic, onlyExactMatches, true).getMember();
            }
        }
        return dec;
    }

    @Override
    public boolean isInherited(Declaration member) {
        if (member.getContainer().equals(this)) {
            return false;
        }
        if (this.isInheritedFromSupertype(member)) {
            return true;
        }
        if (this.getContainer() != null) {
            return this.getContainer().isInherited(member);
        }
        return false;
    }

    @Override
    public TypeDeclaration getInheritingDeclaration(Declaration member) {
        Scope container = member.getContainer();
        if (container != null && container.equals(this)) {
            return null;
        }
        if (this.isInheritedFromSupertype(member)) {
            return this;
        }
        if (this.getContainer() != null) {
            return this.getContainer().getInheritingDeclaration(member);
        }
        return null;
    }

    public boolean isInheritedFromSupertype(final Declaration member) {
        final List<Type> signature = ModelUtil.getSignature(member);
        final boolean variadic = ModelUtil.isVariadic(member);
        class Criteria
        implements Type.Criteria {
            Criteria() {
            }

            @Override
            public boolean satisfies(TypeDeclaration type) {
                if (type.equals(TypeDeclaration.this)) {
                    return false;
                }
                Declaration dm = type.getDirectMember(member.getName(), signature, variadic);
                return dm != null && dm.equals(member);
            }

            @Override
            public boolean isMemberLookup() {
                return false;
            }
        }
        return this.getType().getSupertype(new Criteria()) != null;
    }

    private SupertypeDeclaration getSupertypeDeclaration(final String name, final List<Type> signature, final boolean variadic, final boolean onlyExactMatches, final boolean includeInheritedConstructors) {
        Type type = this.getType();
        class ExactCriteria
        implements Type.Criteria {
            ExactCriteria() {
            }

            @Override
            public boolean satisfies(TypeDeclaration type) {
                if (type == TypeDeclaration.this) {
                    return false;
                }
                Declaration dm = type.getDirectMember(name, signature, variadic, onlyExactMatches);
                if (dm != null && dm.isShared() && ModelUtil.isResolvable(dm) && (includeInheritedConstructors || !ModelUtil.isConstructor(dm))) {
                    return !dm.isAbstraction() || signature == null;
                }
                return false;
            }

            @Override
            public boolean isMemberLookup() {
                return true;
            }
        }
        Type st = type.getSupertype(new ExactCriteria());
        if (st == null) {
            if (!onlyExactMatches) {
                class LooseCriteria
                implements Type.Criteria {
                    LooseCriteria() {
                    }

                    @Override
                    public boolean satisfies(TypeDeclaration type) {
                        if (type == TypeDeclaration.this) {
                            return false;
                        }
                        Declaration dm = type.getDirectMember(name, null, false);
                        if (dm != null && dm.isShared() && ModelUtil.isResolvable(dm)) {
                            return dm.isAbstraction();
                        }
                        return false;
                    }

                    @Override
                    public boolean isMemberLookup() {
                        return true;
                    }
                }
                st = type.getSupertype(new LooseCriteria());
            }
        } else if (st.isUnknown() && this instanceof Class) {
            class SkipFormalCriteria
            implements Type.Criteria {
                SkipFormalCriteria() {
                }

                @Override
                public boolean satisfies(TypeDeclaration type) {
                    if (type == TypeDeclaration.this) {
                        return false;
                    }
                    Declaration dm = type.getDirectMember(name, signature, variadic, onlyExactMatches);
                    if (dm != null && dm.isShared() && ModelUtil.isResolvable(dm)) {
                        return !dm.isFormal() && (!dm.isAbstraction() || signature == null);
                    }
                    return false;
                }

                @Override
                public boolean isMemberLookup() {
                    return true;
                }
            }
            st = type.getSupertype(new SkipFormalCriteria());
        }
        if (st == null) {
            return new SupertypeDeclaration(null, false);
        }
        if (st.isUnknown()) {
            return new SupertypeDeclaration(null, true);
        }
        Declaration member = st.getDeclaration().getDirectMember(name, signature, variadic, onlyExactMatches);
        return new SupertypeDeclaration(member, false);
    }

    public boolean isAlias() {
        return false;
    }

    public void setSelfType(Type selfType) {
        this.selfType = selfType;
    }

    public Type getSelfType() {
        return this.selfType;
    }

    @Override
    public Map<String, DeclarationWithProximity> getImportableDeclarations(Unit unit, String startingWith, List<Import> imports, int proximity, Cancellable canceller) {
        TreeMap<String, DeclarationWithProximity> result = new TreeMap<String, DeclarationWithProximity>();
        for (Declaration dec : this.getMembers()) {
            if (canceller != null && canceller.isCancelled()) {
                return Collections.emptyMap();
            }
            if (!ModelUtil.isResolvable(dec) || !dec.isShared() || ModelUtil.isOverloadedVersion(dec) || !ModelUtil.isNameMatching(startingWith, dec)) continue;
            boolean already = false;
            for (Import i : imports) {
                if (!i.getDeclaration().equals(dec)) continue;
                already = true;
                break;
            }
            if (already) continue;
            result.put(dec.getName(unit), new DeclarationWithProximity(dec, proximity));
        }
        return result;
    }

    @Override
    public Map<String, DeclarationWithProximity> getMatchingDeclarations(Unit unit, String startingWith, int proximity, Cancellable canceller) {
        Map<String, DeclarationWithProximity> result = super.getMatchingDeclarations(unit, startingWith, proximity, canceller);
        result.putAll(this.getMatchingMemberDeclarations(unit, null, startingWith, proximity, canceller));
        for (Declaration dec : this.getMembers()) {
            if (canceller != null && canceller.isCancelled()) {
                return Collections.emptyMap();
            }
            if (!ModelUtil.isResolvable(dec) || ModelUtil.isOverloadedVersion(dec)) continue;
            if (ModelUtil.isNameMatching(startingWith, dec)) {
                result.put(dec.getName(unit), new DeclarationWithProximity(dec, proximity));
            }
            for (String alias : dec.getAliases()) {
                if (!ModelUtil.isNameMatching(startingWith, alias)) continue;
                result.put(alias, new DeclarationWithProximity(alias, dec, proximity));
            }
        }
        return result;
    }

    public Map<String, DeclarationWithProximity> getMatchingMemberDeclarations(Unit unit, Scope scope, String startingWith, int proximity, Cancellable canceller) {
        TreeMap<String, DeclarationWithProximity> result = new TreeMap<String, DeclarationWithProximity>();
        for (Type st : this.getSatisfiedTypes()) {
            this.mergeMembers(result, st.getDeclaration().getMatchingMemberDeclarations(unit, scope, startingWith, proximity + 1, canceller));
        }
        Type et = this.getExtendedType();
        if (et != null) {
            this.mergeMembers(result, et.getDeclaration().getMatchingMemberDeclarations(unit, scope, startingWith, proximity + 1, canceller));
        }
        for (Declaration member : this.getMembers()) {
            if (canceller != null && canceller.isCancelled()) {
                return Collections.emptyMap();
            }
            if (!ModelUtil.isResolvable(member) || ModelUtil.isOverloadedVersion(member) || !member.isShared() && !ModelUtil.contains(member.getScope(), scope)) continue;
            if (ModelUtil.isNameMatching(startingWith, member)) {
                result.put(member.getName(unit), new DeclarationWithProximity(member, proximity));
            }
            for (String alias : member.getAliases()) {
                if (!ModelUtil.isNameMatching(startingWith, alias)) continue;
                result.put(alias, new DeclarationWithProximity(alias, member, proximity));
            }
        }
        result.putAll(unit.getMatchingImportedDeclarations(this, startingWith, proximity, canceller));
        return result;
    }

    private void mergeMembers(Map<String, DeclarationWithProximity> result, Map<String, DeclarationWithProximity> etm) {
        for (Map.Entry<String, DeclarationWithProximity> e : etm.entrySet()) {
            String name = e.getKey();
            DeclarationWithProximity current = e.getValue();
            DeclarationWithProximity existing = result.get(name);
            if (existing != null && existing.getDeclaration().refines(current.getDeclaration())) continue;
            result.put(name, current);
        }
    }

    boolean isDisjoint(TypeDeclaration td) {
        if (this instanceof UnionType) {
            return false;
        }
        if (this instanceof ClassOrInterface && td instanceof ClassOrInterface && this.equals(td)) {
            return false;
        }
        if (this instanceof TypeParameter && td instanceof TypeParameter && this.equals(td)) {
            return false;
        }
        List<Type> sts = this.getSatisfiedTypes();
        int s = sts.size();
        for (int i = 0; i < s; ++i) {
            Type st = sts.get(i);
            if (!this.isDisjoint(td, st)) continue;
            return true;
        }
        Type et = this.getExtendedType();
        return et != null && this.isDisjoint(td, et);
    }

    private boolean isDisjoint(TypeDeclaration td, Type st) {
        TypeDeclaration std = st.getDeclaration();
        List<Type> cts = std.getCaseTypes();
        if (cts != null) {
            int s = cts.size();
            for (int i = 0; i < s; ++i) {
                TypeDeclaration ctd = cts.get(i).getDeclaration();
                if (!ctd.equals(this)) continue;
                int l = cts.size();
                for (int j = 0; j < l; ++j) {
                    TypeDeclaration octd;
                    if (i == j || !td.inherits(octd = cts.get(j).getDeclaration())) continue;
                    return true;
                }
                break;
            }
        }
        return std.isDisjoint(td);
    }

    public final List<TypeDeclaration> getSupertypeDeclarations() {
        return this.getSupertypeDeclarationsInternal();
    }

    private List<TypeDeclaration> getSupertypeDeclarationsInternal() {
        ArrayList<TypeDeclaration> results = new ArrayList<TypeDeclaration>(this.getSatisfiedTypes().size() + 2);
        results.add(this.unit.getAnythingDeclaration());
        this.collectSupertypeDeclarations(results);
        return results;
    }

    abstract void collectSupertypeDeclarations(List<TypeDeclaration> var1);

    public void clearProducedTypeCache() {
    }

    public boolean isAnything() {
        return false;
    }

    public boolean isObject() {
        return false;
    }

    public boolean isIdentifiable() {
        return false;
    }

    public boolean isNull() {
        return false;
    }

    public boolean isNullValue() {
        return false;
    }

    public boolean isTrueValue() {
        return false;
    }

    public boolean isFalseValue() {
        return false;
    }

    public boolean isBasic() {
        return false;
    }

    public boolean isThrowable() {
        return false;
    }

    public boolean isException() {
        return false;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isCharacter() {
        return false;
    }

    public boolean isFloat() {
        return false;
    }

    public boolean isInteger() {
        return false;
    }

    public boolean isByte() {
        return false;
    }

    public boolean isEmpty() {
        return false;
    }

    boolean isEmptyValue() {
        return false;
    }

    public boolean isEntry() {
        return false;
    }

    public boolean isTuple() {
        return false;
    }

    public boolean isIterable() {
        return false;
    }

    public boolean isSequential() {
        return false;
    }

    public boolean isSequence() {
        return false;
    }

    public boolean isRange() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public List<TypedDeclaration> getCaseValues() {
        return this.caseValues;
    }

    public void setCaseValues(List<TypedDeclaration> caseValues) {
        this.caseValues = caseValues;
    }

    public boolean isSequentialType() {
        return false;
    }

    public boolean isSequenceType() {
        return false;
    }

    public boolean isEmptyType() {
        return false;
    }

    public boolean isTupleType() {
        return false;
    }

    public boolean isCallable() {
        return false;
    }

    public boolean isSam() {
        return this.getSamName() != null;
    }

    public String getSamName() {
        return this.samName;
    }

    public void setSamName(String samName) {
        this.samName = samName;
    }

    static class SupertypeDeclaration {
        private Declaration member;
        private boolean ambiguous;

        SupertypeDeclaration(Declaration declaration, boolean ambiguous) {
            this.member = declaration;
            this.ambiguous = ambiguous;
        }

        private boolean isAmbiguous() {
            return this.ambiguous;
        }

        private Declaration getMember() {
            return this.member;
        }
    }
}

