/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.typechecker.model;

import com.redhat.ceylon.model.loader.model.AnnotationTarget;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Reference;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.Typed;
import com.redhat.ceylon.model.typechecker.model.TypedReference;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;

public abstract class TypedDeclaration
extends Declaration
implements Typed {
    private Type type;
    private TypedDeclaration originalDeclaration;

    public boolean isDynamicallyTyped() {
        return (this.flags & 0x40000L) != 0L;
    }

    public void setDynamicallyTyped(boolean dynamicallyTyped) {
        this.flags = dynamicallyTyped ? (this.flags |= 0x40000L) : (this.flags &= 0xFFFFFFFFFFFBFFFFL);
    }

    public TypeDeclaration getTypeDeclaration() {
        if (this.type == null) {
            return null;
        }
        return this.type.getDeclaration();
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public void setType(Type t) {
        this.type = t;
    }

    public TypedReference appliedTypedReference(Type qualifyingType, List<Type> typeArguments) {
        return this.appliedTypedReference(qualifyingType, typeArguments, false);
    }

    public TypedReference appliedTypedReference(Type qualifyingType, List<Type> typeArguments, boolean assignment) {
        TypedReference ptr = new TypedReference(!assignment, assignment);
        ptr.setDeclaration(this);
        ptr.setQualifyingType(qualifyingType);
        ptr.setTypeArguments(ModelUtil.getTypeArgumentMap(this, qualifyingType, typeArguments));
        return ptr;
    }

    public TypedReference getTypedReference() {
        TypedReference ptr = new TypedReference(true, false);
        ptr.setQualifyingType(this.getMemberContainerType());
        ptr.setDeclaration(this);
        ptr.setTypeArguments(this.getTypeParametersAsArguments());
        return ptr;
    }

    @Override
    public Reference appliedReference(Type pt, List<Type> typeArguments) {
        return this.appliedTypedReference(pt, typeArguments);
    }

    @Override
    public final Reference getReference() {
        return this.getTypedReference();
    }

    @Override
    public boolean isMember() {
        return this.getContainer() instanceof ClassOrInterface;
    }

    public boolean isVariable() {
        return false;
    }

    public boolean isLate() {
        return false;
    }

    public TypedDeclaration getOriginalDeclaration() {
        return this.originalDeclaration;
    }

    public void setOriginalDeclaration(TypedDeclaration originalDeclaration) {
        this.originalDeclaration = originalDeclaration;
    }

    public Boolean getUnboxed() {
        if ((this.flags & 0x2000L) == 0L) {
            return null;
        }
        return (this.flags & 0x4000L) != 0L;
    }

    public void setUnboxed(Boolean value) {
        if (value == null) {
            this.flags &= 0xFFFFFFFFFFFFDFFFL;
        } else {
            this.flags |= 0x2000L;
            this.flags = value.booleanValue() ? (this.flags |= 0x4000L) : (this.flags &= 0xFFFFFFFFFFFFBFFFL);
        }
    }

    public Boolean getTypeErased() {
        return (this.flags & 0x8000L) != 0L;
    }

    public void setTypeErased(Boolean typeErased) {
        this.flags = typeErased.booleanValue() ? (this.flags |= 0x8000L) : (this.flags &= 0xFFFFFFFFFFFF7FFFL);
    }

    public Boolean getUntrustedType() {
        if ((this.flags & 0x20000L) == 0L) {
            return null;
        }
        return (this.flags & 0x10000L) != 0L;
    }

    public void setUntrustedType(Boolean untrustedType) {
        if (untrustedType == null) {
            this.flags &= 0xFFFFFFFFFFFDFFFFL;
        } else {
            this.flags |= 0x20000L;
            this.flags = untrustedType.booleanValue() ? (this.flags |= 0x10000L) : (this.flags &= 0xFFFFFFFFFFFEFFFFL);
        }
    }

    public boolean hasUncheckedNullType() {
        return (this.flags & 0x1000L) != 0L;
    }

    public void setUncheckedNullType(boolean uncheckedNullType) {
        this.flags = uncheckedNullType ? (this.flags |= 0x1000L) : (this.flags &= 0xFFFFFFFFFFFFEFFFL);
    }

    @Override
    protected int hashCodeForCache() {
        int ret = 17;
        Scope container = this.getContainer();
        if (container instanceof Declaration) {
            Declaration dec = (Declaration)((Object)container);
            ret = 37 * ret + dec.hashCodeForCache();
        } else {
            ret = 37 * ret + container.hashCode();
        }
        String qualifier = this.getQualifier();
        ret = 37 * ret + (qualifier == null ? 0 : qualifier.hashCode());
        ret = 37 * ret + Objects.hashCode(this.getName());
        return ret;
    }

    @Override
    protected boolean equalsForCache(Object o) {
        Declaration dec;
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof TypedDeclaration)) {
            return false;
        }
        if (this.isOverloaded() && o != this) {
            return false;
        }
        TypedDeclaration b = (TypedDeclaration)o;
        Scope container = this.getContainer();
        if (container instanceof Declaration ? !(dec = (Declaration)((Object)container)).equalsForCache(b.getContainer()) : !container.equals(b.getContainer())) {
            return false;
        }
        if (!Objects.equals(this.getQualifier(), b.getQualifier())) {
            return false;
        }
        return Objects.equals(this.getName(), b.getName());
    }

    public boolean isSelfCaptured() {
        return false;
    }

    public EnumSet<AnnotationTarget> getAnnotationTargets() {
        return null;
    }
}

