/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.typechecker.model;

import com.redhat.ceylon.model.typechecker.model.Cancellable;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.DeclarationKind;
import com.redhat.ceylon.model.typechecker.model.DeclarationWithProximity;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.Unit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UnionType
extends TypeDeclaration {
    public UnionType(Unit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("null unit");
        }
        this.unit = unit;
    }

    @Override
    public void addMember(Declaration declaration) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.getType().asString();
    }

    @Override
    public String getName(Unit unit) {
        return this.getType().asString(unit);
    }

    @Override
    public String getQualifiedNameString() {
        return this.getType().asQualifiedString();
    }

    @Override
    protected boolean needsSatisfiedTypes() {
        return false;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public Type getType() {
        List<Type> cts = this.getCaseTypes();
        for (Type pt : cts) {
            if (pt != null && !pt.isUnknown()) continue;
            return this.unit.getUnknownType();
        }
        if (cts.size() == 0) {
            return this.unit.getNothingType();
        }
        if (cts.size() == 1) {
            return cts.get(0).getType();
        }
        return super.getType();
    }

    @Override
    public Map<String, DeclarationWithProximity> getMatchingMemberDeclarations(Unit unit, Scope scope, String startingWith, int proximity, Cancellable canceller) {
        Map<String, DeclarationWithProximity> result = super.getMatchingMemberDeclarations(unit, scope, startingWith, proximity, canceller);
        TypeDeclaration d = this.getCaseTypes().get(0).getDeclaration();
        for (Map.Entry<String, DeclarationWithProximity> e : d.getMatchingMemberDeclarations(unit, scope, startingWith, proximity, canceller).entrySet()) {
            Declaration member = this.getMember(e.getKey(), null, false);
            if (member == null) continue;
            result.put(e.getKey(), new DeclarationWithProximity(member, e.getValue()));
        }
        return result;
    }

    @Override
    public DeclarationKind getDeclarationKind() {
        return null;
    }

    @Override
    void collectSupertypeDeclarations(List<TypeDeclaration> results) {
        List<Type> cts = this.getCaseTypes();
        if (!cts.isEmpty()) {
            ArrayList<TypeDeclaration> candidates = new ArrayList<TypeDeclaration>(results);
            Type firstCase = cts.get(0);
            firstCase.getDeclaration().collectSupertypeDeclarations(candidates);
            int max = candidates.size();
            for (int j = results.size(); j < max; ++j) {
                TypeDeclaration std = (TypeDeclaration)candidates.get(j);
                if (!this.inherits(std)) continue;
                results.add(std);
            }
        }
    }

    @Override
    public boolean isEmptyType() {
        return this.inherits(this.getUnit().getEmptyDeclaration());
    }

    @Override
    public boolean isTupleType() {
        return this.inherits(this.getUnit().getTupleDeclaration());
    }

    @Override
    public boolean isSequenceType() {
        return this.inherits(this.getUnit().getSequenceDeclaration());
    }

    @Override
    public boolean isSequentialType() {
        return this.inherits(this.getUnit().getSequentialDeclaration());
    }

    @Override
    public boolean inherits(TypeDeclaration dec) {
        if (dec == null) {
            return false;
        }
        if (dec.isAnything()) {
            return true;
        }
        for (Type ct : this.getCaseTypes()) {
            if (ct.getDeclaration().inherits(dec)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        throw new UnsupportedOperationException("union types don't have well-defined equality");
    }

    @Override
    protected int hashCodeForCache() {
        int ret = 17;
        List<Type> caseTypes = this.getCaseTypes();
        int l = caseTypes.size();
        for (int i = 0; i < l; ++i) {
            ret = 37 * ret + caseTypes.get(i).hashCode();
        }
        return ret;
    }

    @Override
    protected boolean equalsForCache(Object o) {
        if (o == null || !(o instanceof UnionType)) {
            return false;
        }
        UnionType b = (UnionType)o;
        List<Type> caseTypesA = this.getCaseTypes();
        List<Type> caseTypesB = b.getCaseTypes();
        if (caseTypesA.size() != caseTypesB.size()) {
            return false;
        }
        int l = caseTypesA.size();
        for (int i = 0; i < l; ++i) {
            if (caseTypesA.get(i).equals(caseTypesB.get(i))) continue;
            return false;
        }
        return true;
    }
}

