/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.typechecker.model;

import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.model.typechecker.context.TypeCache;
import com.redhat.ceylon.model.typechecker.model.Cancellable;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.DeclarationWithProximity;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Import;
import com.redhat.ceylon.model.typechecker.model.ImportList;
import com.redhat.ceylon.model.typechecker.model.ImportScope;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.LanguageModuleProvider;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.NothingType;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import com.redhat.ceylon.model.typechecker.model.Reference;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypedReference;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

public class Unit
implements LanguageModuleProvider,
ImportScope {
    private Package pkg;
    private List<Import> imports = new ArrayList<Import>();
    private List<Declaration> declarations = new ArrayList<Declaration>();
    private String filename;
    private List<ImportList> importLists = new ArrayList<ImportList>();
    private Set<Declaration> duplicateDeclarations = new HashSet<Declaration>();
    private final Set<String> dependentsOf = new HashSet<String>();
    private String fullPath;
    private String relativePath;
    private Backends supportedBackends = Backends.ANY;
    private boolean unresolvedReferences;
    private Module languageModule;
    private Package languagePackage;
    private final Map<String, String> modifiers = new HashMap<String, String>();

    public Unit() {
        this.put("shared");
        this.put("default");
        this.put("formal");
        this.put("native");
        this.put("actual");
        this.put("abstract");
        this.put("final");
        this.put("sealed");
        this.put("variable");
        this.put("late");
        this.put("deprecated");
        this.put("annotation");
        this.put("optional");
        this.put("serializable");
        this.put("small");
        this.put("service");
        this.put("static");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Import> getImports() {
        List<Import> list = this.imports;
        synchronized (list) {
            return new ArrayList<Import>(this.imports);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addImport(Import imp) {
        List<Import> list = this.imports;
        synchronized (list) {
            this.imports.add(imp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeImport(Import imp) {
        List<Import> list = this.imports;
        synchronized (list) {
            this.imports.remove(imp);
        }
    }

    public List<ImportList> getImportLists() {
        return this.importLists;
    }

    public Set<String> getDependentsOf() {
        return this.dependentsOf;
    }

    public Set<Declaration> getDuplicateDeclarations() {
        return this.duplicateDeclarations;
    }

    public Package getPackage() {
        return this.pkg;
    }

    public void setPackage(Package p) {
        this.pkg = p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Declaration> getDeclarations() {
        List<Declaration> list = this.declarations;
        synchronized (list) {
            return new ArrayList<Declaration>(this.declarations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Declaration> getMembers() {
        List<Declaration> list = this.declarations;
        synchronized (list) {
            ArrayList<Declaration> list2 = new ArrayList<Declaration>(this.declarations.size());
            for (Declaration d : this.declarations) {
                if (!d.isToplevel()) continue;
                list2.add(d);
            }
            return list2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeclaration(Declaration declaration) {
        List<Declaration> list = this.declarations;
        synchronized (list) {
            this.declarations.add(declaration);
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public void setFullPath(String fullPath) {
        this.fullPath = fullPath;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }

    public String toString() {
        return this.filename;
    }

    @Override
    public Import getImport(String name) {
        for (Import i : this.getImports()) {
            if (i.isAmbiguous() || i.getTypeDeclaration() != null || !i.getAlias().equals(name)) continue;
            return i;
        }
        return null;
    }

    public String getAliasedName(Declaration dec) {
        return this.getAliasedName(dec, dec.getName());
    }

    public String getAliasedName(Declaration dec, String defaultValue) {
        for (Import i : this.getImports()) {
            if (i.isAmbiguous() || !i.getDeclaration().equals(Unit.getAbstraction(dec))) continue;
            return i.getAlias();
        }
        return defaultValue;
    }

    public static Declaration getAbstraction(Declaration dec) {
        if (ModelUtil.isOverloadedVersion(dec)) {
            return dec.getContainer().getDirectMember(dec.getName(), null, false);
        }
        return dec;
    }

    public Declaration getImportedDeclaration(String name, List<Type> signature, boolean ellipsis) {
        for (Import i : this.getImports()) {
            Declaration d;
            if (i.isAmbiguous() || !i.getAlias().equals(name) || !Unit.isToplevelImport(i, d = i.getDeclaration())) continue;
            return d.getContainer().getMember(d.getName(), signature, ellipsis);
        }
        return null;
    }

    static boolean isToplevelImport(Import i, Declaration d) {
        return d.isToplevel() || d.isStatic() || ModelUtil.isToplevelClassConstructor(i.getTypeDeclaration(), d) || ModelUtil.isToplevelAnonymousClass(i.getTypeDeclaration());
    }

    public Declaration getImportedDeclaration(TypeDeclaration td, String name, List<Type> signature, boolean ellipsis) {
        for (Import i : this.getImports()) {
            TypeDeclaration itd = i.getTypeDeclaration();
            if (itd == null || !td.inherits(itd) || i.isAmbiguous() || !i.getAlias().equals(name)) continue;
            Declaration d = i.getDeclaration();
            return d.getContainer().getMember(d.getName(), signature, ellipsis);
        }
        return null;
    }

    public Map<String, DeclarationWithProximity> getMatchingImportedDeclarations(String startingWith, int proximity, Cancellable canceller) {
        TreeMap<String, DeclarationWithProximity> result = new TreeMap<String, DeclarationWithProximity>();
        for (Import i : this.getImports()) {
            Declaration d;
            if (canceller != null && canceller.isCancelled()) {
                return Collections.emptyMap();
            }
            if (i.getAlias() == null || i.isAmbiguous() || !ModelUtil.isNameMatching(startingWith, i) || !Unit.isToplevelImport(i, d = i.getDeclaration())) continue;
            result.put(i.getAlias(), new DeclarationWithProximity(i, proximity));
        }
        return result;
    }

    public Map<String, DeclarationWithProximity> getMatchingImportedDeclarations(TypeDeclaration td, String startingWith, int proximity, Cancellable canceller) {
        TreeMap<String, DeclarationWithProximity> result = new TreeMap<String, DeclarationWithProximity>();
        for (Import i : this.getImports()) {
            if (canceller != null && canceller.isCancelled()) {
                return Collections.emptyMap();
            }
            TypeDeclaration itd = i.getTypeDeclaration();
            if (i.getAlias() == null || i.isAmbiguous() || itd == null || !itd.equals(td) || !ModelUtil.isNameMatching(startingWith, i)) continue;
            result.put(i.getAlias(), new DeclarationWithProximity(i, proximity));
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Unit) {
            Unit that = (Unit)obj;
            return that == this || that.getPackage().equals(this.getPackage()) && Objects.equals(this.getFilename(), that.getFilename()) && Objects.equals(that.getFullPath(), this.getFullPath());
        }
        return false;
    }

    public int hashCode() {
        return this.getFullPath().hashCode();
    }

    public Declaration getLanguageModuleDeclaration(String name) {
        Module languageModule = this.getLanguageModule();
        if (languageModule != null && languageModule.isAvailable()) {
            Declaration d;
            if ("Nothing".equals(name)) {
                return this.getNothingDeclaration();
            }
            if (this.languagePackage == null) {
                this.languagePackage = languageModule.getPackage("ceylon.language");
            }
            if (this.languagePackage != null && (d = this.languagePackage.getMember(name, null, false)) != null && d.isShared()) {
                return d;
            }
        }
        return null;
    }

    private Module getLanguageModule() {
        if (this.languageModule == null) {
            this.languageModule = this.getPackage().getModule().getLanguageModule();
        }
        return this.languageModule;
    }

    public Declaration getLanguageModuleModelDeclaration(String name) {
        Declaration d;
        Package languageScope;
        Module languageModule = this.getPackage().getModule().getLanguageModule();
        if (languageModule != null && languageModule.isAvailable() && (languageScope = languageModule.getPackage("ceylon.language.meta.model")) != null && (d = languageScope.getMember(name, null, false)) != null && d.isShared()) {
            return d;
        }
        return null;
    }

    public Declaration getLanguageModuleDeclarationDeclaration(String name) {
        Declaration d;
        Package languageScope;
        Module languageModule = this.getPackage().getModule().getLanguageModule();
        if (languageModule != null && languageModule.isAvailable() && (languageScope = languageModule.getPackage("ceylon.language.meta.declaration")) != null && (d = languageScope.getMember(name, null, false)) != null && d.isShared()) {
            return d;
        }
        return null;
    }

    public Declaration getLanguageModuleSerializationDeclaration(String name) {
        Declaration d;
        Package languageScope;
        Module languageModule = this.getPackage().getModule().getLanguageModule();
        if (languageModule != null && languageModule.isAvailable() && (languageScope = languageModule.getPackage("ceylon.language.serialization")) != null && (d = languageScope.getMember(name, null, false)) != null && d.isShared()) {
            return d;
        }
        return null;
    }

    @Override
    public Interface getCorrespondenceDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getCorrespondenceDeclaration();
        }
        return null;
    }

    public Interface getCorrespondenceMutatorDeclaration() {
        return (Interface)this.getLanguageModuleDeclaration("CorrespondenceMutator");
    }

    public Interface getIndexedCorrespondenceMutatorDeclaration() {
        return (Interface)this.getLanguageModuleDeclaration("IndexedCorrespondenceMutator");
    }

    public Interface getKeyedCorrespondenceMutatorDeclaration() {
        return (Interface)this.getLanguageModuleDeclaration("KeyedCorrespondenceMutator");
    }

    @Override
    public Class getAnythingDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getAnythingDeclaration();
        }
        return null;
    }

    @Override
    public Class getNullDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getNullDeclaration();
        }
        return null;
    }

    public Value getNullValueDeclaration() {
        return (Value)this.getLanguageModuleDeclaration("null");
    }

    @Override
    public Interface getEmptyDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getEmptyDeclaration();
        }
        return null;
    }

    @Override
    public Interface getSequenceDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getSequenceDeclaration();
        }
        return null;
    }

    @Override
    public Class getObjectDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getObjectDeclaration();
        }
        return null;
    }

    @Override
    public Class getBasicDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getBasicDeclaration();
        }
        return null;
    }

    @Override
    public Interface getIdentifiableDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getIdentifiableDeclaration();
        }
        return null;
    }

    @Override
    public Class getThrowableDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getThrowableDeclaration();
        }
        return null;
    }

    @Override
    public Class getExceptionDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getExceptionDeclaration();
        }
        return null;
    }

    @Override
    public Interface getCategoryDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getCategoryDeclaration();
        }
        return null;
    }

    @Override
    public Interface getIterableDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getIterableDeclaration();
        }
        return null;
    }

    public Interface getJavaIterableDeclaration() {
        Package lang = this.getJavaLangPackage();
        if (lang == null) {
            return null;
        }
        return (Interface)lang.getMember("Iterable", null, false);
    }

    public Interface getJavaCharSequenceDeclaration() {
        Package lang = this.getJavaLangPackage();
        if (lang == null) {
            return null;
        }
        return (Interface)lang.getMember("CharSequence", null, false);
    }

    public Class getJavaStringDeclaration() {
        Package lang = this.getJavaLangPackage();
        if (lang == null) {
            return null;
        }
        return (Class)lang.getMember("String", null, false);
    }

    public Class getJavaClassDeclaration() {
        Package lang = this.getJavaLangPackage();
        if (lang == null) {
            return null;
        }
        return (Class)lang.getMember("Class", null, false);
    }

    public Interface getJavaCollectionDeclaration() {
        Package util = this.getJavaUtilPackage();
        if (util == null) {
            return null;
        }
        return (Interface)util.getMember("Collection", null, false);
    }

    public Interface getJavaListDeclaration() {
        Package lang = this.getJavaUtilPackage();
        if (lang == null) {
            return null;
        }
        return (Interface)lang.getMember("List", null, false);
    }

    public Interface getJavaMapDeclaration() {
        Package lang = this.getJavaUtilPackage();
        if (lang == null) {
            return null;
        }
        return (Interface)lang.getMember("Map", null, false);
    }

    public Class getJavaObjectArrayDeclaration() {
        Package lang = this.getJavaLangPackage();
        if (lang == null) {
            return null;
        }
        return (Class)lang.getMember("ObjectArray", null, false);
    }

    public Class getJavaBooleanArrayDeclaration() {
        Package lang = this.getJavaLangPackage();
        if (lang == null) {
            return null;
        }
        return (Class)lang.getMember("BooleanArray", null, false);
    }

    public Class getJavaByteArrayDeclaration() {
        Package lang = this.getJavaLangPackage();
        if (lang == null) {
            return null;
        }
        return (Class)lang.getMember("ByteArray", null, false);
    }

    public Class getJavaShortArrayDeclaration() {
        Package lang = this.getJavaLangPackage();
        if (lang == null) {
            return null;
        }
        return (Class)lang.getMember("ShortArray", null, false);
    }

    public Class getJavaIntArrayDeclaration() {
        Package lang = this.getJavaLangPackage();
        if (lang == null) {
            return null;
        }
        return (Class)lang.getMember("IntArray", null, false);
    }

    public Class getJavaLongArrayDeclaration() {
        Package lang = this.getJavaLangPackage();
        if (lang == null) {
            return null;
        }
        return (Class)lang.getMember("LongArray", null, false);
    }

    public Class getJavaFloatArrayDeclaration() {
        Package lang = this.getJavaLangPackage();
        if (lang == null) {
            return null;
        }
        return (Class)lang.getMember("FloatArray", null, false);
    }

    public Class getJavaDoubleArrayDeclaration() {
        Package lang = this.getJavaLangPackage();
        if (lang == null) {
            return null;
        }
        return (Class)lang.getMember("DoubleArray", null, false);
    }

    public Class getJavaCharArrayDeclaration() {
        Package lang = this.getJavaLangPackage();
        if (lang == null) {
            return null;
        }
        return (Class)lang.getMember("CharArray", null, false);
    }

    public Interface getJavaAutoCloseableDeclaration() {
        Package lang = this.getJavaLangPackage();
        if (lang == null) {
            return null;
        }
        return (Interface)lang.getMember("AutoCloseable", null, false);
    }

    public Class getJavaEnumDeclaration() {
        Package lang = this.getJavaLangPackage();
        if (lang == null) {
            return null;
        }
        return (Class)lang.getMember("Enum", null, false);
    }

    public Interface getJavaSerializableDeclaration() {
        Package io = this.getJavaIoPackage();
        if (io == null) {
            return null;
        }
        return (Interface)io.getMember("Serializable", null, false);
    }

    protected Package getJavaLangPackage() {
        return this.getPackage().getModule().getPackage("java.lang");
    }

    protected Package getJavaUtilPackage() {
        return this.getPackage().getModule().getPackage("java.util");
    }

    protected Package getJavaIoPackage() {
        return this.getPackage().getModule().getPackage("java.io");
    }

    @Override
    public Interface getSequentialDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getSequentialDeclaration();
        }
        return null;
    }

    @Override
    public Interface getListDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getListDeclaration();
        }
        return null;
    }

    @Override
    public Interface getCollectionDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getCollectionDeclaration();
        }
        return null;
    }

    @Override
    public Interface getIteratorDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getIteratorDeclaration();
        }
        return null;
    }

    @Override
    public Interface getCallableDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getCallableDeclaration();
        }
        return null;
    }

    @Override
    public Interface getScalableDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getScalableDeclaration();
        }
        return null;
    }

    @Override
    public Interface getSummableDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getSummableDeclaration();
        }
        return null;
    }

    @Override
    public Interface getNumericDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getNumericDeclaration();
        }
        return null;
    }

    @Override
    public Interface getIntegralDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getIntegralDeclaration();
        }
        return null;
    }

    @Override
    public Interface getInvertableDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getInvertableDeclaration();
        }
        return null;
    }

    @Override
    public Interface getExponentiableDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getExponentiableDeclaration();
        }
        return null;
    }

    @Override
    public Interface getSetDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getSetDeclaration();
        }
        return null;
    }

    @Override
    public Interface getMapDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getMapDeclaration();
        }
        return null;
    }

    @Override
    public Class getComparisonDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getComparisonDeclaration();
        }
        return null;
    }

    @Override
    public Class getBooleanDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getBooleanDeclaration();
        }
        return null;
    }

    public Value getTrueValueDeclaration() {
        return (Value)this.getLanguageModuleDeclaration("true");
    }

    public Value getFalseValueDeclaration() {
        return (Value)this.getLanguageModuleDeclaration("false");
    }

    @Override
    public Class getStringDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getStringDeclaration();
        }
        return null;
    }

    @Override
    public Class getFloatDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getFloatDeclaration();
        }
        return null;
    }

    @Override
    public Class getIntegerDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getIntegerDeclaration();
        }
        return null;
    }

    @Override
    public Class getCharacterDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getCharacterDeclaration();
        }
        return null;
    }

    @Override
    public Class getByteDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getByteDeclaration();
        }
        return null;
    }

    @Override
    public Interface getComparableDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getComparableDeclaration();
        }
        return null;
    }

    @Override
    public Interface getUsableDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getUsableDeclaration();
        }
        return null;
    }

    @Override
    public Interface getDestroyableDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getDestroyableDeclaration();
        }
        return null;
    }

    @Override
    public Interface getObtainableDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getObtainableDeclaration();
        }
        return null;
    }

    @Override
    public Interface getOrdinalDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getOrdinalDeclaration();
        }
        return null;
    }

    @Override
    public Interface getEnumerableDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getEnumerableDeclaration();
        }
        return null;
    }

    @Override
    public Class getRangeDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getRangeDeclaration();
        }
        return null;
    }

    @Override
    public Class getSpanDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getSpanDeclaration();
        }
        return null;
    }

    @Override
    public Class getMeasureDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getMeasureDeclaration();
        }
        return null;
    }

    @Override
    public Class getTupleDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getTupleDeclaration();
        }
        return null;
    }

    @Override
    public TypeDeclaration getArrayDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getArrayDeclaration();
        }
        return null;
    }

    @Override
    public Interface getRangedDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getRangedDeclaration();
        }
        return null;
    }

    @Override
    public Class getEntryDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getEntryDeclaration();
        }
        return null;
    }

    Type getCallableType(Reference ref, Type rt) {
        Type result = rt;
        Declaration declaration = ref.getDeclaration();
        if (declaration instanceof Functional) {
            Functional fd = (Functional)((Object)declaration);
            List<ParameterList> pls = fd.getParameterLists();
            for (int i = pls.size() - 1; i >= 0; --i) {
                boolean hasSequenced = false;
                boolean atLeastOne = false;
                int firstDefaulted = -1;
                List<Parameter> ps = pls.get(i).getParameters();
                ArrayList<Type> args = new ArrayList<Type>(ps.size());
                for (int j = 0; j < ps.size(); ++j) {
                    Parameter p = ps.get(j);
                    if (p.getModel() == null) {
                        args.add(this.getUnknownType());
                        continue;
                    }
                    TypedReference np = ref.getTypedParameter(p);
                    Type npt = np.getType();
                    if (npt == null) {
                        args.add(this.getUnknownType());
                        continue;
                    }
                    if (p.isDefaulted() && firstDefaulted == -1) {
                        firstDefaulted = j;
                    }
                    if (np.getDeclaration() instanceof Functional) {
                        args.add(this.getCallableType(np, npt));
                        continue;
                    }
                    if (p.isSequenced()) {
                        args.add(this.getIteratedType(npt));
                        hasSequenced = true;
                        atLeastOne = p.isAtLeastOne();
                        continue;
                    }
                    args.add(npt);
                }
                Type paramListType = this.getTupleType(args, hasSequenced, atLeastOne, firstDefaulted);
                result = ModelUtil.appliedType((TypeDeclaration)this.getCallableDeclaration(), result, paramListType);
            }
        }
        return result;
    }

    public Type getTupleType(List<Type> elemTypes, Type variadicTailType, int firstDefaulted) {
        boolean hasVariadicTail = variadicTailType != null;
        Type result = hasVariadicTail ? variadicTailType : this.getEmptyType();
        Type union = hasVariadicTail ? this.getSequentialElementType(variadicTailType) : this.getNothingType();
        return this.getTupleType(elemTypes, false, false, firstDefaulted, result, union);
    }

    public Type getTupleType(List<Type> elemTypes, boolean variadic, boolean atLeastOne, int firstDefaulted) {
        return this.getTupleType(elemTypes, variadic, atLeastOne, firstDefaulted, this.getEmptyType(), this.getNothingType());
    }

    private Type getTupleType(List<Type> elemTypes, boolean variadic, boolean atLeastOne, int firstDefaulted, Type result, Type union) {
        int last;
        for (int i = last = elemTypes.size() - 1; i >= 0; --i) {
            Type elemType = elemTypes.get(i);
            union = ModelUtil.unionType(union, elemType, this);
            if (variadic && i == last) {
                result = atLeastOne ? this.getSequenceType(elemType) : this.getSequentialType(elemType);
                continue;
            }
            result = ModelUtil.appliedType((TypeDeclaration)this.getTupleDeclaration(), union, elemType, result);
            if (firstDefaulted < 0 || i < firstDefaulted) continue;
            result = ModelUtil.unionType(result, this.getEmptyType(), this);
        }
        return result;
    }

    public Type getEmptyType(Type pt) {
        return pt == null ? null : ModelUtil.unionType(pt, this.getEmptyType(), this);
    }

    public Type getPossiblyEmptyType(Type pt) {
        return pt == null ? null : ModelUtil.appliedType((TypeDeclaration)this.getSequentialDeclaration(), this.getSequentialElementType(pt));
    }

    public Type getOptionalType(Type pt) {
        return pt == null ? null : ModelUtil.unionType(pt, this.getNullType(), this);
    }

    @Override
    public Type getUnknownType() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getUnknownType();
        }
        return null;
    }

    @Override
    public Type getNothingType() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getNothingType();
        }
        return null;
    }

    @Override
    public Type getEmptyType() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getEmptyType();
        }
        return null;
    }

    @Override
    public Type getAnythingType() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getAnythingType();
        }
        return null;
    }

    @Override
    public Type getObjectType() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getObjectType();
        }
        return null;
    }

    @Override
    public Type getIdentifiableType() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getIdentifiableType();
        }
        return null;
    }

    @Override
    public Type getBasicType() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getBasicType();
        }
        return null;
    }

    @Override
    public Type getNullType() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getNullType();
        }
        return null;
    }

    public Type getNullValueType() {
        return this.getNullValueDeclaration().getType();
    }

    @Override
    public Type getThrowableType() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getThrowableType();
        }
        return null;
    }

    @Override
    public Type getExceptionType() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getExceptionType();
        }
        return null;
    }

    @Override
    public Type getBooleanType() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getBooleanType();
        }
        return null;
    }

    @Override
    public Type getStringType() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getStringType();
        }
        return null;
    }

    @Override
    public Type getIntegerType() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getIntegerType();
        }
        return null;
    }

    @Override
    public Type getFloatType() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getFloatType();
        }
        return null;
    }

    @Override
    public Type getCharacterType() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getCharacterType();
        }
        return null;
    }

    @Override
    public Type getByteType() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getByteType();
        }
        return null;
    }

    @Override
    public Type getComparisonType() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getComparisonType();
        }
        return null;
    }

    @Override
    public Type getDestroyableType() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getDestroyableType();
        }
        return null;
    }

    @Override
    public Type getObtainableType() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getObtainableType();
        }
        return null;
    }

    public Type getJavaAutoCloseableType() {
        return this.getType(this.getJavaAutoCloseableDeclaration());
    }

    public Type getJavaEnumType(Type et) {
        return ModelUtil.appliedType((TypeDeclaration)this.getJavaEnumDeclaration(), et);
    }

    public Type getSequenceType(Type et) {
        return ModelUtil.appliedType((TypeDeclaration)this.getSequenceDeclaration(), et);
    }

    public Type getSequentialType(Type et) {
        return ModelUtil.appliedType((TypeDeclaration)this.getSequentialDeclaration(), et);
    }

    public Type getIterableType(Type et) {
        return ModelUtil.appliedType((TypeDeclaration)this.getIterableDeclaration(), et, this.getNullType());
    }

    public Type getNonemptyIterableType(Type et) {
        return ModelUtil.appliedType((TypeDeclaration)this.getIterableDeclaration(), et, this.getNothingType());
    }

    public Type getSetType(Type et) {
        return ModelUtil.appliedType((TypeDeclaration)this.getSetDeclaration(), et);
    }

    public Type getIteratorType(Type et) {
        return ModelUtil.appliedType((TypeDeclaration)this.getIteratorDeclaration(), et);
    }

    public Type getSpanType(Type rt) {
        return ModelUtil.appliedType((TypeDeclaration)this.getRangeDeclaration(), rt);
    }

    public Type getMeasureType(Type rt) {
        return ModelUtil.unionType(ModelUtil.appliedType((TypeDeclaration)this.getRangeDeclaration(), rt), this.getEmptyType(), this);
    }

    public Type getEntryType(Type kt, Type vt) {
        return ModelUtil.appliedType((TypeDeclaration)this.getEntryDeclaration(), kt, vt);
    }

    public Type getKeyType(Type type) {
        Type st = type.getSupertype(this.getEntryDeclaration());
        if (st != null && st.getTypeArguments().size() == 2) {
            return st.getTypeArgumentList().get(0);
        }
        return null;
    }

    public Type getValueType(Type type) {
        Type st = type.getSupertype(this.getEntryDeclaration());
        if (st != null && st.getTypeArguments().size() == 2) {
            return st.getTypeArgumentList().get(1);
        }
        return null;
    }

    public Type getIteratedType(Type type) {
        Interface id = this.getIterableDeclaration();
        Type st = type.getSupertype(id);
        if (st != null && st.getTypeArguments().size() > 0) {
            return st.getTypeArgumentList().get(0);
        }
        return null;
    }

    public Type getJavaIteratedType(Type type) {
        Interface id = this.getJavaIterableDeclaration();
        Type st = type.getSupertype(id);
        if (st != null && st.getTypeArguments().size() > 0) {
            return st.getTypeArgumentList().get(0);
        }
        return null;
    }

    public Type getJavaArrayElementType(Type type) {
        Type t = type.resolveAliases();
        TypeDeclaration dec = t.getDeclaration();
        if (dec instanceof Constructor) {
            dec = dec.getExtendedType().getDeclaration();
        }
        if (!(dec instanceof Class)) {
            return null;
        }
        if (dec.equals(this.getJavaObjectArrayDeclaration())) {
            Type supertype = t.getSupertype(dec);
            if (!supertype.getTypeArguments().isEmpty()) {
                return supertype.getTypeArgumentList().get(0);
            }
            return null;
        }
        if (dec.equals(this.getJavaIntArrayDeclaration())) {
            return this.getIntegerType();
        }
        if (dec.equals(this.getJavaLongArrayDeclaration())) {
            return this.getIntegerType();
        }
        if (dec.equals(this.getJavaShortArrayDeclaration())) {
            return this.getIntegerType();
        }
        if (dec.equals(this.getJavaByteArrayDeclaration())) {
            return this.getByteType();
        }
        if (dec.equals(this.getJavaCharArrayDeclaration())) {
            return this.getCharacterType();
        }
        if (dec.equals(this.getJavaBooleanArrayDeclaration())) {
            return this.getBooleanType();
        }
        if (dec.equals(this.getJavaFloatArrayDeclaration())) {
            return this.getFloatType();
        }
        if (dec.equals(this.getJavaDoubleArrayDeclaration())) {
            return this.getFloatType();
        }
        return null;
    }

    public Type getAbsentType(Type type) {
        Interface id = this.getIterableDeclaration();
        Type st = type.getSupertype(id);
        if (st != null && st.getTypeArguments().size() > 1) {
            return st.getTypeArgumentList().get(1);
        }
        return null;
    }

    public boolean isNonemptyIterableType(Type type) {
        if (type == null) {
            return false;
        }
        Type ft = this.getAbsentType(type);
        return ft != null && ft.isExactlyNothing();
    }

    public Type getSetElementType(Type type) {
        Type st = type.getSupertype(this.getSetDeclaration());
        if (st != null && st.getTypeArguments().size() == 1) {
            return st.getTypeArgumentList().get(0);
        }
        return null;
    }

    public Type getSequentialElementType(Type type) {
        Interface sd = this.getSequentialDeclaration();
        Type st = type.getSupertype(sd);
        if (st != null && st.getTypeArguments().size() == 1) {
            Type et = st.getTypeArgumentList().get(0);
            if (type.isTuple() && et.isUnion()) {
                Unit unit = et.getDeclaration().getUnit();
                ArrayList<Type> types = new ArrayList<Type>();
                for (Type ct : et.getCaseTypes()) {
                    ModelUtil.addToUnion(types, ct);
                }
                return ModelUtil.union(types, unit).getType();
            }
            return et;
        }
        return null;
    }

    public Type getDefiniteType(Type pt) {
        return ModelUtil.intersectionType(this.getObjectType(), pt, this);
    }

    public Type getNonemptyType(Type pt) {
        Type st = ModelUtil.appliedType((TypeDeclaration)this.getSequenceDeclaration(), this.getSequentialElementType(pt));
        return ModelUtil.intersectionType(st, pt, this);
    }

    public Type getNonemptyDefiniteType(Type pt) {
        return this.getNonemptyType(this.getDefiniteType(pt));
    }

    public Type getElementType(Type expressionType) {
        Type it = this.getIteratedType(expressionType);
        if (it == null) {
            it = this.getJavaIteratedType(expressionType);
        }
        if (it == null) {
            it = this.getJavaArrayElementType(expressionType);
        }
        return it;
    }

    public boolean isContainerType(Type t) {
        return this.isIterableType(t) || this.isJavaIterableType(t) || this.isJavaObjectArrayType(t) || this.isJavaPrimitiveArrayType(t);
    }

    public boolean isIterableType(Type pt) {
        return pt.getDeclaration().inherits(this.getIterableDeclaration());
    }

    public boolean isJavaIterableType(Type pt) {
        return pt.getDeclaration().inherits(this.getJavaIterableDeclaration());
    }

    public boolean isJavaObjectArrayType(Type pt) {
        TypeDeclaration dec = pt.resolveAliases().getDeclaration();
        if (dec instanceof Constructor) {
            dec = dec.getExtendedType().getDeclaration();
        }
        return dec instanceof Class && dec.equals(this.getJavaObjectArrayDeclaration());
    }

    public boolean isJavaPrimitiveArrayType(Type pt) {
        TypeDeclaration dec = pt.resolveAliases().getDeclaration();
        if (dec instanceof Constructor) {
            dec = dec.getExtendedType().getDeclaration();
        }
        return dec instanceof Class && (dec.equals(this.getJavaIntArrayDeclaration()) || dec.equals(this.getJavaShortArrayDeclaration()) || dec.equals(this.getJavaLongArrayDeclaration()) || dec.equals(this.getJavaByteArrayDeclaration()) || dec.equals(this.getJavaCharArrayDeclaration()) || dec.equals(this.getJavaBooleanArrayDeclaration()) || dec.equals(this.getJavaFloatArrayDeclaration()) || dec.equals(this.getJavaDoubleArrayDeclaration()));
    }

    public boolean isJavaArrayType(Type pt) {
        return this.isJavaObjectArrayType(pt) || this.isJavaPrimitiveArrayType(pt);
    }

    public boolean isUsableType(Type pt) {
        return pt.getDeclaration().inherits(this.getUsableDeclaration());
    }

    public boolean isEntryType(Type pt) {
        return pt.getDeclaration().inherits(this.getEntryDeclaration());
    }

    public boolean isSequentialType(Type pt) {
        return pt.getDeclaration().isSequentialType();
    }

    public boolean isSequenceType(Type pt) {
        return pt.getDeclaration().isSequenceType();
    }

    public boolean isEmptyType(Type pt) {
        return pt.getDeclaration().isEmptyType();
    }

    public boolean isTupleType(Type pt) {
        return pt.getDeclaration().isTupleType();
    }

    public boolean isOptionalType(Type pt) {
        return !ModelUtil.intersectionType(this.getNullType(), pt, this).isNothing() && !ModelUtil.intersectionType(this.getObjectType(), pt, this).isNothing();
    }

    public boolean isPossiblyEmptyType(Type pt) {
        return this.isSequentialType(this.getDefiniteType(pt)) && !ModelUtil.intersectionType(this.getEmptyType(), pt, this).isNothing() && !ModelUtil.intersectionType(this.getSequentialBottomType(), pt, this).isNothing();
    }

    public Type getSequentialBottomType() {
        return this.getSequentialType(this.getNothingType());
    }

    public boolean isCallableType(Type pt) {
        return pt != null && pt.getDeclaration().inherits(this.getCallableDeclaration());
    }

    @Override
    public NothingType getNothingDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getNothingDeclaration();
        }
        return null;
    }

    public Type denotableType(Type type) {
        if (type != null) {
            TypeDeclaration ed;
            if (type.isUnion()) {
                List<Type> cts = type.getCaseTypes();
                ArrayList<Type> list = new ArrayList<Type>(cts.size() + 1);
                for (Type ct : cts) {
                    ModelUtil.addToUnion(list, this.denotableType(ct));
                }
                return ModelUtil.union(list, this);
            }
            if (type.isIntersection()) {
                List<Type> sts = type.getSatisfiedTypes();
                ArrayList<Type> list = new ArrayList<Type>(sts.size() + 1);
                for (Type st : sts) {
                    ModelUtil.addToIntersection(list, this.denotableType(st), this);
                }
                return ModelUtil.canonicalIntersection(list, this);
            }
            TypeDeclaration dec = type.getDeclaration();
            Type et = dec.getExtendedType();
            TypeDeclaration typeDeclaration = ed = et == null ? null : et.getDeclaration();
            if (dec.isOverloaded()) {
                type = type.getSupertype(ed);
            }
            if (dec instanceof Constructor) {
                return type.getSupertype(ed);
            }
            if (dec instanceof Class && dec.isAnonymous()) {
                List<Type> sts = dec.getSatisfiedTypes();
                ArrayList<Type> list = new ArrayList<Type>(sts.size() + 1);
                if (et != null) {
                    TypeDeclaration etd = et.getDeclaration();
                    ModelUtil.addToIntersection(list, type.getSupertype(etd), this);
                }
                for (Type st : sts) {
                    if (st == null) continue;
                    TypeDeclaration std = st.getDeclaration();
                    ModelUtil.addToIntersection(list, type.getSupertype(std), this);
                }
                return ModelUtil.canonicalIntersection(list, this);
            }
            List<Type> typeArgList = type.getTypeArgumentList();
            if (typeArgList.isEmpty()) {
                return type;
            }
            dec = type.getDeclaration();
            List<TypeParameter> typeParamList = dec.getTypeParameters();
            ArrayList<Type> typeArguments = new ArrayList<Type>(typeArgList.size());
            for (int i = 0; i < typeParamList.size() && i < typeArgList.size(); ++i) {
                Type at = typeArgList.get(i);
                TypeParameter tp = typeParamList.get(i);
                typeArguments.add(tp.isCovariant() ? this.denotableType(at) : at);
            }
            Type qt = type.getQualifyingType();
            Type dt = dec.appliedType(qt, typeArguments);
            dt.setVarianceOverrides(type.getVarianceOverrides());
            dt.setTypeConstructor(type.isTypeConstructor());
            dt.setTypeConstructorParameter(type.getTypeConstructorParameter());
            if (dt.isCached()) {
                dt = dt.clone();
            }
            dt.setUnderlyingType(type.getUnderlyingType());
            dt.setRaw(type.isRaw());
            return dt;
        }
        return null;
    }

    public Type nonemptyArgs(Type args) {
        return this.getEmptyType().isSubtypeOf(args) ? this.getNonemptyType(args) : args;
    }

    public boolean isHomogeneousTuple(Type args) {
        if (args != null) {
            Class td = this.getTupleDeclaration();
            Type tuple = args.getSupertype(td);
            if (tuple != null) {
                List<Type> tal = tuple.getTypeArgumentList();
                if (tal.size() < 3) {
                    return false;
                }
                Type elemType = tal.get(0);
                Type emptyType = this.getEmptyType();
                while ((tal = tuple.getTypeArgumentList()).size() >= 3) {
                    Type first = tal.get(1);
                    if (first == null) {
                        return false;
                    }
                    if (!first.isExactly(elemType)) {
                        return false;
                    }
                    Type rest = tal.get(2);
                    if (rest == null) {
                        return false;
                    }
                    if (rest.isExactly(emptyType)) {
                        return true;
                    }
                    tuple = rest.getSupertype(td);
                    if (tuple != null) continue;
                    return false;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public int getHomogeneousTupleLength(Type args) {
        if (args != null) {
            Class td = this.getTupleDeclaration();
            Type tuple = args.getSupertype(td);
            if (tuple != null) {
                block8: {
                    List<Type> tal = tuple.getTypeArgumentList();
                    if (tal.size() < 1) {
                        return -1;
                    }
                    Type elemType = tal.get(0);
                    int size = 0;
                    Type emptyType = this.getEmptyType();
                    while (true) {
                        ++size;
                        tal = tuple.getTypeArgumentList();
                        if (tal.size() < 3) break block8;
                        Type first = tal.get(1);
                        if (first == null) {
                            return -1;
                        }
                        if (!first.isExactly(elemType)) {
                            return -1;
                        }
                        Type rest = tal.get(2);
                        if (rest == null) {
                            return -1;
                        }
                        if (rest.isExactly(emptyType)) {
                            return size;
                        }
                        if (!rest.isTuple()) break;
                        tuple = rest;
                    }
                    return -1;
                }
                return -1;
            }
            return -1;
        }
        return -1;
    }

    public List<Type> getTupleElementTypes(Type args) {
        if (args != null) {
            if (this.isEmptyType(args)) {
                return ModelUtil.NO_TYPE_ARGS;
            }
            Class td = this.getTupleDeclaration();
            Type tuple = this.nonemptyArgs(args).getSupertype(td);
            if (tuple != null) {
                List<Type> tal;
                LinkedList<Type> result = new LinkedList<Type>();
                while ((tal = tuple.getTypeArgumentList()).size() >= 3) {
                    Type first = tal.get(1);
                    if (first == null) {
                        first = this.getUnknownType();
                    }
                    result.add(first);
                    Type rest = tal.get(2);
                    if (rest == null) {
                        result.add(this.getUnknownType());
                        return result;
                    }
                    if (this.isEmptyType(rest)) {
                        return result;
                    }
                    tuple = this.nonemptyArgs(rest).getSupertype(td);
                    if (tuple != null) continue;
                    if (this.isSequentialType(rest)) {
                        result.add(rest);
                        return result;
                    }
                    result.add(this.getUnknownType());
                    return result;
                }
                result.add(this.getUnknownType());
                return result;
            }
            if (this.isSequentialType(args)) {
                return Unit.singleton(args);
            }
        }
        return Unit.singleton(this.getUnknownType());
    }

    private static List<Type> singleton(Type pt) {
        ArrayList<Type> result = new ArrayList<Type>(1);
        result.add(pt);
        return result;
    }

    public boolean isTupleLengthUnbounded(Type args) {
        if (args != null) {
            List<Type> tal;
            Type emptyType = this.getEmptyType();
            if (args.isSubtypeOf(emptyType)) {
                return false;
            }
            Class td = this.getTupleDeclaration();
            Type tst = this.nonemptyArgs(args).getSupertype(td);
            if (tst == null) {
                return true;
            }
            while ((tal = tst.getTypeArgumentList()).size() >= 3) {
                Type rest = tal.get(2);
                if (rest == null) {
                    return false;
                }
                if (rest.isSubtypeOf(emptyType)) {
                    return false;
                }
                tst = this.nonemptyArgs(rest).getSupertype(td);
                if (tst != null) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean isTupleVariantAtLeastOne(Type args) {
        if (args != null) {
            List<Type> tal;
            Type emptyType = this.getEmptyType();
            if (emptyType.isSubtypeOf(args)) {
                return false;
            }
            Class td = this.getTupleDeclaration();
            Type tuple = this.nonemptyArgs(args).getSupertype(td);
            if (tuple == null) {
                return this.isSequenceType(args);
            }
            while ((tal = tuple.getTypeArgumentList()).size() >= 3) {
                Type rest = tal.get(2);
                if (rest == null) {
                    return false;
                }
                if (emptyType.isSubtypeOf(rest)) {
                    return false;
                }
                if (this.isSequenceType(rest) && !this.isTupleType(args)) {
                    return true;
                }
                tuple = this.nonemptyArgs(rest).getSupertype(td);
                if (tuple != null) continue;
                return this.isSequenceType(args);
            }
            return false;
        }
        return false;
    }

    public int getTupleMinimumLength(Type args) {
        if (args != null) {
            int size;
            block5: {
                Type rest;
                Type emptyType = this.getEmptyType();
                if (emptyType.isSubtypeOf(args)) {
                    return 0;
                }
                Class td = this.getTupleDeclaration();
                Type tuple = this.nonemptyArgs(args).getSupertype(td);
                if (tuple == null) {
                    return this.isSequenceType(args) ? 1 : 0;
                }
                size = 0;
                do {
                    List<Type> tal = tuple.getTypeArgumentList();
                    ++size;
                    if (tal.size() < 3) break block5;
                    rest = tal.get(2);
                    if (rest == null) {
                        return size;
                    }
                    if (!emptyType.isSubtypeOf(rest)) continue;
                    return size;
                } while ((tuple = this.nonemptyArgs(rest).getSupertype(td)) != null);
                return this.isSequenceType(args) ? size + 1 : size;
            }
            return size;
        }
        return 0;
    }

    public int getTupleMaximumLength(Type args) {
        if (args != null) {
            int size;
            block5: {
                Type rest;
                Type emptyType = this.getEmptyType();
                if (args.isSubtypeOf(emptyType)) {
                    return 0;
                }
                Class td = this.getTupleDeclaration();
                Type tuple = this.nonemptyArgs(args).getSupertype(td);
                if (tuple == null) {
                    return Integer.MAX_VALUE;
                }
                size = 0;
                do {
                    List<Type> tal = tuple.getTypeArgumentList();
                    ++size;
                    if (tal.size() < 3) break block5;
                    rest = tal.get(2);
                    if (rest == null) {
                        return size;
                    }
                    if (!rest.isSubtypeOf(emptyType)) continue;
                    return size;
                } while ((tuple = this.nonemptyArgs(rest).getSupertype(td)) != null);
                return Integer.MAX_VALUE;
            }
            return size;
        }
        return Integer.MAX_VALUE;
    }

    public List<Type> getCallableArgumentTypes(Type t) {
        Type tuple = this.getCallableTuple(t);
        if (tuple == null) {
            return Collections.emptyList();
        }
        return this.getTupleElementTypes(tuple);
    }

    public Type getCallableTuple(Type t) {
        List<Type> typeArgs;
        if (t == null) {
            return null;
        }
        Interface cd = this.getCallableDeclaration();
        Type ct = t.getSupertype(cd);
        if (ct != null && (typeArgs = ct.getTypeArgumentList()).size() >= 2) {
            return typeArgs.get(1);
        }
        return null;
    }

    public Type getCallableReturnType(Type t) {
        List<Type> typeArgs;
        if (t == null) {
            return null;
        }
        if (t.isNothing()) {
            return t;
        }
        Interface cd = this.getCallableDeclaration();
        Type ct = t.getSupertype(cd);
        if (ct != null && (typeArgs = ct.getTypeArgumentList()).size() >= 1) {
            return typeArgs.get(0);
        }
        return null;
    }

    public boolean isIterableParameterType(Type t) {
        return t.getDeclaration().isIterable();
    }

    public TypeDeclaration getLanguageModuleModelTypeDeclaration(String name) {
        return (TypeDeclaration)this.getLanguageModuleModelDeclaration(name);
    }

    public TypeDeclaration getLanguageModuleDeclarationTypeDeclaration(String name) {
        return (TypeDeclaration)this.getLanguageModuleDeclarationDeclaration(name);
    }

    private void put(String modifier) {
        this.modifiers.put(modifier, modifier);
    }

    public Map<String, String> getModifiers() {
        return this.modifiers;
    }

    public Type getValueMetatype(TypedReference reference) {
        Type getType;
        Type qualifyingType;
        TypedDeclaration declaration = reference.getDeclaration();
        boolean variable = declaration.isVariable();
        Type setType = this.getNothingType();
        Type type = qualifyingType = declaration.isStatic() ? this.getNullType() : reference.getQualifyingType();
        if (declaration.getTypeDeclaration() instanceof Constructor) {
            getType = this.denotableType(reference.getType());
            if (qualifyingType != null) {
                qualifyingType = qualifyingType.getQualifyingType();
            }
        } else {
            getType = reference.getType();
            if (variable) {
                setType = getType;
            }
        }
        if (qualifyingType != null) {
            TypeDeclaration ad = this.getLanguageModuleModelTypeDeclaration("Attribute");
            return ModelUtil.appliedType(ad, qualifyingType, getType, setType);
        }
        TypeDeclaration vd = this.getLanguageModuleModelTypeDeclaration("Value");
        return ModelUtil.appliedType(vd, getType, setType);
    }

    public Type getFunctionMetatype(TypedReference reference) {
        Type qualifyingType;
        TypedDeclaration declaration = reference.getDeclaration();
        Functional fun = (Functional)((Object)declaration);
        if (fun.getParameterLists().isEmpty()) {
            return null;
        }
        ParameterList fpl = fun.getFirstParameterList();
        List<Parameter> params = fpl.getParameters();
        Type parameterTuple = this.getParameterTypesAsTupleType(params, reference);
        Type fullType = reference.getFullType();
        Type returnType = this.getCallableReturnType(fullType);
        if (returnType == null) {
            return null;
        }
        Type type = qualifyingType = declaration.isStatic() ? this.getNullType() : reference.getQualifyingType();
        if (qualifyingType != null) {
            TypeDeclaration md = this.getLanguageModuleModelTypeDeclaration("Method");
            return ModelUtil.appliedType(md, qualifyingType, returnType, parameterTuple);
        }
        TypeDeclaration fd = this.getLanguageModuleModelTypeDeclaration("Function");
        return ModelUtil.appliedType(fd, returnType, parameterTuple);
    }

    public Type getConstructorMetatype(TypedReference reference) {
        TypeDeclaration d = reference.getDeclaration().getTypeDeclaration();
        if (d == null) {
            return null;
        }
        return this.getConstructorMetatype(reference, d);
    }

    public Type getConstructorMetatype(Type type) {
        TypeDeclaration d = type.getDeclaration();
        if (d == null) {
            return null;
        }
        return this.getConstructorMetatype(type, d);
    }

    private Type getConstructorMetatype(Reference reference, TypeDeclaration d) {
        Type fullType;
        Type returnType;
        Functional f = (Functional)((Object)d);
        ParameterList fpl = f.getFirstParameterList();
        if (fpl == null) {
            return null;
        }
        List<Parameter> params = fpl.getParameters();
        Type parameterTuple = this.getNothingType();
        Scope scope = d.getContainer();
        if (scope instanceof Class) {
            Class c = (Class)scope;
            parameterTuple = c.isClassOrInterfaceMember() || c.isToplevel() ? this.getParameterTypesAsTupleType(params, reference) : this.getNothingType();
        }
        if ((returnType = this.denotableType(this.getCallableReturnType(fullType = reference.getFullType()))) == null) {
            return null;
        }
        Type qualifyingType = reference.getQualifyingType();
        if (qualifyingType != null && qualifyingType.getDeclaration().isClassOrInterfaceMember()) {
            Type qqt = qualifyingType.getQualifyingType();
            TypeDeclaration mccd = this.getLanguageModuleModelTypeDeclaration("MemberClassCallableConstructor");
            return ModelUtil.appliedType(mccd, qqt, returnType, parameterTuple);
        }
        TypeDeclaration cd = this.getLanguageModuleModelTypeDeclaration("CallableConstructor");
        return ModelUtil.appliedType(cd, returnType, parameterTuple);
    }

    public Type getValueConstructorMetatype(Reference reference) {
        Type fullType = reference.getFullType();
        Type returnType = fullType;
        if (returnType == null) {
            return null;
        }
        Type qualifyingType = reference.getQualifyingType();
        if (qualifyingType != null && qualifyingType.getDeclaration().isClassOrInterfaceMember()) {
            Type qqt = qualifyingType.getQualifyingType();
            TypeDeclaration mccd = this.getLanguageModuleModelTypeDeclaration("MemberClassValueConstructor");
            return ModelUtil.appliedType(mccd, qqt, returnType);
        }
        TypeDeclaration cd = this.getLanguageModuleModelTypeDeclaration("ValueConstructor");
        return ModelUtil.appliedType(cd, returnType);
    }

    public Type getClassMetatype(Type type) {
        Type qualifyingType;
        Type parameterTuple;
        Class declaration = (Class)type.getDeclaration();
        ParameterList parameterList = declaration.getParameterList();
        Constructor dc = declaration.getDefaultConstructor();
        if (!(!declaration.isClassOrInterfaceMember() && !declaration.isToplevel() || parameterList == null || declaration.isAbstraction() || declaration.isSealed() && !this.inSameModule(declaration) || declaration.isAbstract() || dc != null && !dc.isShared())) {
            List<Parameter> params = parameterList.getParameters();
            parameterTuple = this.getParameterTypesAsTupleType(params, type);
        } else {
            parameterTuple = this.getNothingType();
        }
        Type type2 = qualifyingType = declaration.isStatic() ? this.getNullType() : type.getQualifyingType();
        if (qualifyingType != null) {
            TypeDeclaration mcd = this.getLanguageModuleModelTypeDeclaration("MemberClass");
            return ModelUtil.appliedType(mcd, qualifyingType, type, parameterTuple);
        }
        TypeDeclaration cd = this.getLanguageModuleModelTypeDeclaration("Class");
        return ModelUtil.appliedType(cd, type, parameterTuple);
    }

    public boolean inSameModule(Declaration declaration) {
        Module module = this.getPackage().getModule();
        Module otherModule = declaration.getUnit().getPackage().getModule();
        return module.equals(otherModule);
    }

    public Type getInterfaceMetatype(Type type) {
        Type qualifyingType;
        Interface declaration = (Interface)type.getDeclaration();
        Type type2 = qualifyingType = declaration.isStatic() ? this.getNullType() : type.getQualifyingType();
        if (qualifyingType != null) {
            TypeDeclaration mid = this.getLanguageModuleModelTypeDeclaration("MemberInterface");
            return ModelUtil.appliedType(mid, qualifyingType, type);
        }
        TypeDeclaration id = this.getLanguageModuleModelTypeDeclaration("Interface");
        return ModelUtil.appliedType(id, type);
    }

    public Type getTypeMetaType(Type type) {
        if (type.isUnion()) {
            TypeDeclaration utd = this.getLanguageModuleModelTypeDeclaration("UnionType");
            return ModelUtil.appliedType(utd, type);
        }
        if (type.isIntersection()) {
            TypeDeclaration itd = this.getLanguageModuleModelTypeDeclaration("IntersectionType");
            return ModelUtil.appliedType(itd, type);
        }
        TypeDeclaration td = this.getLanguageModuleModelTypeDeclaration("Type");
        return ModelUtil.appliedType(td, type);
    }

    public Type getParameterTypesAsTupleType(List<Parameter> params, Reference reference) {
        ArrayList<Type> paramTypes = new ArrayList<Type>(params.size());
        int max = params.size() - 1;
        int firstDefaulted = -1;
        boolean sequenced = false;
        boolean atLeastOne = false;
        for (int i = 0; i <= max; ++i) {
            Type fullType;
            Parameter p = params.get(i);
            if (p.getModel() == null) {
                fullType = this.getUnknownType();
            } else {
                fullType = reference == null ? p.getModel().getReference().getFullType() : reference.getTypedParameter(p).getFullType();
                if (firstDefaulted < 0 && p.isDefaulted()) {
                    firstDefaulted = i;
                }
                if (i == max && p.isSequenced()) {
                    sequenced = true;
                    atLeastOne = p.isAtLeastOne();
                    if (fullType != null) {
                        fullType = this.getIteratedType(fullType);
                    }
                }
            }
            paramTypes.add(fullType);
        }
        return this.getTupleType(paramTypes, sequenced, atLeastOne, firstDefaulted);
    }

    public Type getTailType(Type sequenceType, int fixedLength) {
        int i = 0;
        Type tail = sequenceType;
        while (i++ < fixedLength && tail != null) {
            if (this.isTupleType(tail)) {
                List<Type> list = tail.getTypeArgumentList();
                if (list.size() >= 3) {
                    tail = list.get(2);
                    continue;
                }
                tail = null;
                continue;
            }
            tail = null;
        }
        return tail;
    }

    public Type getType(TypeDeclaration td) {
        return td == null ? this.getUnknownType() : td.getType();
    }

    public Type getPackageDeclarationType() {
        return this.getType(this.getLanguageModuleDeclarationTypeDeclaration("Package"));
    }

    public Type getModuleDeclarationType() {
        return this.getType(this.getLanguageModuleDeclarationTypeDeclaration("Module"));
    }

    public Type getImportDeclarationType() {
        return this.getType(this.getLanguageModuleDeclarationTypeDeclaration("Import"));
    }

    public Type getClassDeclarationType() {
        return this.getType(this.getLanguageModuleDeclarationTypeDeclaration("ClassDeclaration"));
    }

    public Type getClassOrInterfaceDeclarationType() {
        return this.getType(this.getLanguageModuleDeclarationTypeDeclaration("ClassOrInterfaceDeclaration"));
    }

    public TypeDeclaration getClassOrInterfaceModelDeclaration() {
        return this.getLanguageModuleModelTypeDeclaration("ClassOrInterface");
    }

    public Type getClassOrInterfaceModelType(Type classType) {
        TypeDeclaration decl = this.getClassOrInterfaceModelDeclaration();
        if (decl == null) {
            return null;
        }
        return decl.appliedType(null, Arrays.asList(classType));
    }

    public Type getClassDeclarationType(Class clazz) {
        return clazz.hasConstructors() || clazz.hasEnumerated() || clazz.isAnonymous() ? this.getType(this.getLanguageModuleDeclarationTypeDeclaration("ClassWithConstructorsDeclaration")) : this.getType(this.getLanguageModuleDeclarationTypeDeclaration("ClassWithInitializerDeclaration"));
    }

    public Type getConstructorDeclarationType() {
        return this.getType(this.getLanguageModuleDeclarationTypeDeclaration("ConstructorDeclaration"));
    }

    public Type getCallableConstructorDeclarationType() {
        return this.getType(this.getLanguageModuleDeclarationTypeDeclaration("CallableConstructorDeclaration"));
    }

    public Type getValueConstructorDeclarationType() {
        return this.getType(this.getLanguageModuleDeclarationTypeDeclaration("ValueConstructorDeclaration"));
    }

    public Type getInterfaceDeclarationType() {
        return this.getType(this.getLanguageModuleDeclarationTypeDeclaration("InterfaceDeclaration"));
    }

    public Type getAliasDeclarationType() {
        return this.getType(this.getLanguageModuleDeclarationTypeDeclaration("AliasDeclaration"));
    }

    public Type getTypeParameterDeclarationType() {
        return this.getType(this.getLanguageModuleDeclarationTypeDeclaration("TypeParameter"));
    }

    public Type getFunctionDeclarationType() {
        return this.getType(this.getLanguageModuleDeclarationTypeDeclaration("FunctionDeclaration"));
    }

    public Type getValueDeclarationType() {
        return this.getType(this.getLanguageModuleDeclarationTypeDeclaration("ValueDeclaration"));
    }

    @Override
    public TypeDeclaration getAnnotationDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getAnnotationDeclaration();
        }
        return null;
    }

    @Override
    public TypeDeclaration getConstrainedAnnotationDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getConstrainedAnnotationDeclaration();
        }
        return null;
    }

    @Override
    public TypeDeclaration getSequencedAnnotationDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getSequencedAnnotationDeclaration();
        }
        return null;
    }

    @Override
    public TypeDeclaration getOptionalAnnotationDeclaration() {
        Module theLanguageModule = this.getLanguageModule();
        if (theLanguageModule != null) {
            return theLanguageModule.getLanguageModuleCache().getOptionalAnnotationDeclaration();
        }
        return null;
    }

    public TypeDeclaration getDeclarationDeclaration() {
        return this.getLanguageModuleDeclarationTypeDeclaration("Declaration");
    }

    public TypeCache getCache() {
        Module module = this.getPackage().getModule();
        return module != null ? module.getCache() : null;
    }

    public Backends getSupportedBackends() {
        return this.supportedBackends;
    }

    public void setSupportedBackends(Backends backends) {
        this.supportedBackends = backends;
    }

    public void setUnresolvedReferences() {
        this.unresolvedReferences = true;
    }

    public boolean getUnresolvedReferences() {
        return this.unresolvedReferences;
    }

    public boolean isJdkPackage(String name) {
        return false;
    }

    public boolean isUnknownArgumentsCallable(Type callableType) {
        if (callableType == null) {
            return true;
        }
        if (this.getNothingType().isExactly(callableType)) {
            return false;
        }
        Type args = this.getCallableTuple(callableType);
        return this.isUnknownTuple(args);
    }

    private boolean isUnknownTuple(Type args) {
        if (args == null) {
            return true;
        }
        if (args.isTypeParameter()) {
            return true;
        }
        if (args.isUnion()) {
            List<Type> caseTypes = args.getCaseTypes();
            if (caseTypes == null || caseTypes.size() < 2) {
                return true;
            }
            for (int ii = 0; ii < caseTypes.size(); ++ii) {
                if (this.isUnknownTuple(caseTypes.get(ii))) continue;
                return false;
            }
            return true;
        }
        if (args.isIntersection()) {
            List<Type> caseTypes = args.getSatisfiedTypes();
            if (caseTypes == null || caseTypes.size() < 2) {
                return true;
            }
            for (int ii = 0; ii < caseTypes.size(); ++ii) {
                if (!this.isUnknownTuple(caseTypes.get(ii))) continue;
                return true;
            }
            return false;
        }
        if (args.isNothing()) {
            return true;
        }
        if (args.isClassOrInterface()) {
            TypeDeclaration declaration = args.getDeclaration();
            if (declaration.isTuple()) {
                Type rest = args.getTypeArgumentList().get(2);
                return this.isUnknownTuple(rest);
            }
            if (declaration.isEmpty()) {
                return false;
            }
            if (declaration.isSequential() || declaration.isSequence()) {
                return false;
            }
        } else if (args.isTypeAlias()) {
            return this.isUnknownTuple(args.resolveAliases());
        }
        return true;
    }
}

