/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.module.loader;

import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.api.OverridesRuntimeResolver;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.ceylon.loader.BaseModuleLoaderImpl;
import com.redhat.ceylon.cmr.ceylon.loader.ModuleGraph;
import com.redhat.ceylon.cmr.ceylon.loader.ModuleNotFoundException;
import com.redhat.ceylon.compiler.java.runtime.metamodel.Metamodel;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.ModuleScope;
import java.util.Map;

public abstract class BaseRuntimeModuleLoaderImpl
extends BaseModuleLoaderImpl {
    public BaseRuntimeModuleLoaderImpl() {
        super(null, null);
    }

    public BaseRuntimeModuleLoaderImpl(RepositoryManager repoManager, ClassLoader delegateClassLoader) {
        super(repoManager, delegateClassLoader);
    }

    public BaseRuntimeModuleLoaderImpl(RepositoryManager repositoryManager, ClassLoader delegateClassLoader, Map<String, String> extraModules, boolean verbose) {
        super(repositoryManager, delegateClassLoader, extraModules, verbose);
    }

    protected abstract class RuntimeModuleLoaderContext
    extends BaseModuleLoaderImpl.ModuleLoaderContext {
        private final String[] artifactSuffixes;

        @Override
        protected String[] getArtifactSuffixes() {
            return this.artifactSuffixes;
        }

        protected RuntimeModuleLoaderContext(String module, String version2, ModuleScope lookupScope) throws ModuleNotFoundException {
            super(BaseRuntimeModuleLoaderImpl.this, module, version2, lookupScope);
            this.artifactSuffixes = new String[]{".car", ".jar"};
        }

        protected void initialiseMetamodel() {
            Overrides overrides = BaseRuntimeModuleLoaderImpl.this.repositoryManager.getOverrides();
            Metamodel.resetModuleManager(new OverridesRuntimeResolver(overrides));
            this.moduleGraph.visit(new ModuleGraph.Visitor(){

                @Override
                public void visit(ModuleGraph.Module module) {
                    RuntimeModuleLoaderContext.this.registerInMetamodel(module);
                }
            });
        }

        private void registerInMetamodel(ModuleGraph.Module module) {
            if (BaseRuntimeModuleLoaderImpl.this.jdkProvider.isJDKModule(module.name)) {
                return;
            }
            ArtifactResult dependencyArtifact = module.artifact;
            if (dependencyArtifact != null) {
                ClassLoader dependencyClassLoader = module.inCurrentClassLoader ? BaseRuntimeModuleLoaderImpl.this.delegateClassLoader : this.moduleClassLoader;
                this.registerInMetamodel(dependencyArtifact, dependencyClassLoader);
            }
        }

        private void registerInMetamodel(ArtifactResult artifact, ClassLoader classLoader) {
            if (BaseRuntimeModuleLoaderImpl.this.verbose) {
                BaseRuntimeModuleLoaderImpl.this.log("Registering " + artifact.name() + "/" + artifact.version() + " in metamodel");
            }
            Metamodel.loadModule(artifact.name(), artifact.version(), artifact, classLoader);
        }
    }
}

