/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.module.loader;

import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.ceylon.loader.BaseModuleLoaderImpl;
import com.redhat.ceylon.cmr.ceylon.loader.ModuleGraph;
import com.redhat.ceylon.cmr.ceylon.loader.ModuleNotFoundException;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.ModuleScope;
import com.redhat.ceylon.model.cmr.RepositoryException;
import com.redhat.ceylon.module.loader.BaseRuntimeModuleLoaderImpl;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Map;

public class FlatpathModuleLoader
extends BaseRuntimeModuleLoaderImpl {
    public FlatpathModuleLoader() {
        this(null, null);
    }

    public FlatpathModuleLoader(RepositoryManager repoManager, ClassLoader delegateClassLoader) {
        this(repoManager, delegateClassLoader, null, false);
    }

    public FlatpathModuleLoader(RepositoryManager repositoryManager, ClassLoader delegateClassLoader, Map<String, String> extraModules, boolean verbose) {
        super(repositoryManager, delegateClassLoader, extraModules, verbose);
    }

    @Override
    protected BaseModuleLoaderImpl.ModuleLoaderContext createModuleLoaderContext(String name, String version2, ModuleScope lookupScope) throws ModuleNotFoundException {
        return new FlatpathModuleLoaderContext(name, version2, lookupScope);
    }

    class FlatpathModuleLoaderContext
    extends BaseRuntimeModuleLoaderImpl.RuntimeModuleLoaderContext {
        FlatpathModuleLoaderContext(String module, String version2, ModuleScope lookupScope) throws ModuleNotFoundException {
            super(module, version2, lookupScope);
        }

        @Override
        protected void initialise() throws ModuleNotFoundException {
            this.preloadModules();
            this.moduleClassLoader = this.setupClassLoader();
            this.initialiseMetamodel();
        }

        private ClassLoader setupClassLoader() {
            ModuleGraph.Module loadedModule = this.moduleGraph.findModule(this.module);
            if (loadedModule.inCurrentClassLoader) {
                return FlatpathModuleLoader.this.delegateClassLoader;
            }
            return this.makeModuleClassLoader();
        }

        private ClassLoader makeModuleClassLoader() {
            final HashSet modulesNotInCurrentClassLoader = new HashSet();
            this.moduleGraph.visit(new ModuleGraph.Visitor(){

                @Override
                public void visit(ModuleGraph.Module module) {
                    if (!module.inCurrentClassLoader && module.artifact != null) {
                        modulesNotInCurrentClassLoader.add(module);
                    }
                }
            });
            URL[] urls = new URL[modulesNotInCurrentClassLoader.size()];
            if (FlatpathModuleLoader.this.verbose) {
                FlatpathModuleLoader.this.log("Making classpath with " + urls.length + " jars");
            }
            int i = 0;
            for (ModuleGraph.Module module : modulesNotInCurrentClassLoader) {
                ArtifactResult artifact = module.artifact;
                try {
                    URL url = artifact.artifact().toURL();
                    if (FlatpathModuleLoader.this.verbose) {
                        FlatpathModuleLoader.this.log(" cp[" + i + "] = " + url);
                    }
                    urls[i++] = url;
                }
                catch (RepositoryException | MalformedURLException e) {
                    throw new RuntimeException("Failed to get a URL for module file for " + module, e);
                }
            }
            return new URLClassLoader(urls, FlatpathModuleLoader.this.delegateClassLoader);
        }
    }
}

