/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.tools.antdoc;

import com.github.rjeschke.txtmark.BlockEmitter;
import com.github.rjeschke.txtmark.Configuration;
import com.github.rjeschke.txtmark.Processor;
import com.redhat.ceylon.common.tool.CeylonBaseTool;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.Hidden;
import com.redhat.ceylon.common.tool.OptionArgument;
import com.redhat.ceylon.common.tool.OptionModel;
import com.redhat.ceylon.common.tool.Summary;
import com.redhat.ceylon.common.tool.Tool;
import com.redhat.ceylon.common.tool.ToolModel;
import com.redhat.ceylon.common.tools.CeylonToolLoader;
import com.redhat.ceylon.common.tools.help.DocBuilder;
import com.redhat.ceylon.launcher.LauncherUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeMap;

@Hidden
@Summary(value="A tool generates documentation about the Ceylon ant tasks")
@Description(value="")
public class CeylonAntTaskDocTool
extends CeylonBaseTool {
    private static final String DEFAULT_TOOLS_URL = "../ceylon/subcommands";
    private final Class<? extends Annotation> OPTION_EQUIV_ANNOTATION;
    private final Class<? extends Annotation> REQUIRED_ANNOTATION;
    private final Class<? extends Annotation> TOOL_EQUIV_ANNOTATION;
    private final Class<? extends Annotation> DOC_ANNOTATION;
    private final Class<? extends Annotation> IGNORE_ANNOTATION;
    private final Class<? extends Annotation> ATTRIBUTE_ANNOTATION;
    private static final String NL = System.lineSeparator();
    private final CeylonToolLoader toolLoader = new CeylonToolLoader();
    private final ToolModel<Tool> rootToolModel = this.toolLoader.loadToolModel("");
    private final URLClassLoader loader;
    private Class<?> antTaskClass;
    private String toolsUrl = "../ceylon/subcommands";

    public CeylonAntTaskDocTool() {
        try {
            File module = new File(LauncherUtil.determineHome(), "lib/ceylon-ant.jar");
            File antJar = new File("/home/tom/apache-ant-1.8.2/lib/ant.jar");
            System.err.println(module.getAbsolutePath() + " " + module.exists());
            System.err.println(antJar.getAbsolutePath() + " " + antJar.exists());
            this.loader = new URLClassLoader(new URL[]{module.toURI().toURL(), antJar.toURI().toURL()}, null);
            this.antTaskClass = Class.forName("org.apache.tools.ant.Task", false, this.loader);
            this.OPTION_EQUIV_ANNOTATION = Class.forName("com.redhat.ceylon.ant.OptionEquivalent", false, this.loader);
            this.REQUIRED_ANNOTATION = Class.forName("com.redhat.ceylon.ant.Required", false, this.loader);
            this.TOOL_EQUIV_ANNOTATION = Class.forName("com.redhat.ceylon.ant.ToolEquivalent", false, this.loader);
            this.DOC_ANNOTATION = Class.forName("com.redhat.ceylon.ant.AntDoc", false, this.loader);
            this.IGNORE_ANNOTATION = Class.forName("com.redhat.ceylon.ant.AntDocIgnore", false, this.loader);
            this.ATTRIBUTE_ANNOTATION = Class.forName("com.redhat.ceylon.ant.AntAttribute", false, this.loader);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Description(value="URL at which the ceylon tool documentation is available (default: ../ceylon/subcommands)")
    @OptionArgument
    public void setToolsUrl(String toolsUrl) {
        this.toolsUrl = toolsUrl;
    }

    protected String getAnnotationStringValue(Class<? extends Annotation> annotation, AnnotatedElement element) {
        return this.getAnnotationStringValue(annotation, element, "value");
    }

    protected String getAnnotationStringValue(Class<? extends Annotation> annotation, AnnotatedElement element, String name) {
        Annotation a = element.getAnnotation(annotation);
        if (a != null) {
            try {
                return (String)a.annotationType().getMethod(name, new Class[0]).invoke((Object)a, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    protected Boolean getAnnotationBooleanValue(Class<? extends Annotation> annotation, AnnotatedElement element, String name) {
        Annotation a = element.getAnnotation(annotation);
        if (a != null) {
            try {
                return (Boolean)a.annotationType().getMethod(name, new Class[0]).invoke((Object)a, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public void documentTask(Appendable out, Class<?> taskClass) {
        try {
            String taskName = this.getTaskName(taskClass);
            this.docClass(out, taskName, taskClass);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getTaskName(Class<?> taskClass) {
        String taskName = taskClass.getSimpleName();
        taskName = taskName.replaceAll("^Ceylon", "");
        taskName = taskName.replaceAll("AntTask$", "");
        taskName = taskName.replaceAll("Task$", "");
        taskName = "ceylon-" + this.camelCaseToDashes(taskName.substring(0, 1).toLowerCase(Locale.ENGLISH) + taskName.substring(1));
        return taskName;
    }

    private void docClass(Appendable out, String task, Class<?> taskClass) throws IOException {
        ToolModel<Tool> toolModel;
        String elementName = "<" + task + ">";
        out.append("---").append(NL);
        out.append("layout: ").append("reference12").append(NL);
        out.append("title_md: '`").append(elementName).append("` Ant task'").append(NL);
        out.append("tab: ").append("documentation").append(NL);
        out.append("unique_id: ").append("docspage").append(NL);
        out.append("doc_root: ").append("../../..").append(NL);
        out.append("gh_editable: false").append(NL);
        out.append("---").append(NL);
        out.append(NL);
        out.append("<!-- this file was auto-generated by " + this.getClass().getName() + " -->").append(NL);
        out.append(NL);
        out.append("# #{page.title_md}").append(NL);
        out.append(NL);
        out.append("## Usage").append(NL);
        out.append(NL);
        out.append("**Note**: You must [declare the tasks with a `<typedef>`](../ant).").append(NL);
        out.append(NL);
        if (taskClass.isAnnotationPresent(this.DOC_ANNOTATION)) {
            out.append(this.getAnnotationStringValue(this.DOC_ANNOTATION, taskClass)).append(NL);
            out.append(NL);
        }
        out.append("## Description").append(NL);
        out.append(NL);
        String toolName = this.getAnnotationStringValue(this.TOOL_EQUIV_ANNOTATION, taskClass);
        if (toolName != null) {
            toolModel = this.toolLoader.loadToolModel(toolName);
            out.append(DocBuilder.getSummaryValue(toolModel)).append(NL);
            out.append(NL);
            out.append("The `").append(elementName).append("` ant task wraps the [`ceylon " + toolName + "`](" + this.getToolHref(toolName) + ") command.").append(NL);
            out.append(NL);
        } else {
            toolModel = null;
        }
        this.documentAttributes(out, taskClass, toolModel);
        this.documentNestedElements(out, taskClass, toolModel);
        out.append("## See also").append(NL);
        out.append(NL);
        out.append("* How to [declare the tasks with a `<typedef>`](../ant).").append(NL);
    }

    protected String getToolHref(String toolName) {
        if (toolName.isEmpty()) {
            return this.toolsUrl + "/ceylon.html";
        }
        return this.toolsUrl + "/ceylon-" + toolName + ".html";
    }

    protected String getToolOptionHref(String toolName, String longOption) {
        if (!longOption.startsWith("--")) {
            throw new IllegalArgumentException(longOption);
        }
        return this.getToolHref(toolName) + "#option" + longOption;
    }

    protected void documentNestedElements(Appendable out, Class<?> taskClass, ToolModel<Tool> toolModel) throws IOException {
        this.documentNestedElementsRecursive(3, new HashSet(), out, taskClass, toolModel);
    }

    protected void documentNestedElementsRecursive(int depth, Set<Class<?>> classes, Appendable out, Class<?> taskClass, ToolModel<Tool> toolModel) throws IOException {
        if (classes.contains(taskClass)) {
            return;
        }
        classes.add(taskClass);
        if (this.hasAdder(taskClass)) {
            out.append(NL);
            out.append("### Nested elements").append(NL);
            out.append(NL);
            TreeMap<Key, String> attrs = new TreeMap<Key, String>();
            for (Method method : taskClass.getMethods()) {
                if (!this.isDocumentableAdder(method)) continue;
                String elementName = this.getElementName(method);
                StringBuilder sb = new StringBuilder();
                if (method.getName().startsWith("add")) {
                    sb.append("#### `<").append(elementName).append(">`").append(NL);
                    sb.append(NL);
                    this.docElement(sb, toolModel, taskClass, method);
                    if (!method.getParameterTypes()[0].getPackage().getName().startsWith("org.apache.tools.ant")) {
                        this.documentNestedElementClass(depth, classes, sb, method, method.getParameterTypes()[0]);
                    }
                } else {
                    System.err.println("Different kind of adder " + method);
                }
                sb.append(NL);
                boolean required = this.isRequired(method);
                attrs.put(new Key(required, elementName), sb.toString());
            }
            for (String md : attrs.values()) {
                out.append(md);
            }
            out.append(NL);
        }
    }

    protected String getElementName(Method method) {
        String elementName = method.getName().replaceAll("^" + (method.getName().startsWith("addConfigured") ? "addConfigured" : "add"), "");
        elementName = elementName.substring(0, 1).toLowerCase(Locale.ENGLISH) + elementName.substring(1);
        return elementName;
    }

    protected void documentNestedElementClass(int depth, Set<Class<?>> classes, Appendable out, Method method, Class<?> elementClass) throws IOException {
        if (elementClass.isAnnotationPresent(this.DOC_ANNOTATION)) {
            out.append(this.getAnnotationStringValue(this.DOC_ANNOTATION, elementClass)).append(NL);
            out.append(NL);
        }
        if (this.hasSetters(elementClass)) {
            out.append("<table class=\"ant-elements\">").append(NL);
            out.append("<tbody>").append(NL);
            out.append("<tr>").append(NL);
            out.append("<th>Element</th>").append(NL);
            out.append("<th>Description</th>").append(NL);
            out.append("<th>Required</th>").append(NL);
            out.append("</tr>").append(NL);
            TreeMap<Key, String> attrs = new TreeMap<Key, String>();
            for (Method elementMethod : elementClass.getMethods()) {
                if (!this.isDocumentableSetter(elementClass, elementMethod)) continue;
                String attributeName = this.getAttributeName(elementMethod);
                StringBuilder sb = new StringBuilder();
                sb.append("<tr>").append(NL);
                sb.append("<td><code>").append(attributeName).append("</code></td>").append(NL);
                sb.append("<td>");
                if (elementMethod.isAnnotationPresent(this.DOC_ANNOTATION)) {
                    sb.append(this.markdown(this.getAnnotationStringValue(this.DOC_ANNOTATION, elementMethod)));
                } else {
                    sb.append("Not documented");
                    System.err.println("Not documented: " + elementMethod + " for nested element " + method);
                }
                sb.append("</td>").append(NL);
                boolean required = this.isRequired(elementMethod);
                sb.append("<td>").append(this.getRequiredText(elementMethod)).append("</td>").append(NL);
                sb.append("</tr>").append(NL);
                attrs.put(new Key(required, attributeName), sb.toString());
            }
            for (String md : attrs.values()) {
                out.append(md);
            }
            out.append("</tbody>").append(NL);
            out.append("</table>").append(NL);
        }
    }

    protected boolean hasAdder(Class<?> taskClass) {
        boolean hasAdders = false;
        for (Method method : taskClass.getMethods()) {
            if (!this.isDocumentableAdder(method)) continue;
            hasAdders = true;
            break;
        }
        return hasAdders;
    }

    protected void documentAttributes(Appendable out, Class<?> taskClass, ToolModel<Tool> toolModel) throws IOException {
        if (this.hasSetters(taskClass)) {
            out.append("### Attributes").append(NL);
            out.append(NL);
            out.append("<table class=\"ant-parameters\">").append(NL);
            out.append("<tbody>").append(NL);
            out.append("<tr>").append(NL);
            out.append("<th>Attribute</th>").append(NL);
            out.append("<th>Description</th>").append(NL);
            out.append("<th>Required</th>").append(NL);
            out.append("</tr>").append(NL);
            TreeMap<Key, String> attrs = new TreeMap<Key, String>();
            for (Method method : taskClass.getMethods()) {
                if (!this.isDocumentableSetter(taskClass, method)) continue;
                String attributeName = this.getAttributeName(method);
                StringBuilder sb = new StringBuilder();
                sb.append("<tr id=\"attribute-" + attributeName + "\">").append(NL);
                sb.append("<td><code>").append(attributeName).append("</code></td>").append(NL);
                sb.append("<td>");
                this.docElement(sb, toolModel, taskClass, method);
                sb.append("</td>").append(NL);
                boolean required = this.isRequired(method);
                sb.append("<td>").append(this.getRequiredText(method)).append("</td>").append(NL);
                sb.append("</tr>").append(NL);
                sb.append(NL);
                attrs.put(new Key(required, attributeName), sb.toString());
            }
            for (String md : attrs.values()) {
                out.append(md);
            }
            out.append("</tbody>").append(NL);
            out.append("</table>").append(NL);
        }
    }

    protected boolean isRequired(Method method) {
        String reqd = this.getAnnotationStringValue(this.REQUIRED_ANNOTATION, method);
        if (reqd == null) {
            return false;
        }
        return reqd.isEmpty() || reqd.toLowerCase(Locale.ENGLISH).startsWith("yes");
    }

    protected String getRequiredText(Method method) {
        String reqd = this.getAnnotationStringValue(this.REQUIRED_ANNOTATION, method);
        if (reqd == null) {
            if (this.isRequired(method)) {
                throw new RuntimeException();
            }
            return "No";
        }
        if (reqd.isEmpty()) {
            return "Yes";
        }
        return reqd;
    }

    String markdown(String md) {
        Configuration config = Configuration.builder().forceExtentedProfile().setCodeBlockEmitter(new BlockEmitter(){

            @Override
            public void emitBlock(StringBuilder out, List<String> lines, String meta) {
                if (lines.isEmpty()) {
                    return;
                }
                out.append("<!-- lang: none -->").append(NL);
                out.append("<pre><code>");
                for (String s : lines) {
                    block6: for (int i = 0; i < s.length(); ++i) {
                        char c = s.charAt(i);
                        switch (c) {
                            case '&': {
                                out.append("&amp;");
                                continue block6;
                            }
                            case '<': {
                                out.append("&lt;");
                                continue block6;
                            }
                            case '>': {
                                out.append("&gt;");
                                continue block6;
                            }
                            default: {
                                out.append(c);
                            }
                        }
                    }
                    out.append(NL);
                }
                out.append("</code></pre>\n");
            }
        }).build();
        return Processor.process(md, config);
    }

    protected void docElement(Appendable out, ToolModel<Tool> toolModel, Class<?> taskClass, Method method) throws IOException {
        String antDoc = this.getAnnotationStringValue(this.DOC_ANNOTATION, method);
        String option = this.getAnnotationStringValue(this.OPTION_EQUIV_ANNOTATION, method);
        StringBuilder sb = new StringBuilder();
        if (antDoc != null) {
            sb.append(antDoc).append(NL);
        }
        if (option != null) {
            if (option.isEmpty()) {
                option = this.isDocumentableSetter(taskClass, method) ? this.inferOptionNameFromSetter(method) : this.inferOptionNameFromAdder(method);
            }
            boolean found = false;
            if (toolModel == null) {
                System.err.println("@" + this.OPTION_EQUIV_ANNOTATION.getName() + " but no toolModel on " + method);
            } else {
                for (OptionModel<?> opt : toolModel.getOptions()) {
                    if (!("--" + opt.getLongName()).equals(option)) continue;
                    found = true;
                    if (this.getAnnotationBooleanValue(this.OPTION_EQUIV_ANNOTATION, method, "link").booleanValue()) {
                        sb.append("Equivalent to the [`--" + opt.getLongName() + "`](" + this.getToolOptionHref(toolModel.getName(), option) + ") command line option.").append(NL);
                    }
                    if (!this.getAnnotationBooleanValue(this.OPTION_EQUIV_ANNOTATION, method, "transclude").booleanValue()) break;
                    sb.append(DocBuilder.getOptionDescription(toolModel, opt)).append(NL);
                    break;
                }
            }
            if (!found) {
                for (OptionModel<?> opt : this.rootToolModel.getOptions()) {
                    if (!("--" + opt.getLongName()).equals(option)) continue;
                    found = true;
                    if (this.getAnnotationBooleanValue(this.OPTION_EQUIV_ANNOTATION, method, "link").booleanValue()) {
                        sb.append("Equivalent to the [`--" + opt.getLongName() + "`](" + this.getToolOptionHref(toolModel.getName(), option) + ") command line option.").append(NL);
                    }
                    if (!this.getAnnotationBooleanValue(this.OPTION_EQUIV_ANNOTATION, method, "transclude").booleanValue()) break;
                    sb.append(DocBuilder.getOptionDescription(toolModel, opt)).append(NL);
                    break;
                }
            }
            if (!found) {
                System.err.println("Option " + option + " for " + method + " not found");
            }
        }
        if (sb.length() == 0) {
            sb.append("Not documented");
            System.err.println("Not documented: " + method);
        }
        out.append(this.markdown(sb.toString()));
    }

    protected String inferOptionNameFromSetter(Method setter) {
        if (setter.getName().startsWith("set")) {
            return "--" + this.camelCaseToDashes(setter.getName().substring(3));
        }
        throw new RuntimeException(setter.getName());
    }

    protected String inferOptionNameFromAdder(Method adder) {
        if (adder.getName().startsWith("addConfigured")) {
            return "--" + this.camelCaseToDashes(adder.getName().substring(13));
        }
        if (adder.getName().startsWith("add")) {
            return "--" + this.camelCaseToDashes(adder.getName().substring(3));
        }
        throw new RuntimeException(adder.getName());
    }

    protected String camelCaseToDashes(String name) {
        StringBuilder sb = new StringBuilder();
        for (char ch : name.toCharArray()) {
            if (Character.isUpperCase(ch)) {
                if (sb.length() != 0) {
                    sb.append('-');
                }
                sb.append(Character.toLowerCase(ch));
                continue;
            }
            sb.append(ch);
        }
        String toolName = sb.toString();
        return toolName;
    }

    protected boolean hasSetters(Class<?> elementClass) {
        boolean hasSetters = false;
        for (Method elementMethod : elementClass.getMethods()) {
            if (!this.isDocumentableSetter(elementClass, elementMethod)) continue;
            hasSetters = true;
            break;
        }
        return hasSetters;
    }

    protected boolean isDocumentableAdder(Method method) {
        return Modifier.isPublic(method.getModifiers()) && method.getName().startsWith("add") && method.getParameterTypes().length == 1 && !method.isAnnotationPresent(this.IGNORE_ANNOTATION) && !method.getDeclaringClass().isAssignableFrom(this.antTaskClass);
    }

    protected boolean isDocumentableSetter(Class<?> taskClass, Method method) {
        try {
            return Modifier.isPublic(method.getModifiers()) && method.getName().startsWith("set") && method.getParameterTypes().length == 1 && !method.isAnnotationPresent(this.IGNORE_ANNOTATION) && taskClass.getMethod(method.getName(), method.getParameterTypes()).equals(method) && !method.getDeclaringClass().isAssignableFrom(this.antTaskClass) || Modifier.isPublic(method.getModifiers()) && method.getName().startsWith("setDynamicAttribute") && method.getParameterTypes().length == 2 && !method.isAnnotationPresent(this.IGNORE_ANNOTATION) && taskClass.getMethod(method.getName(), method.getParameterTypes()).equals(method) && !method.getDeclaringClass().isAssignableFrom(this.antTaskClass);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getAttributeName(Method method) {
        String name = this.getAnnotationStringValue(this.ATTRIBUTE_ANNOTATION, method);
        if (name != null) {
            return name;
        }
        name = method.getName().replaceFirst("^set", "");
        return name.substring(0, 1).toLowerCase(Locale.ENGLISH) + name.substring(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        for (Class t : Arrays.asList(Class.forName("com.redhat.ceylon.ant.CeylonCompileAntTask", false, this.loader), Class.forName("com.redhat.ceylon.ant.CeylonCompileJsAntTask", false, this.loader), Class.forName("com.redhat.ceylon.ant.CeylonRunAntTask", false, this.loader), Class.forName("com.redhat.ceylon.ant.CeylonRunJsAntTask", false, this.loader), Class.forName("com.redhat.ceylon.ant.CeylonTestAntTask", false, this.loader), Class.forName("com.redhat.ceylon.ant.CeylonTestJsAntTask", false, this.loader), Class.forName("com.redhat.ceylon.ant.CeylonDocAntTask", false, this.loader), Class.forName("com.redhat.ceylon.ant.CeylonWarAntTask", false, this.loader), Class.forName("com.redhat.ceylon.ant.CeylonImportJarAntTask", false, this.loader), Class.forName("com.redhat.ceylon.ant.CeylonCopyAntTask", false, this.loader), Class.forName("com.redhat.ceylon.ant.CeylonModuleDescriptorTask", false, this.loader), Class.forName("com.redhat.ceylon.ant.CeylonPluginAntTask", false, this.loader))) {
            if (!this.antTaskClass.isAssignableFrom(t)) {
                System.err.println(t + " is not a " + this.antTaskClass.getName());
                continue;
            }
            Class task = t;
            String taskName = this.getTaskName(task);
            try (OutputStreamWriter o = new OutputStreamWriter((OutputStream)new FileOutputStream(new File("ant-" + taskName + ".md")), "UTF-8");){
                this.documentTask(o, task);
            }
        }
    }

    public static void main(String[] a) throws Exception {
        new CeylonAntTaskDocTool().run();
    }

    static class Key
    implements Comparable<Key> {
        final boolean required;
        final String attributeName;

        public Key(boolean required, String attributeName) {
            this.required = required;
            this.attributeName = attributeName;
        }

        @Override
        public int compareTo(Key o) {
            if (this.required && !o.required) {
                return -1;
            }
            if (!this.required && o.required) {
                return 1;
            }
            return this.attributeName.compareToIgnoreCase(o.attributeName);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    static @interface Multiplicity {
    }
}

