/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.tools.assemble;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.ModuleQuery;
import com.redhat.ceylon.cmr.ceylon.loader.ModuleGraph;
import com.redhat.ceylon.cmr.impl.IOUtils;
import com.redhat.ceylon.common.BooleanUtil;
import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.JVMModuleUtil;
import com.redhat.ceylon.common.ModuleSpec;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.common.config.DefaultToolOptions;
import com.redhat.ceylon.common.tool.Argument;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.Option;
import com.redhat.ceylon.common.tool.OptionArgument;
import com.redhat.ceylon.common.tool.Summary;
import com.redhat.ceylon.common.tool.ToolUsageError;
import com.redhat.ceylon.common.tools.CeylonTool;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.tools.assemble.CeylonAssembleMessages;
import com.redhat.ceylon.tools.assemble.CeylonAssemblyRunner;
import com.redhat.ceylon.tools.moduleloading.ModuleLoadingTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

@Summary(value="Generate a Ceylon assembly for a given module")
@Description(value="Generate an executable _assembly_ which contains the given module and all its run-time dependencies, including the Ceylon run-time, which makes that jar self-sufficient and executable by `java` as if the Ceylon module was run by `ceylon run`.")
public class CeylonAssembleTool
extends ModuleLoadingTool {
    private List<ModuleSpec> modules;
    private boolean force;
    private File out;
    private final List<String> excludedModules = new ArrayList<String>();
    private String run;
    private boolean includeLanguage;
    private boolean includeRuntime;
    private Boolean jvm;
    private Boolean js;
    private Boolean dart;
    private String[] loaderSuffixes;
    private String[] assemblySuffixes;
    private ModuleQuery.Type mqt;
    public static final String CEYLON_ASSEMBLY_SUFFIX = ".cas";

    @Argument(order=1, argumentName="module", multiplicity="+")
    public void setModules(List<String> modules) {
        this.setModuleSpecs(ModuleSpec.parseEachList(modules, new ModuleSpec.Option[0]));
    }

    public void setModuleSpecs(List<ModuleSpec> modules) {
        this.modules = modules;
    }

    @OptionArgument(longName="run", argumentName="toplevel")
    @Description(value="Specifies the fully qualified name of a toplevel method or class with no parameters. The format is: `qualified.package.name::classOrMethodName` with `::` acting as separator between the package name and the toplevel class or method name (defaults to `{module}::run`).")
    public void setRun(String run) {
        this.run = run;
    }

    @Description(value="Target assembly file (defaults to `{name}-{version}.jar`).")
    @OptionArgument(shortName=111, argumentName="file")
    public void setOut(File out) {
        this.out = out;
    }

    @OptionArgument(argumentName="moduleOrFile", shortName=120)
    @Description(value="Excludes modules from the resulting far jat. Can be a module name or a file containing module names. Can be specified multiple times. Note that this excludes the module from the resulting assembly, but if your modules require that module to be present at runtime it will still be required and may cause your application to fail to start if it is not provided at runtime.")
    public void setExcludeModule(List<String> exclusions) {
        for (String each : exclusions) {
            File xFile = new File(each);
            if (xFile.exists() && xFile.isFile()) {
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(xFile));
                    Throwable throwable = null;
                    try {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            this.excludedModules.add(line);
                        }
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        reader.close();
                        continue;
                    }
                }
                catch (IOException e) {
                    throw new ToolUsageError(CeylonAssembleMessages.msg("exclude.file.failure", each), e);
                }
            }
            this.excludedModules.add(each);
        }
    }

    @Option(longName="force")
    @Description(value="Ignore errors about conflicting modules.")
    public void setForce(boolean force) {
        this.force = force;
    }

    @Option
    @Description(value="Include the language module and its dependencies in the assembly. to ensures that the assembly can be run stand-alone using Java without having Ceylon installed. This option does NOT support module isolation!")
    public void setIncludeLanguage(boolean includeLanguage) {
        this.includeLanguage = includeLanguage;
    }

    @Option
    @Description(value="Include enough of the Ceylon runtime in the assembly to ensure that the assembly can be run stand-alone using Java without having Ceylon installed. This option supports full module isolation.")
    public void setIncludeRuntime(boolean includeRuntime) {
        this.includeRuntime = includeRuntime;
    }

    @Option
    @Description(value="Include artifacts compiled for the JVM (`.car` and `.jar`) (default: `true`)")
    public void setJvm(boolean jvm) {
        this.jvm = jvm;
    }

    @Option
    @Description(value="Include artifacts compiled for JavaScript (`.js` and `-model.js`) (default: `false`)")
    public void setJs(boolean js) {
        this.js = js;
    }

    @Option
    @Description(value="Include artifacts compiled for Dart (`.dart` and `-dartmodel.json`) (default: `true`)")
    public void setDart(boolean dart) {
        this.dart = dart;
    }

    @Override
    protected String[] getLoaderSuffixes() {
        return this.loaderSuffixes;
    }

    @Override
    public void initialize(CeylonTool mainTool) throws Exception {
        boolean defaults = this.js == null && this.jvm == null && this.dart == null;
        this.mqt = ModuleQuery.Type.JVM;
        if (BooleanUtil.isTrue(this.dart)) {
            this.mqt = ModuleQuery.Type.DART;
        }
        if (BooleanUtil.isTrue(this.js)) {
            this.mqt = ModuleQuery.Type.JS;
        }
        if (BooleanUtil.isTrue(this.jvm) || defaults) {
            this.mqt = ModuleQuery.Type.JVM;
        }
        this.loaderSuffixes = this.listSuffixes(true);
        this.assemblySuffixes = this.listSuffixes(false);
        super.initialize(mainTool);
    }

    private String[] listSuffixes(boolean codeOnly) {
        boolean defaults;
        ArrayList<String> sfx = new ArrayList<String>();
        boolean bl = defaults = this.js == null && this.jvm == null && this.dart == null;
        if (BooleanUtil.isTrue(this.jvm) || defaults) {
            sfx.add(".car");
            sfx.add(".jar");
            if (!codeOnly) {
                sfx.add("module.properties");
                sfx.add("module.xml");
            }
        }
        if (BooleanUtil.isTrue(this.js) || defaults) {
            sfx.add(".js");
            sfx.add("-model.js");
            if (!codeOnly) {
                sfx.add("module-resources");
            }
        }
        if (BooleanUtil.isTrue(this.dart) || defaults) {
            sfx.add(".dart");
            sfx.add("-dartmodel.json");
            if (!codeOnly) {
                sfx.add("module-resources");
            }
        }
        return sfx.toArray(new String[0]);
    }

    @Override
    public void run() throws Exception {
        if (this.includeRuntime) {
            this.includeLanguage = true;
        }
        String firstModuleName = null;
        String firstModuleVersion = null;
        for (ModuleSpec module : this.modules) {
            String moduleName = module.getName();
            String version2 = this.checkModuleVersionsOrShowSuggestions(moduleName, module.isVersioned() ? module.getVersion() : null, this.mqt, 8, 1, 10, 0, null);
            if (version2 == null) {
                return;
            }
            if (firstModuleName == null) {
                firstModuleName = moduleName;
                firstModuleVersion = version2;
            }
            this.loadModule(null, moduleName, version2);
            if (this.force) continue;
            this.errorOnConflictingModule(moduleName, version2);
        }
        if (this.includeRuntime) {
            this.loadModule(null, "ceylon.runtime", "1.3.3");
        }
        this.loader.resolve();
        String versionSuffix = firstModuleVersion != null && !firstModuleVersion.isEmpty() ? "-" + firstModuleVersion : "";
        File outputCas = this.applyCwd(this.out != null ? this.out : new File(firstModuleName + versionSuffix + CEYLON_ASSEMBLY_SUFFIX));
        if (outputCas.getParentFile() != null && !outputCas.getParentFile().exists()) {
            FileUtil.mkdirs(outputCas.getParentFile());
        }
        if (outputCas.exists()) {
            FileUtil.delete(outputCas);
        }
        HashSet<String> added = new HashSet<String>();
        Manifest manifest = new Manifest();
        Attributes mainAttributes = manifest.getMainAttributes();
        mainAttributes.putValue("Manifest-Version", "1.0");
        mainAttributes.putValue("Created-By", "Ceylon assemble for module " + firstModuleName + "/" + firstModuleVersion);
        mainAttributes.putValue("X-Ceylon-Assembly-Main-Module", ModuleUtil.makeModuleName(firstModuleName, firstModuleVersion));
        if (this.run != null) {
            mainAttributes.putValue("X-Ceylon-Assembly-Run", this.run);
        }
        mainAttributes.putValue("X-Ceylon-Assembly-Repository", "modules");
        File ovrFile = this.getOverridesFile();
        if (ovrFile != null) {
            mainAttributes.putValue("X-Ceylon-Assembly-Overrides", ovrFile.getName());
        }
        if (this.includeLanguage) {
            String className = JVMModuleUtil.javaClassNameFromCeylon(firstModuleName, this.run != null ? this.run : firstModuleName + "::run");
            mainAttributes.putValue("Main-Class", "com.redhat.ceylon.tools.assemble.CeylonAssemblyRunner");
            mainAttributes.putValue("X-Ceylon-Assembly-Main-Class", className);
        }
        added.add("META-INF/");
        added.add("META-INF/MANIFEST.MF");
        try (final JarOutputStream zipFile = new JarOutputStream((OutputStream)new FileOutputStream(outputCas), manifest);){
            if (ovrFile != null) {
                try (FileInputStream is = new FileInputStream(ovrFile);){
                    ((ZipOutputStream)zipFile).putNextEntry(new ZipEntry(ovrFile.getName()));
                    IOUtils.copyStream(is, zipFile, true, false);
                }
            }
            if (this.includeLanguage) {
                String[] postfixes;
                String prefix = CeylonAssemblyRunner.class.getName().replace('.', '/');
                for (String postfix : postfixes = new String[]{"", "$CeylonAssemblyClassLoader", "$CeylonAssemblyClassLoader$1"}) {
                    String clsName = prefix + postfix + ".class";
                    try (InputStream is = CeylonAssemblyRunner.class.getResourceAsStream("/" + clsName);){
                        ((ZipOutputStream)zipFile).putNextEntry(new ZipEntry(clsName));
                        IOUtils.copyStream(is, zipFile, true, false);
                    }
                }
            }
            this.loader.visitModules(new ModuleGraph.Visitor(){

                @Override
                public void visit(ModuleGraph.Module module) {
                    if (module.artifact != null) {
                        File file = module.artifact.artifact();
                        try {
                            if (file != null) {
                                if (CeylonAssembleTool.this.isVerbose()) {
                                    CeylonAssembleTool.this.append(file.getAbsolutePath());
                                    CeylonAssembleTool.this.newline();
                                }
                                if (module.artifact.namespace() == null) {
                                    ArtifactContext ac = new ArtifactContext(module.artifact.namespace(), module.artifact.name(), module.artifact.version(), CeylonAssembleTool.this.assemblySuffixes);
                                    List<ArtifactResult> artifacts = CeylonAssembleTool.this.getRepositoryManager().getArtifactResults(ac);
                                    for (ArtifactResult ar : artifacts) {
                                        String name = "modules/" + this.moduleToPath(module.name) + "/" + module.version + "/" + ar.artifact().getName();
                                        this.addEntry(zipFile, ar.artifact(), name);
                                    }
                                } else if (module.artifact.namespace().equals("maven")) {
                                    String name = "maven/" + this.moduleToPath(module.name) + "/" + module.version + "/" + file.getName();
                                    this.addEntry(zipFile, file, name);
                                    String pomName = module.artifact.artifactId() + "-" + module.version + ".pom";
                                    File mfile = new File(file.getParentFile(), pomName);
                                    if (mfile.isFile()) {
                                        name = "maven/" + this.moduleToPath(module.name) + "/" + module.version + "/" + mfile.getName();
                                        this.addEntry(zipFile, mfile, name);
                                    }
                                } else if (module.artifact.namespace().equals("npm")) {
                                    File parent;
                                    for (parent = module.artifact.artifact().getParentFile().getCanonicalFile(); parent != null && !new File(parent, "package.json").exists(); parent = parent.getParentFile()) {
                                    }
                                    String name = "node_modules/" + parent.getName();
                                    this.addEntry(zipFile, parent, name);
                                }
                            }
                        }
                        catch (IOException x) {
                            throw new RuntimeException(x);
                        }
                    }
                }

                private String moduleToPath(String name) {
                    return ModuleUtil.moduleToPath(name).getPath().replace(':', File.separatorChar);
                }

                private void addEntry(final ZipOutputStream zipFile2, final File file, final String name) throws IOException {
                    if (file.isFile()) {
                        this.addFileEntry(zipFile2, file, name);
                    } else if (file.isDirectory()) {
                        Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                                if (path.toFile().isFile()) {
                                    Path relPath = file.toPath().relativize(path);
                                    String newName = name + "/" + relPath;
                                    this.addFileEntry(zipFile2, path.toFile(), newName);
                                }
                                return super.visitFile(path, attrs);
                            }
                        });
                    }
                }

                private void addFileEntry(ZipOutputStream zipFile2, File file, String name) throws IOException {
                    try (FileInputStream is = new FileInputStream(file);){
                        zipFile2.putNextEntry(new ZipEntry(name));
                        IOUtils.copyStream(is, zipFile2, true, false);
                    }
                }
            });
            zipFile.flush();
        }
        this.flush();
    }

    @Override
    protected boolean shouldExclude(String moduleName, String version2) {
        return super.shouldExclude(moduleName, version2) || this.excludedModules.contains(moduleName) || !this.includeLanguage && "ceylon.language".equals(moduleName);
    }

    private File getOverridesFile() {
        String path;
        String string = path = this.overrides != null ? this.overrides : DefaultToolOptions.getDefaultOverrides();
        if (path != null) {
            return this.applyCwd(new File(path));
        }
        return null;
    }
}

