/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.tools.assemble;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Attributes;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class CeylonAssemblyRunner {
    public static void main(String[] args) throws Exception {
        try (CeylonAssemblyClassLoader loader = new CeylonAssemblyClassLoader(Thread.currentThread().getContextClassLoader());){
            if (CeylonAssemblyRunner.runtimeExists(loader)) {
                CeylonAssemblyRunner.invokeRuntime(loader, args);
            } else {
                CeylonAssemblyRunner.invokeMain(loader, args);
            }
        }
    }

    private static Attributes getAssemblyManifestAttributes() throws IOException {
        ProtectionDomain protectionDomain = CeylonAssemblyRunner.class.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        if (codeSource != null) {
            URL srcUrl = codeSource.getLocation();
            URL assemblyUrl = new URL("jar", "", srcUrl + "!/");
            JarURLConnection uc = (JarURLConnection)assemblyUrl.openConnection();
            return uc.getMainAttributes();
        }
        return null;
    }

    private static String getMainClassName() {
        try {
            Attributes attrs = CeylonAssemblyRunner.getAssemblyManifestAttributes();
            if (attrs != null) {
                return attrs.getValue("X-Ceylon-Assembly-Main-Class");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static void invokeMain(ClassLoader loader, String[] args) throws Exception {
        String className = CeylonAssemblyRunner.getMainClassName();
        if (className == null) {
            throw new IllegalArgumentException("Missing X-Ceylon-Assembly-Main-Class attribute in assembly manifest");
        }
        Class<?> clazz = loader.loadClass(className);
        Method method = clazz.getMethod("main", args.getClass());
        method.setAccessible(true);
        int mods = method.getModifiers();
        if (method.getReturnType() != Void.TYPE || !Modifier.isStatic(mods) || !Modifier.isPublic(mods)) {
            throw new NoSuchMethodException("'main' in class '" + className + "'");
        }
        method.invoke(null, new Object[]{args});
    }

    private static boolean runtimeExists(ClassLoader loader) {
        try {
            Class<?> clazz = loader.loadClass("ceylon.modules.bootstrap.CeylonRunTool");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static void invokeRuntime(CeylonAssemblyClassLoader loader, String[] args) throws Exception {
        String overrides;
        Class<?> clazz = loader.loadClass("ceylon.modules.bootstrap.CeylonRunTool");
        Object runtool = clazz.newInstance();
        Attributes attrs = CeylonAssemblyRunner.getAssemblyManifestAttributes();
        String mainModule = attrs.getValue("X-Ceylon-Assembly-Main-Module");
        if (mainModule == null) {
            throw new IllegalArgumentException("Missing X-Ceylon-Assembly-Main-Module attribute in assembly manifest");
        }
        Method moduleSetter = clazz.getMethod("setModule", String.class);
        moduleSetter.invoke(runtool, mainModule);
        File repoFolder = loader.getAssemblyFolder();
        String repo = attrs.getValue("X-Ceylon-Assembly-Repository");
        if (repo != null) {
            repoFolder = new File(repoFolder, repo);
        }
        Method sysrepSetter = clazz.getMethod("setSystemRepository", String.class);
        sysrepSetter.invoke(runtool, repoFolder.getPath());
        List<String> argList = Arrays.asList(args);
        Method argsSetter = clazz.getMethod("setArgs", List.class);
        argsSetter.invoke(runtool, argList);
        String runDecl = attrs.getValue("X-Ceylon-Assembly-Run");
        if (runDecl != null) {
            Method runSetter = clazz.getMethod("setRun", String.class);
            runSetter.invoke(runtool, runDecl);
        }
        if ((overrides = attrs.getValue("X-Ceylon-Assembly-Overrides")) != null) {
            Method overridesSetter = clazz.getMethod("setOverrides", String.class);
            overridesSetter.invoke(runtool, overrides);
        }
        Method run = clazz.getMethod("run", new Class[0]);
        run.invoke(runtool, new Object[0]);
    }

    public static class CeylonAssemblyClassLoader
    extends URLClassLoader {
        private File tmpAssemblyFolder = null;

        public File getAssemblyFolder() {
            return this.tmpAssemblyFolder;
        }

        public CeylonAssemblyClassLoader(ClassLoader parent) {
            super(new URL[0], parent);
            ProtectionDomain protectionDomain = this.getClass().getProtectionDomain();
            CodeSource codeSource = protectionDomain.getCodeSource();
            if (codeSource != null) {
                File assembly = new File(codeSource.getLocation().getPath());
                try {
                    this.tmpAssemblyFolder = Files.createTempDirectory("ceylon-assembly-", new FileAttribute[0]).toFile();
                    this.extractArchive(assembly, this.tmpAssemblyFolder);
                    CeylonAssemblyClassLoader.deleteOnExit(this.tmpAssemblyFolder);
                }
                catch (IOException ex) {
                    CeylonAssemblyClassLoader.delete(this.tmpAssemblyFolder);
                    throw new RuntimeException(ex);
                }
            }
        }

        private void extractArchive(File zip, File dir) throws IOException {
            try (ZipFile zf = new ZipFile(zip);){
                Enumeration<? extends ZipEntry> entries = zf.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String entryName = entry.getName();
                    File out = new File(dir, entryName);
                    if (entry.isDirectory() || !CeylonAssemblyClassLoader.shouldInclude(entryName)) continue;
                    this.addURL(out.toURI().toURL());
                    CeylonAssemblyClassLoader.mkdirs(out.getParentFile());
                    InputStream zipIn = zf.getInputStream(entry);
                    Throwable throwable = null;
                    try {
                        BufferedOutputStream fileOut = new BufferedOutputStream(new FileOutputStream(out));
                        Throwable throwable2 = null;
                        try {
                            CeylonAssemblyClassLoader.copyStream(zipIn, fileOut, false, false);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (fileOut == null) continue;
                            if (throwable2 != null) {
                                try {
                                    fileOut.close();
                                }
                                catch (Throwable x2) {
                                    throwable2.addSuppressed(x2);
                                }
                                continue;
                            }
                            fileOut.close();
                        }
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (zipIn == null) continue;
                        if (throwable != null) {
                            try {
                                zipIn.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        zipIn.close();
                    }
                }
            }
        }

        private static boolean shouldInclude(String entryName) {
            return !(entryName = entryName.toLowerCase()).isEmpty() && (entryName.endsWith(".jar") || entryName.endsWith(".car") || entryName.endsWith("/module.xml") || entryName.endsWith("/module.properties"));
        }

        private static File mkdirs(File dir) {
            if (!dir.exists() && !dir.mkdirs()) {
                throw new RuntimeException("Unable to create destination directory: " + dir);
            }
            return dir;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void copyStream(InputStream in, OutputStream out, boolean closeIn, boolean closeOut) throws IOException {
            try {
                CeylonAssemblyClassLoader.copyStreamNoClose(in, out);
            }
            finally {
                if (closeIn) {
                    CeylonAssemblyClassLoader.safeClose(in);
                }
                if (closeOut) {
                    CeylonAssemblyClassLoader.safeClose(out);
                }
            }
        }

        private static void copyStreamNoClose(InputStream in, OutputStream out) throws IOException {
            int cnt;
            byte[] bytes = new byte[8192];
            while ((cnt = in.read(bytes)) != -1) {
                out.write(bytes, 0, cnt);
            }
            out.flush();
        }

        public static void safeClose(Closeable c) {
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private static void deleteOnExit(final File repo) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    CeylonAssemblyClassLoader.delete(repo);
                }
            });
        }

        private static boolean delete(File f) {
            boolean ok = true;
            if (f != null && f.exists()) {
                if (f.isDirectory()) {
                    for (File c : f.listFiles()) {
                        ok = ok && CeylonAssemblyClassLoader.delete(c);
                    }
                }
                try {
                    boolean deleted = f.delete();
                    ok = ok && deleted;
                }
                catch (Exception ex) {
                    ok = false;
                }
            }
            return ok;
        }
    }
}

