/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.tools.bashcompletion;

import com.redhat.ceylon.common.tool.Argument;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.Hidden;
import com.redhat.ceylon.common.tool.OptionArgument;
import com.redhat.ceylon.common.tool.OptionModel;
import com.redhat.ceylon.common.tool.Summary;
import com.redhat.ceylon.common.tool.Tool;
import com.redhat.ceylon.common.tool.ToolLoader;
import com.redhat.ceylon.common.tool.ToolModel;
import com.redhat.ceylon.common.tools.CeylonTool;
import java.io.File;
import java.io.FileFilter;
import java.io.Flushable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;

@Hidden
@Summary(value="A tool which provides completion suggestions for the Bash shell.")
@Description(value="The `<arguments>` are the elements of the `${COMP_WORDS}` bash array variable.\n\nThe tool inspects the `<arguments>` and writes its completions to standard output.Currently the tool can complete\n\n* tool names (except tools names which are arguments to another tool),\n* long option names,\n* long option values **if** the setter type is a `java.lang.File` or a subclass  of `java.lang.Enum`.")
public class CeylonBashCompletionTool
implements Tool {
    private int cword = -1;
    private List<String> arguments;
    private ToolLoader toolLoader;
    private Appendable out = System.out;

    @OptionArgument
    @Description(value="The index in the `<arguments>` of the argument being completed, i.e. The value of `${COMP_CWORD}`.")
    public void setCword(int word) {
        this.cword = word;
    }

    @Argument(argumentName="arguments", multiplicity="*")
    public void setArguments(List<String> arguments) {
        this.arguments = arguments;
    }

    public final void setToolLoader(ToolLoader toolLoader) {
        this.toolLoader = toolLoader;
    }

    @Override
    public void initialize(CeylonTool mainTool) {
    }

    @Override
    public void run() throws Exception {
        CompletionResults results;
        this.arguments.remove(0);
        --this.cword;
        if (this.cword == 0) {
            results = this.completeToolNames(this.arguments.isEmpty() ? "" : this.arguments.get(this.cword));
        } else if (this.cword < this.arguments.size()) {
            String argument = this.arguments.get(this.cword);
            CeylonTool main = new CeylonTool();
            main.setArgs(this.arguments);
            main.setToolLoader(this.toolLoader);
            ToolModel tool = main.getToolModel();
            results = !this.afterEoo() ? (argument.startsWith("--") ? (argument.contains("=") ? this.completeLongOptionArgument(tool, argument) : this.completeLongOption(tool, argument)) : (argument.startsWith("-") ? new CompletionResults() : new CompletionResults())) : new CompletionResults();
        } else {
            results = new CompletionResults();
        }
        results.emitCompletions();
    }

    private CompletionResults completeLongOptionArgument(ToolModel<?> tool, String argument) {
        int index = argument.indexOf(61);
        String optionName = argument.substring(2, argument.charAt(index - 1) == '\\' ? index - 1 : index);
        String partialValue = argument.substring(index + 1);
        OptionModel<?> option = tool.getOption(optionName);
        Class<?> type = option.getArgument().getType();
        if (File.class.isAssignableFrom(type)) {
            return this.completeFilename(argument, partialValue, true, null);
        }
        if (Enum.class.isAssignableFrom(type)) {
            return this.completeEnum(argument, type, partialValue);
        }
        return new CompletionResults();
    }

    private <E extends Enum<E>> CompletionResults completeEnum(String argumentPrefix, Class<E> type, String partialValue) {
        try {
            Enum[] values;
            CompletionResults result = new CompletionResults();
            result.setPartial(partialValue);
            result.setPrefix(argumentPrefix);
            Method method = type.getMethod("values", null);
            for (Enum value : values = (Enum[])method.invoke(null, new Object[0])) {
                String enumElementName = value.toString();
                result.addResult(enumElementName);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    private CompletionResults completeFilename(String argumentPrefix, String partialValue, boolean wantFiles, final FileFilter fileFilter) {
        String partial;
        File file;
        if (partialValue.isEmpty()) {
            file = new File(".").getAbsoluteFile();
            partial = "";
        } else {
            file = new File(partialValue).getAbsoluteFile();
            partial = file.getName();
        }
        File[] files = file.getParentFile().listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String name = pathname.getName();
                if (pathname.isFile() && fileFilter != null) {
                    return name.startsWith(partial) && fileFilter.accept(pathname);
                }
                return name.startsWith(partial);
            }
        });
        CompletionResults results = new CompletionResults();
        results.setPrefix(argumentPrefix);
        results.setPartial(partialValue);
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory() && wantFiles) {
                    results.addResult(f.getName() + "/");
                    continue;
                }
                results.addResult(f.getName());
            }
        }
        return results;
    }

    private CompletionResults completeLongOption(ToolModel<?> tool, String argument) {
        Comparator comparator = new Comparator<OptionModel<?>>(){

            @Override
            public int compare(OptionModel<?> o1, OptionModel<?> o2) {
                return o1.getLongName().compareTo(o2.getLongName());
            }
        };
        CompletionResults results = new CompletionResults();
        results.setPartial(argument);
        TreeSet sorted = new TreeSet(comparator);
        sorted.addAll(tool.getOptions());
        for (OptionModel optionModel : sorted) {
            results.addResult("--" + optionModel.getLongName() + (optionModel.getArgumentType() == OptionModel.ArgumentType.BOOLEAN ? "" : "\\="));
        }
        return results;
    }

    private boolean afterEoo() {
        boolean eoo = false;
        for (int ii = 0; ii < this.cword; ++ii) {
            if (!this.arguments.get(ii).equals("--")) continue;
            eoo = true;
            break;
        }
        return eoo;
    }

    private CompletionResults completeToolNames(String partial) {
        if (partial.indexOf(44) != -1) {
            partial = partial.substring(partial.lastIndexOf(44) + 1);
        }
        CompletionResults results = new CompletionResults();
        results.setPartial(partial);
        for (String toolName : this.toolLoader.getToolNames()) {
            if (!this.toolLoader.loadToolModel(toolName).isPorcelain()) continue;
            results.addResult(toolName);
        }
        return results;
    }

    public void setOut(Appendable out) {
        this.out = out;
    }

    public class CompletionResults {
        private List<String> results = new ArrayList<String>();
        private String prefix = "";
        private String partial = "";

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public void setPartial(String partial) {
            this.partial = partial;
        }

        public boolean addResult(String completion) {
            if (completion.startsWith(this.partial)) {
                this.results.add(completion);
                return true;
            }
            return false;
        }

        public void emitCompletions() throws IOException {
            boolean appendSpace = this.results.size() == 1;
            for (String result : this.results) {
                String completion = this.prefix.isEmpty() ? this.escape(result) : this.escape(this.prefix + result.substring(this.partial.length()));
                if (appendSpace) {
                    completion = completion + " ";
                }
                CeylonBashCompletionTool.this.out.append(completion);
                CeylonBashCompletionTool.this.out.append(System.lineSeparator());
            }
            if (CeylonBashCompletionTool.this.out instanceof Flushable) {
                ((Flushable)((Object)CeylonBashCompletionTool.this.out)).flush();
            }
        }

        private String escape(String completion) {
            return completion.replace("\n", "\\\n");
        }
    }
}

